/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.timers;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.GestoreMessaggi;
import org.openspcoop2.pdd.core.state.OpenSPCoopStateful;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.pdd.services.OpenSPCoop2Startup;
import org.openspcoop2.pdd.timers.TimerException;
import org.openspcoop2.pdd.timers.TimerLock;
import org.openspcoop2.pdd.timers.TimerLockNotAvailableException;
import org.openspcoop2.pdd.timers.TimerMonitoraggioRisorseThread;
import org.openspcoop2.pdd.timers.TimerState;
import org.openspcoop2.pdd.timers.TipoLock;
import org.openspcoop2.protocol.engine.driver.RollbackRepositoryBuste;
import org.openspcoop2.protocol.sdk.state.StateMessage;
import org.openspcoop2.utils.TipiDatabase;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.id.serial.InfoStatistics;
import org.openspcoop2.utils.semaphore.Semaphore;
import org.openspcoop2.utils.semaphore.SemaphoreConfiguration;
import org.openspcoop2.utils.semaphore.SemaphoreMapping;
import org.slf4j.Logger;

public class TimerGestorePuliziaMessaggiAnomaliLib {
    private static TimerState STATE = TimerState.OFF;
    private MsgDiagnostico msgDiag = null;
    private Logger logTimer = null;
    private OpenSPCoop2Properties propertiesReader = null;
    private boolean logQuery = false;
    private int limit = 50;
    private boolean orderByQuery;
    private TimerLock timerLock = null;
    private Semaphore semaphore = null;
    private InfoStatistics semaphore_statistics;

    public static TimerState getSTATE() {
        return STATE;
    }

    public static void setSTATE(TimerState sTATE) {
        STATE = sTATE;
    }

    public TimerGestorePuliziaMessaggiAnomaliLib(MsgDiagnostico msgDiag, Logger log, OpenSPCoop2Properties p, boolean logQuery, int limit, boolean orderByQuery) throws TimerException {
        this.msgDiag = msgDiag;
        this.logTimer = log;
        this.propertiesReader = p;
        this.logQuery = logQuery;
        this.limit = limit;
        this.orderByQuery = orderByQuery;
        this.timerLock = new TimerLock(TipoLock.GESTIONE_PULIZIA_MESSAGGI_ANOMALI);
        if (this.propertiesReader.isTimerLockByDatabase()) {
            this.semaphore_statistics = new InfoStatistics();
            SemaphoreConfiguration config = GestoreMessaggi.newSemaphoreConfiguration(this.propertiesReader.getTimerGestorePuliziaMessaggiAnomaliLockMaxLife(), this.propertiesReader.getTimerGestorePuliziaMessaggiAnomaliLockIdleTime());
            TipiDatabase databaseType = TipiDatabase.toEnumConstant((String)this.propertiesReader.getDatabaseType());
            try {
                this.semaphore = new Semaphore(this.semaphore_statistics, SemaphoreMapping.newInstance((String)this.timerLock.getIdLock()), config, databaseType, this.logTimer);
            }
            catch (Exception e) {
                throw new TimerException(e.getMessage(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void check() throws TimerException {
        if (OpenSPCoop2Startup.contextDestroyed) {
            this.logTimer.error("[GestoreConsistenzaDatabase] Rilevato sistema in shutdown");
            return;
        }
        if (!OpenSPCoop2Startup.initialize) {
            this.msgDiag.logFatalError("inizializzazione di OpenSPCoop non effettuata", "Check Inizializzazione");
            String msgErrore = "Riscontrato errore: inizializzazione del Timer o di OpenSPCoop non effettuata";
            this.logTimer.error(msgErrore);
            throw new TimerException(msgErrore);
        }
        if (!TimerMonitoraggioRisorseThread.isRisorseDisponibili()) {
            this.logTimer.error("[GestoreConsistenzaDatabase] Risorse di sistema non disponibili: " + TimerMonitoraggioRisorseThread.getRisorsaNonDisponibile().getMessage(), (Throwable)TimerMonitoraggioRisorseThread.getRisorsaNonDisponibile());
            return;
        }
        if (!MsgDiagnostico.gestoreDiagnosticaDisponibile) {
            this.logTimer.error("[GestoreConsistenzaDatabase] Sistema di diagnostica non disponibile: " + MsgDiagnostico.motivoMalfunzionamentoDiagnostici.getMessage(), MsgDiagnostico.motivoMalfunzionamentoDiagnostici);
            return;
        }
        if (!TimerState.ENABLED.equals((Object)STATE)) {
            this.msgDiag.logPersonalizzato("disabilitato");
            this.logTimer.info(this.msgDiag.getMessaggio_replaceKeywords("disabilitato"));
            return;
        }
        this.msgDiag.logPersonalizzato("controlloInCorso");
        this.logTimer.info(this.msgDiag.getMessaggio_replaceKeywords("controlloInCorso"));
        long startControlloRepositoryMessaggi = DateManager.getTimeMillis();
        RollbackRepositoryBuste rollbackMessaggio = null;
        OpenSPCoopStateful openspcoopstate = new OpenSPCoopStateful();
        try {
            openspcoopstate.initResource(this.propertiesReader.getIdentitaPortaDefaultWithoutProtocol(), "GestoreConsistenzaDatabase", null);
            Connection connectionDB = ((StateMessage)openspcoopstate.getStatoRichiesta()).getConnectionDB();
            GestoreMessaggi gestoreMsgSearch = new GestoreMessaggi(openspcoopstate, true, this.logTimer, this.msgDiag, null);
            String causaMessaggiDaRipulire = "Eliminazione buste non pi\u00f9 riferite da messaggi";
            List<String> busteInutiliINBOX = null;
            List<String> busteInutiliOUTBOX = null;
            try {
                GestoreMessaggi.acquireLock(this.semaphore, connectionDB, this.timerLock, this.msgDiag, causaMessaggiDaRipulire, this.propertiesReader.getTimerGestorePuliziaMessaggiAnomali_getLockAttesaAttiva(), this.propertiesReader.getTimerGestorePuliziaMessaggiAnomali_getLockCheckInterval());
                busteInutiliINBOX = gestoreMsgSearch.readBusteNonRiferiteDaMessaggiFromInBox(this.limit, this.logQuery, this.propertiesReader.isForceIndex(), this.orderByQuery);
                busteInutiliOUTBOX = gestoreMsgSearch.readBusteNonRiferiteDaMessaggiFromOutBox(this.limit, this.logQuery, this.propertiesReader.isForceIndex(), this.orderByQuery);
                if (this.logQuery && busteInutiliINBOX.size() <= 0 && busteInutiliOUTBOX.size() <= 0) {
                    this.logTimer.info("Non sono stati trovati messaggi anomali");
                }
                while (busteInutiliINBOX.size() > 0 || busteInutiliOUTBOX.size() > 0) {
                    String idMsgDaEliminare;
                    int i;
                    this.msgDiag.addKeyword("@NUMERO_MESSAGGI_INCONSISTENTI_INBOX@", "" + busteInutiliINBOX.size());
                    this.msgDiag.addKeyword("@NUMERO_MESSAGGI_INCONSISTENTI_OUTBOX@", "" + busteInutiliOUTBOX.size());
                    this.msgDiag.logPersonalizzato("ricercaMessaggiDaEliminare");
                    if (this.logQuery) {
                        this.logTimer.info("Trovate " + busteInutiliINBOX.size() + " buste non piu' riferita da messaggi da eliminare (INBOX) ...");
                    }
                    this.msgDiag.addKeyword("@TIPO_MESSAGGIO@", "INBOX");
                    for (i = 0; i < busteInutiliINBOX.size(); ++i) {
                        idMsgDaEliminare = busteInutiliINBOX.get(i);
                        this.msgDiag.addKeyword("@ID_MESSAGGIO_DA_ELIMINARE@", idMsgDaEliminare);
                        try {
                            GestoreMessaggi.updateLock(this.semaphore, connectionDB, this.timerLock, this.msgDiag, "Eliminazione busta anomala in INBOX con id [" + idMsgDaEliminare + "] ...");
                        }
                        catch (Throwable e) {
                            this.msgDiag.logErroreGenerico(e, "EliminazioneBustaInbox(" + idMsgDaEliminare + ")-UpdateLock");
                            this.logTimer.error("ErroreEliminazioneBustaInbox(" + idMsgDaEliminare + ")-UpdateLock: " + e.getMessage(), e);
                            break;
                        }
                        try {
                            rollbackMessaggio = new RollbackRepositoryBuste(idMsgDaEliminare, openspcoopstate.getStatoRichiesta(), true);
                            rollbackMessaggio.rollbackBustaIntoInBox(false);
                            ((StateMessage)openspcoopstate.getStatoRichiesta()).executePreparedStatement();
                            this.msgDiag.logPersonalizzato("eliminazioneMessaggio");
                            if (!this.logQuery) continue;
                            this.logTimer.debug(this.msgDiag.getMessaggio_replaceKeywords("eliminazioneMessaggio"));
                            continue;
                        }
                        catch (Exception e) {
                            if (rollbackMessaggio != null) {
                                ((StateMessage)openspcoopstate.getStatoRichiesta()).closePreparedStatement();
                                rollbackMessaggio = null;
                            }
                            this.msgDiag.logErroreGenerico(e, "EliminazioneBustaInbox(" + idMsgDaEliminare + ")");
                            this.logTimer.error("ErroreEliminazioneBustaInbox(" + idMsgDaEliminare + "): " + e.getMessage(), (Throwable)e);
                        }
                    }
                    if (this.logQuery) {
                        this.logTimer.info("Eliminate " + busteInutiliINBOX.size() + " buste non piu' riferita da messaggi (INBOX)");
                    }
                    if (this.logQuery) {
                        this.logTimer.info("Trovate " + busteInutiliOUTBOX.size() + " buste non piu' riferita da messaggi da eliminare (OUTBOX) ...");
                    }
                    this.msgDiag.addKeyword("@TIPO_MESSAGGIO@", "OUTBOX");
                    for (i = 0; i < busteInutiliOUTBOX.size(); ++i) {
                        idMsgDaEliminare = busteInutiliOUTBOX.get(i);
                        this.msgDiag.addKeyword("@ID_MESSAGGIO_DA_ELIMINARE@", idMsgDaEliminare);
                        try {
                            GestoreMessaggi.updateLock(this.semaphore, connectionDB, this.timerLock, this.msgDiag, "Eliminazione busta anomala in OUTBOX con id [" + idMsgDaEliminare + "] ...");
                        }
                        catch (Throwable e) {
                            this.msgDiag.logErroreGenerico(e, "EliminazioneBustaOutbox(" + idMsgDaEliminare + ")-UpdateLock");
                            this.logTimer.error("EliminazioneBustaOutbox(" + idMsgDaEliminare + ")-UpdateLock: " + e.getMessage(), e);
                            break;
                        }
                        try {
                            rollbackMessaggio = new RollbackRepositoryBuste(idMsgDaEliminare, openspcoopstate.getStatoRichiesta(), true);
                            rollbackMessaggio.rollbackBustaIntoOutBox(false);
                            ((StateMessage)openspcoopstate.getStatoRichiesta()).executePreparedStatement();
                            this.msgDiag.logPersonalizzato("eliminazioneMessaggio");
                            if (!this.logQuery) continue;
                            this.logTimer.debug(this.msgDiag.getMessaggio_replaceKeywords("eliminazioneMessaggio"));
                            continue;
                        }
                        catch (Exception e) {
                            if (rollbackMessaggio != null) {
                                ((StateMessage)openspcoopstate.getStatoRichiesta()).closePreparedStatement();
                                rollbackMessaggio = null;
                            }
                            this.msgDiag.logErroreGenerico(e, "EliminazioneBustaOutbox(" + idMsgDaEliminare + ")");
                            this.logTimer.error("EliminazioneBustaOutbox(" + idMsgDaEliminare + "): " + e.getMessage(), (Throwable)e);
                        }
                    }
                    if (this.logQuery) {
                        this.logTimer.info("Eliminate " + busteInutiliOUTBOX.size() + " buste non piu' riferita da messaggi (OUTBOX)");
                    }
                    boolean cerca = true;
                    try {
                        GestoreMessaggi.updateLock(this.semaphore, connectionDB, this.timerLock, this.msgDiag, "Ricerca nuove buste non pi\u00f9 riferite da messaggi ...");
                    }
                    catch (Throwable e) {
                        this.msgDiag.logErroreGenerico(e, "RicercaNuoveBusteOneWayNonRiscontrate-UpdateLock");
                        this.logTimer.error("ErroreRicercaNuoveBusteOneWayNonRiscontrate-UpdateLock: " + e.getMessage(), e);
                        cerca = false;
                    }
                    if (cerca) {
                        busteInutiliINBOX = gestoreMsgSearch.readBusteNonRiferiteDaMessaggiFromInBox(this.limit, this.logQuery, this.propertiesReader.isForceIndex(), this.orderByQuery);
                        busteInutiliOUTBOX = gestoreMsgSearch.readBusteNonRiferiteDaMessaggiFromOutBox(this.limit, this.logQuery, this.propertiesReader.isForceIndex(), this.orderByQuery);
                        continue;
                    }
                    busteInutiliINBOX = new ArrayList<String>();
                    busteInutiliOUTBOX = new ArrayList<String>();
                }
            }
            finally {
                try {
                    GestoreMessaggi.releaseLock(this.semaphore, connectionDB, this.timerLock, this.msgDiag, causaMessaggiDaRipulire);
                }
                catch (Exception cerca) {}
            }
            long endControlloRepositoryMessaggi = DateManager.getTimeMillis();
            long diff = endControlloRepositoryMessaggi - startControlloRepositoryMessaggi;
            this.logTimer.info("Pulizia Messaggi Anomali terminata in " + Utilities.convertSystemTimeIntoStringMillisecondi((long)diff, (boolean)true));
        }
        catch (TimerLockNotAvailableException t) {
            this.logTimer.info(t.getMessage(), (Throwable)t);
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "GestioneMessaggiInconsistenti");
            this.logTimer.error("Riscontrato errore durante la pulizia dei messaggi anomali: " + e.getMessage(), (Throwable)e);
        }
        finally {
            if (openspcoopstate != null) {
                openspcoopstate.releaseResource();
            }
        }
    }
}

