/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.timers;

import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.pdd.services.OpenSPCoop2Startup;
import org.openspcoop2.pdd.timers.TimerException;
import org.openspcoop2.pdd.timers.TimerGestorePuliziaMessaggiAnomaliLib;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.threads.BaseThread;
import org.slf4j.Logger;

public class TimerGestorePuliziaMessaggiAnomaliThread
extends BaseThread {
    private OpenSPCoop2Properties propertiesReader;
    private MsgDiagnostico msgDiag;
    private Logger logTimer = null;
    private boolean logQuery = false;
    private int limit = 50;
    private boolean orderByQuery = false;

    public TimerGestorePuliziaMessaggiAnomaliThread() throws TimerException {
        int secondi;
        int attesa = 90;
        for (secondi = 0; !OpenSPCoop2Startup.initialize && secondi < attesa; ++secondi) {
            Utilities.sleep((long)1000L);
        }
        if (secondi >= 90) {
            throw new TimerException("Riscontrata inizializzazione OpenSPCoop non effettuata");
        }
        this.logTimer = OpenSPCoop2Logger.getLoggerOpenSPCoopTimers();
        try {
            this.msgDiag = MsgDiagnostico.newInstance("GestoreConsistenzaDatabase");
            this.msgDiag.setPrefixMsgPersonalizzati("timerGestoreMessaggiInconsistenti.");
            this.msgDiag.addKeyword("@ID_TIMER_GESTORE_MESSAGGI_INCONSISTENTI@", "GestoreConsistenzaDatabase");
        }
        catch (Exception e) {
            String msgErrore = "Riscontrato Errore durante l'inizializzazione del MsgDiagnostico";
            this.logTimer.error(msgErrore, (Throwable)e);
            throw new TimerException(msgErrore, e);
        }
        this.msgDiag.logPersonalizzato("avvioInCorso");
        this.logTimer.info(this.msgDiag.getMessaggio_replaceKeywords("avvioInCorso"));
        try {
            this.propertiesReader = OpenSPCoop2Properties.getInstance();
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "InizializzazioneTimer");
            String msgErrore = "Riscontrato errore durante l'inizializzazione del Reader delle Properties di OpenSPCoop: " + e.getMessage();
            this.logTimer.error(msgErrore, (Throwable)e);
            throw new TimerException(msgErrore, e);
        }
        this.setTimeout((int)this.propertiesReader.getRepositoryIntervalloEliminazioneMessaggi());
        String s = "secondi";
        if (this.getTimeout() == 1) {
            s = "secondo";
        }
        this.msgDiag.addKeyword("@TIMEOUT@", this.getTimeout() + " " + s);
        this.logQuery = this.propertiesReader.isTimerGestorePuliziaMessaggiAnomaliAbilitatoLog();
        this.orderByQuery = this.propertiesReader.isTimerGestorePuliziaMessaggiAnomaliAbilitatoOrderBy();
        this.limit = this.propertiesReader.getTimerGestorePuliziaMessaggiAnomaliLimit();
        if (this.limit <= 0) {
            this.limit = 50;
        }
        this.msgDiag.addKeyword("@LIMIT@", "" + this.limit);
        this.msgDiag.logPersonalizzato("avvioEffettuato");
        this.logTimer.info(this.msgDiag.getMessaggio_replaceKeywords("avvioEffettuato"));
    }

    public void process() {
        try {
            TimerGestorePuliziaMessaggiAnomaliLib gestoreMessaggiLib = new TimerGestorePuliziaMessaggiAnomaliLib(this.msgDiag, this.logTimer, this.propertiesReader, this.logQuery, this.limit, this.orderByQuery);
            gestoreMessaggiLib.check();
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "TimerGestorePuliziaMessaggiAnomaliLib.check()");
            this.logTimer.error("Errore generale: " + e.getMessage(), (Throwable)e);
        }
    }
}

