/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.timers;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.List;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.eventi.Evento;
import org.openspcoop2.core.eventi.constants.CodiceEventoStatoGateway;
import org.openspcoop2.core.eventi.constants.TipoEvento;
import org.openspcoop2.core.eventi.constants.TipoSeverita;
import org.openspcoop2.core.eventi.utils.SeveritaConverter;
import org.openspcoop2.pdd.config.ClassNameProperties;
import org.openspcoop2.pdd.config.ConfigurazionePdDManager;
import org.openspcoop2.pdd.config.DBManager;
import org.openspcoop2.pdd.config.DBTransazioniManager;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.config.QueueManager;
import org.openspcoop2.pdd.core.FileSystemSerializer;
import org.openspcoop2.pdd.core.eventi.GestoreEventi;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.pdd.services.OpenSPCoop2Startup;
import org.openspcoop2.pdd.timers.TimerState;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.manifest.constants.ServiceBinding;
import org.openspcoop2.protocol.registry.RegistroServiziManager;
import org.openspcoop2.protocol.sdk.diagnostica.IDiagnosticProducer;
import org.openspcoop2.protocol.sdk.tracciamento.ITracciaProducer;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.beans.WriteToSerializerType;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.threads.BaseThread;
import org.slf4j.Logger;

public class TimerMonitoraggioRisorseThread
extends BaseThread {
    private static TimerState state = TimerState.OFF;
    private static boolean risorseDisponibili = true;
    private static Exception risorsaNonDisponibileEccezione = null;
    public static final String ID_MODULO = "MonitoraggioRisorse";
    private OpenSPCoop2Properties propertiesReader = OpenSPCoop2Properties.getInstance();
    private MsgDiagnostico msgDiag = MsgDiagnostico.newInstance("MonitoraggioRisorse");
    private boolean lastCheck = true;
    private Logger logger = null;
    private DBManager dbManager = null;
    private QueueManager queueManager = null;
    private ConfigurazionePdDManager configPdDReader = null;
    private RegistroServiziManager registriPdDReader = null;
    private List<ITracciaProducer> tracciamentiPersonalizzati = null;
    private List<String> tipiTracciamentiPersonalizzati = null;
    private DBTransazioniManager dbTransazioniManager = null;
    private List<IDiagnosticProducer> msgDiagnosticiPersonalizzati = null;
    private List<String> tipiMsgDiagnosticiPersonalizzati = null;
    private GestoreEventi gestoreEventi;

    public static TimerState getSTATE() {
        return state;
    }

    public static void setSTATE(TimerState sTATE) {
        state = sTATE;
    }

    private static void setRisorseDisponibili(boolean risorseDisponibili) {
        TimerMonitoraggioRisorseThread.risorseDisponibili = risorseDisponibili;
    }

    public static boolean isRisorseDisponibili() {
        return risorseDisponibili;
    }

    public static Exception getRisorsaNonDisponibile() {
        return risorsaNonDisponibileEccezione;
    }

    private static void setRisorsaNonDisponibile(Exception risorsaNonDisponibile) {
        risorsaNonDisponibileEccezione = risorsaNonDisponibile;
        risorseDisponibili = false;
    }

    private void logDebug(String msg) {
        if (this.logger != null) {
            this.logger.debug(msg);
        }
    }

    private void logWarn(String msg) {
        if (this.logger != null) {
            this.logger.warn(msg);
        }
    }

    public TimerMonitoraggioRisorseThread() throws Exception {
        this.msgDiag.setPrefixMsgPersonalizzati("timerMonitoraggioRisorse.");
        this.msgDiag.addKeyword("@ID_TIMER_MONITORAGGIO_RISORSE@", ID_MODULO);
        this.logger = OpenSPCoop2Logger.getLoggerOpenSPCoopResources();
        if (this.propertiesReader.isAbilitatoControlloRisorseDB()) {
            this.dbManager = DBManager.getInstance();
        }
        if (this.propertiesReader.isAbilitatoControlloRisorseJMS()) {
            this.queueManager = QueueManager.getInstance();
        }
        if (this.propertiesReader.isAbilitatoControlloRisorseConfigurazione() || this.propertiesReader.isAbilitatoControlloValidazioneSemanticaConfigurazione()) {
            this.configPdDReader = ConfigurazionePdDManager.getInstance();
        }
        if (this.propertiesReader.isAbilitatoControlloRisorseRegistriServizi() || this.propertiesReader.isAbilitatoControlloValidazioneSemanticaRegistriServizi()) {
            this.registriPdDReader = RegistroServiziManager.getInstance();
        }
        if (this.propertiesReader.isAbilitatoControlloRisorseTracciamentiPersonalizzati()) {
            this.tracciamentiPersonalizzati = OpenSPCoop2Logger.getLoggerTracciamentoOpenSPCoopAppender();
            this.tipiTracciamentiPersonalizzati = OpenSPCoop2Logger.getTipoTracciamentoOpenSPCoopAppender();
            if (!this.propertiesReader.isTransazioniUsePddRuntimeDatasource()) {
                this.dbTransazioniManager = DBTransazioniManager.getInstance();
            }
        }
        if (this.propertiesReader.isAbilitatoControlloRisorseMsgDiagnosticiPersonalizzati()) {
            this.msgDiagnosticiPersonalizzati = OpenSPCoop2Logger.getLoggerMsgDiagnosticoOpenSPCoopAppender();
            this.tipiMsgDiagnosticiPersonalizzati = OpenSPCoop2Logger.getTipoMsgDiagnosticoOpenSPCoopAppender();
        }
        if (this.propertiesReader.isControlloRisorseRegistrazioneEvento()) {
            this.gestoreEventi = GestoreEventi.getInstance();
        }
    }

    public void process() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            String sec = "secondi";
            if (this.propertiesReader.getControlloRisorseCheckInterval() == 1L) {
                sec = "secondo";
            }
            this.msgDiag.addKeyword("@TIMEOUT@", this.propertiesReader.getControlloRisorseCheckInterval() + " " + sec);
            this.msgDiag.logPersonalizzato("avvioEffettuato");
            Object risorsaNonDisponibile = null;
            while (!this.isStop()) {
                boolean checkRisorseDisponibili = true;
                if (OpenSPCoop2Startup.contextDestroyed) {
                    this.logger.error("[MonitoraggioRisorse] Rilevato sistema in shutdown");
                    return;
                }
                if (TimerState.ENABLED.equals((Object)state)) {
                    int j;
                    Throwable t;
                    int j2;
                    Throwable t2;
                    int i;
                    String descrizione = null;
                    if (checkRisorseDisponibili && this.propertiesReader.isAbilitatoControlloRisorseMsgDiagnosticiPersonalizzati()) {
                        String tipoMsgDiagnostico = null;
                        try {
                            for (i = 0; i < this.tipiMsgDiagnosticiPersonalizzati.size(); ++i) {
                                tipoMsgDiagnostico = this.tipiMsgDiagnosticiPersonalizzati.get(i);
                                this.logDebug("Controllo MsgDiagnosticoPersonalizzato [" + tipoMsgDiagnostico + "] (iterazioni:" + this.propertiesReader.getNumeroIterazioniFalliteControlloRisorseMsgDiagnosticiPersonalizzati() + " checkInterval:" + this.propertiesReader.getIterazioniFalliteCheckIntervalControlloRisorseMsgDiagnosticiPersonalizzati() + ")");
                                t2 = null;
                                for (j2 = 0; j2 < this.propertiesReader.getNumeroIterazioniFalliteControlloRisorseMsgDiagnosticiPersonalizzati(); ++j2) {
                                    try {
                                        this.logDebug("MsgDiagnosticoPersonalizzato [" + tipoMsgDiagnostico + "] check '" + j2 + "' ...");
                                        this.msgDiagnosticiPersonalizzati.get(i).isAlive();
                                        this.logDebug("MsgDiagnosticoPersonalizzato [" + tipoMsgDiagnostico + "] check '" + j2 + "' ok");
                                        t2 = null;
                                        break;
                                    }
                                    catch (Throwable tAlive) {
                                        this.logDebug("MsgDiagnosticoPersonalizzato [" + tipoMsgDiagnostico + "] check '" + j2 + "' failed: " + tAlive.getMessage());
                                        t2 = tAlive;
                                        Utilities.sleep((long)this.propertiesReader.getIterazioniFalliteCheckIntervalControlloRisorseMsgDiagnosticiPersonalizzati());
                                        continue;
                                    }
                                }
                                if (t2 == null) continue;
                                throw t2;
                            }
                        }
                        catch (Throwable e) {
                            risorsaNonDisponibile = "[MessaggioDiagnosticoAppender " + tipoMsgDiagnostico + "]";
                            TimerMonitoraggioRisorseThread.setRisorsaNonDisponibile((Exception)((Object)new CoreException((String)risorsaNonDisponibile + " " + e.getMessage(), e)));
                            this.logger.error((String)risorsaNonDisponibile + " " + e.getMessage(), e);
                            descrizione = (String)risorsaNonDisponibile + " " + e.getMessage();
                            checkRisorseDisponibili = false;
                        }
                    }
                    if (checkRisorseDisponibili && this.propertiesReader.isAbilitatoControlloRisorseDB()) {
                        try {
                            this.logDebug("Controllo Database (iterazioni:" + this.propertiesReader.getNumeroIterazioniFalliteControlloRisorseDB() + " checkInterval:" + this.propertiesReader.getIterazioniFalliteCheckIntervalControlloRisorseDB() + ")");
                            t = null;
                            for (j = 0; j < this.propertiesReader.getNumeroIterazioniFalliteControlloRisorseDB(); ++j) {
                                try {
                                    this.logDebug("Database check '" + j + "' ...");
                                    this.dbManager.isAlive();
                                    this.logDebug("Database check '" + j + "' ok");
                                    t = null;
                                    break;
                                }
                                catch (Throwable tAlive) {
                                    this.logDebug("Database check '" + j + "' failed: " + tAlive.getMessage());
                                    t = tAlive;
                                    Utilities.sleep((long)this.propertiesReader.getIterazioniFalliteCheckIntervalControlloRisorseDB());
                                    continue;
                                }
                            }
                            if (t != null) {
                                throw t;
                            }
                        }
                        catch (Throwable e) {
                            risorsaNonDisponibile = "[Database]";
                            TimerMonitoraggioRisorseThread.setRisorsaNonDisponibile((Exception)((Object)new CoreException((String)risorsaNonDisponibile + " " + e.getMessage(), e)));
                            this.logger.error((String)risorsaNonDisponibile + " " + e.getMessage(), e);
                            descrizione = (String)risorsaNonDisponibile + " " + e.getMessage();
                            checkRisorseDisponibili = false;
                        }
                    }
                    if (this.propertiesReader.isServerJ2EE().booleanValue() && checkRisorseDisponibili && this.propertiesReader.isAbilitatoControlloRisorseJMS()) {
                        try {
                            this.logDebug("Controllo BrokerJMS (iterazioni:" + this.propertiesReader.getNumeroIterazioniFalliteControlloRisorseJMS() + " checkInterval:" + this.propertiesReader.getIterazioniFalliteCheckIntervalControlloRisorseJMS() + ")");
                            t = null;
                            for (j = 0; j < this.propertiesReader.getNumeroIterazioniFalliteControlloRisorseJMS(); ++j) {
                                try {
                                    this.logDebug("BrokerJMS check '" + j + "' ...");
                                    this.queueManager.isAlive();
                                    this.logDebug("BrokerJMS check '" + j + "' ok");
                                    t = null;
                                    break;
                                }
                                catch (Throwable tAlive) {
                                    this.logDebug("BrokerJMS check '" + j + "' failed: " + tAlive.getMessage());
                                    t = tAlive;
                                    Utilities.sleep((long)this.propertiesReader.getIterazioniFalliteCheckIntervalControlloRisorseJMS());
                                    continue;
                                }
                            }
                            if (t != null) {
                                throw t;
                            }
                        }
                        catch (Throwable e) {
                            risorsaNonDisponibile = "[Broker JMS]";
                            TimerMonitoraggioRisorseThread.setRisorsaNonDisponibile((Exception)((Object)new CoreException((String)risorsaNonDisponibile + " " + e.getMessage(), e)));
                            this.logger.error((String)risorsaNonDisponibile + " " + e.getMessage(), e);
                            descrizione = (String)risorsaNonDisponibile + " " + e.getMessage();
                            checkRisorseDisponibili = false;
                        }
                    }
                    if (checkRisorseDisponibili && this.propertiesReader.isAbilitatoControlloRisorseConfigurazione()) {
                        try {
                            this.logDebug("Controllo Configurazione (iterazioni:" + this.propertiesReader.getNumeroIterazioniFalliteControlloRisorseConfigurazione() + " checkInterval:" + this.propertiesReader.getIterazioniFalliteCheckIntervalControlloRisorseConfigurazione() + ")");
                            t = null;
                            for (j = 0; j < this.propertiesReader.getNumeroIterazioniFalliteControlloRisorseConfigurazione(); ++j) {
                                try {
                                    this.logDebug("Configurazione check '" + j + "' ...");
                                    this.configPdDReader.isAlive();
                                    this.logDebug("Configurazione check '" + j + "' ok");
                                    t = null;
                                    break;
                                }
                                catch (Throwable tAlive) {
                                    this.logDebug("Configurazione check '" + j + "' failed: " + tAlive.getMessage());
                                    t = tAlive;
                                    Utilities.sleep((long)this.propertiesReader.getIterazioniFalliteCheckIntervalControlloRisorseConfigurazione());
                                    continue;
                                }
                            }
                            if (t != null) {
                                throw t;
                            }
                        }
                        catch (Throwable e) {
                            risorsaNonDisponibile = "[Configurazione]";
                            TimerMonitoraggioRisorseThread.setRisorsaNonDisponibile((Exception)((Object)new CoreException((String)risorsaNonDisponibile + " " + e.getMessage(), e)));
                            this.logger.error((String)risorsaNonDisponibile + " " + e.getMessage(), e);
                            descrizione = (String)risorsaNonDisponibile + " " + e.getMessage();
                            checkRisorseDisponibili = false;
                        }
                    }
                    if (checkRisorseDisponibili && this.propertiesReader.isAbilitatoControlloValidazioneSemanticaConfigurazione()) {
                        try {
                            this.logDebug("Controllo Validazione semantica della Configurazione");
                            ClassNameProperties classNameReader = ClassNameProperties.getInstance();
                            this.configPdDReader.validazioneSemantica(classNameReader.getConnettore(), classNameReader.getMsgDiagnosticoOpenSPCoopAppender(), classNameReader.getTracciamentoOpenSPCoopAppender(), classNameReader.getDumpOpenSPCoopAppender(), classNameReader.getAutenticazionePortaDelegata(), classNameReader.getAutenticazionePortaApplicativa(), classNameReader.getAutorizzazionePortaDelegata(), classNameReader.getAutorizzazionePortaApplicativa(), classNameReader.getAutorizzazioneContenutoPortaDelegata(), classNameReader.getAutorizzazioneContenutoPortaApplicativa(), classNameReader.getIntegrazionePortaDelegata(), classNameReader.getIntegrazionePortaApplicativa(), true, true, true, null);
                        }
                        catch (Throwable e) {
                            risorsaNonDisponibile = "[Validazione semantica della Configurazione]";
                            TimerMonitoraggioRisorseThread.setRisorsaNonDisponibile((Exception)((Object)new CoreException((String)risorsaNonDisponibile + " " + e.getMessage(), e)));
                            this.logger.error((String)risorsaNonDisponibile + " " + e.getMessage(), e);
                            descrizione = (String)risorsaNonDisponibile + " " + e.getMessage();
                            checkRisorseDisponibili = false;
                        }
                    }
                    if (checkRisorseDisponibili && this.propertiesReader.isAbilitatoControlloRisorseRegistriServizi()) {
                        try {
                            this.logDebug("Controllo Registri dei Servizi (iterazioni:" + this.propertiesReader.getNumeroIterazioniFalliteControlloRisorseRegistriServizi() + " checkInterval:" + this.propertiesReader.getIterazioniFalliteCheckIntervalControlloRisorseRegistriServizi() + ")");
                            t = null;
                            for (j = 0; j < this.propertiesReader.getNumeroIterazioniFalliteControlloRisorseRegistriServizi(); ++j) {
                                try {
                                    this.logDebug("Registri dei Servizi check '" + j + "' ...");
                                    this.registriPdDReader.isAlive(this.propertiesReader.isControlloRisorseRegistriRaggiungibilitaTotale());
                                    this.logDebug("Registri dei Servizi check '" + j + "' ok");
                                    t = null;
                                    break;
                                }
                                catch (Throwable tAlive) {
                                    this.logDebug("Registri dei Servizi check '" + j + "' failed: " + tAlive.getMessage());
                                    t = tAlive;
                                    Utilities.sleep((long)this.propertiesReader.getIterazioniFalliteCheckIntervalControlloRisorseRegistriServizi());
                                    continue;
                                }
                            }
                            if (t != null) {
                                throw t;
                            }
                        }
                        catch (Throwable e) {
                            risorsaNonDisponibile = "[Registri dei Servizi]";
                            TimerMonitoraggioRisorseThread.setRisorsaNonDisponibile((Exception)((Object)new CoreException((String)risorsaNonDisponibile + " " + e.getMessage(), e)));
                            this.logger.error((String)risorsaNonDisponibile + " " + e.getMessage(), e);
                            descrizione = (String)risorsaNonDisponibile + " " + e.getMessage();
                            checkRisorseDisponibili = false;
                        }
                    }
                    if (checkRisorseDisponibili && this.propertiesReader.isAbilitatoControlloValidazioneSemanticaRegistriServizi()) {
                        try {
                            ProtocolFactoryManager pFactoryManager = ProtocolFactoryManager.getInstance();
                            this.logDebug("Controllo Validazione semantica del Registri dei Servizi");
                            this.registriPdDReader.validazioneSemantica(this.propertiesReader.isControlloRisorseRegistriRaggiungibilitaTotale(), this.propertiesReader.isValidazioneSemanticaRegistroServiziCheckURI(), pFactoryManager.getOrganizationTypesAsArray(), pFactoryManager.getServiceTypesAsArray(ServiceBinding.SOAP), pFactoryManager.getServiceTypesAsArray(ServiceBinding.REST), ClassNameProperties.getInstance().getConnettore(), true, true, null);
                        }
                        catch (Throwable e) {
                            risorsaNonDisponibile = "[Validazione semantica del Registri dei Servizi]";
                            TimerMonitoraggioRisorseThread.setRisorsaNonDisponibile((Exception)((Object)new CoreException((String)risorsaNonDisponibile + " " + e.getMessage(), e)));
                            this.logger.error((String)risorsaNonDisponibile + " " + e.getMessage(), e);
                            descrizione = (String)risorsaNonDisponibile + " " + e.getMessage();
                            checkRisorseDisponibili = false;
                        }
                    }
                    if (checkRisorseDisponibili && this.propertiesReader.isAbilitatoControlloRisorseTracciamentiPersonalizzati()) {
                        String tipoTracciamento = null;
                        try {
                            for (i = 0; i < this.tipiTracciamentiPersonalizzati.size(); ++i) {
                                tipoTracciamento = this.tipiTracciamentiPersonalizzati.get(i);
                                this.logDebug("Controllo TracciamentoPersonalizzato [" + tipoTracciamento + "] (iterazioni:" + this.propertiesReader.getNumeroIterazioniFalliteControlloRisorseTracciamentiPersonalizzati() + " checkInterval:" + this.propertiesReader.getIterazioniFalliteCheckIntervalControlloRisorseTracciamentiPersonalizzati() + ")");
                                t2 = null;
                                for (j2 = 0; j2 < this.propertiesReader.getNumeroIterazioniFalliteControlloRisorseTracciamentiPersonalizzati(); ++j2) {
                                    try {
                                        this.logDebug("TracciamentoPersonalizzato [" + tipoTracciamento + "] check '" + j2 + "' ...");
                                        this.tracciamentiPersonalizzati.get(i).isAlive();
                                        this.logDebug("TracciamentoPersonalizzato [" + tipoTracciamento + "] check '" + j2 + "' ok");
                                        t2 = null;
                                        break;
                                    }
                                    catch (Throwable tAlive) {
                                        this.logDebug("TracciamentoPersonalizzato [" + tipoTracciamento + "] check '" + j2 + "' failed: " + tAlive.getMessage());
                                        t2 = tAlive;
                                        Utilities.sleep((long)this.propertiesReader.getIterazioniFalliteCheckIntervalControlloRisorseTracciamentiPersonalizzati());
                                        continue;
                                    }
                                }
                                if (t2 == null) continue;
                                throw t2;
                            }
                        }
                        catch (Throwable e) {
                            risorsaNonDisponibile = "[TracciamentoAppender " + tipoTracciamento + "]";
                            TimerMonitoraggioRisorseThread.setRisorsaNonDisponibile((Exception)((Object)new CoreException((String)risorsaNonDisponibile + " " + e.getMessage(), e)));
                            this.logger.error((String)risorsaNonDisponibile + " " + e.getMessage(), e);
                            descrizione = (String)risorsaNonDisponibile + " " + e.getMessage();
                            checkRisorseDisponibili = false;
                        }
                        if (checkRisorseDisponibili && !this.propertiesReader.isTransazioniUsePddRuntimeDatasource()) {
                            try {
                                this.logDebug("Controllo Database Transazioni (iterazioni:" + this.propertiesReader.getNumeroIterazioniFalliteControlloRisorseTracciamentiPersonalizzati() + " checkInterval:" + this.propertiesReader.getIterazioniFalliteCheckIntervalControlloRisorseTracciamentiPersonalizzati() + ")");
                                Throwable t3 = null;
                                for (int j3 = 0; j3 < this.propertiesReader.getNumeroIterazioniFalliteControlloRisorseTracciamentiPersonalizzati(); ++j3) {
                                    try {
                                        this.logDebug("Database Transazioni check '" + j3 + "' ...");
                                        this.dbTransazioniManager.isAlive();
                                        this.logDebug("Database Transazioni check '" + j3 + "' ok");
                                        t3 = null;
                                        break;
                                    }
                                    catch (Throwable tAlive) {
                                        this.logDebug("Database Transazioni check '" + j3 + "' failed: " + tAlive.getMessage());
                                        t3 = tAlive;
                                        Utilities.sleep((long)this.propertiesReader.getIterazioniFalliteCheckIntervalControlloRisorseTracciamentiPersonalizzati());
                                        continue;
                                    }
                                }
                                if (t3 != null) {
                                    throw t3;
                                }
                            }
                            catch (Throwable e) {
                                risorsaNonDisponibile = "[DatabaseTransazioni]";
                                TimerMonitoraggioRisorseThread.setRisorsaNonDisponibile((Exception)((Object)new CoreException((String)risorsaNonDisponibile + " " + e.getMessage(), e)));
                                this.logger.error((String)risorsaNonDisponibile + " " + e.getMessage(), e);
                                descrizione = (String)risorsaNonDisponibile + " " + e.getMessage();
                                checkRisorseDisponibili = false;
                            }
                        }
                    }
                    if (risorsaNonDisponibile != null) {
                        this.msgDiag.addKeyword("@RISORSA_NON_DISPONIBILE@", (String)risorsaNonDisponibile);
                    }
                    if (!checkRisorseDisponibili && this.lastCheck) {
                        if (risorsaNonDisponibile != null && !((String)risorsaNonDisponibile).startsWith("[MessaggioDiagnosticoAppender")) {
                            if (((String)risorsaNonDisponibile).startsWith("[Validazione semantica")) {
                                this.msgDiag.logPersonalizzato("validazioneSemanticaFallita");
                            } else {
                                this.msgDiag.logPersonalizzato("risorsaNonDisponibile");
                            }
                        } else {
                            this.logWarn("Il Monitoraggio delle risorse ha rilevato che la risorsa " + (String)risorsaNonDisponibile + " non e' raggiungibile, tutti i servizi/moduli della porta di dominio sono momentanemanete sospesi.");
                        }
                        this.registraEvento(false, descrizione);
                    } else if (checkRisorseDisponibili && !this.lastCheck) {
                        this.msgDiag.logPersonalizzato("risorsaRitornataDisponibile");
                        risorsaNonDisponibile = null;
                        this.registraEvento(true, this.msgDiag.getMessaggio_replaceKeywords("risorsaRitornataDisponibile"));
                    }
                    this.lastCheck = checkRisorseDisponibili;
                    TimerMonitoraggioRisorseThread.setRisorseDisponibili(checkRisorseDisponibili);
                } else {
                    this.logger.info("Timer MonitoraggioRisorse disabilitato");
                }
                this.sleepForNextCheck((int)this.propertiesReader.getControlloRisorseCheckInterval(), 1000);
            }
        }
        finally {
            this.finished();
        }
    }

    private void registraEvento(boolean risorseDisponibili, String descrizione) {
        block6: {
            String clusterID = this.propertiesReader.getClusterId(false);
            Logger log = OpenSPCoop2Logger.getLoggerOpenSPCoopResources();
            Evento evento = null;
            try {
                if (this.gestoreEventi != null && this.propertiesReader.isControlloRisorseRegistrazioneEvento()) {
                    evento = new Evento();
                    evento.setTipo(TipoEvento.STATO_GATEWAY.getValue());
                    evento.setCodice(risorseDisponibili ? CodiceEventoStatoGateway.RISORSE_SISTEMA_DISPONIBILI.getValue() : CodiceEventoStatoGateway.RISORSE_SISTEMA_NON_DISPONIBILI.getValue());
                    evento.setSeverita(risorseDisponibili ? SeveritaConverter.toIntValue((TipoSeverita)TipoSeverita.INFO) : SeveritaConverter.toIntValue((TipoSeverita)TipoSeverita.ERROR));
                    evento.setClusterId(clusterID);
                    evento.setDescrizione(descrizione);
                    this.gestoreEventi.log(evento, true);
                }
            }
            catch (Throwable e) {
                log.debug("Errore durante la registrazione dell'evento (risorse disponibili:" + descrizione + " '" + descrizione + "'): " + e.getMessage(), e);
                if (evento == null) break block6;
                try {
                    if (evento.getOraRegistrazione() == null) {
                        evento.setOraRegistrazione(DateManager.getDate());
                    }
                    ByteArrayOutputStream bout = new ByteArrayOutputStream();
                    evento.writeTo((OutputStream)bout, WriteToSerializerType.XML_JAXB);
                    bout.flush();
                    bout.close();
                    FileSystemSerializer.getInstance().registraEvento(bout.toByteArray(), evento.getOraRegistrazione());
                }
                catch (Exception eSerializer) {
                    log.error("Errore durante la registrazione su file system dell'evento: " + eSerializer.getMessage(), (Throwable)eSerializer);
                }
            }
        }
    }
}

