/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.timers;

import java.sql.Connection;
import org.openspcoop2.core.commons.dao.DAOFactory;
import org.openspcoop2.core.commons.dao.DAOFactoryProperties;
import org.openspcoop2.core.transazioni.utils.ProjectInfo;
import org.openspcoop2.generic_project.beans.IProjectInfo;
import org.openspcoop2.generic_project.utils.ServiceManagerProperties;
import org.openspcoop2.pdd.config.DBTransazioniManager;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.config.Resource;
import org.openspcoop2.pdd.core.handlers.HandlerException;
import org.openspcoop2.pdd.core.transazioni.GestoreTransazioniStateful;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.pdd.timers.TimerState;
import org.openspcoop2.utils.threads.BaseThread;
import org.slf4j.Logger;

public class TimerRepositoryStatefulThread
extends BaseThread {
    private static TimerState STATE = TimerState.OFF;
    public static final String ID_MODULO = "TimerRepositoryStateful";
    private Logger log = null;
    private Logger logSql = null;
    private boolean debug = false;
    private String tipoDatabaseRuntime = null;
    private DAOFactory daoFactory = null;
    private ServiceManagerProperties daoFactoryServiceManagerPropertiesTransazioni = null;
    private Logger daoFactoryLoggerTransazioni = null;
    private OpenSPCoop2Properties openspcoopProperties = OpenSPCoop2Properties.getInstance();
    private GestoreTransazioniStateful gestore = null;

    public static TimerState getSTATE() {
        return STATE;
    }

    public static void setSTATE(TimerState sTATE) {
        STATE = sTATE;
    }

    public TimerRepositoryStatefulThread() throws Exception {
        this.setTimeout(this.openspcoopProperties.getTransazioniStatefulTimerIntervalSeconds());
        this.debug = this.openspcoopProperties.isTransazioniStatefulDebug();
        this.log = OpenSPCoop2Logger.getLoggerOpenSPCoopTransazioniStateful(this.debug);
        this.logSql = OpenSPCoop2Logger.getLoggerOpenSPCoopTransazioniStatefulSql(this.debug);
        try {
            this.tipoDatabaseRuntime = this.openspcoopProperties.getDatabaseType();
            if (this.tipoDatabaseRuntime == null) {
                throw new Exception("Tipo Database non definito");
            }
            DAOFactoryProperties daoFactoryProperties = null;
            this.daoFactoryLoggerTransazioni = this.logSql;
            this.daoFactory = DAOFactory.getInstance((Logger)this.daoFactoryLoggerTransazioni);
            daoFactoryProperties = DAOFactoryProperties.getInstance((Logger)this.daoFactoryLoggerTransazioni);
            this.daoFactoryServiceManagerPropertiesTransazioni = daoFactoryProperties.getServiceManagerProperties((IProjectInfo)ProjectInfo.getInstance());
            this.daoFactoryServiceManagerPropertiesTransazioni.setShowSql(this.debug);
            this.daoFactoryServiceManagerPropertiesTransazioni.setDatabaseType(DBTransazioniManager.getInstance().getTipoDatabase());
        }
        catch (Exception e) {
            throw new HandlerException("Errore durante l'inizializzazione delle risorse per l'accesso al database: " + e.getMessage(), e);
        }
        try {
            this.gestore = new GestoreTransazioniStateful(this.log, this.logSql, this.tipoDatabaseRuntime, this.debug);
        }
        catch (Exception e) {
            throw new Exception("Errore durante l'inizializzazione del gestore: " + e.getMessage(), e);
        }
    }

    public boolean initialize() {
        if (this.gestore == null) {
            this.log.error("Gestore non correttamente inizializzato");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void process() {
        if (TimerState.ENABLED.equals((Object)STATE)) {
            DBTransazioniManager dbManager = null;
            Resource r = null;
            try {
                dbManager = DBTransazioniManager.getInstance();
                r = dbManager.getResource(this.openspcoopProperties.getIdentitaPortaDefaultWithoutProtocol(), ID_MODULO, null);
                if (r == null) {
                    throw new Exception("Risorsa al database non disponibile");
                }
                Connection con = (Connection)r.getResource();
                if (con == null) {
                    throw new Exception("Connessione non disponibile");
                }
                if (this.debug) {
                    this.log.debug("Esecuzione thread per gestione delle transazioni stateful....");
                }
                this.gestore.verificaOggettiPresentiRepository(this.daoFactory, this.daoFactoryServiceManagerPropertiesTransazioni, this.daoFactoryLoggerTransazioni, con);
                if (!this.debug) return;
                this.log.debug("Esecuzione thread per gestione delle transazioni stateful terminata");
                return;
            }
            catch (Exception e) {
                this.log.error("Errore durante la gestione delle transazioni stateful: " + e.getMessage(), (Throwable)e);
                return;
            }
            finally {
                try {
                    if (r != null) {
                        dbManager.releaseResource(this.openspcoopProperties.getIdentitaPortaDefaultWithoutProtocol(), ID_MODULO, r);
                    }
                }
                catch (Exception exception) {}
            }
        }
        this.log.info("Timer TimerRepositoryStateful disabilitato");
    }
}

