/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.timers;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import javax.rmi.PortableRemoteObject;
import org.openspcoop2.pdd.config.DBManager;
import org.openspcoop2.pdd.config.DBStatisticheManager;
import org.openspcoop2.pdd.config.DBTransazioniManager;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.config.Resource;
import org.openspcoop2.pdd.core.GestoreMessaggi;
import org.openspcoop2.pdd.timers.TimerGestoreBusteNonRiscontrate;
import org.openspcoop2.pdd.timers.TimerGestoreBusteNonRiscontrateHome;
import org.openspcoop2.pdd.timers.TimerGestoreMessaggi;
import org.openspcoop2.pdd.timers.TimerGestoreMessaggiHome;
import org.openspcoop2.pdd.timers.TimerGestorePuliziaMessaggiAnomali;
import org.openspcoop2.pdd.timers.TimerGestorePuliziaMessaggiAnomaliHome;
import org.openspcoop2.pdd.timers.TimerGestoreRepositoryBuste;
import org.openspcoop2.pdd.timers.TimerGestoreRepositoryBusteHome;
import org.openspcoop2.pdd.timers.TimerLock;
import org.openspcoop2.pdd.timers.TipoLock;
import org.openspcoop2.utils.TipiDatabase;
import org.openspcoop2.utils.id.serial.InfoStatistics;
import org.openspcoop2.utils.resources.GestoreJNDI;
import org.openspcoop2.utils.semaphore.Semaphore;
import org.openspcoop2.utils.semaphore.SemaphoreConfiguration;
import org.openspcoop2.utils.semaphore.SemaphoreMapping;
import org.slf4j.Logger;

public class TimerUtils {
    public static TimerGestoreBusteNonRiscontrate createTimerGestoreBusteNonRiscontrate() throws Exception {
        OpenSPCoop2Properties properties = OpenSPCoop2Properties.getInstance();
        GestoreJNDI jndi = null;
        jndi = properties.getJNDIContext_TimerEJB() == null ? new GestoreJNDI() : new GestoreJNDI(properties.getJNDIContext_TimerEJB());
        String nomeJNDI = properties.getJNDITimerEJBName().get("GestoreBusteNonRiscontrate");
        Object objref = jndi.lookup(nomeJNDI);
        TimerGestoreBusteNonRiscontrateHome timerHome = (TimerGestoreBusteNonRiscontrateHome)PortableRemoteObject.narrow((Object)objref, TimerGestoreBusteNonRiscontrateHome.class);
        TimerGestoreBusteNonRiscontrate timerDiServizio = timerHome.create();
        return timerDiServizio;
    }

    public static TimerGestoreMessaggi createTimerGestoreMessaggi() throws Exception {
        OpenSPCoop2Properties properties = OpenSPCoop2Properties.getInstance();
        GestoreJNDI jndi = null;
        jndi = properties.getJNDIContext_TimerEJB() == null ? new GestoreJNDI() : new GestoreJNDI(properties.getJNDIContext_TimerEJB());
        String nomeJNDI = properties.getJNDITimerEJBName().get("GestoreMessaggi");
        Object objref = jndi.lookup(nomeJNDI);
        TimerGestoreMessaggiHome timerHome = (TimerGestoreMessaggiHome)PortableRemoteObject.narrow((Object)objref, TimerGestoreMessaggiHome.class);
        TimerGestoreMessaggi timerDiServizio = timerHome.create();
        return timerDiServizio;
    }

    public static TimerGestorePuliziaMessaggiAnomali createTimerGestorePuliziaMessaggiAnomali() throws Exception {
        OpenSPCoop2Properties properties = OpenSPCoop2Properties.getInstance();
        GestoreJNDI jndi = null;
        jndi = properties.getJNDIContext_TimerEJB() == null ? new GestoreJNDI() : new GestoreJNDI(properties.getJNDIContext_TimerEJB());
        String nomeJNDI = properties.getJNDITimerEJBName().get("GestoreConsistenzaDatabase");
        Object objref = jndi.lookup(nomeJNDI);
        TimerGestorePuliziaMessaggiAnomaliHome timerHome = (TimerGestorePuliziaMessaggiAnomaliHome)PortableRemoteObject.narrow((Object)objref, TimerGestorePuliziaMessaggiAnomaliHome.class);
        TimerGestorePuliziaMessaggiAnomali timerDiServizio = timerHome.create();
        return timerDiServizio;
    }

    public static TimerGestoreRepositoryBuste createTimerGestoreRepositoryBuste() throws Exception {
        OpenSPCoop2Properties properties = OpenSPCoop2Properties.getInstance();
        GestoreJNDI jndi = null;
        jndi = properties.getJNDIContext_TimerEJB() == null ? new GestoreJNDI() : new GestoreJNDI(properties.getJNDIContext_TimerEJB());
        String nomeJNDI = properties.getJNDITimerEJBName().get("GestoreRepositoryBuste");
        Object objref = jndi.lookup(nomeJNDI);
        TimerGestoreRepositoryBusteHome timerHome = (TimerGestoreRepositoryBusteHome)PortableRemoteObject.narrow((Object)objref, TimerGestoreRepositoryBusteHome.class);
        TimerGestoreRepositoryBuste timerDiServizio = timerHome.create();
        return timerDiServizio;
    }

    public static boolean createEmptyLockTimers(OpenSPCoop2Properties propertiesReader, String ID_MODULO, Logger logCore, boolean logErrorConnection) {
        return TimerUtils._lockTimers(propertiesReader, ID_MODULO, logCore, logErrorConnection, false);
    }

    public static void relaseLockTimers(OpenSPCoop2Properties propertiesReader, String ID_MODULO, Logger logCore, boolean logErrorConnection) {
        TimerUtils._lockTimers(propertiesReader, ID_MODULO, logCore, logErrorConnection, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean _lockTimers(OpenSPCoop2Properties propertiesReader, String ID_MODULO, Logger logCore, boolean logErrorConnection, boolean release) {
        boolean ok = true;
        if (propertiesReader != null && propertiesReader.isTimerLockByDatabase() && propertiesReader.getDatabaseType() != null) {
            boolean result;
            Resource resource;
            ArrayList<TipoLock> tipiStatistiche = new ArrayList<TipoLock>();
            tipiStatistiche.add(TipoLock.GENERAZIONE_STATISTICHE_ORARIE);
            tipiStatistiche.add(TipoLock.GENERAZIONE_STATISTICHE_GIORNALIERE);
            tipiStatistiche.add(TipoLock.GENERAZIONE_STATISTICHE_SETTIMANALI);
            tipiStatistiche.add(TipoLock.GENERAZIONE_STATISTICHE_MENSILI);
            ArrayList<TipoLock> tipiRuntime = new ArrayList<TipoLock>();
            tipiRuntime.add(TipoLock.GESTIONE_BUSTE_NON_RISCONTRATE);
            tipiRuntime.add(TipoLock.GESTIONE_CORRELAZIONE_APPLICATIVA);
            tipiRuntime.add(TipoLock.GESTIONE_PULIZIA_MESSAGGI_ANOMALI);
            if (propertiesReader.isMsgGiaInProcessamentoUseLock()) {
                tipiRuntime.add(TipoLock._getLockGestioneRepositoryMessaggi());
            } else {
                tipiRuntime.add(TipoLock.GESTIONE_PULIZIA_REPOSITORY_MESSAGGI);
                tipiRuntime.add(TipoLock.GESTIONE_PULIZIA_REPOSITORY_BUSTE);
            }
            if (propertiesReader.isStatisticheGenerazioneEnabled() && propertiesReader.isStatisticheUsePddRuntimeDatasource()) {
                tipiRuntime.addAll(tipiStatistiche);
            }
            if (tipiRuntime != null && tipiRuntime.size() > 0) {
                resource = null;
                DBManager dbManager = DBManager.getInstance();
                try {
                    List<String> code;
                    resource = dbManager.getResource(propertiesReader.getIdentitaPortaDefaultWithoutProtocol(), ID_MODULO, null, false);
                    for (TipoLock tipoLock : tipiRuntime) {
                        TimerUtils._lock(propertiesReader, (Connection)resource.getResource(), tipoLock, logCore, release);
                    }
                    if (propertiesReader.isServerJ2EE() != null && !propertiesReader.isServerJ2EE().booleanValue() && propertiesReader.isTimerConsegnaContenutiApplicativiAbilitato() && (code = propertiesReader.getTimerConsegnaContenutiApplicativiCode()) != null && !code.isEmpty()) {
                        for (String coda : code) {
                            result = TimerUtils._lock(propertiesReader, (Connection)resource.getResource(), TimerLock.getIdLockConsegnaNotifica(coda), logCore, release);
                            if (result) continue;
                            ok = false;
                        }
                    }
                }
                catch (Exception e) {
                    ok = false;
                    if (logErrorConnection) {
                        logCore.error("Riscontrato errore durante il " + (release ? "il rilascio" : "la creazione") + " dei lock: " + e.getMessage(), (Throwable)e);
                    } else {
                        logCore.debug("Riscontrato errore durante il " + (release ? "il rilascio" : "la creazione") + " dei lock, in fase di shutdown: " + e.getMessage(), (Throwable)e);
                    }
                }
                finally {
                    if (dbManager != null) {
                        dbManager.releaseResource(propertiesReader.getIdentitaPortaDefaultWithoutProtocol(), ID_MODULO, resource, false);
                    }
                }
            }
            if (propertiesReader.isStatisticheGenerazioneEnabled() && !propertiesReader.isStatisticheUsePddRuntimeDatasource() && tipiStatistiche != null && tipiStatistiche.size() > 0) {
                resource = null;
                DBStatisticheManager dbStatisticheManager = null;
                DBTransazioniManager dbTransazioniManager = null;
                if (propertiesReader.isStatisticheUseTransazioniDatasource()) {
                    dbTransazioniManager = DBTransazioniManager.getInstance();
                } else {
                    dbStatisticheManager = DBStatisticheManager.getInstance();
                }
                try {
                    if (dbTransazioniManager != null) {
                        resource = dbTransazioniManager.getResource(propertiesReader.getIdentitaPortaDefaultWithoutProtocol(), ID_MODULO, null, false);
                    } else if (dbStatisticheManager != null) {
                        resource = dbStatisticheManager.getResource(propertiesReader.getIdentitaPortaDefaultWithoutProtocol(), ID_MODULO, null, false);
                    }
                    for (TipoLock tipoLock : tipiStatistiche) {
                        if (resource != null) {
                            result = TimerUtils._lock(propertiesReader, (Connection)resource.getResource(), tipoLock, logCore, release);
                            if (result) continue;
                            ok = false;
                            continue;
                        }
                        ok = false;
                        logCore.error("Timer Resource is null?");
                    }
                }
                catch (Exception exception) {
                    ok = false;
                    if (logErrorConnection) {
                        logCore.error("Riscontrato errore durante il " + (release ? "il rilascio" : "la creazione") + " dei lock: " + exception.getMessage(), (Throwable)exception);
                    } else {
                        logCore.debug("Riscontrato errore durante il " + (release ? "il rilascio" : "la creazione") + " dei lock, in fase di shutdown: " + exception.getMessage(), (Throwable)exception);
                    }
                }
                finally {
                    if (dbTransazioniManager != null) {
                        dbTransazioniManager.releaseResource(propertiesReader.getIdentitaPortaDefaultWithoutProtocol(), ID_MODULO, resource, false);
                    } else if (dbStatisticheManager != null) {
                        dbStatisticheManager.releaseResource(propertiesReader.getIdentitaPortaDefaultWithoutProtocol(), ID_MODULO, resource, false);
                    }
                }
            }
        }
        return ok;
    }

    private static boolean _lock(OpenSPCoop2Properties propertiesReader, Connection connection, TipoLock tipoLock, Logger logCore, boolean release) {
        return TimerUtils._lock(propertiesReader, connection, tipoLock.getTipo(), logCore, release);
    }

    private static boolean _lock(OpenSPCoop2Properties propertiesReader, Connection connection, String idLock, Logger logCore, boolean release) {
        boolean ok = true;
        try {
            InfoStatistics semaphore_statistics = new InfoStatistics();
            SemaphoreConfiguration config = GestoreMessaggi.newSemaphoreConfiguration(propertiesReader.getTimerConsegnaContenutiApplicativiLockMaxLife(), propertiesReader.getTimerConsegnaContenutiApplicativiLockIdleTime());
            TipiDatabase databaseType = TipiDatabase.toEnumConstant((String)propertiesReader.getDatabaseType());
            Semaphore semaphore = new Semaphore(semaphore_statistics, SemaphoreMapping.newInstance((String)idLock), config, databaseType, logCore);
            if (release) {
                boolean unlock = semaphore.releaseLock(connection, "Riavvio application server");
                logCore.debug("Lock di tipo '" + idLock + "' " + (unlock ? "rilasciato" : "non rilasciato"));
            } else {
                boolean created = semaphore.createEmptyLock(connection, false);
                logCore.debug("Lock di tipo '" + idLock + "' " + (created ? "creato" : "non creato"));
            }
        }
        catch (Exception e) {
            ok = false;
            logCore.error("Riscontrato errore durante " + (release ? "il rilascio" : "la creazione") + " del lock di tipo '" + idLock + "': " + e.getMessage(), (Throwable)e);
        }
        return ok;
    }
}

