/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.timers.proxy;

import java.util.Date;
import java.util.List;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.pdd.services.OpenSPCoop2Startup;
import org.openspcoop2.pdd.services.connector.Proxy;
import org.openspcoop2.pdd.services.connector.proxy.IProxyOperationService;
import org.openspcoop2.pdd.services.connector.proxy.ProxyOperation;
import org.openspcoop2.pdd.timers.TimerException;
import org.openspcoop2.pdd.timers.TimerMonitoraggioRisorseThread;
import org.openspcoop2.pdd.timers.TimerState;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.transport.http.HttpResponse;
import org.slf4j.Logger;

public class TimerGestoreOperazioniRemoteLib {
    private static TimerState state = TimerState.OFF;
    private OpenSPCoop2Properties op2Properties = OpenSPCoop2Properties.getInstance();
    private String tipoDatabase = this.op2Properties.getDatabaseType();
    private Logger logCore = null;
    private Logger logTimer = null;
    private MsgDiagnostico msgDiag = null;
    private Date dataUltimoAggiornamento;
    private Date now;
    private int limit;
    private IProxyOperationService proxyOperationService;
    private String urlPrefix;

    public static TimerState getState() {
        return state;
    }

    public static void setState(TimerState stateParam) {
        state = stateParam;
    }

    private void logCoreInfo(String msg) {
        if (this.logCore != null) {
            this.logCore.info(msg);
        }
    }

    private void logTimerError(String msgErrore, Throwable e) {
        if (this.logTimer != null) {
            this.logTimer.error(msgErrore, e);
        }
    }

    private void logTimerError(String msgErrore) {
        if (this.logTimer != null) {
            this.logTimer.error(msgErrore);
        }
    }

    private void logTimerInfo(String msg) {
        if (this.logTimer != null) {
            this.logTimer.info(msg);
        }
    }

    public TimerGestoreOperazioniRemoteLib(Logger logTimer, MsgDiagnostico msgDiag, IProxyOperationService proxyOperationService, Date now, Date dataUltimoAggiornamento, String urlPrefix) throws TimerException {
        if (this.tipoDatabase == null) {
            throw new TimerException("Tipo Database non definito");
        }
        boolean debug = this.op2Properties.isProxyReadJMXResourcesAsyncProcessByTimerDebug();
        this.logCore = OpenSPCoop2Logger.getLoggerOpenSPCoopGestoreOperazioniRemote(debug);
        this.logTimer = logTimer;
        this.msgDiag = msgDiag;
        this.dataUltimoAggiornamento = dataUltimoAggiornamento;
        this.now = now;
        this.urlPrefix = urlPrefix;
        this.limit = this.op2Properties.getProxyReadJMXResourcesAsyncProcessByTimerLimit();
        this.proxyOperationService = proxyOperationService;
    }

    public void check() throws TimerException {
        if (OpenSPCoop2Startup.contextDestroyed) {
            this.logTimerError("[TimerGestoreOperazioniRemote] Rilevato sistema in shutdown");
            return;
        }
        if (!OpenSPCoop2Startup.initialize) {
            this.msgDiag.logFatalError("inizializzazione di OpenSPCoop non effettuata", "Check Inizializzazione");
            String msgErrore = "Riscontrato errore: inizializzazione del Timer o di OpenSPCoop non effettuata";
            this.logTimerError(msgErrore);
            throw new TimerException(msgErrore);
        }
        if (!TimerMonitoraggioRisorseThread.isRisorseDisponibili()) {
            this.logTimerError("[TimerGestoreOperazioniRemote] Risorse di sistema non disponibili: " + TimerMonitoraggioRisorseThread.getRisorsaNonDisponibile().getMessage(), TimerMonitoraggioRisorseThread.getRisorsaNonDisponibile());
            return;
        }
        if (!MsgDiagnostico.gestoreDiagnosticaDisponibile) {
            this.logTimerError("[TimerGestoreOperazioniRemote] Sistema di diagnostica non disponibile: " + MsgDiagnostico.motivoMalfunzionamentoDiagnostici.getMessage(), MsgDiagnostico.motivoMalfunzionamentoDiagnostici);
            return;
        }
        boolean enabled = TimerState.ENABLED.equals((Object)state);
        if (!enabled) {
            this.emitDiagnosticLog("disabilitato");
            return;
        }
        this.emitDiagnosticLog("letturaOperazioni");
        long startControlloTimer = DateManager.getTimeMillis();
        try {
            int offset = 0;
            int op = this.process(offset);
            while (op > 0) {
                op = this.process(offset += op);
            }
            long endControlloTimer = DateManager.getTimeMillis();
            long diff = endControlloTimer - startControlloTimer;
            this.logTimerInfo("Gestione operazioni remote terminata in " + Utilities.convertSystemTimeIntoStringMillisecondi((long)diff, (boolean)true));
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "TimerGestoreOperazioniRemoteLib");
            this.logTimerError("Riscontrato errore durante la gestione delle operazioni remote: " + e.getMessage(), e);
        }
    }

    private int process(int offset) throws CoreException {
        this.msgDiag.addKeyword("@OFFSET@", "" + offset);
        this.msgDiag.addKeyword("@LIMIT@", "" + this.limit);
        try {
            long startGenerazione = DateManager.getTimeMillis();
            this.emitDiagnosticLog("gestioneOperazioni.inCorso");
            List<ProxyOperation> list = this.proxyOperationService.next(this.dataUltimoAggiornamento, this.now, offset, this.limit);
            int op = 0;
            op = list == null || list.isEmpty() ? 0 : list.size();
            this.msgDiag.addKeyword("@NUMERO_OPERAZIONI@", "" + op);
            this.emitDiagnosticLog("gestioneOperazioni.analisi");
            if (op > 0) {
                for (ProxyOperation proxyOperation : list) {
                    this.gestioneOperazione(proxyOperation);
                }
            }
            long endGenerazione = DateManager.getTimeMillis();
            String tempoImpiegato = Utilities.convertSystemTimeIntoStringMillisecondi((long)(endGenerazione - startGenerazione), (boolean)true);
            this.msgDiag.addKeyword("@TEMPO_GESTIONE@", tempoImpiegato);
            this.emitDiagnosticLog("gestioneOperazioni.effettuata");
            return op;
        }
        catch (Exception e) {
            this.msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", e.getMessage());
            this.emitDiagnosticLog("gestioneOperazioni.fallita");
            return -1;
        }
    }

    private void gestioneOperazione(ProxyOperation proxyOperation) {
        String dettaglioOperazione = proxyOperation.getDescription() + " (command: " + proxyOperation.getCommand() + ")";
        this.msgDiag.addKeyword("@DATI_OPERAZIONE@", dettaglioOperazione);
        try {
            Object stato = null;
            String url = this.urlPrefix + proxyOperation.getCommand();
            boolean https = this.op2Properties.isProxyReadJMXResourcesHttpsEnabled();
            boolean verificaHostname = false;
            boolean autenticazioneServer = false;
            String autenticazioneServerPath = null;
            String autenticazioneServerType = null;
            String autenticazioneServerPassword = null;
            if (https) {
                verificaHostname = this.op2Properties.isProxyReadJMXResourcesHttpsEnabledVerificaHostName();
                autenticazioneServer = this.op2Properties.isProxyReadJMXResourcesHttpsEnabledAutenticazioneServer();
                if (autenticazioneServer) {
                    autenticazioneServerPath = this.op2Properties.getProxyReadJMXResourcesHttpsEnabledAutenticazioneServerTruststorePath();
                    autenticazioneServerType = this.op2Properties.getProxyReadJMXResourcesHttpsEnabledAutenticazioneServerTruststoreType();
                    autenticazioneServerPassword = this.op2Properties.getProxyReadJMXResourcesHttpsEnabledAutenticazioneServerTruststorePassword();
                }
            }
            int readTimeout = this.op2Properties.getProxyReadJMXResourcesReadTimeout();
            int connectTimeout = this.op2Properties.getProxyReadJMXResourcesConnectionTimeout();
            String usernameCheck = this.op2Properties.getCheckReadJMXResourcesUsername();
            String passwordCheck = this.op2Properties.getCheckReadJMXResourcesPassword();
            HttpResponse httpResponse = Proxy.invokeHttp(url, readTimeout, connectTimeout, usernameCheck, passwordCheck, https, verificaHostname, autenticazioneServer, autenticazioneServerPath, autenticazioneServerType, autenticazioneServerPassword);
            String sResponse = null;
            if (httpResponse.getContent() != null) {
                sResponse = new String(httpResponse.getContent());
            }
            boolean error = sResponse != null && sResponse.startsWith("Operazione non riuscita: ");
            stato = httpResponse.getResultHTTPOperation() == 200 && !error ? "Success" : "Failed";
            stato = (String)stato + (String)(sResponse != null ? "; " + sResponse : "");
            this.msgDiag.addKeyword("@DETTAGLI_OPERAZIONE@", (String)stato);
            this.emitDiagnosticLog("gestioneOperazioni.operazione");
        }
        catch (Exception e) {
            this.msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", e.getMessage());
            this.emitDiagnosticLog("gestioneOperazioni.operazione.fallita");
        }
    }

    private void emitDiagnosticLog(String code) {
        this.msgDiag.logPersonalizzato(code);
        String msg = this.msgDiag.getMessaggio_replaceKeywords(code);
        this.emitLog(msg);
    }

    private void emitLog(String msg) {
        this.logCoreInfo(msg);
        this.logTimerInfo(msg);
    }
}

