/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.monitor.rs.server.api.impl;

import jakarta.ws.rs.WebApplicationException;
import java.sql.Connection;
import java.util.ArrayList;
import org.openspcoop2.core.monitor.rs.server.api.StatusApi;
import org.openspcoop2.core.monitor.rs.server.config.DBManager;
import org.openspcoop2.core.monitor.rs.server.config.LoggerProperties;
import org.openspcoop2.core.monitor.rs.server.config.ServerProperties;
import org.openspcoop2.core.monitor.rs.server.model.Problem;
import org.openspcoop2.generic_project.exception.NotFoundException;
import org.openspcoop2.generic_project.utils.ServiceManagerProperties;
import org.openspcoop2.utils.service.BaseImpl;
import org.openspcoop2.utils.service.authorization.AuthorizationConfig;
import org.openspcoop2.utils.service.authorization.AuthorizationManager;
import org.openspcoop2.utils.service.context.IContext;
import org.openspcoop2.utils.service.fault.jaxrs.FaultCode;
import org.openspcoop2.utils.service.fault.jaxrs.ProblemRFC7807;
import org.openspcoop2.web.monitor.core.utils.BeanUtils;
import org.openspcoop2.web.monitor.eventi.bean.EventoBean;
import org.openspcoop2.web.monitor.eventi.dao.EventiService;
import org.slf4j.LoggerFactory;

public class StatusApiServiceImpl
extends BaseImpl
implements StatusApi {
    public StatusApiServiceImpl() {
        super(LoggerFactory.getLogger(StatusApiServiceImpl.class));
    }

    private AuthorizationConfig getAuthorizationConfig() throws Exception {
        return new AuthorizationConfig(ServerProperties.getInstance().getProperties());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Problem getStatus() {
        IContext context = this.getContext();
        try {
            Problem p;
            block10: {
                context.getLogger().info("Invocazione in corso ...", new Object[0]);
                AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
                context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
                DBManager dbManager = DBManager.getInstance();
                Connection connection = null;
                p = null;
                try {
                    connection = dbManager.getConnectionTracce();
                    ServiceManagerProperties smp = dbManager.getServiceManagerPropertiesTracce();
                    EventiService eventiService = new EventiService(connection, true, smp, LoggerProperties.getLoggerDAO());
                    Long id = 1L;
                    boolean ok = false;
                    try {
                        EventoBean eventoBean = eventiService.findById(id, true);
                        if (eventoBean != null) {
                            ok = true;
                        }
                    }
                    catch (NotFoundException notFound) {
                        ok = true;
                    }
                    if (ok) {
                        p = new Problem();
                        ProblemRFC7807 pUtils = FaultCode.STATUS_OK.toFault();
                        ArrayList metodiEsclusi = new ArrayList(0);
                        BeanUtils.copy((Object)((Object)p), (Object)pUtils, metodiEsclusi);
                        break block10;
                    }
                    throw new Exception("Servizio non disponibile");
                }
                finally {
                    dbManager.releaseConnectionTracce(connection);
                }
            }
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return p;
        }
        catch (WebApplicationException e) {
            context.getLogger().error("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }
}

