/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.lib.mvc;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.web.lib.mvc.DataElement;
import org.openspcoop2.web.lib.mvc.DataElementImage;
import org.openspcoop2.web.lib.mvc.DataElementType;
import org.openspcoop2.web.lib.mvc.TargetType;

public class BinaryParameter
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private byte[] value;
    private String filename;
    private String id;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public byte[] getValue() {
        return this.value;
    }

    public void setValue(byte[] value) {
        this.value = value;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public List<DataElement> getFileNameDataElement() {
        ArrayList<DataElement> dati = new ArrayList<DataElement>();
        DataElement de1 = new DataElement();
        DataElement de2 = null;
        de1.setName("__fn__" + this.name);
        de1.setValue(this.filename);
        de1.setType(DataElementType.HIDDEN);
        if (StringUtils.isNotBlank((CharSequence)this.filename)) {
            de2 = new DataElement();
            de2.setName("___fn__" + this.name);
            de2.setValue("<I>" + this.filename + "</I>");
            de2.setLabel("");
            de2.setType(DataElementType.TEXT);
            DataElementImage newImage = new DataElementImage();
            newImage.setImage("&#xE872;");
            newImage.setTarget(TargetType.SELF);
            newImage.setUrl("#");
            newImage.setToolTip(MessageFormat.format("Rimuovi {0}", this.filename));
            StringBuilder onClickFunction = new StringBuilder();
            onClickFunction.append("postBack('");
            onClickFunction.append(this.name + "__fr__0");
            onClickFunction.append("')");
            newImage.setOnClick(onClickFunction.toString());
            de2.setImage(newImage);
        }
        dati.add(de1);
        if (de2 != null) {
            dati.add(de2);
        }
        return dati;
    }

    public DataElement getFileIdDataElement() {
        DataElement de = new DataElement();
        de.setType(DataElementType.HIDDEN);
        de.setName("__fd__" + this.name);
        de.setValue(this.id);
        return de;
    }

    public DataElement getFileDataElement(String label, String value, int size) {
        DataElement de = new DataElement();
        de = new DataElement();
        de.setLabel(label);
        de.setValue(value);
        de.setType(DataElementType.FILE);
        de.setName(this.name);
        de.setSize(size);
        de.setPostBack(true);
        return de;
    }

    public static List<DataElement> getFileNameDataElement(List<BinaryParameter> listaParametri) {
        ArrayList<DataElement> dati = new ArrayList<DataElement>();
        BinaryParameter bp0 = listaParametri.get(0);
        ArrayList<String> fileNames = new ArrayList<String>();
        for (BinaryParameter bp : listaParametri) {
            if (!StringUtils.isNotBlank((CharSequence)bp.getFilename())) continue;
            fileNames.add(bp.getFilename());
        }
        DataElement de1 = new DataElement();
        DataElement de2 = null;
        de1.setName("__fn__" + bp0.getName());
        de1.setValue(StringUtils.join(fileNames, (String)","));
        de1.setType(DataElementType.HIDDEN);
        dati.add(de1);
        int i = 0;
        for (String fileName : fileNames) {
            if (!StringUtils.isNotBlank((CharSequence)fileName)) continue;
            de2 = new DataElement();
            de2.setName("___fn__" + bp0.getName());
            de2.setValue("<I>" + fileName + "</I>");
            de2.setLabel("");
            de2.setType(DataElementType.TEXT);
            DataElementImage newImage = new DataElementImage();
            newImage.setImage("&#xE872;");
            newImage.setTarget(TargetType.SELF);
            newImage.setUrl("#");
            newImage.setToolTip(MessageFormat.format("Rimuovi {0}", fileName));
            StringBuilder onClickFunction = new StringBuilder();
            onClickFunction.append("postBack('");
            onClickFunction.append(bp0.getName() + "__fr__" + i);
            onClickFunction.append("')");
            newImage.setOnClick(onClickFunction.toString());
            de2.setImage(newImage);
            dati.add(de2);
            ++i;
        }
        return dati;
    }

    public static DataElement getFileIdDataElement(List<BinaryParameter> listaParametri) {
        DataElement de = new DataElement();
        BinaryParameter bp0 = listaParametri.get(0);
        ArrayList<String> ids = new ArrayList<String>();
        for (BinaryParameter bp : listaParametri) {
            if (!StringUtils.isNotBlank((CharSequence)bp.getId())) continue;
            ids.add(bp.getId());
        }
        de.setType(DataElementType.HIDDEN);
        de.setName("__fd__" + bp0.getName());
        de.setValue(StringUtils.join(ids, (String)","));
        return de;
    }
}

