/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.lib.mvc.security;

import java.util.Properties;
import org.jsoup.safety.Safelist;
import org.slf4j.Logger;

public class InputSanitizerProperties {
    private static Logger log;
    private static InputSanitizerProperties instance;
    private Properties properties;
    private Safelist safelist;

    public static synchronized void init(Properties p, Logger log) {
        if (InputSanitizerProperties.log == null) {
            InputSanitizerProperties.log = log;
        }
        if (instance == null) {
            instance = new InputSanitizerProperties(p);
        }
    }

    public static synchronized InputSanitizerProperties getInstance() {
        return instance;
    }

    private InputSanitizerProperties(Properties p) {
        this.properties = p;
        this.safelist = this.createSafelist();
    }

    private Safelist createSafelist() {
        Safelist customSafelist = new Safelist();
        String tags = this.getProperty("tag.whitelist");
        for (String tag : tags.split(",")) {
            customSafelist.addTags(new String[]{tag.trim()});
        }
        String specialTags = this.getProperty("tag.contentSpecial");
        for (String tag : specialTags.split(",")) {
            customSafelist.addTags(new String[]{tag.trim()});
        }
        for (String tag : this.properties.stringPropertyNames()) {
            if (!tag.startsWith("attributes.")) continue;
            String tagName = tag.substring("attributes.".length());
            String attributes = this.getProperty(tag);
            for (String attribute : attributes.split(",")) {
                customSafelist.addAttributes(tagName, new String[]{attribute.trim()});
            }
        }
        String cssAttributes = this.getProperty("css.attributes");
        for (String attribute : cssAttributes.split(",")) {
            customSafelist.addAttributes("style", new String[]{attribute.trim()});
        }
        String protocols = this.getProperty("protocols.A.href");
        if (protocols != null) {
            for (String protocol : protocols.split(",")) {
                customSafelist.addProtocols("A", "href", new String[]{protocol.trim()});
            }
        }
        return customSafelist;
    }

    public String getProperty(String property) {
        return this.properties.getProperty(property);
    }

    public Safelist getSafelist() {
        return this.safelist;
    }
}

