/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.core.bean;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.faces.event.ActionEvent;
import javax.faces.model.SelectItem;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.commons.search.IdSoggetto;
import org.openspcoop2.core.commons.search.Soggetto;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.utils.resources.MapReader;
import org.openspcoop2.web.lib.users.dao.User;
import org.openspcoop2.web.monitor.core.bean.UserDetailsBean;
import org.openspcoop2.web.monitor.core.core.PermessiUtenteOperatore;
import org.openspcoop2.web.monitor.core.core.Utility;
import org.openspcoop2.web.monitor.core.exception.UserInvalidException;
import org.openspcoop2.web.monitor.core.logger.LoggerManager;
import org.slf4j.Logger;

public class BaseForm
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerManager.getPddMonitorCoreLogger();
    private String nomeAzione;
    private String nomeServizio;
    private String uriAccordo;
    private String servizioApplicativo;
    private String tipoNomeMittente;
    private String tipoNomeDestinatario;
    private String tipoNomeTrafficoPerSoggetto;
    private String tipoNomeSoggettoLocale;
    private String protocollo;
    private List<SelectItem> protocolli = null;
    private User user;

    public String ripulisci() {
        this.ripulisciValori();
        return null;
    }

    protected void ripulisciValori() {
        this.initListener(null);
    }

    public void initListener(ActionEvent ae) {
        this.nomeAzione = null;
        this.nomeServizio = null;
        this.servizioApplicativo = null;
        this.tipoNomeDestinatario = null;
        this.tipoNomeMittente = null;
        this.tipoNomeSoggettoLocale = null;
        this.tipoNomeTrafficoPerSoggetto = null;
        this.protocollo = null;
    }

    public void soggettoLocaleSelected(ActionEvent ae) {
        this.setServizioApplicativo(null);
    }

    public void destinatarioSelected(ActionEvent ae) {
        this.nomeServizio = null;
        this.nomeAzione = null;
    }

    public void apiSelected(ActionEvent ae) {
        this.nomeServizio = null;
        this.nomeAzione = null;
    }

    public void servizioSelected(ActionEvent ae) {
        this.nomeAzione = null;
    }

    public void azioneSelected(ActionEvent ae) {
    }

    public User getUser() {
        if (this.user != null) {
            return this.user;
        }
        return Utility.getLoggedUtente();
    }

    public void setUser(User user) {
        this.user = user;
    }

    public String getTipoMittente() {
        return Utility.parseTipoSoggetto(this.tipoNomeMittente);
    }

    public String getNomeMittente() {
        return Utility.parseNomeSoggetto(this.tipoNomeMittente);
    }

    public void setTipoNomeMittente(String tipoNomeMittente) {
        this.tipoNomeMittente = tipoNomeMittente;
        if (StringUtils.isEmpty((CharSequence)this.tipoNomeMittente) || "--".equals(this.tipoNomeMittente)) {
            this.tipoNomeMittente = null;
        }
    }

    public String getNomeAzione() {
        return this.nomeAzione;
    }

    public void setNomeAzione(String nomeAzione) {
        this.nomeAzione = nomeAzione;
        if (StringUtils.isEmpty((CharSequence)nomeAzione) || "--".equals(nomeAzione)) {
            this.nomeAzione = null;
        }
    }

    public String getNomeServizio() {
        return this.nomeServizio;
    }

    public void setNomeServizio(String nomeServizio) {
        this.nomeServizio = nomeServizio;
        if (StringUtils.isEmpty((CharSequence)nomeServizio) || "--".equals(nomeServizio)) {
            this.nomeServizio = null;
        }
    }

    public String getTipoDestinatario() {
        return Utility.parseTipoSoggetto(this.tipoNomeDestinatario);
    }

    public String getNomeDestinatario() {
        return Utility.parseNomeSoggetto(this.tipoNomeDestinatario);
    }

    public void setTipoNomeDestinatario(String nomeDestinatario) {
        this.tipoNomeDestinatario = nomeDestinatario;
        if (StringUtils.isEmpty((CharSequence)nomeDestinatario) || "--".equals(nomeDestinatario)) {
            this.tipoNomeDestinatario = null;
        }
    }

    public PermessiUtenteOperatore getPermessiUtenteOperatore() throws CoreException, UserInvalidException {
        User u = this.getUser();
        UserDetailsBean user = new UserDetailsBean();
        user.setUtente(u);
        String tipoSoggettoLocale = null;
        String nomeSoggettoLocale = null;
        if (this.tipoNomeSoggettoLocale != null && !StringUtils.isEmpty((CharSequence)this.tipoNomeSoggettoLocale) && !"--".equals(this.tipoNomeSoggettoLocale)) {
            tipoSoggettoLocale = Utility.parseTipoSoggetto(this.tipoNomeSoggettoLocale);
            nomeSoggettoLocale = Utility.parseNomeSoggetto(this.tipoNomeSoggettoLocale);
        }
        return PermessiUtenteOperatore.getPermessiUtenteOperatore(user, tipoSoggettoLocale, nomeSoggettoLocale);
    }

    public String getTipoTrafficoPerSoggetto() {
        return Utility.parseTipoSoggetto(this.tipoNomeTrafficoPerSoggetto);
    }

    public String getTrafficoPerSoggetto() {
        return Utility.parseNomeSoggetto(this.tipoNomeTrafficoPerSoggetto);
    }

    public void setTipoNomeTrafficoPerSoggetto(String trafficoPerSoggetto) {
        this.tipoNomeTrafficoPerSoggetto = trafficoPerSoggetto;
        if (StringUtils.isEmpty((CharSequence)trafficoPerSoggetto) || "--".equals(trafficoPerSoggetto)) {
            this.tipoNomeTrafficoPerSoggetto = null;
        }
    }

    public String getTipoSoggettoLocale() {
        User u = this.getUser();
        if (u.getSoggetti().size() == 1) {
            IDSoggetto s = (IDSoggetto)u.getSoggetti().get(0);
            this.tipoNomeSoggettoLocale = s.getTipo() + "/" + s.getNome();
        }
        return Utility.parseTipoSoggetto(this.tipoNomeSoggettoLocale);
    }

    public String getSoggettoLocale() {
        User u = this.getUser();
        if (u.getSoggetti().size() == 1) {
            IDSoggetto s = (IDSoggetto)u.getSoggetti().get(0);
            this.tipoNomeSoggettoLocale = s.getTipo() + "/" + s.getNome();
        }
        return Utility.parseNomeSoggetto(this.tipoNomeSoggettoLocale);
    }

    public void setTipoNomeSoggettoLocale(String soggettoLocale) {
        this.tipoNomeSoggettoLocale = soggettoLocale;
        if (StringUtils.isEmpty((CharSequence)soggettoLocale) || "--".equals(soggettoLocale)) {
            this.tipoNomeSoggettoLocale = null;
        }
    }

    public List<Soggetto> getSoggettiGestione() {
        ArrayList<Soggetto> soggetti = new ArrayList<Soggetto>();
        User u = this.getUser();
        if (StringUtils.isNotEmpty((CharSequence)this.tipoNomeSoggettoLocale)) {
            String tipo = Utility.parseTipoSoggetto(this.tipoNomeSoggettoLocale);
            String nome = Utility.parseNomeSoggetto(this.tipoNomeSoggettoLocale);
            for (IDSoggetto idSog : u.getSoggetti()) {
                if (!idSog.getTipo().equals(tipo) || !idSog.getNome().equals(nome)) continue;
                IdSoggetto idsog2 = new IdSoggetto();
                idsog2.setNome(idSog.getNome());
                idsog2.setTipo(idSog.getTipo());
                Soggetto soggetto = Utility.getSoggetto(idsog2);
                soggetti.add(soggetto);
                break;
            }
            return soggetti;
        }
        for (IDSoggetto idSog : u.getSoggetti()) {
            IdSoggetto idsog2 = new IdSoggetto();
            idsog2.setNome(idSog.getNome());
            idsog2.setTipo(idSog.getTipo());
            Soggetto s = Utility.getSoggetto(idsog2);
            soggetti.add(s);
        }
        return soggetti;
    }

    public String getServizioApplicativo() {
        return this.servizioApplicativo;
    }

    public void setServizioApplicativo(String servizioApplicativo) {
        this.servizioApplicativo = servizioApplicativo;
        if (StringUtils.isEmpty((CharSequence)servizioApplicativo) || "--".equals(servizioApplicativo)) {
            this.servizioApplicativo = null;
        }
    }

    public String getTipoNomeMittente() {
        return this.tipoNomeMittente;
    }

    public String getTipoNomeDestinatario() {
        return this.tipoNomeDestinatario;
    }

    public String getTipoNomeTrafficoPerSoggetto() {
        return this.tipoNomeTrafficoPerSoggetto;
    }

    public String getTipoNomeSoggettoLocale() {
        return this.tipoNomeSoggettoLocale;
    }

    public String getProtocollo() {
        return this.protocollo;
    }

    public void setProtocollo(String protocollo) {
        this.protocollo = protocollo;
        if (StringUtils.isEmpty((CharSequence)protocollo) || "*".equals(protocollo)) {
            this.protocollo = null;
        }
    }

    public List<SelectItem> getProtocolli() {
        this.protocolli = new ArrayList<SelectItem>();
        this.protocolli.add(new SelectItem((Object)"*"));
        try {
            List<Soggetto> listaSoggettiGestione = this.getSoggettiGestione();
            ProtocolFactoryManager pfManager = ProtocolFactoryManager.getInstance();
            MapReader protocolFactories = pfManager.getProtocolFactories();
            ArrayList<String> listaNomiProtocolli = new ArrayList<String>();
            if (listaSoggettiGestione != null && listaSoggettiGestione.size() > 0) {
                ArrayList<String> tipiSoggetti = new ArrayList<String>();
                for (Soggetto soggetto : listaSoggettiGestione) {
                    String tipoSoggetto = soggetto.getTipoSoggetto();
                    if (tipiSoggetti.contains(tipoSoggetto)) continue;
                    tipiSoggetti.add(tipoSoggetto);
                }
                for (String tipo : tipiSoggetti) {
                    String protocolBySubjectType = pfManager.getProtocolByOrganizationType(tipo);
                    if (listaNomiProtocolli.contains(protocolBySubjectType)) continue;
                    listaNomiProtocolli.add(protocolBySubjectType);
                }
            } else {
                Enumeration keys = protocolFactories.keys();
                while (keys.hasMoreElements()) {
                    String protocolKey = (String)keys.nextElement();
                    if (listaNomiProtocolli.contains(protocolKey)) continue;
                    listaNomiProtocolli.add(protocolKey);
                }
            }
            for (String protocolKey : listaNomiProtocolli) {
                IProtocolFactory protocollo = (IProtocolFactory)protocolFactories.get((Object)protocolKey);
                this.protocolli.add(new SelectItem((Object)protocollo.getProtocol()));
            }
        }
        catch (ProtocolException e) {
            log.error("Si e' verificato un errore durante il caricamento della lista protocolli: " + e.getMessage(), (Throwable)e);
        }
        return this.protocolli;
    }

    public boolean isShowListaProtocolli() {
        try {
            ProtocolFactoryManager pfManager = ProtocolFactoryManager.getInstance();
            MapReader protocolFactories = pfManager.getProtocolFactories();
            int numeroProtocolli = protocolFactories.size();
            if (numeroProtocolli == 1) {
                return false;
            }
            List<Soggetto> listaSoggettiGestione = this.getSoggettiGestione();
            ArrayList<String> listaNomiProtocolli = new ArrayList<String>();
            if (listaSoggettiGestione != null && listaSoggettiGestione.size() > 0) {
                ArrayList<String> tipiSoggetti = new ArrayList<String>();
                for (Soggetto soggetto : listaSoggettiGestione) {
                    String tipoSoggetto = soggetto.getTipoSoggetto();
                    if (tipiSoggetti.contains(tipoSoggetto)) continue;
                    tipiSoggetti.add(tipoSoggetto);
                }
                for (String tipo : tipiSoggetti) {
                    String protocolBySubjectType = pfManager.getProtocolByOrganizationType(tipo);
                    if (listaNomiProtocolli.contains(protocolBySubjectType)) continue;
                    listaNomiProtocolli.add(protocolBySubjectType);
                }
            } else {
                Enumeration keys = protocolFactories.keys();
                while (keys.hasMoreElements()) {
                    String protocolKey = (String)keys.nextElement();
                    if (listaNomiProtocolli.contains(protocolKey)) continue;
                    listaNomiProtocolli.add(protocolKey);
                }
            }
            if ((numeroProtocolli = listaNomiProtocolli.size()) == 1) {
                return false;
            }
        }
        catch (ProtocolException e) {
            log.error("Si e' verificato un errore durante il caricamento della lista protocolli: " + e.getMessage(), (Throwable)e);
        }
        return true;
    }

    public void protocolloSelected(ActionEvent ae) {
    }

    public String getAccordo() {
        return this.uriAccordo;
    }

    public void setAccordo(String uriAccordo) {
        this.uriAccordo = uriAccordo;
    }

    public void accordoSelected(ActionEvent ae) {
    }
}

