/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.core.bean;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.protocol.engine.utils.NamingUtils;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.utils.beans.BlackListElement;
import org.openspcoop2.web.lib.users.dao.RicercaUtente;
import org.openspcoop2.web.monitor.core.constants.ModalitaRicercaTransazioni;
import org.openspcoop2.web.monitor.core.core.Utility;
import org.openspcoop2.web.monitor.core.ricerche.ModuloRicerca;
import org.openspcoop2.web.monitor.core.utils.BeanUtils;
import org.openspcoop2.web.monitor.core.utils.MessageManager;

public class RicercaUtenteBean
extends RicercaUtente {
    private static final long serialVersionUID = 1L;

    public RicercaUtenteBean() {
    }

    public RicercaUtenteBean(RicercaUtente ricercaUtente) {
        ArrayList<BlackListElement> metodiEsclusi = new ArrayList<BlackListElement>(0);
        BeanUtils.copy((Object)this, ricercaUtente, metodiEsclusi);
    }

    @JsonIgnore
    public String getModuloLabel() {
        String modulo = this.getModulo();
        if (modulo == null || modulo.equals("")) {
            return "--";
        }
        ModuloRicerca moduloRicerca = ModuloRicerca.valueOf(modulo);
        switch (moduloRicerca) {
            case ALLARMI: {
                return MessageManager.getInstance().getMessageFromResourceBundle("commons.ricercheUtente.modulo.allarmi.label");
            }
            case CONFIGURAZIONI: {
                return MessageManager.getInstance().getMessageFromResourceBundle("commons.ricercheUtente.modulo.configurazioni.label");
            }
            case EVENTI: {
                return MessageManager.getInstance().getMessageFromResourceBundle("commons.ricercheUtente.modulo.eventi.label");
            }
            case STATISTICHE: {
                return MessageManager.getInstance().getMessageFromResourceBundle("commons.ricercheUtente.modulo.statistiche.label");
            }
            case STATISTICHE_PERSONALIZZATE: {
                return MessageManager.getInstance().getMessageFromResourceBundle("commons.ricercheUtente.modulo.statistichePersonalizzate.label");
            }
            case TRANSAZIONI: {
                return MessageManager.getInstance().getMessageFromResourceBundle("commons.ricercheUtente.modulo.transazioni.label");
            }
        }
        return "--";
    }

    @JsonIgnore
    public String getModalitaRicercaLabel() {
        String modalitaRicerca = this.getModalitaRicerca();
        if (modalitaRicerca == null || modalitaRicerca.equals("")) {
            return "--";
        }
        String modulo = this.getModulo();
        if (modulo.equals(ModuloRicerca.STATISTICHE.toString())) {
            switch (modalitaRicerca) {
                case "temporale": {
                    return MessageManager.getInstance().getMessage("stats.analisiStatistica.tipoDistribuzione.temporale.label");
                }
                case "esiti": {
                    return MessageManager.getInstance().getMessage("stats.analisiStatistica.tipoDistribuzione.esiti.label");
                }
                case "errori": {
                    return MessageManager.getInstance().getMessage("stats.analisiStatistica.tipoDistribuzione.errori.label");
                }
                case "soggetto_remoto": {
                    return MessageManager.getInstance().getMessage("stats.analisiStatistica.tipoDistribuzione.soggettoRemoto.label");
                }
                case "soggetto_locale": {
                    return MessageManager.getInstance().getMessage("stats.analisiStatistica.tipoDistribuzione.soggettoLocale.label");
                }
                case "servizio": {
                    return MessageManager.getInstance().getMessage("stats.analisiStatistica.tipoDistribuzione.servizio.label");
                }
                case "azione": {
                    return MessageManager.getInstance().getMessage("stats.analisiStatistica.tipoDistribuzione.azione.label");
                }
                case "servizio_applicativo": {
                    return MessageManager.getInstance().getMessage("stats.analisiStatistica.tipoDistribuzione.applicativo.label");
                }
            }
            return "--";
        }
        if (modulo.equals(ModuloRicerca.TRANSAZIONI.toString())) {
            ModalitaRicercaTransazioni modalitaRicercaTransazioni = ModalitaRicercaTransazioni.getFromString(modalitaRicerca);
            switch (modalitaRicercaTransazioni) {
                case ANDAMENTO_TEMPORALE: {
                    return MessageManager.getInstance().getMessage("transazioni.search.tipoRicerca.temporale.ricercaTemporale.label");
                }
                case RICERCA_LIBERA: {
                    return MessageManager.getInstance().getMessage("transazioni.search.tipoRicerca.temporale.ricercaLibera.label");
                }
                case MITTENTE_TOKEN_INFO: {
                    return MessageManager.getInstance().getMessage("transazioni.search.tipoRicerca.mittente.ricercaTokenInfo.label");
                }
                case MITTENTE_SOGGETTO: {
                    return MessageManager.getInstance().getMessage("transazioni.search.tipoRicerca.mittente.ricercaSoggetto.label");
                }
                case MITTENTE_APPLICATIVO: {
                    return MessageManager.getInstance().getMessage("transazioni.search.tipoRicerca.mittente.ricercaApplicativo.label");
                }
                case MITTENTE_IDENTIFICATIVO_AUTENTICATO: {
                    return MessageManager.getInstance().getMessage("transazioni.search.tipoRicerca.mittente.ricercaIdentificativoAutenticato.label");
                }
                case MITTENTE_INDIRIZZO_IP: {
                    return MessageManager.getInstance().getMessage("transazioni.search.tipoRicerca.mittente.ricercaIndirizzoIP.label");
                }
                case ID_APPLICATIVO_AVANZATA: {
                    return MessageManager.getInstance().getMessage("transazioni.search.tipoRicerca.id.ricercaIdentificativoApplicativo.lvl2.ricercaLibera.label");
                }
                case LIVE: {
                    return MessageManager.getInstance().getMessage("transazioni.search.tipoRicerca.live.label");
                }
            }
            return "--";
        }
        return "--";
    }

    @JsonIgnore
    public String getVisibilitaLabel() {
        String visibilita = this.getVisibilita();
        if (visibilita.equals("privata")) {
            return MessageManager.getInstance().getMessage("commons.salvaRicerca.modal.privata");
        }
        return MessageManager.getInstance().getMessage("commons.salvaRicerca.modal.pubblica");
    }

    @JsonIgnore
    public String getDescrizioneTooltip() {
        String descrizione = this.getDescrizione();
        if (descrizione == null) {
            return "";
        }
        if (descrizione.length() > 1000) {
            return descrizione.substring(0, 997) + "...";
        }
        return descrizione;
    }

    @JsonIgnore
    public String getProtocolloLabel() {
        String protocollo = super.getProtocollo();
        if (protocollo == null || protocollo.equals("")) {
            return "Tutti";
        }
        try {
            return NamingUtils.getLabelProtocollo((String)protocollo);
        }
        catch (ProtocolException e) {
            return protocollo;
        }
    }

    @JsonIgnore
    public String getSoggettoLabel() {
        String soggetto = super.getSoggetto();
        if (soggetto == null || soggetto.equals("")) {
            return "Tutti";
        }
        String tipoSoggettoOperativoSelezionato = Utility.parseTipoSoggetto(soggetto);
        String nomeSoggettoOperativoSelezionato = Utility.parseNomeSoggetto(soggetto);
        IDSoggetto idSoggetto = new IDSoggetto(tipoSoggettoOperativoSelezionato, nomeSoggettoOperativoSelezionato);
        try {
            return NamingUtils.getLabelSoggetto((IDSoggetto)idSoggetto);
        }
        catch (ProtocolException e) {
            return soggetto;
        }
    }
}

