/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.core.dao;

import java.sql.Connection;
import java.util.Properties;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.commons.dao.DAOFactoryProperties;
import org.openspcoop2.core.commons.search.utils.ProjectInfo;
import org.openspcoop2.core.config.RegistroPlugins;
import org.openspcoop2.core.config.driver.DriverConfigurazioneNotFound;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB;
import org.openspcoop2.generic_project.beans.IProjectInfo;
import org.openspcoop2.generic_project.exception.NotFoundException;
import org.openspcoop2.generic_project.utils.ServiceManagerProperties;
import org.openspcoop2.monitor.engine.dynamic.IRegistroPluginsReader;
import org.openspcoop2.web.monitor.core.logger.LoggerManager;
import org.slf4j.Logger;

public class RegistroPluginsService
implements IRegistroPluginsReader {
    private static Logger log = LoggerManager.getPddMonitorSqlLogger();
    private transient DriverConfigurazioneDB driverConfigDB = null;

    public RegistroPluginsService() {
        try {
            this._init(null, null);
        }
        catch (Exception e) {
            log.error("Errore durante la creazione del Service: " + e.getMessage(), (Throwable)e);
        }
    }

    public RegistroPluginsService(Connection con, boolean autoCommit) {
        this(con, autoCommit, null, log);
    }

    public RegistroPluginsService(Connection con, boolean autoCommit, Logger log) {
        this(con, autoCommit, null, log);
    }

    public RegistroPluginsService(Connection con, boolean autoCommit, ServiceManagerProperties serviceManagerProperties) {
        this(con, autoCommit, serviceManagerProperties, log);
    }

    public RegistroPluginsService(Connection con, boolean autoCommit, ServiceManagerProperties serviceManagerProperties, Logger log) {
        try {
            this._init(con, serviceManagerProperties);
        }
        catch (Exception e) {
            RegistroPluginsService.log.error("Errore durante la creazione del Service: " + e.getMessage(), (Throwable)e);
        }
    }

    private void _init(Connection con, ServiceManagerProperties serviceManagerProperties) {
        try {
            String tipoDatabase = null;
            tipoDatabase = serviceManagerProperties != null ? serviceManagerProperties.getDatabaseType() : DAOFactoryProperties.getInstance((Logger)log).getTipoDatabase((IProjectInfo)ProjectInfo.getInstance());
            if (con != null) {
                this.driverConfigDB = new DriverConfigurazioneDB(con, log, tipoDatabase);
            } else {
                String datasourceJNDIName = DAOFactoryProperties.getInstance((Logger)log).getDatasourceJNDIName((IProjectInfo)ProjectInfo.getInstance());
                Properties datasourceJNDIContext = DAOFactoryProperties.getInstance((Logger)log).getDatasourceJNDIContext((IProjectInfo)ProjectInfo.getInstance());
                this.driverConfigDB = new DriverConfigurazioneDB(datasourceJNDIName, datasourceJNDIContext, log, tipoDatabase);
            }
        }
        catch (Exception e) {
            log.error("Errore durante la creazione del Service: " + e.getMessage(), (Throwable)e);
        }
    }

    public RegistroPlugins getRegistroPlugins() throws NotFoundException, CoreException {
        try {
            return this.driverConfigDB.getRegistroPlugins();
        }
        catch (DriverConfigurazioneNotFound notFound) {
            throw new NotFoundException(notFound.getMessage(), (Throwable)notFound);
        }
        catch (Exception e) {
            throw new CoreException(e.getMessage(), (Throwable)e);
        }
    }
}

