/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.core.filters;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ReadListener;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.openspcoop2.web.monitor.core.core.PddMonitorProperties;
import org.openspcoop2.web.monitor.core.logger.LoggerManager;
import org.slf4j.Logger;

public class MultipartFilter
implements Filter {
    private static Logger log = LoggerManager.getPddMonitorCoreLogger();
    private boolean filtroAttivo;
    public static final String MULTIPART = "multipart/";

    public void init(FilterConfig filterConfig) throws ServletException {
        try {
            this.filtroAttivo = PddMonitorProperties.getInstance(log).isMultipartRequestCache();
        }
        catch (Exception e) {
            log.error("Errore durante la init del filtro: " + e.getMessage(), (Throwable)e);
            throw new ServletException((Throwable)e);
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        BufferedRequestWrapper reqWrapper = null;
        if (this.filtroAttivo && this.isMultipartRequest(httpServletRequest)) {
            reqWrapper = new BufferedRequestWrapper((HttpServletRequest)request);
            chain.doFilter((ServletRequest)reqWrapper, response);
        } else {
            chain.doFilter(request, response);
        }
    }

    private boolean isMultipartRequest(HttpServletRequest request) {
        if (!"post".equals(request.getMethod().toLowerCase())) {
            return false;
        }
        String contentType = request.getContentType();
        if (contentType == null) {
            return false;
        }
        return contentType.toLowerCase().startsWith(MULTIPART);
    }

    public void destroy() {
    }

    private class BufferedRequestWrapper
    extends HttpServletRequestWrapper {
        private ByteArrayInputStream bais;
        private ByteArrayOutputStream baos;
        private BufferedServletInputStream bsis;
        private byte[] buffer;

        public BufferedRequestWrapper(HttpServletRequest req) throws IOException {
            int letti;
            super(req);
            ServletInputStream is = req.getInputStream();
            this.baos = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            while ((letti = is.read(buf)) > 0) {
                this.baos.write(buf, 0, letti);
            }
            this.buffer = this.baos.toByteArray();
        }

        public ServletInputStream getInputStream() {
            try {
                this.bais = new ByteArrayInputStream(this.buffer);
                this.bsis = new BufferedServletInputStream(MultipartFilter.this, this.bais);
            }
            catch (Exception ex) {
                ex.printStackTrace(System.err);
            }
            return this.bsis;
        }

        public byte[] getBuffer() {
            return this.buffer;
        }
    }

    class BufferedServletInputStream
    extends ServletInputStream {
        private ByteArrayInputStream bais;

        public BufferedServletInputStream(MultipartFilter this$0, ByteArrayInputStream bais) {
            this.bais = bais;
        }

        public int available() {
            return this.bais.available();
        }

        public int read() {
            return this.bais.read();
        }

        public int read(byte[] buf, int off, int len) {
            return this.bais.read(buf, off, len);
        }

        public boolean isFinished() {
            return false;
        }

        public boolean isReady() {
            return true;
        }

        public void setReadListener(ReadListener arg0) {
        }
    }
}

