/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.core.listener;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletContextListener;
import java.io.File;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.core.config.driver.ExtendedInfoManager;
import org.openspcoop2.core.transazioni.utils.DumpUtils;
import org.openspcoop2.monitor.engine.dynamic.CorePluginLoader;
import org.openspcoop2.monitor.engine.dynamic.IRegistroPluginsReader;
import org.openspcoop2.monitor.engine.dynamic.PluginLoader;
import org.openspcoop2.pdd.config.ConfigurazioneNodiRuntime;
import org.openspcoop2.pdd.config.ConfigurazioneNodiRuntimeProperties;
import org.openspcoop2.pdd.core.byok.BYOKMapProperties;
import org.openspcoop2.pdd.core.dynamic.DynamicInfo;
import org.openspcoop2.pdd.core.dynamic.DynamicUtils;
import org.openspcoop2.pdd.services.OpenSPCoop2Startup;
import org.openspcoop2.pdd.services.ServicesUtils;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.sdk.ConfigurazionePdD;
import org.openspcoop2.utils.Costanti;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.UtilsRuntimeException;
import org.openspcoop2.utils.cache.AbstractCacheJmx;
import org.openspcoop2.utils.cache.Cache;
import org.openspcoop2.utils.cache.CacheJMXUtils;
import org.openspcoop2.utils.certificate.byok.BYOKManager;
import org.openspcoop2.utils.certificate.hsm.HSMManager;
import org.openspcoop2.utils.certificate.hsm.HSMUtils;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.date.SystemDate;
import org.openspcoop2.utils.properties.CollectionProperties;
import org.openspcoop2.utils.properties.MapProperties;
import org.openspcoop2.utils.properties.PropertiesUtilities;
import org.openspcoop2.utils.resources.Loader;
import org.openspcoop2.utils.security.ProviderUtils;
import org.openspcoop2.utils.transport.http.HttpLibrary;
import org.openspcoop2.utils.transport.http.HttpLibraryConnection;
import org.openspcoop2.web.monitor.core.config.ApplicationProperties;
import org.openspcoop2.web.monitor.core.dao.DynamicUtilsServiceCache;
import org.openspcoop2.web.monitor.core.dao.DynamicUtilsServiceCacheJmxDatiConfigurazione;
import org.openspcoop2.web.monitor.core.dao.DynamicUtilsServiceCacheJmxRicercheConfigurazione;
import org.openspcoop2.web.monitor.core.dao.RegistroPluginsService;
import org.openspcoop2.web.monitor.core.logger.LoggerManager;
import org.slf4j.Logger;

public abstract class AbstractConsoleStartupListener
implements ServletContextListener {
    protected static Logger log = LoggerWrapperFactory.getLogger(AbstractConsoleStartupListener.class);
    public static boolean initializedLog = false;
    private static final String DEFAULT_APPLICATION_NAME = "/monitor.properties";
    private static final String DEFAULT_LOCAL_APPLICATION_NAME = "/monitor_local.properties";
    private static final String DEFAULT_APPLICATION_PROPERTY_NAME = "MONITOR_PROPERTIES";
    private String applicationProperties;
    private String localApplicationProperties;
    private String localApplicationPropertyName;
    private static final String DEFAULT_LOGGER_NAME = "/monitor.log4j2.properties";
    private static final String DEFAULT_LOCAL_LOGGER_NAME = "/monitor_local.log4j2.properties";
    private static final String DEFAULT_LOGGER_PROPERTY_NAME = "MONITOR_LOG_PROPERTIES";
    private String logProperties;
    private String localLogProperties;
    private String localLogPropertyName;
    public static boolean debugCache_datiConfigurazione = false;
    public static DynamicUtilsServiceCache dynamicUtilsServiceCache_datiConfigurazione = null;
    public static boolean debugCache_ricercheConfigurazione = false;
    public static DynamicUtilsServiceCache dynamicUtilsServiceCache_ricercheConfigurazione = null;
    private static final String DEFAULT_CACHE_NAME = "/monitor.jcs.properties";
    private static final String DEFAULT_LOCAL_CACHE_NAME = "/monitor_local.jcs.properties";
    private static final String DEFAULT_CACHE_PROPERTY_NAME = "MONITOR_CACHE_PROPERTIES";
    private String cacheProperties;
    private String localCacheProperties;
    private String localCachePropertyName;
    private boolean reInitSecretMaps = false;

    public static Logger getLog() {
        return log;
    }

    protected static void logDebug(String msg) {
        if (log != null) {
            log.debug(msg);
        }
    }

    protected static void logDebug(String msg, Throwable e) {
        if (log != null) {
            log.debug(msg, e);
        }
    }

    protected static void logInfo(String msg) {
        if (log != null) {
            log.info(msg);
        }
    }

    protected static void logWarn(String msg) {
        if (log != null) {
            log.warn(msg);
        }
    }

    protected static void logError(String msg) {
        if (log != null) {
            log.error(msg);
        }
    }

    protected static void logError(String msg, Throwable e) {
        if (log != null) {
            log.error(msg, e);
        }
    }

    public void setApplicationProperties(String applicationProperties) {
        this.applicationProperties = applicationProperties;
    }

    public void setLocalApplicationProperties(String localApplicationProperties) {
        this.localApplicationProperties = localApplicationProperties;
    }

    public void setLocalApplicationPropertyName(String localApplicationPropertyName) {
        this.localApplicationPropertyName = localApplicationPropertyName;
    }

    public String getApplicationProperties() {
        if (this.applicationProperties == null || "".equals(this.applicationProperties)) {
            return DEFAULT_APPLICATION_NAME;
        }
        return this.applicationProperties;
    }

    public String getLocalApplicationProperties() {
        if (this.localApplicationProperties == null || "".equals(this.localApplicationProperties)) {
            return DEFAULT_LOCAL_APPLICATION_NAME;
        }
        return this.localApplicationProperties;
    }

    public String getLocalApplicationPropertyName() {
        if (this.localApplicationPropertyName == null || "".equals(this.localApplicationPropertyName)) {
            return DEFAULT_APPLICATION_PROPERTY_NAME;
        }
        return this.localApplicationPropertyName;
    }

    public void setLogProperties(String loggerName) {
        this.logProperties = loggerName;
    }

    public void setLocalLogProperties(String localLog4jProperties) {
        this.localLogProperties = localLog4jProperties;
    }

    public void setLocalLogPropertyName(String localLog4jPropertyName) {
        this.localLogPropertyName = localLog4jPropertyName;
    }

    public String getLoggerProperties() {
        if (this.logProperties == null || "".equals(this.logProperties)) {
            return DEFAULT_LOGGER_NAME;
        }
        return this.logProperties;
    }

    public String getLocalLoggerProperties() {
        if (this.localLogProperties == null || "".equals(this.localLogProperties)) {
            return DEFAULT_LOCAL_LOGGER_NAME;
        }
        return this.localLogProperties;
    }

    public String getLocalLoggerPropertyName() {
        if (this.localLogPropertyName == null || "".equals(this.localLogPropertyName)) {
            return DEFAULT_LOGGER_PROPERTY_NAME;
        }
        return this.localLogPropertyName;
    }

    public void setCacheProperties(String cacheName) {
        this.cacheProperties = cacheName;
    }

    public void setLocalCacheProperties(String localCacheProperties) {
        this.localCacheProperties = localCacheProperties;
    }

    public void setLocalCachePropertyName(String localCachePropertyName) {
        this.localCachePropertyName = localCachePropertyName;
    }

    public String getCacheProperties() {
        if (this.cacheProperties == null || "".equals(this.cacheProperties)) {
            return DEFAULT_CACHE_NAME;
        }
        return this.cacheProperties;
    }

    public String getLocalCacheProperties() {
        if (this.localCacheProperties == null || "".equals(this.localCacheProperties)) {
            return DEFAULT_LOCAL_CACHE_NAME;
        }
        return this.localCacheProperties;
    }

    public String getLocalCachePropertyName() {
        if (this.localCachePropertyName == null || "".equals(this.localCachePropertyName)) {
            return DEFAULT_CACHE_PROPERTY_NAME;
        }
        return this.localCachePropertyName;
    }

    public boolean isReInitSecretMaps() {
        return this.reInitSecretMaps;
    }

    private String getStringInitParameter(ServletContext ctx, String name) {
        String value = ctx.getInitParameter(name);
        if (value == null || "".equals(value)) {
            return null;
        }
        return value.trim();
    }

    public void contextInitialized(ServletContextEvent evt) {
        String msgErrore;
        String msgErrore2;
        ServletContext ctx = evt.getServletContext();
        this.setApplicationProperties(this.getStringInitParameter(ctx, "applicationProperties"));
        this.setLocalApplicationProperties(this.getStringInitParameter(ctx, "localApplicationProperties"));
        this.setLocalApplicationPropertyName(this.getStringInitParameter(ctx, "localApplicationPropertyName"));
        ApplicationProperties appProperties = null;
        try {
            ApplicationProperties.initialize(log, this.getApplicationProperties(), this.getLocalApplicationPropertyName(), this.getLocalApplicationProperties());
            appProperties = ApplicationProperties.getInstance(log);
        }
        catch (Exception e) {
            String msgErrore3 = "Errore durante l'inizializzazione del ApplicationProperties: " + e.getMessage();
            AbstractConsoleStartupListener.logError(msgErrore3, e);
            throw new UtilsRuntimeException(msgErrore3, (Throwable)e);
        }
        try {
            boolean appendActualConfiguration = false;
            String tmpAppendActualConfiguration = appProperties.getProperty("appendLog4j", false, true);
            if (tmpAppendActualConfiguration != null) {
                appendActualConfiguration = "true".equalsIgnoreCase(tmpAppendActualConfiguration.trim());
            }
            this.setLogProperties(this.getStringInitParameter(ctx, "logProperties"));
            this.setLocalLogProperties(this.getStringInitParameter(ctx, "localLogProperties"));
            this.setLocalLogPropertyName(this.getStringInitParameter(ctx, "localLogPropertyName"));
            InputStream is = AbstractConsoleStartupListener.class.getResourceAsStream(this.getLoggerProperties());
            Properties loggerProperties = new Properties();
            loggerProperties.load(is);
            CollectionProperties overrideProp = PropertiesUtilities.searchLocalImplementation((String)"GOVWAY_HOME", (Logger)log, (String)this.getLocalLoggerPropertyName(), (String)this.getLocalLoggerProperties(), (String)appProperties.getConfigurationDir());
            if (overrideProp != null) {
                Enumeration proEnums = overrideProp.keys();
                while (proEnums.hasMoreElements()) {
                    String key = (String)proEnums.nextElement();
                    loggerProperties.put(key, overrideProp.getProperty(key));
                }
            }
            LoggerWrapperFactory.patchLoggers((Properties)loggerProperties, (Map)Costanti.ENV_LOG_MONITOR, Map.of("appName", "govwayMonitor"));
            if (appendActualConfiguration) {
                System.out.println("[govwayMonitor] Attendo inizializzazione GovWay prima di appender la configurazione Log4J ...");
                int i = 0;
                int limit = 60;
                while (!OpenSPCoop2Startup.initialize && i < limit) {
                    Utilities.sleep((long)1000L);
                    if (++i % 10 != 0) continue;
                    System.out.println("[govwayMonitor] Attendo inizializzazione GovWay ...");
                }
                if (!OpenSPCoop2Startup.initialize) {
                    throw new UtilsException("[govwayMonitor] Inizializzazione GovWay non rilevata");
                }
                System.out.println("[govwayMonitor] Configurazione Log4J ...");
                LoggerWrapperFactory.setLogConfiguration((Properties)loggerProperties, (boolean)true);
                System.out.println("[govwayMonitor] Configurazione Log4J aggiunta");
            } else {
                LoggerWrapperFactory.setLogConfiguration((Properties)loggerProperties);
            }
        }
        catch (Exception e) {
            String msgErrore4 = "Errore durante il caricamento del file di logging " + this.getLoggerProperties() + ": " + e.getMessage();
            AbstractConsoleStartupListener.logError(msgErrore4, e);
            throw new UtilsRuntimeException(msgErrore4, (Throwable)e);
        }
        try {
            if (appProperties.getConnettoriRemoteAccessUtilityLibrary() != null) {
                HttpLibraryConnection.setDefaultLibrary((HttpLibrary)appProperties.getConnettoriRemoteAccessUtilityLibrary());
            }
            AbstractConsoleStartupListener.logInfo("HttpLibraryConnection: " + String.valueOf(HttpLibraryConnection.getDefaultLibrary()));
        }
        catch (Exception e) {
            msgErrore2 = "Inizializzazione libreria accesso risorse esterne non riuscita: " + e.getMessage();
            AbstractConsoleStartupListener.logError(msgErrore2, e);
            throw new UtilsRuntimeException(msgErrore2, (Throwable)e);
        }
        try {
            if (!appProperties.isLoginApplication() && (appProperties.getLoginTipo() == null || StringUtils.isEmpty((CharSequence)appProperties.getLoginTipo()))) {
                throw new UtilsException("Con login applicativo disabilitato (login.application=false) deve essere obbligatoriamente definito un tipo di login tramite la propriet\u00e0 'login.tipo'");
            }
        }
        catch (Exception e) {
            msgErrore2 = "Configurazione login errata: " + e.getMessage();
            AbstractConsoleStartupListener.logError(msgErrore2, e);
            throw new UtilsRuntimeException(msgErrore2, (Throwable)e);
        }
        try {
            Logger logR = LoggerManager.getPddMonitorCoreLogger() != null ? LoggerManager.getPddMonitorCoreLogger() : log;
            ServicesUtils.initCheckConnectionDB((Logger)logR, (boolean)appProperties.isJdbcCloseConnectionCheckIsClosed(), (boolean)appProperties.isJdbcCloseConnectionCheckAutocommit());
        }
        catch (Exception e) {
            msgErrore2 = "Inizializzazione controlli connessione non riuscita: " + e.getMessage();
            AbstractConsoleStartupListener.logError(msgErrore2, e);
            throw new UtilsRuntimeException(msgErrore2, (Throwable)e);
        }
        try {
            String mapConfig = appProperties.getEnvMapConfig();
            if (StringUtils.isNotEmpty((CharSequence)mapConfig)) {
                AbstractConsoleStartupListener.logInfo("Inizializzazione environment in corso...");
                MapProperties.initialize((Logger)log, (String)mapConfig, (boolean)appProperties.isEnvMapConfigRequired());
                MapProperties mapProperties = MapProperties.getInstance();
                mapProperties.initEnvironment();
                String msgInit = "Environment inizializzato con le variabili definite nel file '" + mapConfig + "'\n\tJavaProperties: " + String.valueOf(mapProperties.getJavaMap().keys()) + "\n\tEnvProperties: " + String.valueOf(mapProperties.getEnvMap().keys()) + "\n\tObfuscateMode: " + mapProperties.getObfuscateModeDescription() + "\n\tObfuscatedJavaKeys: " + String.valueOf(mapProperties.getObfuscatedJavaKeys()) + "\n\tObfuscatedEnvKeys: " + String.valueOf(mapProperties.getObfuscatedEnvKeys());
                AbstractConsoleStartupListener.logInfo(msgInit);
            }
        }
        catch (Exception e) {
            msgErrore2 = "Inizializzazione ambiente non riuscita: " + e.getMessage();
            AbstractConsoleStartupListener.logError(msgErrore2, e);
            throw new UtilsRuntimeException(msgErrore2, (Throwable)e);
        }
        try {
            if (appProperties.isSecurityLoadBouncyCastle()) {
                ProviderUtils.addBouncyCastleAfterSun((boolean)true);
                AbstractConsoleStartupListener.logInfo("Aggiunto Security Provider org.bouncycastle.jce.provider.BouncyCastleProvider");
            }
        }
        catch (Exception e) {
            msgErrore2 = "Errore durante l'aggiunta dei security provider: " + e.getMessage();
            AbstractConsoleStartupListener.logError(msgErrore2, e);
            throw new UtilsRuntimeException(msgErrore2, (Throwable)e);
        }
        try {
            String hsmConfig = appProperties.getHSMConfigurazione();
            if (StringUtils.isNotEmpty((CharSequence)hsmConfig)) {
                AbstractConsoleStartupListener.logInfo("Inizializzazione HSM in corso...");
                File f = new File(hsmConfig);
                HSMManager.init((File)f, (boolean)appProperties.isHSMRequired(), (Logger)log, (boolean)false);
                HSMUtils.setHsmConfigurableKeyPassword((boolean)appProperties.isHSMKeyPasswordConfigurable());
                AbstractConsoleStartupListener.logInfo("Inizializzazione HSM effettuata con successo");
            }
        }
        catch (Exception e) {
            msgErrore2 = "Errore durante l'inizializzazione del manager HSM: " + e.getMessage();
            AbstractConsoleStartupListener.logError(msgErrore2, e);
            throw new UtilsRuntimeException(msgErrore2, (Throwable)e);
        }
        BYOKManager byokManager = null;
        try {
            String byokConfig = appProperties.getBYOKConfig();
            if (StringUtils.isNotEmpty((CharSequence)byokConfig)) {
                AbstractConsoleStartupListener.logInfo("Inizializzazione BYOK in corso...");
                File f = new File(byokConfig);
                BYOKManager.init((File)f, (boolean)appProperties.isBYOKConfigRequired(), (Logger)log);
                byokManager = BYOKManager.getInstance();
                String msgInit = "Gestore BYOK inizializzato;\n\tHSM registrati: " + String.valueOf(byokManager.getKeystoreTypes()) + "\n\tSecurityEngine registrati: " + String.valueOf(byokManager.getSecurityEngineTypes()) + "\n\tGovWaySecurityEngine: " + byokManager.getSecurityEngineGovWayDescription();
                AbstractConsoleStartupListener.logInfo(msgInit);
            }
        }
        catch (Exception e) {
            msgErrore = "Errore durante l'inizializzazione del manager BYOK: " + e.getMessage();
            AbstractConsoleStartupListener.logError(msgErrore, e);
            throw new UtilsRuntimeException(msgErrore, (Throwable)e);
        }
        try {
            String secretsConfig = appProperties.getBYOKEnvSecretsConfig();
            if (byokManager != null && StringUtils.isNotEmpty((CharSequence)secretsConfig)) {
                AbstractConsoleStartupListener.logInfo("Inizializzazione secrets in corso...");
                boolean useSecurityEngine = true;
                HashMap dynamicMap = new HashMap();
                DynamicInfo dynamicInfo = new DynamicInfo();
                DynamicUtils.fillDynamicMap((Logger)log, dynamicMap, (DynamicInfo)dynamicInfo);
                if (byokManager.isBYOKRemoteGovWayNodeUnwrapConfig()) {
                    this.reInitSecretMaps = true;
                    useSecurityEngine = false;
                }
                BYOKMapProperties.initialize((Logger)log, (String)secretsConfig, (boolean)appProperties.isBYOKEnvSecretsConfigRequired(), (boolean)useSecurityEngine, dynamicMap, (boolean)true);
                BYOKMapProperties secretsProperties = BYOKMapProperties.getInstance();
                secretsProperties.initEnvironment();
                String msgInit = "Environment inizializzato con i secrets definiti nel file '" + secretsConfig + "'\n\tJavaProperties: " + String.valueOf(secretsProperties.getJavaMap().keys()) + "\n\tEnvProperties: " + String.valueOf(secretsProperties.getEnvMap().keys()) + "\n\tObfuscateMode: " + secretsProperties.getObfuscateModeDescription();
                AbstractConsoleStartupListener.logInfo(msgInit);
            }
        }
        catch (Exception e) {
            msgErrore = "Inizializzazione ambiente (secrets) non riuscita: " + e.getMessage();
            AbstractConsoleStartupListener.logError(msgErrore, e);
            throw new UtilsRuntimeException(msgErrore, (Throwable)e);
        }
        boolean isInitializeCache = false;
        boolean cacheEnabledDatiConfigurazione = false;
        boolean cacheEnabledRicercheConfigurazione = false;
        Logger logCore = LoggerManager.getPddMonitorCoreLogger();
        try {
            cacheEnabledDatiConfigurazione = appProperties.isAbilitataCache_datiConfigurazione();
            cacheEnabledRicercheConfigurazione = appProperties.isAbilitataCache_ricercheConfigurazione();
            if (cacheEnabledDatiConfigurazione || cacheEnabledRicercheConfigurazione) {
                this.setCacheProperties(this.getStringInitParameter(ctx, "cacheProperties"));
                this.setLocalCacheProperties(this.getStringInitParameter(ctx, "localCacheProperties"));
                this.setLocalCachePropertyName(this.getStringInitParameter(ctx, "localCachePropertyName"));
                isInitializeCache = Cache.initialize((Logger)log, (Logger)logCore, (String)this.getCacheProperties(), (String)appProperties.getConfigurationDir(), null, (String)"GOVWAY_HOME", (String)this.getLocalCachePropertyName(), (String)this.getLocalCacheProperties());
            }
        }
        catch (Exception e) {
            String msgErrore5 = "Errore durante l'inizializzazione della cache " + this.getCacheProperties() + ": " + e.getMessage();
            AbstractConsoleStartupListener.logError(msgErrore5, e);
            throw new UtilsRuntimeException(msgErrore5, (Throwable)e);
        }
        if ((cacheEnabledDatiConfigurazione || cacheEnabledRicercheConfigurazione) && !isInitializeCache) {
            String msgErrore6 = "Errore durante l'inizializzazione della cache " + this.getCacheProperties() + ": cache non inizializzata";
            AbstractConsoleStartupListener.logError(msgErrore6);
            throw new UtilsRuntimeException(msgErrore6);
        }
        if (cacheEnabledDatiConfigurazione) {
            try {
                debugCache_datiConfigurazione = appProperties.isDebugCache_datiConfigurazione();
                dynamicUtilsServiceCache_datiConfigurazione = new DynamicUtilsServiceCache("datiConfigurazione", logCore, appProperties.getDimensioneCache_datiConfigurazione(), appProperties.getAlgoritmoCache_datiConfigurazione(), appProperties.getItemIdleTimeCache_datiConfigurazione(), appProperties.getItemLifeSecondCache_datiConfigurazione());
                if (appProperties.isAbilitataJmxCache_datiConfigurazione()) {
                    DynamicUtilsServiceCacheJmxDatiConfigurazione jmxObject = new DynamicUtilsServiceCacheJmxDatiConfigurazione();
                    CacheJMXUtils.register((Logger)log, (AbstractCacheJmx)jmxObject, (String)DynamicUtilsServiceCache.JMX_DOMAIN, (String)jmxObject.getCacheWrapper().getCacheName());
                }
            }
            catch (Exception e) {
                String msgErrore7 = "Errore durante la creazione della cache " + this.getCacheProperties() + ": " + e.getMessage();
                AbstractConsoleStartupListener.logError(msgErrore7, e);
                throw new UtilsRuntimeException(msgErrore7, (Throwable)e);
            }
        }
        if (cacheEnabledRicercheConfigurazione) {
            try {
                debugCache_ricercheConfigurazione = appProperties.isDebugCache_ricercheConfigurazione();
                dynamicUtilsServiceCache_ricercheConfigurazione = new DynamicUtilsServiceCache("ricercheConfigurazione", logCore, appProperties.getDimensioneCache_ricercheConfigurazione(), appProperties.getAlgoritmoCache_ricercheConfigurazione(), appProperties.getItemIdleTimeCache_ricercheConfigurazione(), appProperties.getItemLifeSecondCache_ricercheConfigurazione());
                if (appProperties.isAbilitataJmxCache_ricercheConfigurazione()) {
                    DynamicUtilsServiceCacheJmxRicercheConfigurazione jmxObject = new DynamicUtilsServiceCacheJmxRicercheConfigurazione();
                    CacheJMXUtils.register((Logger)log, (AbstractCacheJmx)jmxObject, (String)DynamicUtilsServiceCache.JMX_DOMAIN, (String)jmxObject.getCacheWrapper().getCacheName());
                }
            }
            catch (Exception e) {
                String msgErrore8 = "Errore durante la creazione della cache " + this.getCacheProperties() + ": " + e.getMessage();
                AbstractConsoleStartupListener.logError(msgErrore8, e);
                throw new UtilsRuntimeException(msgErrore8, (Throwable)e);
            }
        }
        ConfigurazionePdD configPdD = null;
        try {
            configPdD = new ConfigurazionePdD();
            configPdD.setAttesaAttivaJDBC(-1L);
            configPdD.setCheckIntervalJDBC(-1);
            configPdD.setLoader(new Loader(this.getClass().getClassLoader()));
            configPdD.setLog(log);
            ProtocolFactoryManager.initialize((Logger)log, (ConfigurazionePdD)configPdD, (String)appProperties.getProtocolloDefault());
        }
        catch (Throwable e) {
            String msgErrore9 = "Errore durante l'inizializzazione del ProtocolFactoryManager: " + e.getMessage();
            AbstractConsoleStartupListener.logError(msgErrore9, e);
            throw new UtilsRuntimeException(msgErrore9, e);
        }
        try {
            ExtendedInfoManager.initialize((Loader)configPdD.getLoader(), null, null, null);
        }
        catch (Exception e) {
            String msgErrore10 = "Errore durante l'inizializzazione del ExtendedInfoManager: " + e.getMessage();
            AbstractConsoleStartupListener.logError(msgErrore10, e);
            throw new UtilsRuntimeException(msgErrore10, (Throwable)e);
        }
        try {
            ConfigurazioneNodiRuntimeProperties backwardCompatibility = new ConfigurazioneNodiRuntimeProperties(appProperties.getJmxPdD_backwardCompatibilityPrefix(), appProperties.getJmxPdD_backwardCompatibilityProperties());
            ConfigurazioneNodiRuntime.initialize((String)appProperties.getJmxPdD_externalConfiguration(), (ConfigurazioneNodiRuntimeProperties[])new ConfigurazioneNodiRuntimeProperties[]{backwardCompatibility});
        }
        catch (Exception e) {
            String msgErrore11 = "Errore durante l'inizializzazione del gestore dei nodi run: " + e.getMessage();
            AbstractConsoleStartupListener.logError(msgErrore11, e);
            throw new UtilsRuntimeException(msgErrore11, (Throwable)e);
        }
        try {
            if (appProperties.isPluginsEnabled()) {
                CorePluginLoader.initialize((Loader)configPdD.getLoader(), (Logger)LoggerManager.getPddMonitorSqlLogger(), PluginLoader.class, (IRegistroPluginsReader)new RegistroPluginsService(), (int)appProperties.getPluginsSeconds());
            }
        }
        catch (Exception e) {
            String msgErrore12 = "Errore durante l'inizializzazione del loader dei plugins: " + e.getMessage();
            AbstractConsoleStartupListener.logError(msgErrore12, e);
            throw new UtilsRuntimeException(msgErrore12, (Throwable)e);
        }
        try {
            DateManager.initializeDataManager((String)SystemDate.class.getName(), null, (Logger)log);
        }
        catch (Exception e) {
            String msgErrore13 = "Errore durante l'inizializzazione del DataManager: " + e.getMessage();
            AbstractConsoleStartupListener.logError(msgErrore13, e);
            throw new UtilsRuntimeException(msgErrore13, (Throwable)e);
        }
        try {
            DumpUtils.setThreshold_readInMemory((int)appProperties.getTransazioniDettaglioVisualizzazioneMessaggiThreshold());
        }
        catch (Exception e) {
            String msgErrore14 = "Errore durante l'inizializzazione del threshold per l'accesso ai dump: " + e.getMessage();
            AbstractConsoleStartupListener.logError(msgErrore14, e);
            throw new UtilsRuntimeException(msgErrore14, (Throwable)e);
        }
        AbstractConsoleStartupListener.logDebug("PddMonitor Console avviata correttamente.");
    }

    public void contextDestroyed(ServletContextEvent arg0) {
        block5: {
            if (log != null) {
                AbstractConsoleStartupListener.logInfo("Undeploy govwayMonitor Console in corso...");
            }
            if (dynamicUtilsServiceCache_datiConfigurazione != null || dynamicUtilsServiceCache_ricercheConfigurazione != null) {
                CacheJMXUtils.unregister();
            }
            try {
                CorePluginLoader.close((Logger)log);
            }
            catch (Throwable e) {
                if (log == null) break block5;
                String msgErrore = "Errore durante la chiusura del loader dei plugins: " + e.getMessage();
                AbstractConsoleStartupListener.logError(msgErrore, e);
            }
        }
        if (log != null) {
            AbstractConsoleStartupListener.logInfo("Undeploy govwayMonitor Console effettuato.");
        }
    }
}

