/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.core.mbean;

import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import org.openspcoop2.generic_project.dao.IServiceWithId;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.web.monitor.core.core.Utils;
import org.slf4j.Logger;

public abstract class BaseBeanDAO<T, K, ServiceType extends IServiceWithId<T, K>>
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected transient ServiceType service;
    protected T selectedElement;
    protected Map<T, Boolean> selectedIds = new HashMap<T, Boolean>();
    protected ArrayList<T> toRemove;
    private static Logger log = LoggerWrapperFactory.getLogger(BaseBeanDAO.class);
    private boolean selectedAll = false;

    public abstract void setService(ServiceType var1);

    public void isAddRequest(ActionEvent ae) {
        this.selectedElement = null;
    }

    public T getSelectedElement() {
        if (this.selectedElement == null) {
            try {
                ParameterizedType parameterizedType = (ParameterizedType)this.getClass().getGenericSuperclass();
                this.selectedElement = Utilities.newInstance((Class)((Class)parameterizedType.getActualTypeArguments()[0]));
            }
            catch (Exception e) {
                log.error("errore cercando di istanziare il selectedElement ", (Throwable)e);
            }
        }
        return this.selectedElement;
    }

    public void setSelectedElement(T selectedElement) {
        this.selectedElement = selectedElement;
    }

    public Map<T, Boolean> getSelectedIds() {
        return this.selectedIds;
    }

    public void setSelectedIds(Map<T, Boolean> selectedIds) {
        this.selectedIds = selectedIds;
    }

    public String delete() {
        this.toRemove = new ArrayList();
        Iterator<T> it = this.selectedIds.keySet().iterator();
        while (it.hasNext()) {
            T elem = it.next();
            if (!this.selectedIds.get(elem).booleanValue()) continue;
            this.toRemove.add(elem);
            it.remove();
        }
        for (T elem : this.toRemove) {
            try {
                this.service.delete(elem);
            }
            catch (Exception e) {
                FacesContext ctx = FacesContext.getCurrentInstance();
                String m = Utils.getMessageFromResourceBundle(ctx.getApplication().getMessageBundle(), "DELETE_ERROR", new String[]{elem.toString()}, ctx.getViewRoot().getLocale());
                ctx.addMessage(null, new FacesMessage(m, e.getLocalizedMessage()));
                Iterator ite = ctx.getMessages();
                while (ite.hasNext()) {
                    FacesMessage t = (FacesMessage)ite.next();
                    log.debug("Detail:" + t.getDetail());
                    log.debug("Summary:" + t.getSummary());
                }
            }
        }
        return null;
    }

    public List<FacesMessage> getMessages() {
        FacesContext ctx = FacesContext.getCurrentInstance();
        Iterator ite = ctx.getMessages();
        ArrayList<FacesMessage> list = new ArrayList<FacesMessage>();
        while (ite.hasNext()) {
            list.add((FacesMessage)ite.next());
        }
        return list;
    }

    public boolean isSelectedAll() {
        return this.selectedAll;
    }

    public void setSelectedAll(boolean selectedAll) {
        this.selectedAll = selectedAll;
    }

    public void addNewListener(ActionEvent ae) {
        this.selectedElement = null;
    }
}

