/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.core.mbean;

import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.faces.model.SelectItem;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.core.commons.search.Soggetto;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.json.JSONUtils;
import org.openspcoop2.web.lib.users.DriverUsersDBException;
import org.openspcoop2.web.lib.users.dao.RicercaUtente;
import org.openspcoop2.web.lib.users.dao.User;
import org.openspcoop2.web.monitor.core.bean.ApplicationBean;
import org.openspcoop2.web.monitor.core.bean.RicercaUtenteBean;
import org.openspcoop2.web.monitor.core.bean.RicercheUtenteSearchForm;
import org.openspcoop2.web.monitor.core.constants.ModalitaRicercaTransazioni;
import org.openspcoop2.web.monitor.core.core.Utility;
import org.openspcoop2.web.monitor.core.dao.IRicercheUtenteService;
import org.openspcoop2.web.monitor.core.dao.IService;
import org.openspcoop2.web.monitor.core.logger.LoggerManager;
import org.openspcoop2.web.monitor.core.mbean.PdDBaseBean;
import org.openspcoop2.web.monitor.core.ricerche.ModuloRicerca;
import org.openspcoop2.web.monitor.core.ricerche.RicercheFileUploadBean;
import org.openspcoop2.web.monitor.core.ricerche.RicerchePersonalizzate;
import org.openspcoop2.web.monitor.core.ricerche.SalvaRicercaForm;
import org.openspcoop2.web.monitor.core.utils.MessageManager;
import org.openspcoop2.web.monitor.core.utils.MessageUtils;
import org.richfaces.model.UploadItem;
import org.slf4j.Logger;

public class RicercheUtenteBean
extends PdDBaseBean<RicercaUtenteBean, Long, IService<RicercaUtenteBean, Long>> {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerManager.getPddMonitorCoreLogger();
    private transient RicercheUtenteSearchForm search;
    private RicercheFileUploadBean ricercheFile = null;
    private String idFiles = null;
    private String caricaRicercheErrorMessage = null;
    private boolean salvataggioOk = false;

    public RicercheUtenteSearchForm getSearch() {
        return this.search;
    }

    public void setSearch(RicercheUtenteSearchForm search) {
        this.search = search;
    }

    public List<SelectItem> getListaModuli() {
        ArrayList<SelectItem> moduli = new ArrayList<SelectItem>();
        moduli.add(new SelectItem((Object)"--", "--"));
        moduli.add(new SelectItem((Object)ModuloRicerca.TRANSAZIONI.toString(), MessageManager.getInstance().getMessageFromResourceBundle("commons.ricercheUtente.modulo.transazioni.label")));
        moduli.add(new SelectItem((Object)ModuloRicerca.EVENTI.toString(), MessageManager.getInstance().getMessageFromResourceBundle("commons.ricercheUtente.modulo.eventi.label")));
        if (ApplicationBean.getInstance().getShowAllarmi()) {
            moduli.add(new SelectItem((Object)ModuloRicerca.ALLARMI.toString(), MessageManager.getInstance().getMessageFromResourceBundle("commons.ricercheUtente.modulo.allarmi.label")));
        }
        moduli.add(new SelectItem((Object)ModuloRicerca.STATISTICHE.toString(), MessageManager.getInstance().getMessageFromResourceBundle("commons.ricercheUtente.modulo.statistiche.label")));
        if (ApplicationBean.getInstance().getShowStatistichePersonalizzate()) {
            moduli.add(new SelectItem((Object)ModuloRicerca.STATISTICHE_PERSONALIZZATE.toString(), MessageManager.getInstance().getMessageFromResourceBundle("commons.ricercheUtente.modulo.statistichePersonalizzate.label")));
        }
        moduli.add(new SelectItem((Object)ModuloRicerca.CONFIGURAZIONI.toString(), MessageManager.getInstance().getMessageFromResourceBundle("commons.ricercheUtente.modulo.configurazioni.label")));
        return moduli;
    }

    public List<SelectItem> getListaModalitaRicerca() {
        ArrayList<SelectItem> modalitaRicercaList = new ArrayList<SelectItem>();
        modalitaRicercaList.add(new SelectItem((Object)"--", "--"));
        String filtroModulo2 = this.search.getFiltroModulo();
        if (filtroModulo2.equals(ModuloRicerca.STATISTICHE.toString())) {
            modalitaRicercaList.add(new SelectItem((Object)"temporale", MessageManager.getInstance().getMessage("stats.analisiStatistica.tipoDistribuzione.temporale.label")));
            modalitaRicercaList.add(new SelectItem((Object)"esiti", MessageManager.getInstance().getMessage("stats.analisiStatistica.tipoDistribuzione.esiti.label")));
            modalitaRicercaList.add(new SelectItem((Object)"errori", MessageManager.getInstance().getMessage("stats.analisiStatistica.tipoDistribuzione.errori.label")));
            modalitaRicercaList.add(new SelectItem((Object)"soggetto_remoto", MessageManager.getInstance().getMessage("stats.analisiStatistica.tipoDistribuzione.soggettoRemoto.label")));
            modalitaRicercaList.add(new SelectItem((Object)"soggetto_locale", MessageManager.getInstance().getMessage("stats.analisiStatistica.tipoDistribuzione.soggettoLocale.label")));
            modalitaRicercaList.add(new SelectItem((Object)"servizio", MessageManager.getInstance().getMessage("stats.analisiStatistica.tipoDistribuzione.servizio.label")));
            modalitaRicercaList.add(new SelectItem((Object)"azione", MessageManager.getInstance().getMessage("stats.analisiStatistica.tipoDistribuzione.azione.label")));
            modalitaRicercaList.add(new SelectItem((Object)"servizio_applicativo", MessageManager.getInstance().getMessage("stats.analisiStatistica.tipoDistribuzione.applicativo.label")));
        }
        if (filtroModulo2.equals(ModuloRicerca.TRANSAZIONI.toString())) {
            modalitaRicercaList.add(new SelectItem((Object)ModalitaRicercaTransazioni.ANDAMENTO_TEMPORALE.toString(), MessageManager.getInstance().getMessage("transazioni.search.tipoRicerca.temporale.ricercaTemporale.label")));
            modalitaRicercaList.add(new SelectItem((Object)ModalitaRicercaTransazioni.RICERCA_LIBERA.toString(), MessageManager.getInstance().getMessage("transazioni.search.tipoRicerca.temporale.ricercaLibera.label")));
            modalitaRicercaList.add(new SelectItem((Object)ModalitaRicercaTransazioni.MITTENTE_TOKEN_INFO.toString(), MessageManager.getInstance().getMessage("transazioni.search.tipoRicerca.mittente.ricercaTokenInfo.label")));
            modalitaRicercaList.add(new SelectItem((Object)ModalitaRicercaTransazioni.MITTENTE_SOGGETTO.toString(), MessageManager.getInstance().getMessage("transazioni.search.tipoRicerca.mittente.ricercaSoggetto.label")));
            modalitaRicercaList.add(new SelectItem((Object)ModalitaRicercaTransazioni.MITTENTE_APPLICATIVO.toString(), MessageManager.getInstance().getMessage("transazioni.search.tipoRicerca.mittente.ricercaApplicativo.label")));
            modalitaRicercaList.add(new SelectItem((Object)ModalitaRicercaTransazioni.MITTENTE_IDENTIFICATIVO_AUTENTICATO.toString(), MessageManager.getInstance().getMessage("transazioni.search.tipoRicerca.mittente.ricercaIdentificativoAutenticato.label")));
            modalitaRicercaList.add(new SelectItem((Object)ModalitaRicercaTransazioni.MITTENTE_INDIRIZZO_IP.toString(), MessageManager.getInstance().getMessage("transazioni.search.tipoRicerca.mittente.ricercaIndirizzoIP.label")));
            modalitaRicercaList.add(new SelectItem((Object)ModalitaRicercaTransazioni.ID_APPLICATIVO_AVANZATA.toString(), MessageManager.getInstance().getMessage("transazioni.search.tipoRicerca.id.ricercaIdentificativoApplicativo.lvl2.ricercaLibera.label")));
            modalitaRicercaList.add(new SelectItem((Object)ModalitaRicercaTransazioni.LIVE.toString(), MessageManager.getInstance().getMessage("transazioni.search.tipoRicerca.live.label")));
        }
        return modalitaRicercaList;
    }

    @Override
    public String delete() {
        ArrayList<Long> idReport = new ArrayList<Long>();
        if (!this.isSelectedAll()) {
            Iterator it = this.selectedIds.keySet().iterator();
            while (it.hasNext()) {
                RicercaUtenteBean bean = (RicercaUtenteBean)((Object)it.next());
                if (!((Boolean)this.selectedIds.get((Object)bean)).booleanValue()) continue;
                idReport.add(bean.getId());
                it.remove();
            }
            for (Long idToRemove : idReport) {
                log.debug("Rimozione Ricerca [{}]", (Object)idToRemove);
                this.service.deleteById(idToRemove);
            }
        } else {
            try {
                this.service.deleteAll();
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                MessageUtils.addErrorMsg(MessageManager.getInstance().getMessage("commons.ricercheUtente.cancellaRicerche.messaggioErrore"));
            }
        }
        return null;
    }

    @Override
    public void initExportListener(ActionEvent ae) {
        super.initExportListener(ae);
    }

    public String exportSelected() {
        try {
            ArrayList<CallSite> idRicerche = new ArrayList<CallSite>();
            if (!this.isSelectedAll()) {
                Iterator it = this.selectedIds.keySet().iterator();
                while (it.hasNext()) {
                    RicercaUtenteBean bean = (RicercaUtenteBean)((Object)it.next());
                    if (!((Boolean)this.selectedIds.get((Object)bean)).booleanValue()) continue;
                    idRicerche.add((CallSite)((Object)("" + bean.getId())));
                    it.remove();
                }
            }
            FacesContext context = FacesContext.getCurrentInstance();
            HttpServletResponse response = (HttpServletResponse)context.getExternalContext().getResponse();
            HttpSession sessione = (HttpSession)context.getExternalContext().getSession(false);
            sessione.setAttribute("idsOriginali", (Object)StringUtils.join(idRicerche, (String)","));
            sessione.setAttribute("isAllOriginale", (Object)this.isSelectedAll());
            response.sendRedirect(context.getExternalContext().getRequestContextPath() + "/ricercheExporter?isAll=" + this.isSelectedAll() + "&ids=" + StringUtils.join(idRicerche, (String)","));
            context.responseComplete();
        }
        catch (Exception e) {
            FacesContext.getCurrentInstance().responseComplete();
            log.error(e.getMessage(), (Throwable)e);
            MessageUtils.addErrorMsg(MessageManager.getInstance().getMessage("commons.ricercheUtente.esportaRicerche.messaggioErrore"));
        }
        return null;
    }

    public String salvaRicerche() {
        this.salvataggioOk = false;
        this.caricaRicercheErrorMessage = null;
        if (this.idFiles != null && !this.idFiles.isEmpty()) {
            RicerchePersonalizzate ricerchePersonalizzate;
            String checkIdentificativiMsg = this.checkIdentificativi();
            if (checkIdentificativiMsg != null) {
                log.error("Identificativi ricevuti non coincidono con quelli in sessione il salvataggio non verra' effettuato.");
                this.setCaricaRicercheErrorMessage(MessageManager.getInstance().getMessage("commons.ricercheUtente.importaRicerche.messaggioErrore"));
                return null;
            }
            if (this.ricercheFile.getMapElementiRicevuti().isEmpty()) {
                log.error("Identificativi ricevuti non coincidono con quelli in sessione il salvataggio non verra' effettuato.");
                this.setCaricaRicercheErrorMessage(MessageManager.getInstance().getMessage("commons.ricercheUtente.importaRicerche.messaggioErrore"));
                return null;
            }
            JSONUtils jsonUtils = JSONUtils.getInstance();
            for (Map.Entry<String, UploadItem> fileCaricatoEntry : this.ricercheFile.getMapElementiRicevuti().entrySet()) {
                UploadItem fileCaricato = fileCaricatoEntry.getValue();
                String fileName = fileCaricato.getFileName();
                if (fileCaricato.getContentType() != null) {
                    boolean checkAcceptedType = this.ricercheFile.checkAcceptedType(fileCaricato.getContentType());
                    if (!checkAcceptedType) {
                        log.error("Il ContentType " + fileCaricato.getContentType() + " del file ricerche " + fileName + " non e' valido.");
                        this.setCaricaRicercheErrorMessage(MessageManager.getInstance().getMessageWithParamsFromResourceBundle("commons.ricercheUtente.importaRicerche.messaggioErrore.fileNonValido", fileName));
                        return null;
                    }
                    try {
                        ricerchePersonalizzate = (RicerchePersonalizzate)jsonUtils.getAsObject(fileCaricato.getData(), RicerchePersonalizzate.class);
                        if (ricerchePersonalizzate != null && ricerchePersonalizzate.getRicerche() != null && !ricerchePersonalizzate.getRicerche().isEmpty()) continue;
                        log.error("Il file ricerche " + fileName + " e' vuoto.");
                        this.setCaricaRicercheErrorMessage(MessageManager.getInstance().getMessageWithParamsFromResourceBundle("commons.ricercheUtente.importaRicerche.messaggioErrore.fileVuoto", fileName));
                        return null;
                    }
                    catch (UtilsException e) {
                        log.error("Il contenuto del file ricerche " + fileName + " non e' valido.");
                        this.setCaricaRicercheErrorMessage(MessageManager.getInstance().getMessageWithParamsFromResourceBundle("commons.ricercheUtente.importaRicerche.messaggioErrore.fileContenutoNonValido", fileName));
                        return null;
                    }
                }
                log.error("Il ContentType " + fileCaricato.getContentType() + " del file ricerche " + fileName + " non e' valido.");
                this.setCaricaRicercheErrorMessage(MessageManager.getInstance().getMessageWithParamsFromResourceBundle("commons.ricercheUtente.importaRicerche.messaggioErrore.fileNonValido", fileName));
                return null;
            }
            ArrayList<String> msgRicercheScartate = new ArrayList<String>();
            for (Map.Entry<String, UploadItem> fileCaricatoEntry : this.ricercheFile.getMapElementiRicevuti().entrySet()) {
                UploadItem fileCaricato = fileCaricatoEntry.getValue();
                String fileName = fileCaricato.getFileName();
                try {
                    ricerchePersonalizzate = (RicerchePersonalizzate)jsonUtils.getAsObject(fileCaricato.getData(), RicerchePersonalizzate.class);
                    User loggedUtente = Utility.getLoggedUtente();
                    String login = loggedUtente.getLogin();
                    for (RicercaUtente ricercaPersonalizzata : ricerchePersonalizzate.getRicerche()) {
                        RicercaUtenteBean ricercaUtenteBean = new RicercaUtenteBean(ricercaPersonalizzata);
                        String nuovaLabelRicerca = ((IRicercheUtenteService)this.service).calcolaLabelRicerca(login, ricercaUtenteBean.getLabel(), ricercaUtenteBean.getModulo(), ricercaUtenteBean.getModalitaRicerca(), ricercaUtenteBean.getVisibilita());
                        if (nuovaLabelRicerca == null) {
                            msgRicercheScartate.add(MessageManager.getInstance().getMessageWithParamsFromResourceBundle("commons.ricercheUtente.importaRicerche.messaggioErrore.ricercaDuplicata", ricercaUtenteBean.getLabel(), ricercaUtenteBean.getModuloLabel(), ricercaUtenteBean.getModalitaRicercaLabel()));
                            continue;
                        }
                        String protocolloRicercaImport = ricercaUtenteBean.getProtocollo();
                        String soggettoRicercaImport = ricercaUtenteBean.getSoggetto();
                        if (protocolloRicercaImport != null && !protocolloRicercaImport.equals("--")) {
                            List<String> protocolliUtente = Utility.getProtocolli(loggedUtente);
                            if (!protocolliUtente.contains(protocolloRicercaImport)) {
                                msgRicercheScartate.add(MessageManager.getInstance().getMessageWithParamsFromResourceBundle("commons.ricercheUtente.importaRicerche.messaggioErrore.protocolloNonDisponibile", ricercaUtenteBean.getLabel(), ricercaUtenteBean.getProtocolloLabel()));
                                continue;
                            }
                            if (soggettoRicercaImport != null && !soggettoRicercaImport.equals("--")) {
                                String tipoSoggettoOperativoSelezionato = Utility.parseTipoSoggetto(soggettoRicercaImport);
                                String nomeSoggettoOperativoSelezionato = Utility.parseNomeSoggetto(soggettoRicercaImport);
                                List<Soggetto> soggettiOperativiAssociatiAlProfilo = Utility.getSoggettiOperativiAssociatiAlProfilo(Utility.getLoggedUser(), protocolloRicercaImport);
                                boolean found = false;
                                for (Soggetto soggetto : soggettiOperativiAssociatiAlProfilo) {
                                    if (!soggetto.getTipoSoggetto().equals(tipoSoggettoOperativoSelezionato) || !soggetto.getNomeSoggetto().equals(nomeSoggettoOperativoSelezionato)) continue;
                                    found = true;
                                    break;
                                }
                                if (!found) {
                                    msgRicercheScartate.add(MessageManager.getInstance().getMessageWithParamsFromResourceBundle("commons.ricercheUtente.importaRicerche.messaggioErrore.soggettoNonDisponibile", ricercaUtenteBean.getLabel(), ricercaUtenteBean.getSoggettoLabel()));
                                    continue;
                                }
                            }
                        }
                        ricercaPersonalizzata.setLabel(nuovaLabelRicerca);
                        ((IRicercheUtenteService)this.service).insertRicerca(login, ricercaPersonalizzata);
                    }
                }
                catch (UtilsException e) {
                    log.error("Il contenuto del file ricerche " + fileName + " non e' valido.");
                    this.setCaricaRicercheErrorMessage(MessageManager.getInstance().getMessageWithParamsFromResourceBundle("commons.ricercheUtente.importaRicerche.messaggioErrore.fileContenutoNonValido", fileName));
                    return null;
                }
                catch (ProtocolException | DriverUsersDBException e) {
                    log.error("Si e' verificato un errore in fase di salvataggio: " + e.getMessage(), e);
                    this.setCaricaRicercheErrorMessage(MessageManager.getInstance().getMessage("commons.ricercheUtente.messaggioErrore.operazioneNonEseguita"));
                    return null;
                }
            }
            this.salvataggioOk = true;
            if (!msgRicercheScartate.isEmpty()) {
                MessageUtils.addWarnMsg(MessageManager.getInstance().getMessage("commons.ricercheUtente.importaRicerche.messaggioErrore.caricamentoCompletatoConErrori"));
                for (String msgRicercaScartata : msgRicercheScartate) {
                    MessageUtils.addWarnMsg(msgRicercaScartata);
                }
            } else {
                FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(MessageManager.getInstance().getMessage("commons.ricercheUtente.importaRicerche.ok")));
            }
            return null;
        }
        log.error("Nessun file selezionato.");
        this.setCaricaRicercheErrorMessage(MessageManager.getInstance().getMessageWithParamsFromResourceBundle("commons.ricercheUtente.importaRicerche.messaggioErrore.fileNonIndicato", MessageManager.getInstance().getMessageFromResourceBundle("commons.ricercheUtente.importaRicerche.label")));
        return null;
    }

    public String aggiornaRicerca() {
        try {
            User loggedUtente = Utility.getLoggedUtente();
            String login = loggedUtente.getLogin();
            String aggiornaRicercaErrorMessage = this.eseguiValidazioneForm();
            if (aggiornaRicercaErrorMessage != null) {
                MessageUtils.addErrorMsg(aggiornaRicercaErrorMessage);
                return null;
            }
            RicercaUtenteBean oldRicercaUtente = (RicercaUtenteBean)((Object)this.service.findById(((RicercaUtenteBean)((Object)this.getSelectedElement())).getId()));
            String labelToSave = ((RicercaUtenteBean)((Object)this.getSelectedElement())).getLabel().replaceAll("\\s+", " ").trim();
            if (!oldRicercaUtente.getLabel().equals(labelToSave)) {
                if (((IRicercheUtenteService)this.service).esisteRicerca(login, false, labelToSave, ((RicercaUtenteBean)((Object)this.getSelectedElement())).getModulo(), ((RicercaUtenteBean)((Object)this.getSelectedElement())).getModalitaRicerca(), null)) {
                    MessageUtils.addErrorMsg(MessageManager.getInstance().getMessage("commons.ricercheUtente.aggiornaRicerca.messaggioErrore.ricercaDuplicata"));
                    return null;
                }
                if (((IRicercheUtenteService)this.service).esisteRicercaPubblicaAltroUtente(login, labelToSave, ((RicercaUtenteBean)((Object)this.getSelectedElement())).getModulo(), ((RicercaUtenteBean)((Object)this.getSelectedElement())).getModalitaRicerca())) {
                    MessageUtils.addErrorMsg(MessageManager.getInstance().getMessage("commons.ricercheUtente.aggiornaRicerca.messaggioErrore.ricercaPubblicaDuplicata"));
                    return null;
                }
            }
            oldRicercaUtente.setLabel(labelToSave);
            oldRicercaUtente.setDescrizione(((RicercaUtenteBean)((Object)this.selectedElement)).getDescrizione().trim());
            oldRicercaUtente.setVisibilita(((RicercaUtenteBean)((Object)this.selectedElement)).getVisibilita());
            ((IRicercheUtenteService)this.service).updateRicerca(login, oldRicercaUtente);
            FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(MessageManager.getInstance().getMessage("commons.ricercheUtente.aggiornaRicerca.ok")));
            return "ricercheUtente";
        }
        catch (DriverUsersDBException e) {
            log.error("Si e' verificato un errore in fase di salvataggio: " + e.getMessage(), (Throwable)e);
            MessageUtils.addErrorMsg(MessageManager.getInstance().getMessage("commons.ricercheUtente.messaggioErrore.operazioneNonEseguita"));
            return null;
        }
    }

    public String eseguiValidazioneForm() {
        String aggiornaRicercaErrorMessage = SalvaRicercaForm.validaLabel(((RicercaUtenteBean)((Object)this.getSelectedElement())).getLabel());
        if (aggiornaRicercaErrorMessage != null) {
            return aggiornaRicercaErrorMessage;
        }
        aggiornaRicercaErrorMessage = SalvaRicercaForm.validaDescrizione(((RicercaUtenteBean)((Object)this.getSelectedElement())).getDescrizione());
        if (aggiornaRicercaErrorMessage != null) {
            return aggiornaRicercaErrorMessage;
        }
        aggiornaRicercaErrorMessage = SalvaRicercaForm.validaVisibilita(((RicercaUtenteBean)((Object)this.getSelectedElement())).getVisibilita());
        if (aggiornaRicercaErrorMessage != null) {
            return aggiornaRicercaErrorMessage;
        }
        return null;
    }

    public void initFormRicercaListener(ActionEvent ae) {
        this.ricercheFile.clear();
        this.salvataggioOk = false;
        this.caricaRicercheErrorMessage = null;
    }

    public RicercheFileUploadBean getRicercheFile() {
        return this.ricercheFile;
    }

    public void setRicercheFile(RicercheFileUploadBean ricercheFile) {
        this.ricercheFile = ricercheFile;
        this.ricercheFile.setmBean(this);
    }

    public String getIdFiles() {
        return this.idFiles;
    }

    public void setIdFiles(String idFiles) {
        this.idFiles = idFiles;
    }

    public void clearIdFiles() {
        this.setIdFiles("");
    }

    public String checkIdentificativi() {
        String[] ids;
        if (StringUtils.isNotEmpty((CharSequence)this.idFiles) && (ids = this.idFiles.split(",")) != null && ids.length > 0) {
            if (ids.length != this.ricercheFile.getMapChiaviElementi().size()) {
                return "ERRORE_GENERICO";
            }
            for (String idRicerca : ids) {
                if (this.ricercheFile.getMapChiaviElementi().containsKey(idRicerca)) continue;
                return "ERRORE_GENERICO";
            }
            return null;
        }
        return "ERRORE_GENERICO";
    }

    public String getCaricaRicercheErrorMessage() {
        return this.caricaRicercheErrorMessage;
    }

    public void setCaricaRicercheErrorMessage(String caricaRicercheErrorMessage) {
        this.caricaRicercheErrorMessage = caricaRicercheErrorMessage;
    }

    public boolean isSalvataggioOk() {
        return this.salvataggioOk;
    }

    public void setSalvataggioOk(boolean salvataggioOk) {
        this.salvataggioOk = salvataggioOk;
    }
}

