/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.core.report;

import org.openspcoop2.utils.resources.Loader;
import org.openspcoop2.web.monitor.core.logger.LoggerManager;
import org.openspcoop2.web.monitor.core.report.ILiveReport;
import org.slf4j.Logger;

public class ReportFactory {
    private static Logger log = LoggerManager.getPddMonitorCoreLogger();
    private static ReportFactory staticInstance = null;
    private ILiveReport transazioniReportManager = null;
    private ILiveReport statisticaReportManager = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ReportFactory getInstance() {
        if (staticInstance != null) return staticInstance;
        Class<ReportFactory> clazz = ReportFactory.class;
        synchronized (ReportFactory.class) {
            ReportFactory.init();
            // ** MonitorExit[var0] (shouldn't be in output)
            return staticInstance;
        }
    }

    private static synchronized void init() {
        if (staticInstance == null) {
            staticInstance = new ReportFactory();
        }
    }

    private ReportFactory() {
        try {
            log.debug("Init ReportFactory in corso...");
            log.debug("Init ReportFactory completato.");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public ILiveReport getTransazioniReportManager() {
        if (this.transazioniReportManager == null) {
            this.initTransazioniReportManagerEngine();
        }
        return this.transazioniReportManager;
    }

    private synchronized void initTransazioniReportManagerEngine() {
        try {
            log.debug("Init Report Manager Transazioni in corso...");
            if (this.transazioniReportManager == null) {
                this.transazioniReportManager = (ILiveReport)Loader.getInstance().newInstance("org.openspcoop2.web.monitor.transazioni.report.TransazioniReportManager");
            }
            log.debug("Init Report Manager Transazioni completato.");
        }
        catch (Exception e) {
            log.debug("Errore durante la creazione del Report Manager Transazioni:" + e.getMessage(), (Throwable)e);
        }
    }

    public ILiveReport getStatisticaReportManager() {
        if (this.statisticaReportManager == null) {
            this.initStatisticaReportManagerEngine();
        }
        return this.statisticaReportManager;
    }

    private synchronized void initStatisticaReportManagerEngine() {
        try {
            log.debug("Init Report Manager Statistiche in corso...");
            if (this.statisticaReportManager == null) {
                this.statisticaReportManager = (ILiveReport)Loader.getInstance().newInstance("org.openspcoop2.web.monitor.statistiche.report.StatisticaReportManager");
            }
            log.debug("Init Report Manager Statistiche completato.");
        }
        catch (Exception e) {
            log.debug("Errore durante la creazione del Report Manager Statistiche:" + e.getMessage(), (Throwable)e);
        }
    }
}

