/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.core.report;

import be.quodlibet.boxable.BaseTable;
import be.quodlibet.boxable.Cell;
import be.quodlibet.boxable.Table;
import be.quodlibet.boxable.datatable.DataTable;
import be.quodlibet.boxable.line.LineStyle;
import java.awt.Color;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFDataFormat;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.csv.Format;
import org.openspcoop2.utils.csv.FormatReader;
import org.openspcoop2.utils.csv.Printer;
import org.openspcoop2.web.monitor.core.report.Colonna;

public class Templates {
    public static final float MARGIN = 10.0f;
    public static final float PDF_SPACE_TEXT_FONT_SIZE = 6.0f;
    public static final float PDF_TEXT_FONT_SIZE = 8.0f;
    public static final float PDF_TABLE_FONT_SIZE = 8.0f;
    public static final float PDF_TITLE_FONT_SIZE = 18.0f;
    public static final float PDF_SUBTITLE_FONT_SIZE = 14.0f;
    public static final String PDF_LINKIT_URL = "https://govway.org";
    public static final Color TABLE_HEADER_BACKGROUND_COLOR = new Color(192, 192, 192);
    public static final Color TABLE_EVEN_ROWS_BACKGROUND_COLOR = new Color(255, 255, 255);
    public static final Color TABLE_ODD_ROWS_BACKGROUND_COLOR = new Color(240, 240, 240);
    public static final Color BORDER_COLOR_BLACK = new Color(0, 0, 0);
    public static final LineStyle SOLID_BORDER_BLACK_1F = new LineStyle(BORDER_COLOR_BLACK, 1.0f);
    private static Properties propertiesWriterCsv;

    private Templates() {
    }

    public static void createTitleComponent(String titoloReport, String periodoOsservazione, PDDocument document) throws IOException {
        if ((periodoOsservazione == null || StringUtils.isEmpty((CharSequence)periodoOsservazione)) && titoloReport.contains(" ( dal ")) {
            int indexOf = titoloReport.indexOf(" ( dal ");
            periodoOsservazione = titoloReport.substring(indexOf);
            titoloReport = titoloReport.substring(0, indexOf);
        }
        titoloReport = titoloReport.trim();
        if (periodoOsservazione != null) {
            periodoOsservazione = periodoOsservazione.trim();
        }
        PDPage page = document.getPage(0);
        float width = page.getMediaBox().getWidth();
        float height = page.getMediaBox().getHeight();
        PDPageContentStream contentStream = new PDPageContentStream(document, page);
        contentStream.beginText();
        contentStream.setFont((PDFont)PDType1Font.HELVETICA_BOLD, 18.0f);
        contentStream.newLineAtOffset(10.0f, height - 40.0f);
        contentStream.showText(titoloReport);
        contentStream.endText();
        contentStream.beginText();
        contentStream.setFont((PDFont)PDType1Font.HELVETICA_BOLD, 14.0f);
        contentStream.newLineAtOffset(10.0f, height - 60.0f);
        contentStream.showText(periodoOsservazione);
        contentStream.endText();
        contentStream.beginText();
        contentStream.setFont((PDFont)PDType1Font.HELVETICA_OBLIQUE, 8.0f);
        contentStream.newLineAtOffset(10.0f, height - 110.0f);
        contentStream.showText(PDF_LINKIT_URL);
        contentStream.endText();
        float yLine = 116.0f;
        contentStream.setLineWidth(1.5f);
        contentStream.moveTo(10.0f, height - yLine);
        contentStream.lineTo(width - 10.0f, height - yLine);
        contentStream.stroke();
        contentStream.close();
    }

    private static List<List> convert(List<List<String>> src, List<Colonna> colonne) {
        List<List> lReturnNull = null;
        if (src == null || src.isEmpty()) {
            return lReturnNull;
        }
        if (colonne == null || colonne.isEmpty()) {
            return lReturnNull;
        }
        ArrayList<List> data = new ArrayList<List>();
        ArrayList<String> headers = new ArrayList<String>();
        for (Colonna colonna : colonne) {
            headers.add(colonna.getLabel());
        }
        data.add(headers);
        for (List list : src) {
            data.add(list);
        }
        return data;
    }

    public static void createTableComponent(List<Colonna> colonne, List<List<String>> dati, PDDocument document) throws IOException {
        if (colonne == null || colonne.isEmpty()) {
            throw new IOException("Colonne non fornite");
        }
        if (dati == null || dati.isEmpty()) {
            throw new IOException("Dati non forniti");
        }
        if (document == null) {
            throw new IOException("Document non fornito");
        }
        PDPage page = document.getPage(0);
        float height = page.getMediaBox().getHeight();
        float yStart = height - 130.0f;
        float startNewPageY = height - 20.0f;
        float bottomMargin = 10.0f;
        float tableWidth = page.getMediaBox().getWidth() - 20.0f;
        BaseTable dataTable = new BaseTable(yStart, startNewPageY, bottomMargin, tableWidth, 10.0f, document, page, true, true);
        DataTable t = new DataTable((Table)dataTable, page);
        t.addListToTable(Templates.convert(dati, colonne), DataTable.HASHEADER);
        int numeroColonne = colonne.size();
        float preferredColumWidth = tableWidth / (float)numeroColonne;
        for (int jColonna = 0; jColonna < dataTable.getHeader().getCells().size(); ++jColonna) {
            Colonna colonna = colonne.get(jColonna);
            ((Cell)dataTable.getHeader().getCells().get(jColonna)).setFillColor(TABLE_HEADER_BACKGROUND_COLOR);
            ((Cell)dataTable.getHeader().getCells().get(jColonna)).setAlign(colonna.getAlignment());
            ((Cell)dataTable.getHeader().getCells().get(jColonna)).setFontSize(8.0f);
            ((Cell)dataTable.getHeader().getCells().get(jColonna)).setWidth(preferredColumWidth);
            ((Cell)dataTable.getHeader().getCells().get(jColonna)).setFont((PDFont)PDType1Font.HELVETICA_BOLD);
        }
        for (int iRiga = 1; iRiga < dataTable.getRows().size(); ++iRiga) {
            for (int jColonna = 0; jColonna < ((be.quodlibet.boxable.Row)dataTable.getRows().get(iRiga)).getCells().size(); ++jColonna) {
                Colonna colonna = colonne.get(jColonna);
                if (iRiga % 2 == 0) {
                    ((Cell)((be.quodlibet.boxable.Row)dataTable.getRows().get(iRiga)).getCells().get(jColonna)).setFillColor(TABLE_EVEN_ROWS_BACKGROUND_COLOR);
                    ((Cell)((be.quodlibet.boxable.Row)dataTable.getRows().get(iRiga)).getCells().get(jColonna)).setBorderStyle(new LineStyle(TABLE_EVEN_ROWS_BACKGROUND_COLOR, 0.0f));
                } else {
                    ((Cell)((be.quodlibet.boxable.Row)dataTable.getRows().get(iRiga)).getCells().get(jColonna)).setFillColor(TABLE_ODD_ROWS_BACKGROUND_COLOR);
                    ((Cell)((be.quodlibet.boxable.Row)dataTable.getRows().get(iRiga)).getCells().get(jColonna)).setBorderStyle(new LineStyle(TABLE_ODD_ROWS_BACKGROUND_COLOR, 0.0f));
                }
                ((Cell)((be.quodlibet.boxable.Row)dataTable.getRows().get(iRiga)).getCells().get(jColonna)).setAlign(colonna.getAlignment());
                ((Cell)((be.quodlibet.boxable.Row)dataTable.getRows().get(iRiga)).getCells().get(jColonna)).setFontSize(8.0f);
                ((Cell)((be.quodlibet.boxable.Row)dataTable.getRows().get(iRiga)).getCells().get(jColonna)).setWidth(preferredColumWidth);
                ((Cell)((be.quodlibet.boxable.Row)dataTable.getRows().get(iRiga)).getCells().get(jColonna)).setFont((PDFont)PDType1Font.HELVETICA);
            }
        }
        dataTable.draw();
    }

    public static XSSFFont createHeaderFont(XSSFWorkbook workbook) {
        XSSFFont headerFont = workbook.createFont();
        headerFont.setBold(true);
        headerFont.setColor(IndexedColors.BLACK.getIndex());
        headerFont.setFontHeight(10.0);
        return headerFont;
    }

    public static XSSFFont createCellFont(XSSFWorkbook workbook) {
        XSSFFont headerFont = workbook.createFont();
        short blackIndex = IndexedColors.BLACK.getIndex();
        headerFont.setColor(blackIndex);
        headerFont.setFontHeight(10.0);
        return headerFont;
    }

    public static XSSFCellStyle createHeaderStyle(XSSFWorkbook workbook) {
        XSSFCellStyle headerCellStyle = workbook.createCellStyle();
        headerCellStyle.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
        headerCellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        headerCellStyle.setAlignment(HorizontalAlignment.CENTER);
        headerCellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        headerCellStyle.setFont((Font)Templates.createHeaderFont(workbook));
        headerCellStyle.setBorderTop(BorderStyle.THIN);
        headerCellStyle.setBorderRight(BorderStyle.THIN);
        headerCellStyle.setBorderBottom(BorderStyle.THIN);
        headerCellStyle.setBorderLeft(BorderStyle.THIN);
        short blackIndex = IndexedColors.BLACK.getIndex();
        headerCellStyle.setTopBorderColor(blackIndex);
        headerCellStyle.setRightBorderColor(blackIndex);
        headerCellStyle.setBottomBorderColor(blackIndex);
        headerCellStyle.setLeftBorderColor(blackIndex);
        return headerCellStyle;
    }

    public static XSSFCellStyle createCellStyle(XSSFWorkbook workbook) {
        XSSFCellStyle cellStyle = workbook.createCellStyle();
        XSSFDataFormat dataFormat = workbook.createDataFormat();
        cellStyle.setDataFormat(dataFormat.getFormat("@"));
        cellStyle.setAlignment(HorizontalAlignment.LEFT);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        cellStyle.setFont((Font)Templates.createCellFont(workbook));
        return cellStyle;
    }

    public static void autoSizeColumn(XSSFWorkbook workbook) {
        for (Sheet sheet : workbook) {
            if (sheet.getPhysicalNumberOfRows() <= 0) continue;
            Row row = sheet.getRow(sheet.getFirstRowNum());
            Iterator cellIterator = row.cellIterator();
            while (cellIterator.hasNext()) {
                org.apache.poi.ss.usermodel.Cell cell = (org.apache.poi.ss.usermodel.Cell)cellIterator.next();
                int columnIndex = cell.getColumnIndex();
                sheet.autoSizeColumn(columnIndex);
            }
        }
    }

    public static void writeDataIntoXls(List<List<String>> dati, List<String> labelColonna, XSSFWorkbook workbook) {
        int i;
        XSSFSheet sheet = workbook.createSheet("Report");
        XSSFRow header = sheet.createRow(0);
        XSSFCellStyle headerStyle = Templates.createHeaderStyle(workbook);
        XSSFCellStyle cellStyle = Templates.createCellStyle(workbook);
        for (i = 0; i < labelColonna.size(); ++i) {
            String label = labelColonna.get(i);
            XSSFCell headerCell = header.createCell(i);
            headerCell.setCellStyle((CellStyle)headerStyle);
            headerCell.setCellValue(label);
            headerCell.setCellType(CellType.STRING);
        }
        for (i = 0; i < dati.size(); ++i) {
            List<String> riga = dati.get(i);
            XSSFRow row = sheet.createRow(i + 1);
            for (int j = 0; j < riga.size(); ++j) {
                XSSFCell cell = row.createCell(j);
                cell.setCellStyle((CellStyle)cellStyle);
                cell.setCellValue(riga.get(j));
                cell.setCellType(CellType.STRING);
            }
        }
        Templates.autoSizeColumn(workbook);
    }

    public static Properties getPropertiesWriterCsv() {
        if (propertiesWriterCsv == null) {
            Templates.init();
        }
        return propertiesWriterCsv;
    }

    private static synchronized void init() {
        if (propertiesWriterCsv == null) {
            propertiesWriterCsv = new Properties();
            propertiesWriterCsv.put("format", "Default");
            propertiesWriterCsv.put("commentMarker", "#");
            propertiesWriterCsv.put("delimiter", ",");
            propertiesWriterCsv.put("withHeader", (Object)false);
            propertiesWriterCsv.put("ignoreEmptyLines", (Object)true);
            propertiesWriterCsv.put("ignoreSurroundingSpaces", (Object)true);
            propertiesWriterCsv.put("nullString", "");
            propertiesWriterCsv.put("skipEmptyRecord", (Object)true);
        }
    }

    public static Format getFormat() throws UtilsException {
        FormatReader formatWriter = new FormatReader(Templates.getPropertiesWriterCsv());
        return formatWriter.getFormat();
    }

    public static Printer getPrinter(OutputStream outputStream) throws UtilsException {
        return new Printer(Templates.getFormat(), outputStream);
    }

    public static void writeDataIntoCsv(List<List<String>> dati, List<String> labelColonna, Printer printer) throws UtilsException {
        printer.printRecord(labelColonna);
        for (List<String> list : dati) {
            printer.printRecord(list);
        }
    }
}

