/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.core.ricerche;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Date;
import javax.faces.event.ActionEvent;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.json.JSONUtils;
import org.openspcoop2.web.lib.users.dao.RicercaUtente;
import org.openspcoop2.web.monitor.core.bean.AbstractDateSearchForm;
import org.openspcoop2.web.monitor.core.ricerche.FiltriRicercaPersonalizzata;
import org.openspcoop2.web.monitor.core.ricerche.ModuloRicerca;
import org.openspcoop2.web.monitor.core.utils.MessageManager;

public class SalvaRicercaForm {
    private String label;
    private String visibilita;
    private String descrizione;
    private ModuloRicerca modulo;
    private String modalitaRicerca;
    private AbstractDateSearchForm search;
    private String salvaRicercaErrorMessage = null;

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getVisibilita() {
        return this.visibilita;
    }

    public void setVisibilita(String visibilita) {
        this.visibilita = visibilita;
    }

    public AbstractDateSearchForm getSearch() {
        return this.search;
    }

    public void setSearch(AbstractDateSearchForm search) {
        this.search = search;
    }

    public String getSalvaRicercaErrorMessage() {
        return this.salvaRicercaErrorMessage;
    }

    public void setSalvaRicercaErrorMessage(String salvaRicercaErrorMessage) {
        this.salvaRicercaErrorMessage = salvaRicercaErrorMessage;
    }

    public ModuloRicerca getModulo() {
        return this.modulo;
    }

    public void setModulo(ModuloRicerca modulo) {
        this.modulo = modulo;
    }

    public String getModalitaRicerca() {
        return this.modalitaRicerca;
    }

    public void setModalitaRicerca(String modalitaRicerca) {
        this.modalitaRicerca = modalitaRicerca;
    }

    public String getDescrizione() {
        return this.descrizione;
    }

    public void setDescrizione(String descrizione) {
        this.descrizione = descrizione;
    }

    public void initFormListener(ActionEvent ae) {
        this.label = "";
        this.descrizione = "";
        this.visibilita = "privata";
        this.search = null;
        this.salvaRicercaErrorMessage = null;
    }

    public boolean eseguiValidazioneForm() {
        if (this.salvaRicercaErrorMessage == null) {
            this.salvaRicercaErrorMessage = SalvaRicercaForm.validaLabel(this.getLabel());
            if (this.salvaRicercaErrorMessage != null) {
                return false;
            }
            this.salvaRicercaErrorMessage = SalvaRicercaForm.validaDescrizione(this.getDescrizione());
            if (this.salvaRicercaErrorMessage != null) {
                return false;
            }
            this.salvaRicercaErrorMessage = SalvaRicercaForm.validaVisibilita(this.getVisibilita());
        }
        return this.salvaRicercaErrorMessage == null;
    }

    public static String validaLabel(String label) {
        if (StringUtils.isEmpty((CharSequence)label)) {
            return MessageManager.getInstance().getMessage("commons.salvaRicerca.missing_parameter.label");
        }
        if (label.length() > 255) {
            return MessageManager.getInstance().getMessage("commons.salvaRicerca.invalid_parameter.label.dimensioneNonValida");
        }
        if (label.length() != label.trim().length()) {
            return MessageManager.getInstance().getMessage("commons.salvaRicerca.invalid_parameter.label.caratteriVuotiAgliEstremi");
        }
        return null;
    }

    public static String validaDescrizione(String descrizione) {
        if (StringUtils.isEmpty((CharSequence)descrizione)) {
            return MessageManager.getInstance().getMessage("commons.salvaRicerca.missing_parameter.descrizione");
        }
        if (descrizione.length() > 4000) {
            return MessageManager.getInstance().getMessage("commons.salvaRicerca.invalid_parameter.descrizione.dimensioneNonValida");
        }
        if (descrizione.length() != descrizione.trim().length()) {
            return MessageManager.getInstance().getMessage("commons.salvaRicerca.invalid_parameter.descrizione.caratteriVuotiAgliEstremi");
        }
        return null;
    }

    public static String validaVisibilita(String visibilita) {
        if (StringUtils.isEmpty((CharSequence)visibilita)) {
            return MessageManager.getInstance().getMessage("commons.salvaRicerca.missing_parameter.visibilita");
        }
        return null;
    }

    public String validaForm() {
        this.eseguiValidazioneForm();
        return null;
    }

    public RicercaUtente getRicerca() throws UtilsException {
        RicercaUtente ricercaPersonalizzata = new RicercaUtente();
        ricercaPersonalizzata.setLabel(this.label.replaceAll("\\s+", " ").trim());
        ricercaPersonalizzata.setDescrizione(this.descrizione.trim());
        ricercaPersonalizzata.setDataCreazione(new Date());
        ricercaPersonalizzata.setVisibilita(this.visibilita);
        ricercaPersonalizzata.setModulo(this.modulo.toString());
        ricercaPersonalizzata.setModalitaRicerca(this.modalitaRicerca);
        ricercaPersonalizzata.setProtocollo(this.search.getProtocolloRicerca());
        ricercaPersonalizzata.setSoggetto(this.search.getSoggettoRicerca());
        FiltriRicercaPersonalizzata filtriRicercaPersonalizzata = new FiltriRicercaPersonalizzata();
        filtriRicercaPersonalizzata.setFiltri(this.search.getFiltriImpostati());
        JSONUtils jsonUtils = JSONUtils.getInstance();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        jsonUtils.writeTo((Object)filtriRicercaPersonalizzata, (OutputStream)baos);
        ricercaPersonalizzata.setRicerca(baos.toString());
        return ricercaPersonalizzata;
    }

    public void impostaIdRicercaSalvata(long idUtente, long idRicerca) {
        String idRicercaForm = idUtente + "_" + idRicerca;
        this.search.setRicercaUtente(idRicercaForm);
    }

    public boolean getSalvaRicercaErrorMessageCheck() {
        return this.salvaRicercaErrorMessage == null;
    }
}

