/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.core.servlet;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.fileupload2.core.DiskFileItem;
import org.apache.commons.fileupload2.core.DiskFileItemFactory;
import org.apache.commons.fileupload2.jakarta.JakartaServletDiskFileUpload;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.json.JSONUtils;
import org.openspcoop2.web.monitor.core.bean.BaseFileUploadBean;
import org.openspcoop2.web.monitor.core.logger.LoggerManager;
import org.openspcoop2.web.monitor.core.utils.BrowserInfo;
import org.richfaces.model.UploadItem;
import org.slf4j.Logger;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class UploadServlet
extends HttpServlet {
    private static final String RESPONSE_LOG = "Response [{}].";
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerManager.getPddMonitorCoreLogger();
    public static final String ID_TO_DELETE_PARAM_NAME = "id";
    private String fileUploadBeanName = "fileUploadBean";

    public void init() throws ServletException {
        super.init();
        this.fileUploadBeanName = this.getInitParameter("fileUploadBeanName");
        log.debug("Init Servlet UploadServlet completato.");
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        log.error("Operazione non consentita!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        log.debug("DoPost!");
        try {
            WebApplicationContext context = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServletContext());
            if (context == null) {
                throw new CoreException("Context is null");
            }
            BaseFileUploadBean fileUploadBean = (BaseFileUploadBean)context.getBean(this.fileUploadBeanName);
            Map<String, UploadItem> mapElementiRicevuti = fileUploadBean.getMapElementiRicevuti();
            Map<String, String> mapChiaviElementi = fileUploadBean.getMapChiaviElementi();
            String baseDeleteURL = req.getContextPath() + req.getServletPath();
            String userAgent = req.getHeader("User-Agent");
            DiskFileItemFactory diskFileItemFactory = DiskFileItemFactory.builder().get();
            JakartaServletDiskFileUpload jakartaServletFileUpload = new JakartaServletDiskFileUpload(diskFileItemFactory);
            List multiparts = jakartaServletFileUpload.parseRequest(req);
            String fileName = "";
            Iterator iter = multiparts.iterator();
            ArrayList<ObjectNode> itemResp = new ArrayList<ObjectNode>();
            while (iter.hasNext()) {
                DiskFileItem item = (DiskFileItem)iter.next();
                if (item.isFormField()) continue;
                fileName = item.getName().contains("\\") ? item.getName().substring(item.getName().lastIndexOf("\\") + 1) : (item.getName().contains("/") ? item.getName().substring(item.getName().lastIndexOf("/") + 1) : item.getName());
                ObjectNode respBodyItem = this.leggiContenutoFileRicevuto(mapElementiRicevuti, mapChiaviElementi, baseDeleteURL, fileName, item);
                itemResp.add(respBodyItem);
            }
            ObjectNode responseBody = UploadServlet.getResponse(itemResp);
            log.debug(RESPONSE_LOG, (Object)responseBody);
            JSONUtils jsonUtils = JSONUtils.getInstance((boolean)true);
            jsonUtils.writeTo((JsonNode)responseBody, (OutputStream)resp.getOutputStream());
            resp.setContentType("application/json");
            BrowserInfo browserInfo = BrowserInfo.getBrowserInfo(userAgent);
            if (browserInfo.getBrowserFamily().equals((Object)BrowserInfo.BrowserFamily.IE)) {
                double versione;
                double d = versione = browserInfo.getVersion() != null ? browserInfo.getVersion() : -1.0;
                if ((int)versione == 8) {
                    resp.setContentType("text/html");
                }
            }
            resp.setStatus(200);
        }
        catch (IOException | CoreException | UtilsException e) {
            log.error("Errore: " + e.getMessage(), e);
            resp.setStatus(500);
        }
        finally {
            try {
                resp.flushBuffer();
            }
            catch (Exception exception) {}
        }
    }

    private ObjectNode leggiContenutoFileRicevuto(Map<String, UploadItem> mapElementiRicevuti, Map<String, String> mapChiaviElementi, String baseDeleteURL, String fileName, DiskFileItem item) throws UtilsException {
        ObjectNode respBodyItem;
        int dimensione = 0;
        try {
            byte[] contenuto = item.get();
            dimensione = contenuto != null ? contenuto.length : 0;
            String contentType = item.getContentType();
            log.debug("Ricevuto File [{}], content-type [{}], dimensione [{}]", new Object[]{fileName, contentType, dimensione});
            UploadItem uploadItem = new UploadItem(fileName, dimensione, contentType, (Object)contenuto);
            String idFileRicevuto = UUID.randomUUID().toString().replace("-", "");
            UploadItem remove = mapElementiRicevuti.remove(fileName);
            String deleteUrl = null;
            if (remove == null) {
                mapChiaviElementi.put(idFileRicevuto, fileName);
                log.debug("File [{}] non presente, aggiunto alla lista con id [{}].", (Object)fileName, (Object)idFileRicevuto);
            } else {
                String oldId = null;
                for (Map.Entry<String, String> entry : mapChiaviElementi.entrySet()) {
                    if (!entry.getValue().equals(fileName)) continue;
                    oldId = entry.getKey();
                    break;
                }
                log.debug("File [{}] gia' presente, assegno vecchio id [{}].", (Object)fileName, oldId);
                idFileRicevuto = oldId;
            }
            mapElementiRicevuti.put(fileName, uploadItem);
            deleteUrl = baseDeleteURL + "?id=" + idFileRicevuto;
            respBodyItem = UploadServlet.getUploadOkResponseItem(fileName, dimensione, idFileRicevuto, deleteUrl);
        }
        catch (Exception e) {
            log.error("[{}] Errore durante l'elaborazione del file [" + fileName + "]: " + e.getMessage(), (Throwable)e);
            respBodyItem = UploadServlet.getUploadKoResponseItem(fileName, dimensione, "ERRORE");
        }
        return respBodyItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        log.debug("DoDelete!");
        ArrayList<ObjectNode> itemResp = new ArrayList<ObjectNode>();
        try {
            WebApplicationContext context = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServletContext());
            if (context == null) {
                throw new CoreException("Context is null");
            }
            BaseFileUploadBean fileUploadBean = (BaseFileUploadBean)context.getBean("fileUploadBean");
            Map<String, UploadItem> mapElementiRicevuti = fileUploadBean.getMapElementiRicevuti();
            Map<String, String> mapChiaviElementi = fileUploadBean.getMapChiaviElementi();
            String idToDelete = req.getParameter(ID_TO_DELETE_PARAM_NAME);
            log.debug("Richiesta cancellazione del file id [{}].", (Object)idToDelete);
            boolean statoDelete = true;
            String fileName = mapChiaviElementi.remove(idToDelete);
            mapElementiRicevuti.remove(fileName);
            if (fileName != null) {
                ObjectNode respBodyItem = UploadServlet.getDeleteOkResponseItem(fileName, idToDelete, statoDelete);
                itemResp.add(respBodyItem);
                ObjectNode responseBody = UploadServlet.getResponse(itemResp);
                log.debug(RESPONSE_LOG, (Object)responseBody);
                JSONUtils jsonUtils = JSONUtils.getInstance((boolean)true);
                jsonUtils.writeTo((JsonNode)responseBody, (OutputStream)resp.getOutputStream());
            } else {
                ObjectNode respBodyItem = UploadServlet.getDeleteKoResponseItem("File non trovato");
                itemResp.add(respBodyItem);
                ObjectNode responseBody = UploadServlet.getResponse(itemResp);
                log.debug(RESPONSE_LOG, (Object)responseBody);
                JSONUtils jsonUtils = JSONUtils.getInstance((boolean)true);
                jsonUtils.writeTo((JsonNode)responseBody, (OutputStream)resp.getOutputStream());
            }
            resp.setContentType("application/json");
            resp.setStatus(200);
        }
        catch (IOException | CoreException | UtilsException e) {
            log.error("Errore: " + e.getMessage(), e);
            resp.setStatus(500);
        }
        finally {
            try {
                resp.flushBuffer();
            }
            catch (Exception exception) {}
        }
    }

    public static ObjectNode getUploadOkResponseItem(String itemName, int dimensione, String idFileRicevuto, String deleteURL) throws UtilsException {
        JSONUtils jsonUtils = JSONUtils.getInstance();
        ObjectNode j = jsonUtils.newObjectNode();
        j.put("name", itemName);
        j.put("size", dimensione);
        j.put("url", "");
        j.put("thumbnailUrl", "");
        j.put(ID_TO_DELETE_PARAM_NAME, idFileRicevuto);
        j.put("deleteUrl", deleteURL);
        j.put("deleteType", "DELETE");
        return j;
    }

    public static ObjectNode getUploadKoResponseItem(String itemName, int dimensione, String errorString) throws UtilsException {
        JSONUtils jsonUtils = JSONUtils.getInstance();
        ObjectNode j = jsonUtils.newObjectNode();
        j.put("name", itemName);
        j.put("size", dimensione);
        j.put("error", errorString);
        return j;
    }

    public static ObjectNode getDeleteOkResponseItem(String itemName, String idFileRicevuto, boolean stato) throws UtilsException {
        JSONUtils jsonUtils = JSONUtils.getInstance();
        ObjectNode j = jsonUtils.newObjectNode();
        j.put("name", itemName);
        j.put("stato", stato);
        j.put(ID_TO_DELETE_PARAM_NAME, idFileRicevuto);
        return j;
    }

    public static ObjectNode getDeleteKoResponseItem(String errorString) throws UtilsException {
        JSONUtils jsonUtils = JSONUtils.getInstance();
        ObjectNode j = jsonUtils.newObjectNode();
        j.put("error", errorString);
        return j;
    }

    public static ObjectNode getResponse(List<ObjectNode> itemResp) throws UtilsException {
        JSONUtils jsonUtils = JSONUtils.getInstance();
        ObjectNode j = jsonUtils.newObjectNode();
        ArrayNode jsonArray = jsonUtils.newArrayNode();
        for (ObjectNode item : itemResp) {
            jsonArray.add((JsonNode)item);
        }
        j.set("files", (JsonNode)jsonArray);
        return j;
    }
}

