/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.core.thread;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.openspcoop2.web.monitor.core.core.PddMonitorProperties;
import org.openspcoop2.web.monitor.core.logger.LoggerManager;
import org.slf4j.Logger;

public class ThreadExecutorManager {
    private static Logger log = LoggerManager.getPddMonitorCoreLogger();
    private static ExecutorService executorRicerche;
    private static boolean initialized;

    private static synchronized void init() throws Exception {
        if (!initialized) {
            try {
                PddMonitorProperties pddMonitorProperties = PddMonitorProperties.getInstance(log);
                int threadNotificaPoolSize = pddMonitorProperties.getDimensionePoolRicercheConTimeout();
                log.info("Predisposizione pool di ricerca su db [NumThread: " + threadNotificaPoolSize + "]");
                executorRicerche = Executors.newFixedThreadPool(threadNotificaPoolSize);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                throw e;
            }
        }
        initialized = true;
    }

    public static void setup() throws Exception {
        if (!initialized) {
            ThreadExecutorManager.init();
        }
    }

    public static void shutdown() throws InterruptedException {
        executorRicerche.shutdown();
        while (!executorRicerche.isTerminated()) {
            Thread.sleep(500L);
        }
    }

    public static ExecutorService getClientPoolExecutorRicerche() {
        return executorRicerche;
    }

    static {
        initialized = false;
    }
}

