/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.core.utils;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.Strings;
import org.openspcoop2.web.monitor.core.bean.ApplicationBean;
import org.openspcoop2.web.monitor.core.core.PddMonitorProperties;
import org.openspcoop2.web.monitor.core.logger.LoggerManager;
import org.openspcoop2.web.monitor.core.utils.ContentAuthorizationCostanti;
import org.openspcoop2.web.monitor.core.utils.IContentAuthorizationManager;
import org.slf4j.Logger;

public class ContentAuthorizationManager
implements IContentAuthorizationManager {
    private Map<String, List<String>> mappaRuoliPagine = null;
    private Map<String, String> mappaPagineModuli = null;
    private static Logger log = LoggerManager.getPddMonitorCoreLogger();
    private static ContentAuthorizationManager instance = null;
    private IContentAuthorizationManager extendedContentAuthorizationManager = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ContentAuthorizationManager getInstance() throws Exception {
        if (instance != null) return instance;
        Class<ContentAuthorizationManager> clazz = ContentAuthorizationManager.class;
        synchronized (ContentAuthorizationManager.class) {
            ContentAuthorizationManager.init();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private static synchronized void init() throws Exception {
        if (instance == null) {
            instance = new ContentAuthorizationManager();
        }
    }

    private ContentAuthorizationManager() throws Exception {
        log.debug("Inizializzazione Content Authorization Manager in corso...");
        this.mappaRuoliPagine = new HashMap<String, List<String>>();
        this.mappaPagineModuli = new HashMap<String, String>();
        this.extendedContentAuthorizationManager = this.loadExtendedAuthorizationManager(log);
        this.load();
        log.debug("Inizializzazione Content Authorization Manager completata.");
    }

    private void load() {
        this.mappaRuoliPagine.put("ROLE_ADMIN", Arrays.asList(this.getListaPagineRuoloAmministratore()));
        this.mappaRuoliPagine.put("ROLE_CONFIG", Arrays.asList(this.getListaPagineRuoloConfiguratore()));
        this.mappaRuoliPagine.put("ROLE_OPERATORE", Arrays.asList(this.getListaPagineRuoloOperatore()));
        for (String[] regola : this.getListaPagineModuli()) {
            String pagina = regola[0];
            String modulo = regola[1];
            this.mappaPagineModuli.put(pagina, modulo);
        }
    }

    public boolean isRisorsaRichiestaAbilitata(String requestUrl, ApplicationBean applicationBean) {
        boolean risorsaDisponibile = false;
        String funzionalita = this.mappaPagineModuli.get(requestUrl);
        if (funzionalita != null && applicationBean != null) {
            risorsaDisponibile = applicationBean.isFunzionalitaAbilitata(funzionalita);
        }
        if (funzionalita != null) {
            log.debug("La funzionalita' [" + funzionalita + "] " + (risorsaDisponibile ? "" : "non ") + "e' abilitata");
        } else {
            log.debug("La risorsa richiesta non corrisponde a nessuna funzionalita' disponibile nel sistema");
        }
        return risorsaDisponibile;
    }

    public boolean checkRuoloRichiestoPerLaRisorsa(Map<String, Boolean> ruoliUtente, String requestUrl, ApplicationBean applicationBean) {
        String funzionalita;
        boolean autorizzatoOperatore = false;
        boolean autorizzatoConfiguratore = false;
        boolean autorizzatoAmministratore = false;
        if (ruoliUtente == null || ruoliUtente.isEmpty()) {
            return false;
        }
        if (ruoliUtente.get("ROLE_OPERATORE").booleanValue()) {
            autorizzatoOperatore = this.contains(requestUrl, this.mappaRuoliPagine.get("ROLE_OPERATORE"));
            funzionalita = this.mappaPagineModuli.get(requestUrl);
            if (funzionalita.equals("esiti_live") && !applicationBean.isFunzionalitaAbilitata("esiti_live_operatore")) {
                autorizzatoOperatore = false;
            }
            if (funzionalita.equals("transazioni_live") && !applicationBean.isFunzionalitaAbilitata("transazioni_live_operatore")) {
                autorizzatoOperatore = false;
            }
            if (funzionalita.equals("utenti") && !applicationBean.isFunzionalitaAbilitata("gestione_password")) {
                autorizzatoOperatore = false;
            }
        }
        if (ruoliUtente.get("ROLE_CONFIG").booleanValue()) {
            autorizzatoConfiguratore = this.contains(requestUrl, this.mappaRuoliPagine.get("ROLE_CONFIG"));
            funzionalita = this.mappaPagineModuli.get(requestUrl);
            if (funzionalita.equals("utenti") && !applicationBean.isFunzionalitaAbilitata("gestione_password")) {
                autorizzatoOperatore = false;
            }
        }
        if (ruoliUtente.get("ROLE_ADMIN").booleanValue()) {
            autorizzatoAmministratore = this.contains(requestUrl, this.mappaRuoliPagine.get("ROLE_ADMIN"));
        }
        return autorizzatoOperatore || autorizzatoConfiguratore || autorizzatoAmministratore;
    }

    public boolean contains(String requestUrl, List<String> listUrl) {
        boolean found = false;
        if (listUrl.size() > 0) {
            for (String page : listUrl) {
                if (!Strings.CS.contains((CharSequence)requestUrl, (CharSequence)page)) continue;
                found = true;
                break;
            }
        } else {
            found = false;
        }
        return found;
    }

    private IContentAuthorizationManager loadExtendedAuthorizationManager(Logger log) throws Exception {
        IContentAuthorizationManager p = null;
        String authManagerClass = null;
        try {
            authManagerClass = PddMonitorProperties.getInstance(log).getExtendedInfoAuthorizationClass();
            if (authManagerClass != null) {
                Class<?> c = Class.forName(authManagerClass);
                Constructor<?> constructor = c.getConstructor(new Class[0]);
                p = (IContentAuthorizationManager)constructor.newInstance(new Object[0]);
            }
        }
        catch (Exception e) {
            throw new Exception("Impossibile caricare l'Authorization Manager indicato [" + authManagerClass + "] " + String.valueOf(e), e);
        }
        return p;
    }

    @Override
    public String[] getListaPathConsentiti() {
        if (this.extendedContentAuthorizationManager != null) {
            ArrayList<String> toReturn = new ArrayList<String>();
            toReturn.addAll(Arrays.asList(ContentAuthorizationCostanti.listaPathConsentiti));
            toReturn.addAll(Arrays.asList(this.extendedContentAuthorizationManager.getListaPathConsentiti()));
            return toReturn.toArray(new String[toReturn.size()]);
        }
        return ContentAuthorizationCostanti.listaPathConsentiti;
    }

    @Override
    public String[] getListaPagineRuoloAmministratore() {
        if (this.extendedContentAuthorizationManager != null) {
            ArrayList<String> toReturn = new ArrayList<String>();
            toReturn.addAll(Arrays.asList(ContentAuthorizationCostanti.listaPagineRuoloAmministratore));
            toReturn.addAll(Arrays.asList(this.extendedContentAuthorizationManager.getListaPagineRuoloAmministratore()));
            return toReturn.toArray(new String[toReturn.size()]);
        }
        return ContentAuthorizationCostanti.listaPagineRuoloAmministratore;
    }

    @Override
    public String[] getListaPagineRuoloConfiguratore() {
        if (this.extendedContentAuthorizationManager != null) {
            ArrayList<String> toReturn = new ArrayList<String>();
            toReturn.addAll(Arrays.asList(ContentAuthorizationCostanti.listaPagineRuoloConfiguratore));
            toReturn.addAll(Arrays.asList(this.extendedContentAuthorizationManager.getListaPagineRuoloConfiguratore()));
            return toReturn.toArray(new String[toReturn.size()]);
        }
        return ContentAuthorizationCostanti.listaPagineRuoloConfiguratore;
    }

    @Override
    public String[] getListaPagineRuoloOperatore() {
        if (this.extendedContentAuthorizationManager != null) {
            ArrayList<String> toReturn = new ArrayList<String>();
            toReturn.addAll(Arrays.asList(ContentAuthorizationCostanti.listaPagineRuoloOperatore));
            toReturn.addAll(Arrays.asList(this.extendedContentAuthorizationManager.getListaPagineRuoloOperatore()));
            return toReturn.toArray(new String[toReturn.size()]);
        }
        return ContentAuthorizationCostanti.listaPagineRuoloOperatore;
    }

    @Override
    public String[][] getListaPagineModuli() {
        if (this.extendedContentAuthorizationManager != null) {
            int i;
            String[][] listaPagineModuli = this.extendedContentAuthorizationManager.getListaPagineModuli();
            String[][] toReturn = new String[listaPagineModuli.length + ContentAuthorizationCostanti.listaPagineModuli.length][2];
            int c = 0;
            for (i = 0; i < ContentAuthorizationCostanti.listaPagineModuli.length; ++i) {
                toReturn[i] = ContentAuthorizationCostanti.listaPagineModuli[i];
                ++c;
            }
            for (i = 0; i < listaPagineModuli.length; ++i) {
                toReturn[c] = listaPagineModuli[i];
                ++c;
            }
            return toReturn;
        }
        return ContentAuthorizationCostanti.listaPagineModuli;
    }

    @Override
    public String[] getListaPagineNoIE8() {
        if (this.extendedContentAuthorizationManager != null) {
            ArrayList<String> toReturn = new ArrayList<String>();
            toReturn.addAll(Arrays.asList(ContentAuthorizationCostanti.listaPagineNoIE8));
            toReturn.addAll(Arrays.asList(this.extendedContentAuthorizationManager.getListaPagineNoIE8()));
            return toReturn.toArray(new String[toReturn.size()]);
        }
        return ContentAuthorizationCostanti.listaPagineNoIE8;
    }
}

