/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.core.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openspcoop2.utils.UtilsRuntimeException;
import org.openspcoop2.web.monitor.core.logger.LoggerManager;
import org.slf4j.Logger;

public class RicercheUtils {
    private static Logger log = LoggerManager.getPddMonitorCoreLogger();

    private RicercheUtils() {
    }

    public static Map<String, Object> getNonNullFields(Object bean, List<String> fieldsToIgnore) {
        HashMap<String, Object> fieldMap = new HashMap<String, Object>();
        if (fieldsToIgnore == null) {
            fieldsToIgnore = Collections.emptyList();
        }
        for (Class<?> currentClass = bean.getClass(); currentClass != null && currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = currentClass.getDeclaredFields()) {
                field.setAccessible(true);
                try {
                    String s;
                    String fieldName = field.getName();
                    if (fieldsToIgnore.contains(fieldName)) {
                        log.debug("Field [{}] da non salvare.", (Object)fieldName);
                        continue;
                    }
                    Object value = field.get(bean);
                    log.debug("Field [{}], Valore [{}]", (Object)fieldName, value);
                    if (value == null) continue;
                    if (value instanceof String && !(s = (String)value).isEmpty()) {
                        if ("periodo".equals(fieldName) && "Personalizzato".equals(value)) {
                            log.debug("Field [{}] con valore '{}' viene ignorato.", (Object)fieldName, value);
                            continue;
                        }
                        fieldMap.put(fieldName, value);
                        continue;
                    }
                    if (value instanceof Collection && !((Collection)value).isEmpty()) {
                        fieldMap.put(fieldName, value);
                        continue;
                    }
                    if (value instanceof Boolean) {
                        fieldMap.put(fieldName, value);
                        continue;
                    }
                    if (value instanceof Integer || value instanceof Double || value instanceof Long) {
                        fieldMap.put(fieldName, value);
                        continue;
                    }
                    if (value.getClass().isEnum()) {
                        fieldMap.put(fieldName, value);
                        continue;
                    }
                    if (value instanceof String[]) {
                        String[] array = (String[])value;
                        if (array.length <= 0) continue;
                        fieldMap.put(fieldName, array);
                        continue;
                    }
                    log.debug("Field [{}], Tipo [{}] non gestito", (Object)fieldName, value.getClass());
                }
                catch (IllegalAccessException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return fieldMap;
    }

    public static void applyFieldsToBean(Object bean, Map<String, Object> fieldMap) {
        for (Map.Entry<String, Object> entry : fieldMap.entrySet()) {
            String fieldName = entry.getKey();
            Object fieldValue = entry.getValue();
            try {
                Field field = RicercheUtils.getFieldFromClassHierarchy(bean.getClass(), fieldName);
                if (field != null) {
                    field.setAccessible(true);
                    if (field.getType().isEnum() && fieldValue instanceof String) {
                        String s = (String)fieldValue;
                        Object enumValue = null;
                        try {
                            Method toEnumConstantMethod = field.getType().getMethod("toEnumConstant", String.class);
                            enumValue = toEnumConstantMethod != null && Modifier.isStatic(toEnumConstantMethod.getModifiers()) ? toEnumConstantMethod.invoke(null, s) : (Object)Enum.valueOf(field.getType(), s);
                        }
                        catch (NoSuchMethodException e) {
                            enumValue = Enum.valueOf(field.getType(), s);
                        }
                        catch (Exception e) {
                            throw new UtilsRuntimeException("Errore durante la conversione dell'Enum", (Throwable)e);
                        }
                        log.debug("Field di tipo Enum [{}], Valore [{}]", (Object)fieldName, enumValue);
                        field.set(bean, enumValue);
                        continue;
                    }
                    if (field.getType().isArray() && field.getType().getComponentType() == String.class && fieldValue instanceof Collection) {
                        Collection collection = (Collection)fieldValue;
                        Object[] stringArray = collection.toArray(new String[0]);
                        log.debug("Field di tipo Array di String [{}], Valore [{}]", (Object)fieldName, (Object)Arrays.toString(stringArray));
                        field.set(bean, stringArray);
                        continue;
                    }
                    log.debug("Field [{}], Valore [{}]", (Object)fieldName, fieldValue);
                    field.set(bean, fieldValue);
                    continue;
                }
                log.debug("Campo {} non trovato nella gerarchia delle classi.", (Object)fieldName);
            }
            catch (IllegalAccessException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private static Field getFieldFromClassHierarchy(Class<?> clazz, String fieldName) {
        while (clazz != null && clazz != Object.class) {
            try {
                return clazz.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException e) {
                clazz = clazz.getSuperclass();
            }
        }
        return null;
    }
}

