/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.sdi.builder;

import it.gov.fatturapa.sdi.fatturapa.v1_0.utils.ProjectInfo;
import it.gov.fatturapa.sdi.fatturapa.v1_0.utils.XSDValidatorWithSignature;
import it.gov.fatturapa.sdi.messaggi.v1_0.NotificaEsitoCommittenteType;
import it.gov.fatturapa.sdi.messaggi.v1_0.constants.TipiMessaggi;
import it.gov.fatturapa.sdi.messaggi.v1_0.utils.serializer.JaxbDeserializer;
import it.gov.fatturapa.sdi.ws.ricezione.v1_0.types.FileSdIType;
import it.gov.fatturapa.sdi.ws.ricezione.v1_0.types.RispostaRiceviFattureType;
import it.gov.fatturapa.sdi.ws.ricezione.v1_0.types.constants.EsitoRicezioneType;
import it.gov.fatturapa.sdi.ws.trasmissione.v1_0.types.FileSdIBaseType;
import it.gov.fatturapa.sdi.ws.trasmissione.v1_0.types.ObjectFactory;
import it.gov.fatturapa.sdi.ws.trasmissione.v1_0.types.utils.serializer.JaxbSerializer;
import jakarta.xml.soap.AttachmentPart;
import jakarta.xml.soap.SOAPBody;
import jakarta.xml.soap.SOAPElement;
import jakarta.xml.soap.SOAPPart;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.OpenSPCoop2SoapMessage;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.soap.SoapUtils;
import org.openspcoop2.message.utils.MessageUtilities;
import org.openspcoop2.message.xml.MessageXMLUtils;
import org.openspcoop2.pdd.core.CostantiPdD;
import org.openspcoop2.protocol.sdi.builder.SDIBustaBuilder;
import org.openspcoop2.protocol.sdi.config.SDIProperties;
import org.openspcoop2.protocol.sdi.config.SDITraduttore;
import org.openspcoop2.protocol.sdi.constants.SDICostanti;
import org.openspcoop2.protocol.sdi.utils.SDICompatibilitaNamespaceErrati;
import org.openspcoop2.protocol.sdi.utils.SDIFatturaUtils;
import org.openspcoop2.protocol.sdi.utils.SDIUtils;
import org.openspcoop2.protocol.sdi.validator.SDIValidazioneUtils;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.Context;
import org.openspcoop2.protocol.sdk.Eccezione;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.xml.AbstractValidatoreXSD;
import org.w3c.dom.Element;

public class SDIImbustamento {
    private SDIBustaBuilder bustaBuilder = null;
    private SDIValidazioneUtils sdiUtils = null;
    private SDITraduttore sdiTraduttore = null;
    private SDIProperties sdiProperties = null;

    public SDIImbustamento(SDIBustaBuilder bustaBuilder) throws ProtocolException {
        this.bustaBuilder = bustaBuilder;
        this.sdiUtils = new SDIValidazioneUtils(bustaBuilder.getProtocolFactory());
        this.sdiTraduttore = (SDITraduttore)bustaBuilder.getProtocolFactory().createTraduttore();
        this.sdiProperties = SDIProperties.getInstance(bustaBuilder.getProtocolFactory().getLogger());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SOAPElement creaRichiesta_ServizioSdIRiceviFile_AzioneRiceviFile(IProtocolFactory<?> protocolFactory, IState state, Busta busta, OpenSPCoop2Message msgParam, Context context) throws ProtocolException {
        try {
            List childs;
            OpenSPCoop2SoapMessage msg = msgParam.castAsSoap();
            OpenSPCoop2MessageFactory messageFactory = msgParam.getFactory();
            MessageXMLUtils xmlUtils = MessageXMLUtils.getInstance((OpenSPCoop2MessageFactory)messageFactory);
            SOAPPart soapPart = msg.getSOAPPart();
            SOAPBody soapBody = msg.getSOAPBody();
            if (soapBody == null) {
                soapBody = soapPart.getEnvelope().addBody();
            }
            if ((childs = SoapUtils.getNotEmptyChildSOAPElement((SOAPElement)soapBody)) == null || childs.size() <= 0) {
                throw new Exception("FatturaPA non presente");
            }
            if (childs.size() > 1) {
                throw new Exception("Sono presenti piu' elementi xml. Deve essere fornita una singola FatturaPA (o file ZIP)");
            }
            SOAPElement fatturaSOAPElement = (SOAPElement)childs.get(0);
            String tipoInvioFattura = null;
            byte[] fatturaAllegata = null;
            String idPaese = null;
            String idCodice = null;
            String versioneFattura = null;
            if ("http://www.govway.org/out/xml2soap".equals(fatturaSOAPElement.getNamespaceURI())) {
                if (msg.getTransportRequestContext() != null) {
                    versioneFattura = msg.getTransportRequestContext().getParameterFirstValue("Versione");
                    if (versioneFattura == null) {
                        versioneFattura = msg.getTransportRequestContext().getHeaderFirstValue("SDI-Versione");
                    }
                    if (versioneFattura == null) {
                        versioneFattura = msg.getTransportRequestContext().getHeaderFirstValue("GovWay-SDI-Versione");
                    }
                }
                if (versioneFattura == null) {
                    throw new Exception("Versione non fornita (indicare una delle seguenti versioni: " + String.valueOf(SDICostanti.SDI_VERSIONI_FATTURA) + ")");
                }
                if (!SDICostanti.SDI_VERSIONI_FATTURA.contains(versioneFattura = versioneFattura.trim().toUpperCase())) {
                    throw new Exception("Versione fornita [" + versioneFattura + "] non supportata (indicare una delle seguenti versioni: " + String.valueOf(SDICostanti.SDI_VERSIONI_FATTURA) + ")");
                }
                String tipoFileFattura = null;
                if (msg.getTransportRequestContext() != null) {
                    tipoFileFattura = msg.getTransportRequestContext().getParameterFirstValue("TipoFile");
                    if (tipoFileFattura == null) {
                        tipoFileFattura = msg.getTransportRequestContext().getHeaderFirstValue("SDI-TipoFile");
                    }
                    if (tipoFileFattura == null) {
                        tipoFileFattura = msg.getTransportRequestContext().getHeaderFirstValue("GovWay-SDI-TipoFile");
                    }
                }
                if (tipoFileFattura == null) {
                    tipoFileFattura = "XML";
                }
                if ("XML".equalsIgnoreCase(tipoFileFattura)) {
                    tipoInvioFattura = "XML";
                } else if ("ZIP".equalsIgnoreCase(tipoFileFattura)) {
                    tipoInvioFattura = "ZIP";
                } else {
                    if (!"P7M".equalsIgnoreCase(tipoFileFattura)) throw new Exception("TipoFileFattura fornito non supportato: " + tipoInvioFattura);
                    tipoInvioFattura = "P7M";
                }
                if (msg.getTransportRequestContext() != null) {
                    idPaese = msg.getTransportRequestContext().getParameterFirstValue("IdPaese");
                    if (idPaese == null) {
                        idPaese = msg.getTransportRequestContext().getHeaderFirstValue("SDI-IdPaese");
                    }
                    if (idPaese == null) {
                        idPaese = msg.getTransportRequestContext().getHeaderFirstValue("GovWay-SDI-IdPaese");
                    }
                }
                if (idPaese == null && !"XML".equals(tipoInvioFattura)) {
                    throw new Exception("IdPaese non fornito");
                }
                if (msg.getTransportRequestContext() != null) {
                    idCodice = msg.getTransportRequestContext().getParameterFirstValue("IdCodice");
                    if (idCodice == null) {
                        idCodice = msg.getTransportRequestContext().getHeaderFirstValue("SDI-IdCodice");
                    }
                    if (idCodice == null) {
                        idCodice = msg.getTransportRequestContext().getHeaderFirstValue("GovWay-SDI-IdCodice");
                    }
                }
                if (idCodice == null && !"XML".equals(tipoInvioFattura)) {
                    throw new Exception("IdCodice non fornito");
                }
                if (msg.countAttachments() <= 0) {
                    throw new Exception("Atteso fattura come attachment");
                }
                AttachmentPart ap = (AttachmentPart)msg.getAttachments().next();
                fatturaAllegata = Utilities.getAsByteArray((InputStream)ap.getDataHandler().getInputStream());
            } else {
                tipoInvioFattura = "XML";
                if (msg.getTransportRequestContext() != null) {
                    versioneFattura = msg.getTransportRequestContext().getParameterFirstValue("Versione");
                    if (versioneFattura == null) {
                        versioneFattura = msg.getTransportRequestContext().getHeaderFirstValue("SDI-Versione");
                    }
                    if (versioneFattura == null) {
                        versioneFattura = msg.getTransportRequestContext().getHeaderFirstValue("GovWay-SDI-Versione");
                    }
                }
                if (versioneFattura == null) {
                    if (ProjectInfo.getInstance().getProjectNamespace().equals(fatturaSOAPElement.getNamespaceURI())) {
                        versioneFattura = SDICostanti.SDI_VERSIONE_FATTURA_PA_10;
                    } else if (it.gov.fatturapa.sdi.fatturapa.v1_1.utils.ProjectInfo.getInstance().getProjectNamespace().equals(fatturaSOAPElement.getNamespaceURI())) {
                        versioneFattura = SDICostanti.SDI_VERSIONE_FATTURA_PA_11;
                    } else {
                        if (!it.gov.agenziaentrate.ivaservizi.docs.xsd.fatture.v1_0.utils.ProjectInfo.getInstance().getProjectNamespace().equals(fatturaSOAPElement.getNamespaceURI())) throw new Exception("Versione non fornita (indicare una delle seguenti versioni: " + String.valueOf(SDICostanti.SDI_VERSIONI_FATTURA) + ")");
                        versioneFattura = SDICostanti.SDI_VERSIONE_FATTURA_SEMPLIFICATA_10;
                    }
                } else {
                    if (!SDICostanti.SDI_VERSIONI_FATTURA.contains(versioneFattura)) {
                        throw new Exception("Versione fornita [" + versioneFattura + "] non supportata (indicare una delle seguenti versioni: " + String.valueOf(SDICostanti.SDI_VERSIONI_FATTURA) + ")");
                    }
                    if (SDICostanti.SDI_VERSIONE_FATTURA_PA_10.equals(versioneFattura) ? !ProjectInfo.getInstance().getProjectNamespace().equals(fatturaSOAPElement.getNamespaceURI()) : (SDICostanti.SDI_VERSIONE_FATTURA_PA_11.equals(versioneFattura) ? !it.gov.fatturapa.sdi.fatturapa.v1_1.utils.ProjectInfo.getInstance().getProjectNamespace().equals(fatturaSOAPElement.getNamespaceURI()) : (SDICostanti.SDI_VERSIONE_FATTURA_SEMPLIFICATA_10.equals(versioneFattura) ? !it.gov.agenziaentrate.ivaservizi.docs.xsd.fatture.v1_0.utils.ProjectInfo.getInstance().getProjectNamespace().equals(fatturaSOAPElement.getNamespaceURI()) : !it.gov.agenziaentrate.ivaservizi.docs.xsd.fatture.v1_2.utils.ProjectInfo.getInstance().getProjectNamespace().equals(fatturaSOAPElement.getNamespaceURI())))) {
                        throw new Exception("Versione fornita [" + versioneFattura + "] non \u00e8 utilizzabile con la fattura fornita che appartiene ad una differente versione di namespace [" + fatturaSOAPElement.getNamespaceURI() + "]");
                    }
                }
            }
            String nomeFileFatturaDaSpedire = null;
            boolean readNomeFromTrasporto = false;
            if (!this.sdiProperties.isEnable_fatturazioneAttiva_generazioneNomeFileFattura().booleanValue() || this.sdiProperties.isEnable_fatturazioneAttiva_generazioneNomeFileFatturaOpzionale().booleanValue()) {
                readNomeFromTrasporto = true;
            }
            if (readNomeFromTrasporto) {
                if (msg.getTransportRequestContext() != null) {
                    nomeFileFatturaDaSpedire = msg.getTransportRequestContext().getParameterFirstValue("NomeFile");
                    if (nomeFileFatturaDaSpedire == null) {
                        nomeFileFatturaDaSpedire = msg.getTransportRequestContext().getHeaderFirstValue("SDI-NomeFile");
                    }
                    if (nomeFileFatturaDaSpedire == null) {
                        nomeFileFatturaDaSpedire = msg.getTransportRequestContext().getHeaderFirstValue("GovWay-SDI-NomeFile");
                    }
                }
                if (nomeFileFatturaDaSpedire == null && !this.sdiProperties.isEnable_fatturazioneAttiva_generazioneNomeFileFattura().booleanValue()) {
                    throw new Exception("Nome file fattura non fornito");
                }
            }
            busta.addProperty("FormatoArchivioInvioFattura", tipoInvioFattura);
            busta.addProperty("FormatoFatturaPA", versioneFattura);
            byte[] fatturaBytes = fatturaAllegata;
            if (fatturaBytes == null && "XML".equals(tipoInvioFattura)) {
                try {
                    fatturaBytes = xmlUtils.toByteArray((Element)fatturaSOAPElement);
                }
                catch (Exception e) {
                    throw new Exception("Fattura non valida: " + e.getMessage(), e);
                }
            }
            if (this.sdiProperties.isEnableValidazioneXsdFatturaDaInviare().booleanValue()) {
                AbstractValidatoreXSD validatore = null;
                try {
                    validatore = SDICostanti.SDI_VERSIONE_FATTURA_PA_10.equals(versioneFattura) ? XSDValidatorWithSignature.getOpenSPCoop2MessageXSDValidator(this.bustaBuilder.getProtocolFactory().getLogger()) : (SDICostanti.SDI_VERSIONE_FATTURA_PA_11.equals(versioneFattura) ? it.gov.fatturapa.sdi.fatturapa.v1_1.utils.XSDValidatorWithSignature.getOpenSPCoop2MessageXSDValidator(this.bustaBuilder.getProtocolFactory().getLogger()) : (SDICostanti.SDI_VERSIONE_FATTURA_SEMPLIFICATA_10.equals(versioneFattura) ? it.gov.agenziaentrate.ivaservizi.docs.xsd.fatture.v1_0.utils.XSDValidatorWithSignature.getOpenSPCoop2MessageXSDValidator(this.bustaBuilder.getProtocolFactory().getLogger()) : it.gov.agenziaentrate.ivaservizi.docs.xsd.fatture.v1_2.utils.XSDValidatorWithSignature.getOpenSPCoop2MessageXSDValidator(this.bustaBuilder.getProtocolFactory().getLogger())));
                }
                catch (Exception e) {
                    throw new Exception("Inizializzazione schema per validazione fattura non riuscita: " + e.getMessage(), e);
                }
                if ("XML".equals(tipoInvioFattura)) {
                    try {
                        validatore.valida((InputStream)new ByteArrayInputStream(fatturaBytes));
                    }
                    catch (Exception e) {
                        throw new Exception("Fattura non valida: " + e.getMessage(), e);
                    }
                }
            }
            if ("XML".equals(tipoInvioFattura)) {
                try {
                    ArrayList<Eccezione> erroriValidazione = new ArrayList<Eccezione>();
                    boolean forceDisableValidazioneXsd = true;
                    SDIFatturaUtils.validazioneFattura(fatturaBytes, this.sdiProperties, erroriValidazione, this.sdiUtils, protocolFactory, busta, (OpenSPCoop2Message)msg, false, false, forceDisableValidazioneXsd);
                    if (erroriValidazione != null && erroriValidazione.size() > 0) {
                        StringBuilder bf = new StringBuilder();
                        for (int k = 0; k < erroriValidazione.size(); ++k) {
                            Eccezione error = (Eccezione)erroriValidazione.get(k);
                            try {
                                bf.append("Processamento[" + this.sdiTraduttore.toString(error.getCodiceEccezione(), error.getSubCodiceEccezione()) + "] " + error.getDescrizione(protocolFactory) + "\n");
                                continue;
                            }
                            catch (Exception e) {
                                protocolFactory.getLogger().error("getDescrizione Error:" + e.getMessage(), (Throwable)e);
                            }
                        }
                        throw new Exception(bf.toString());
                    }
                }
                catch (Exception e) {
                    throw new Exception("Fattura non valida: " + e.getMessage(), e);
                }
            }
            ObjectFactory of = new ObjectFactory();
            FileSdIBaseType fileSdi = new FileSdIBaseType();
            fileSdi.setFile(fatturaBytes);
            if (nomeFileFatturaDaSpedire == null && this.sdiProperties.isEnable_fatturazioneAttiva_generazioneNomeFileFattura().booleanValue()) {
                if ("XML".equals(tipoInvioFattura)) {
                    fileSdi.setNomeFile(SDIUtils.getNomeFileFattura(protocolFactory, state, idPaese != null ? idPaese : busta.getProperty("DatiTrasmissione-IdTrasmittente-IdPaese"), idCodice != null ? idCodice : busta.getProperty("DatiTrasmissione-IdTrasmittente-IdCodice"), tipoInvioFattura));
                } else {
                    fileSdi.setNomeFile(SDIUtils.getNomeFileFattura(protocolFactory, state, idPaese, idCodice, tipoInvioFattura));
                }
            } else {
                if (nomeFileFatturaDaSpedire == null) {
                    throw new Exception("Nome file fattura non fornito");
                }
                fileSdi.setNomeFile(nomeFileFatturaDaSpedire);
            }
            if (idPaese != null && !"".equals(idPaese) && !busta.existsProperty("DatiTrasmissione-IdTrasmittente-IdPaese")) {
                busta.addProperty("DatiTrasmissione-IdTrasmittente-IdPaese", idPaese);
            }
            if (idCodice != null && !"".equals(idCodice) && !busta.existsProperty("DatiTrasmissione-IdTrasmittente-IdCodice")) {
                busta.addProperty("DatiTrasmissione-IdTrasmittente-IdCodice", idCodice);
            }
            soapBody.removeContents();
            if (msg.countAttachments() > 0) {
                msg.removeAllAttachments();
            }
            JaxbSerializer serializer = new JaxbSerializer();
            String xmlRichiesta = serializer.toString(of.createFileSdIAccoglienza(fileSdi));
            SOAPElement element = SoapUtils.getSoapFactory((OpenSPCoop2MessageFactory)messageFactory, (MessageType)msg.getMessageType()).createElement(xmlUtils.newElement(xmlRichiesta.getBytes()));
            soapBody.addChildElement(element);
            busta.addProperty("NomeFile", fileSdi.getNomeFile());
            if (context != null && this.sdiProperties.isEnableFatturazioneAttivaHeaderIntegrazioneGestioneErrore().booleanValue()) {
                context.addObject(CostantiPdD.BUSTA_RICHIESTA_SDI_NOME_FILE, (Object)fileSdi.getNomeFile());
            }
            msg.setSoapAction("\"http://www.fatturapa.it/SdIRiceviFile/RiceviFile\"");
            return SDIUtils.readHeader(msg);
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
    }

    public SOAPElement creaRisposta_ServizioRicezioneFatture_AzioneRiceviFatture(IProtocolFactory<?> protocolFactory, IState state, Busta busta, OpenSPCoop2Message msgParam) throws ProtocolException {
        try {
            OpenSPCoop2SoapMessage msg = msgParam.castAsSoap();
            OpenSPCoop2MessageFactory messageFactory = msgParam.getFactory();
            MessageXMLUtils xmlUtils = MessageXMLUtils.getInstance((OpenSPCoop2MessageFactory)messageFactory);
            SOAPPart soapPart = msg.getSOAPPart();
            SOAPBody soapBody = msg.getSOAPBody();
            if (soapBody == null) {
                soapBody = soapPart.getEnvelope().addBody();
            } else if (soapBody.hasFault()) {
                return null;
            }
            soapBody.removeContents();
            if (msg.countAttachments() > 0) {
                msg.removeAllAttachments();
            }
            msg.setContentType(MessageUtilities.getDefaultContentType((MessageType)msg.getMessageType()));
            it.gov.fatturapa.sdi.ws.ricezione.v1_0.types.ObjectFactory of = new it.gov.fatturapa.sdi.ws.ricezione.v1_0.types.ObjectFactory();
            RispostaRiceviFattureType rispostaRiceviFatture = of.createRispostaRiceviFattureType();
            rispostaRiceviFatture.setEsito(EsitoRicezioneType.ER01);
            it.gov.fatturapa.sdi.ws.ricezione.v1_0.types.utils.serializer.JaxbSerializer serializer = new it.gov.fatturapa.sdi.ws.ricezione.v1_0.types.utils.serializer.JaxbSerializer();
            String xmlRisposta = serializer.toString(of.createRispostaRiceviFatture(rispostaRiceviFatture));
            SOAPElement element = SoapUtils.getSoapFactory((OpenSPCoop2MessageFactory)messageFactory, (MessageType)msg.getMessageType()).createElement(xmlUtils.newElement(xmlRisposta.getBytes()));
            soapBody.addChildElement(element);
            return element;
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
    }

    public SOAPElement creaRichiesta_ServizioSdIRiceviNotifica_AzioneNotificaEsito(IProtocolFactory<?> protocolFactory, IState state, Busta busta, OpenSPCoop2Message msgParam, boolean isEnableGenerazioneMessaggiCompatibilitaNamespaceSenzaGov, boolean isEnableValidazioneMessaggiCompatibilitaNamespaceSenzaGov, Context context) throws ProtocolException {
        try {
            List childs;
            OpenSPCoop2SoapMessage msg = msgParam.castAsSoap();
            OpenSPCoop2MessageFactory messageFactory = msgParam.getFactory();
            MessageXMLUtils xmlUtils = MessageXMLUtils.getInstance((OpenSPCoop2MessageFactory)messageFactory);
            SOAPPart soapPart = msg.getSOAPPart();
            SOAPBody soapBody = msg.getSOAPBody();
            if (soapBody == null) {
                soapBody = soapPart.getEnvelope().addBody();
            }
            String nomeFileFattura = null;
            if (msg.getTransportRequestContext() != null) {
                nomeFileFattura = msg.getTransportRequestContext().getParameterFirstValue("NomeFile");
                if (nomeFileFattura == null) {
                    nomeFileFattura = msg.getTransportRequestContext().getHeaderFirstValue("SDI-NomeFile");
                }
                if (nomeFileFattura == null) {
                    nomeFileFattura = msg.getTransportRequestContext().getHeaderFirstValue("GovWay-SDI-NomeFile");
                }
            }
            if (nomeFileFattura == null) {
                if (this.sdiProperties.isEnable_fatturazionePassiva_generazioneNomeFileEsito().booleanValue()) {
                    throw new Exception("Nome File Fattura non fornito");
                }
                throw new Exception("Nome File Esito non fornito");
            }
            String identificativoSdi = null;
            String tmpIdentificativoSdi = null;
            if (msg.getTransportRequestContext() != null) {
                tmpIdentificativoSdi = msg.getTransportRequestContext().getParameterFirstValue("IdentificativoSdI");
                if (tmpIdentificativoSdi == null) {
                    tmpIdentificativoSdi = msg.getTransportRequestContext().getHeaderFirstValue("SDI-IdentificativoSdI");
                }
                if (tmpIdentificativoSdi == null) {
                    tmpIdentificativoSdi = msg.getTransportRequestContext().getHeaderFirstValue("GovWay-SDI-IdentificativoSdI");
                }
            }
            boolean accessoNotificaDaInviare = this.sdiProperties.isEnableAccessoNotificaDaInviare();
            if (tmpIdentificativoSdi == null && !accessoNotificaDaInviare) {
                throw new Exception("IdentificativoSdi non fornito");
            }
            if (tmpIdentificativoSdi != null) {
                try {
                    BigInteger bigInteger;
                    String s;
                    if (!this.sdiProperties.isEnable_InputIdSDIValidationAsBigInteger_NotificaDaInviare().booleanValue() || (s = (bigInteger = new BigInteger(tmpIdentificativoSdi)).toString()) != null) {
                        // empty if block
                    }
                    identificativoSdi = tmpIdentificativoSdi;
                }
                catch (Exception e) {
                    throw new Exception("IdentificativoSdi fornito non possiede un valore valido: " + e.getMessage());
                }
            }
            if ((childs = SoapUtils.getNotEmptyChildSOAPElement((SOAPElement)soapBody)) == null || childs.size() <= 0) {
                throw new Exception("Notifica di Esito Committente non presente");
            }
            if (childs.size() > 1) {
                throw new Exception("Sono presenti piu' elementi xml. Deve essere fornita una singola Notifica di Esito Committente");
            }
            SOAPElement notificaEsitoCommittenteSOAPElement = (SOAPElement)childs.get(0);
            byte[] notificaEsitoCommittenteBytes = null;
            if ("http://www.govway.org/out/xml2soap".equals(notificaEsitoCommittenteSOAPElement.getNamespaceURI())) {
                if (msg.countAttachments() <= 0) {
                    throw new Exception("Attesa notifica come attachment");
                }
                AttachmentPart ap = (AttachmentPart)msg.getAttachments().next();
                notificaEsitoCommittenteBytes = Utilities.getAsByteArray((InputStream)ap.getDataHandler().getInputStream());
            } else {
                notificaEsitoCommittenteBytes = xmlUtils.toByteArray((Element)notificaEsitoCommittenteSOAPElement);
            }
            byte[] notificaEsitoCommittenteBytesCompatibilitaSenzaGov = notificaEsitoCommittenteBytes;
            try {
                if (isEnableValidazioneMessaggiCompatibilitaNamespaceSenzaGov) {
                    notificaEsitoCommittenteBytesCompatibilitaSenzaGov = SDICompatibilitaNamespaceErrati.convertiXmlNamespaceSenzaGov(protocolFactory.getLogger(), notificaEsitoCommittenteBytes);
                }
                if (this.sdiProperties.isEnableValidazioneXsdNotificaDaInviare().booleanValue()) {
                    AbstractValidatoreXSD validatore = it.gov.fatturapa.sdi.messaggi.v1_0.utils.XSDValidatorWithSignature.getOpenSPCoop2MessageXSDValidator(this.bustaBuilder.getProtocolFactory().getLogger());
                    validatore.valida((InputStream)new ByteArrayInputStream(notificaEsitoCommittenteBytesCompatibilitaSenzaGov));
                }
            }
            catch (Exception e) {
                throw new Exception("Notifica di Esito Committente non valida: " + e.getMessage(), e);
            }
            NotificaEsitoCommittenteType notificaEsitoCommittente = null;
            if (accessoNotificaDaInviare) {
                try {
                    JaxbDeserializer deserializer = new JaxbDeserializer();
                    notificaEsitoCommittente = deserializer.readNotificaEsitoCommittenteType(notificaEsitoCommittenteBytesCompatibilitaSenzaGov);
                }
                catch (Exception e) {
                    throw new Exception("Notifica di Esito Committente non valida: " + e.getMessage(), e);
                }
                if (notificaEsitoCommittente.getIdentificativoSdI() != null) {
                    busta.addProperty("IdentificativoSdI", notificaEsitoCommittente.getIdentificativoSdI().toString());
                    identificativoSdi = notificaEsitoCommittente.getIdentificativoSdI();
                }
                if (notificaEsitoCommittente.getRiferimentoFattura() != null) {
                    if (notificaEsitoCommittente.getRiferimentoFattura().getAnnoFattura() != null) {
                        busta.addProperty("RiferimentoFattura-Anno", notificaEsitoCommittente.getRiferimentoFattura().getAnnoFattura().toString());
                    }
                    if (notificaEsitoCommittente.getRiferimentoFattura().getNumeroFattura() != null) {
                        busta.addProperty("RiferimentoFattura-Numero", notificaEsitoCommittente.getRiferimentoFattura().getNumeroFattura());
                    }
                    if (notificaEsitoCommittente.getRiferimentoFattura().getPosizioneFattura() != null) {
                        busta.addProperty("RiferimentoFattura-Posizione", notificaEsitoCommittente.getRiferimentoFattura().getPosizioneFattura().toString());
                    }
                }
                if (notificaEsitoCommittente.getEsito() != null) {
                    busta.addProperty("Esito", notificaEsitoCommittente.getEsito().name());
                }
                if (notificaEsitoCommittente.getDescrizione() != null) {
                    busta.addProperty("Descrizione", notificaEsitoCommittente.getDescrizione());
                }
                if (notificaEsitoCommittente.getMessageIdCommittente() != null) {
                    busta.addProperty("MessageIdCommittente", notificaEsitoCommittente.getMessageIdCommittente());
                }
                if (identificativoSdi == null) {
                    throw new Exception("IdentificativoSdi non fornito nella notifica da inviare");
                }
            }
            it.gov.fatturapa.sdi.ws.ricezione.v1_0.types.ObjectFactory of = new it.gov.fatturapa.sdi.ws.ricezione.v1_0.types.ObjectFactory();
            FileSdIType fileSdi = new FileSdIType();
            byte[] fileSent = notificaEsitoCommittenteBytes;
            if (isEnableGenerazioneMessaggiCompatibilitaNamespaceSenzaGov) {
                fileSent = SDICompatibilitaNamespaceErrati.produciXmlNamespaceSenzaGov(protocolFactory.getLogger(), fileSent);
            }
            fileSdi.setFile(fileSent);
            fileSdi.setIdentificativoSdI(identificativoSdi);
            if (this.sdiProperties.isEnable_fatturazionePassiva_generazioneNomeFileEsito().booleanValue()) {
                busta.addProperty("NomeFileFattura", nomeFileFattura);
                fileSdi.setNomeFile(SDIUtils.getNomeFileMessaggi(protocolFactory, state, nomeFileFattura, TipiMessaggi.EC));
            } else {
                fileSdi.setNomeFile(nomeFileFattura);
            }
            busta.addProperty("IdentificativoSdI", identificativoSdi);
            busta.addProperty("NomeFile", fileSdi.getNomeFile());
            if (context != null && this.sdiProperties.isEnableFatturazionePassivaHeaderIntegrazioneGestioneErrore().booleanValue()) {
                context.addObject(CostantiPdD.BUSTA_RICHIESTA_SDI_NOME_FILE, (Object)fileSdi.getNomeFile());
                context.addObject(CostantiPdD.BUSTA_RICHIESTA_SDI_IDENTIFICATIVO_SDI, (Object)identificativoSdi);
            }
            soapBody.removeContents();
            if (msg.countAttachments() > 0) {
                msg.removeAllAttachments();
            }
            it.gov.fatturapa.sdi.ws.ricezione.v1_0.types.utils.serializer.JaxbSerializer serializer = new it.gov.fatturapa.sdi.ws.ricezione.v1_0.types.utils.serializer.JaxbSerializer();
            String xmlRichiesta = serializer.toString(of.createFileSdI(fileSdi));
            SOAPElement element = SoapUtils.getSoapFactory((OpenSPCoop2MessageFactory)messageFactory, (MessageType)msg.getMessageType()).createElement(xmlUtils.newElement(xmlRichiesta.getBytes()));
            soapBody.addChildElement(element);
            msg.setSoapAction("\"http://www.fatturapa.it/SdIRicezioneNotifiche/NotificaEsito\"");
            return SDIUtils.readHeader(msg);
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
    }
}

