/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.sdi.config;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.openspcoop2.protocol.basic.BasicStaticInstanceConfig;
import org.openspcoop2.protocol.sdi.config.SDIInstanceProperties;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.utils.BooleanNullable;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.resources.Loader;
import org.slf4j.Logger;

public class SDIProperties {
    private Logger log = null;
    private static SDIProperties sdiProperties = null;
    private SDIInstanceProperties reader;
    private String tipoSoggettoSDI = null;
    private String nomeSoggettoSDI = null;
    private Boolean isEnableGenerazioneMessaggiCompatibilitaNamespaceSenzaGov = null;
    private Boolean isEnableValidazioneMessaggiCompatibilitaNamespaceSenzaGov = null;
    private Boolean isEnableValidazioneNomeFile = null;
    private Boolean isEnableValidazioneXsdFatturaDaInviare = null;
    private Boolean isEnable_fatturazioneAttiva_notifiche_enrichInfoFromFattura = null;
    private Boolean isEnable_fatturazioneAttiva_generazioneNomeFileFattura = null;
    private Boolean isEnable_fatturazioneAttiva_generazioneNomeFileFatturaOpzionale = null;
    private Boolean isEnableFatturazioneAttivaHeaderIntegrazioneGestioneErrore = null;
    private Boolean isEnableValidazioneXsdNotificaDaInviare = null;
    private Boolean isEnableAccessoNotificaDaInviare = null;
    private Boolean isEnable_InputIdSDIValidationAsBigInteger_NotificaDaInviare = null;
    private Boolean isEnable_fatturazionePassiva_consegnaFileMetadati = null;
    private Boolean isEnable_fatturazionePassiva_notifiche_enrichInfoFromFattura = null;
    private Boolean isEnable_fatturazionePassiva_generazioneNomeFileEsito = null;
    private Boolean isEnableFatturazionePassivaHeaderIntegrazioneGestioneErrore = null;
    private Boolean tracciamentoDatasource_read;
    private String tracciamentoDatasource;
    private Boolean tracciamentoTipoDatabase_read;
    private String tracciamentoTipoDatabase;
    private Properties tracciamentoDatasource_jndiContext = null;
    private Boolean isEnableAccessoMetadati = null;
    private Boolean isEnableAccessoFattura = null;
    private Boolean isEnableAccessoMessaggi = null;
    private Boolean isEnableAccessoMetadatiWarningMode = null;
    private Boolean isEnableAccessoFatturaWarningMode = null;
    private Boolean isEnableAccessoMessaggiWarningMode = null;
    private Boolean isEnableValidazioneXsdMetadati = null;
    private Boolean isEnableValidazioneXsdFattura = null;
    private Boolean isEnableValidazioneXsdMessaggi = null;
    private Boolean isEnableValidazioneCampiInterniMetadati = null;
    private Boolean isEnableValidazioneCampiInterniFattura = null;
    private Boolean isEnableValidazioneCampiInterniMessaggi = null;
    private Boolean isSaveFatturaInContext = null;
    private Boolean isSaveMessaggiInContext = null;
    private Boolean isNotificaATConsegnaSoloAttestato = null;
    private Boolean isBehaviourCreaProtocolloSDI = null;
    private List<String> soggettiWhiteList = null;
    private List<String> serviziWhiteList = null;
    private List<String> azioniWhiteList = null;
    private List<String> namespaceWhiteList = null;
    private Boolean isPortaApplicativaBustaErrore_personalizzaElementiFault = null;
    private Boolean isPortaApplicativaBustaErrore_personalizzaElementiFaultRead = null;
    private Boolean isPortaApplicativaBustaErrore_aggiungiErroreApplicativo = null;
    private Boolean isPortaApplicativaBustaErrore_aggiungiErroreApplicativoRead = null;
    private Boolean isGenerazioneDetailsSOAPFaultProtocolValidazione = null;
    private Boolean isGenerazioneDetailsSOAPFaultProtocolProcessamento = null;
    private Boolean isGenerazioneDetailsSOAPFaultProtocolWithStackTrace = null;
    private Boolean isGenerazioneDetailsSOAPFaultProtocolConInformazioniGeneriche = null;
    private Boolean isGenerazioneDetailsSOAPFaultIntegrationServerError = null;
    private Boolean isGenerazioneDetailsSOAPFaultIntegrationClientError = null;
    private Boolean isGenerazioneDetailsSOAPFaultIntegrationWithStackTrace = null;
    private Boolean isGenerazioneDetailsSOAPFaultIntegrationConInformazioniGeneriche = null;
    private Boolean isGenerazioneDetailsSOAPFaultIntegrationConInformazioniGenericheRead = null;
    private BooleanNullable isAggiungiDetailErroreApplicativo_SoapFaultApplicativo = null;
    private Boolean isAggiungiDetailErroreApplicativo_SoapFaultApplicativoRead = null;
    private BooleanNullable isAggiungiDetailErroreApplicativo_SoapFaultPdD = null;
    private Boolean isAggiungiDetailErroreApplicativo_SoapFaultPdDRead = null;
    private Boolean useConfigStaticInstance = null;
    private Boolean useErroreApplicativoStaticInstance = null;
    private Boolean useEsitoStaticInstance = null;
    private BasicStaticInstanceConfig staticInstanceConfig = null;

    private void logError(String msg, Throwable e) {
        if (this.log != null) {
            this.log.error(msg, e);
        }
    }

    private void logError(String msg) {
        if (this.log != null) {
            this.log.error(msg);
        }
    }

    private SDIProperties(String confDir, Logger log) throws ProtocolException {
        this.log = log != null ? log : LoggerWrapperFactory.getLogger((String)"SDIProperties");
        Properties propertiesReader = new Properties();
        InputStream properties = null;
        try {
            properties = SDIProperties.class.getResourceAsStream("/sdi.properties");
            if (properties == null) {
                throw new Exception("File '/sdi.properties' not found");
            }
            propertiesReader.load(properties);
        }
        catch (Exception e) {
            this.logError("Riscontrato errore durante la lettura del file 'sdi.properties': " + e.getMessage());
            throw new ProtocolException("SDIProperties initialize error: " + e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (properties != null) {
                    properties.close();
                }
            }
            catch (Throwable throwable) {}
        }
        try {
            this.reader = new SDIInstanceProperties(propertiesReader, this.log);
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
    }

    public static synchronized void initialize(String confDir, Logger log) throws ProtocolException {
        if (sdiProperties == null) {
            sdiProperties = new SDIProperties(confDir, log);
        }
    }

    public static SDIProperties getInstance(Logger log) throws ProtocolException {
        if (sdiProperties == null) {
            Class<SDIProperties> clazz = SDIProperties.class;
            synchronized (SDIProperties.class) {
                throw new ProtocolException("SDIProperties not initialized (use init method in factory)");
            }
        }
        return sdiProperties;
    }

    public void validaConfigurazione(Loader loader) throws ProtocolException {
        try {
            this.getTipoSoggettoSDI();
            this.getNomeSoggettoSDI();
            this.isEnableGenerazioneMessaggiCompatibilitaNamespaceSenzaGov();
            this.isEnableValidazioneMessaggiCompatibilitaNamespaceSenzaGov();
            this.isEnableValidazioneNomeFile();
            this.isEnableValidazioneXsdFatturaDaInviare();
            this.isEnable_fatturazioneAttiva_notifiche_enrichInfoFromFattura();
            this.isEnable_fatturazioneAttiva_generazioneNomeFileFattura();
            this.isEnable_fatturazioneAttiva_generazioneNomeFileFatturaOpzionale();
            this.isEnableValidazioneXsdNotificaDaInviare();
            this.isEnableAccessoNotificaDaInviare();
            this.isEnable_InputIdSDIValidationAsBigInteger_NotificaDaInviare();
            this.isEnable_fatturazionePassiva_consegnaFileMetadati();
            this.isEnable_fatturazionePassiva_notifiche_enrichInfoFromFattura();
            this.isEnable_fatturazionePassiva_generazioneNomeFileEsito();
            if (this.isTracciamentoRequiredFromConfiguration()) {
                if (this.getTracciamentoDatasource() == null) {
                    throw new Exception("Datasource non definito per l'accesso al database delle tracce");
                }
                this.getTracciamentoDatasource_jndiContext();
                this.getTracciamentoTipoDatabase();
            }
            this.isEnableAccessoMetadati();
            this.isEnableAccessoFattura();
            this.isEnableAccessoMessaggi();
            this.isEnableAccessoMetadatiWarningMode();
            this.isEnableAccessoFatturaWarningMode();
            this.isEnableAccessoMessaggiWarningMode();
            this.isEnableValidazioneXsdMetadati();
            this.isEnableValidazioneXsdFattura();
            this.isEnableValidazioneXsdMessaggi();
            this.isEnableValidazioneCampiInterniMetadati();
            this.isEnableValidazioneCampiInterniFattura();
            this.isEnableValidazioneCampiInterniMessaggi();
            this.isSaveFatturaInContext();
            this.isSaveMessaggiInContext();
            this.isNotificaATConsegnaSoloAttestato();
            this.getSoggettiWhiteList();
            this.getServiziWhiteList();
            this.getAzioniWhiteList();
            this.getNamespaceWhiteList();
            this.isAggiungiDetailErroreApplicativo_SoapFaultApplicativo();
            this.isAggiungiDetailErroreApplicativo_SoapFaultPdD();
            this.isGenerazioneDetailsSOAPFaultProtocolValidazione();
            this.isGenerazioneDetailsSOAPFaultProtocolProcessamento();
            this.isGenerazioneDetailsSOAPFaultProtocolWithStackTrace();
            this.isGenerazioneDetailsSOAPFaultProtocolConInformazioniGeneriche();
            this.isGenerazioneDetailsSOAPFaultIntegrationServerError();
            this.isGenerazioneDetailsSOAPFaultIntegrationClientError();
            this.isGenerazioneDetailsSOAPFaultIntegrationWithStackTrace();
            this.isGenerazioneDetailsSOAPFaultIntegrazionConInformazioniGeneriche();
            this.isPortaApplicativaBustaErrore_personalizzaElementiFault();
            this.isPortaApplicativaBustaErrore_aggiungiErroreApplicativo();
            this.useConfigStaticInstance();
            this.useErroreApplicativoStaticInstance();
            this.useEsitoStaticInstance();
            this.getStaticInstanceConfig();
        }
        catch (Exception e) {
            String msg = "Riscontrato errore durante la validazione della proprieta' del protocollo sdi, " + e.getMessage();
            this.logError(msg, e);
            throw new ProtocolException(msg, (Throwable)e);
        }
    }

    public String getTipoSoggettoSDI() throws ProtocolException {
        if (this.tipoSoggettoSDI == null) {
            String propertyName = "org.openspcoop2.protocol.sdi.soggetto.tipo";
            try {
                String value = this.reader.getValueConvertEnvProperties(propertyName);
                if (value == null) {
                    throw new Exception("Non definita");
                }
                this.tipoSoggettoSDI = value = value.trim();
            }
            catch (Exception e) {
                String msg = "Riscontrato errore durante la lettura della proprieta' '" + propertyName + "': " + e.getMessage();
                this.logError(msg, e);
                throw new ProtocolException(msg, (Throwable)e);
            }
        }
        return this.tipoSoggettoSDI;
    }

    public String getNomeSoggettoSDI() throws ProtocolException {
        if (this.nomeSoggettoSDI == null) {
            String propertyName = "org.openspcoop2.protocol.sdi.soggetto.nome";
            try {
                String value = this.reader.getValueConvertEnvProperties(propertyName);
                if (value == null) {
                    throw new Exception("Non definita");
                }
                this.nomeSoggettoSDI = value = value.trim();
            }
            catch (Exception e) {
                String msg = "Riscontrato errore durante la lettura della proprieta' '" + propertyName + "': " + e.getMessage();
                this.logError(msg, e);
                throw new ProtocolException(msg, (Throwable)e);
            }
        }
        return this.nomeSoggettoSDI;
    }

    public Boolean isEnableGenerazioneMessaggiCompatibilitaNamespaceSenzaGov() throws ProtocolException {
        if (this.isEnableGenerazioneMessaggiCompatibilitaNamespaceSenzaGov == null) {
            String propertyName = "org.openspcoop2.protocol.sdi.generazione.messaggi.compatibilitaNamespaceSenzaGov";
            try {
                String value = this.reader.getValueConvertEnvProperties(propertyName);
                if (value == null) {
                    throw new Exception("Non definita");
                }
                value = value.trim();
                this.isEnableGenerazioneMessaggiCompatibilitaNamespaceSenzaGov = Boolean.parseBoolean(value);
            }
            catch (Exception e) {
                String msg = "Riscontrato errore durante la lettura della proprieta' '" + propertyName + "': " + e.getMessage();
                this.logError(msg, e);
                throw new ProtocolException(msg, (Throwable)e);
            }
        }
        return this.isEnableGenerazioneMessaggiCompatibilitaNamespaceSenzaGov;
    }

    public Boolean isEnableValidazioneMessaggiCompatibilitaNamespaceSenzaGov() throws ProtocolException {
        if (this.isEnableValidazioneMessaggiCompatibilitaNamespaceSenzaGov == null) {
            String propertyName = "org.openspcoop2.protocol.sdi.validazione.messaggi.compatibilitaNamespaceSenzaGov";
            try {
                String value = this.reader.getValueConvertEnvProperties(propertyName);
                if (value == null) {
                    throw new Exception("Non definita");
                }
                value = value.trim();
                this.isEnableValidazioneMessaggiCompatibilitaNamespaceSenzaGov = Boolean.parseBoolean(value);
            }
            catch (Exception e) {
                String msg = "Riscontrato errore durante la lettura della proprieta' '" + propertyName + "': " + e.getMessage();
                this.logError(msg, e);
                throw new ProtocolException(msg, (Throwable)e);
            }
        }
        return this.isEnableValidazioneMessaggiCompatibilitaNamespaceSenzaGov;
    }

    public Boolean isEnableValidazioneNomeFile() throws ProtocolException {
        if (this.isEnableValidazioneNomeFile == null) {
            String propertyName = "org.openspcoop2.protocol.sdi.validazione.nomeFile.enable";
            try {
                String value = this.reader.getValueConvertEnvProperties(propertyName);
                if (value == null) {
                    throw new Exception("Non definita");
                }
                value = value.trim();
                this.isEnableValidazioneNomeFile = Boolean.parseBoolean(value);
            }
            catch (Exception e) {
                String msg = "Riscontrato errore durante la lettura della proprieta' '" + propertyName + "': " + e.getMessage();
                this.logError(msg, e);
                throw new ProtocolException(msg, (Throwable)e);
            }
        }
        return this.isEnableValidazioneNomeFile;
    }

    public Boolean isEnableValidazioneXsdFatturaDaInviare() throws ProtocolException {
        if (this.isEnableValidazioneXsdFatturaDaInviare == null) {
            String propertyName = "org.openspcoop2.protocol.sdi.validazione.xsd.fatturaDaInviare";
            try {
                String value = this.reader.getValueConvertEnvProperties(propertyName);
                if (value == null) {
                    throw new Exception("Non definita");
                }
                value = value.trim();
                this.isEnableValidazioneXsdFatturaDaInviare = Boolean.parseBoolean(value);
            }
            catch (Exception e) {
                String msg = "Riscontrato errore durante la lettura della proprieta' '" + propertyName + "': " + e.getMessage();
                this.logError(msg, e);
                throw new ProtocolException(msg, (Throwable)e);
            }
        }
        return this.isEnableValidazioneXsdFatturaDaInviare;
    }

    public Boolean isEnable_fatturazioneAttiva_notifiche_enrichInfoFromFattura() throws ProtocolException {
        if (this.isEnable_fatturazioneAttiva_notifiche_enrichInfoFromFattura == null) {
            String propertyName = "org.openspcoop2.protocol.sdi.fatturazioneAttiva.notifiche.enrichInfoFromFattura";
            try {
                String value = this.reader.getValueConvertEnvProperties(propertyName);
                if (value == null) {
                    throw new Exception("Non definita");
                }
                value = value.trim();
                this.isEnable_fatturazioneAttiva_notifiche_enrichInfoFromFattura = Boolean.parseBoolean(value);
            }
            catch (Exception e) {
                String msg = "Riscontrato errore durante la lettura della proprieta' '" + propertyName + "': " + e.getMessage();
                this.logError(msg, e);
                throw new ProtocolException(msg, (Throwable)e);
            }
        }
        return this.isEnable_fatturazioneAttiva_notifiche_enrichInfoFromFattura;
    }

    public Boolean isEnable_fatturazioneAttiva_generazioneNomeFileFattura() throws ProtocolException {
        if (this.isEnable_fatturazioneAttiva_generazioneNomeFileFattura == null) {
            String propertyName = "org.openspcoop2.protocol.sdi.fatturazioneAttiva.nomeFile.gestione";
            try {
                String value = this.reader.getValueConvertEnvProperties(propertyName);
                if (value == null) {
                    throw new Exception("Non definita");
                }
                value = value.trim();
                this.isEnable_fatturazioneAttiva_generazioneNomeFileFattura = Boolean.parseBoolean(value);
            }
            catch (Exception e) {
                String msg = "Riscontrato errore durante la lettura della proprieta' '" + propertyName + "': " + e.getMessage();
                this.logError(msg, e);
                throw new ProtocolException(msg, (Throwable)e);
            }
        }
        return this.isEnable_fatturazioneAttiva_generazioneNomeFileFattura;
    }

    public Boolean isEnable_fatturazioneAttiva_generazioneNomeFileFatturaOpzionale() throws ProtocolException {
        if (this.isEnable_fatturazioneAttiva_generazioneNomeFileFatturaOpzionale == null) {
            String propertyName = "org.openspcoop2.protocol.sdi.fatturazioneAttiva.nomeFile.gestioneOpzionale";
            try {
                String value = this.reader.getValueConvertEnvProperties(propertyName);
                if (value != null) {
                    value = value.trim();
                    this.isEnable_fatturazioneAttiva_generazioneNomeFileFatturaOpzionale = Boolean.parseBoolean(value);
                } else {
                    this.isEnable_fatturazioneAttiva_generazioneNomeFileFatturaOpzionale = false;
                }
            }
            catch (Exception e) {
                String msg = "Riscontrato errore durante la lettura della proprieta' '" + propertyName + "': " + e.getMessage();
                this.logError(msg, e);
                throw new ProtocolException(msg, (Throwable)e);
            }
        }
        return this.isEnable_fatturazioneAttiva_generazioneNomeFileFatturaOpzionale;
    }

    public Boolean isEnableFatturazioneAttivaHeaderIntegrazioneGestioneErrore() throws ProtocolException {
        if (this.isEnableFatturazioneAttivaHeaderIntegrazioneGestioneErrore == null) {
            String propertyName = "org.openspcoop2.protocol.sdi.fatturazioneAttiva.headerIntegrazione.gestioneErrore";
            try {
                String value = this.reader.getValueConvertEnvProperties(propertyName);
                if (value != null) {
                    value = value.trim();
                    this.isEnableFatturazioneAttivaHeaderIntegrazioneGestioneErrore = Boolean.parseBoolean(value);
                } else {
                    this.isEnableFatturazioneAttivaHeaderIntegrazioneGestioneErrore = false;
                }
            }
            catch (Exception e) {
                String msg = "Riscontrato errore durante la lettura della proprieta' '" + propertyName + "': " + e.getMessage();
                this.logError(msg, e);
                throw new ProtocolException(msg, (Throwable)e);
            }
        }
        return this.isEnableFatturazioneAttivaHeaderIntegrazioneGestioneErrore;
    }

    public Boolean isEnableValidazioneXsdNotificaDaInviare() throws ProtocolException {
        if (this.isEnableValidazioneXsdNotificaDaInviare == null) {
            String propertyName = "org.openspcoop2.protocol.sdi.validazione.xsd.notificaDaInviare";
            try {
                String value = this.reader.getValueConvertEnvProperties(propertyName);
                if (value == null) {
                    throw new Exception("Non definita");
                }
                value = value.trim();
                this.isEnableValidazioneXsdNotificaDaInviare = Boolean.parseBoolean(value);
            }
            catch (Exception e) {
                String msg = "Riscontrato errore durante la lettura della proprieta' '" + propertyName + "': " + e.getMessage();
                this.logError(msg, e);
                throw new ProtocolException(msg, (Throwable)e);
            }
        }
        return this.isEnableValidazioneXsdNotificaDaInviare;
    }

    public Boolean isEnableAccessoNotificaDaInviare() throws ProtocolException {
        if (this.isEnableAccessoNotificaDaInviare == null) {
            String propertyName = "org.openspcoop2.protocol.sdi.access.notificaDaInviare";
            try {
                String value = this.reader.getValueConvertEnvProperties(propertyName);
                if (value == null) {
                    throw new Exception("Non definita");
                }
                value = value.trim();
                this.isEnableAccessoNotificaDaInviare = Boolean.parseBoolean(value);
            }
            catch (Exception e) {
                String msg = "Riscontrato errore durante la lettura della proprieta' '" + propertyName + "': " + e.getMessage();
                this.logError(msg, e);
                throw new ProtocolException(msg, (Throwable)e);
            }
        }
        return this.isEnableAccessoNotificaDaInviare;
    }

    public Boolean isEnable_InputIdSDIValidationAsBigInteger_NotificaDaInviare() throws ProtocolException {
        if (this.isEnable_InputIdSDIValidationAsBigInteger_NotificaDaInviare == null) {
            String propertyName = "org.openspcoop2.protocol.sdi.inputIdSDI.validationAsBigInteger.notificaDaInviare";
            try {
                String value = this.reader.getValueConvertEnvProperties(propertyName);
                if (value == null) {
                    throw new Exception("Non definita");
                }
                value = value.trim();
                this.isEnable_InputIdSDIValidationAsBigInteger_NotificaDaInviare = Boolean.parseBoolean(value);
            }
            catch (Exception e) {
                String msg = "Riscontrato errore durante la lettura della proprieta' '" + propertyName + "': " + e.getMessage();
                this.logError(msg, e);
                throw new ProtocolException(msg, (Throwable)e);
            }
        }
        return this.isEnable_InputIdSDIValidationAsBigInteger_NotificaDaInviare;
    }

    public Boolean isEnable_fatturazionePassiva_consegnaFileMetadati() throws ProtocolException {
        if (this.isEnable_fatturazionePassiva_consegnaFileMetadati == null) {
            String propertyName = "org.openspcoop2.protocol.sdi.fatturazionePassiva.consegnaFileMetadati";
            try {
                String value = this.reader.getValueConvertEnvProperties(propertyName);
                if (value == null) {
                    throw new Exception("Non definita");
                }
                value = value.trim();
                this.isEnable_fatturazionePassiva_consegnaFileMetadati = Boolean.parseBoolean(value);
            }
            catch (Exception e) {
                String msg = "Riscontrato errore durante la lettura della proprieta' '" + propertyName + "': " + e.getMessage();
                this.logError(msg, e);
                throw new ProtocolException(msg, (Throwable)e);
            }
        }
        return this.isEnable_fatturazionePassiva_consegnaFileMetadati;
    }

    public Boolean isEnable_fatturazionePassiva_notifiche_enrichInfoFromFattura() throws ProtocolException {
        if (this.isEnable_fatturazionePassiva_notifiche_enrichInfoFromFattura == null) {
            String propertyName = "org.openspcoop2.protocol.sdi.fatturazionePassiva.notifiche.enrichInfoFromFattura";
            try {
                String value = this.reader.getValueConvertEnvProperties(propertyName);
                if (value == null) {
                    throw new Exception("Non definita");
                }
                value = value.trim();
                this.isEnable_fatturazionePassiva_notifiche_enrichInfoFromFattura = Boolean.parseBoolean(value);
            }
            catch (Exception e) {
                String msg = "Riscontrato errore durante la lettura della proprieta' '" + propertyName + "': " + e.getMessage();
                this.logError(msg, e);
                throw new ProtocolException(msg, (Throwable)e);
            }
        }
        return this.isEnable_fatturazionePassiva_notifiche_enrichInfoFromFattura;
    }

    public Boolean isEnable_fatturazionePassiva_generazioneNomeFileEsito() throws ProtocolException {
        if (this.isEnable_fatturazionePassiva_generazioneNomeFileEsito == null) {
            String propertyName = "org.openspcoop2.protocol.sdi.fatturazionePassiva.nomeFile.gestione";
            try {
                String value = this.reader.getValueConvertEnvProperties(propertyName);
                if (value == null) {
                    throw new Exception("Non definita");
                }
                value = value.trim();
                this.isEnable_fatturazionePassiva_generazioneNomeFileEsito = Boolean.parseBoolean(value);
            }
            catch (Exception e) {
                String msg = "Riscontrato errore durante la lettura della proprieta' '" + propertyName + "': " + e.getMessage();
                this.logError(msg, e);
                throw new ProtocolException(msg, (Throwable)e);
            }
        }
        return this.isEnable_fatturazionePassiva_generazioneNomeFileEsito;
    }

    public Boolean isEnableFatturazionePassivaHeaderIntegrazioneGestioneErrore() throws ProtocolException {
        if (this.isEnableFatturazionePassivaHeaderIntegrazioneGestioneErrore == null) {
            String propertyName = "org.openspcoop2.protocol.sdi.fatturazionePassiva.headerIntegrazione.gestioneErrore";
            try {
                String value = this.reader.getValueConvertEnvProperties(propertyName);
                if (value != null) {
                    value = value.trim();
                    this.isEnableFatturazionePassivaHeaderIntegrazioneGestioneErrore = Boolean.parseBoolean(value);
                } else {
                    this.isEnableFatturazionePassivaHeaderIntegrazioneGestioneErrore = false;
                }
            }
            catch (Exception e) {
                String msg = "Riscontrato errore durante la lettura della proprieta' '" + propertyName + "': " + e.getMessage();
                this.logError(msg, e);
                throw new ProtocolException(msg, (Throwable)e);
            }
        }
        return this.isEnableFatturazionePassivaHeaderIntegrazioneGestioneErrore;
    }

    public boolean isTracciamentoRequiredFromConfiguration() throws ProtocolException {
        return this.isEnable_fatturazioneAttiva_notifiche_enrichInfoFromFattura() != false || this.isEnable_fatturazionePassiva_notifiche_enrichInfoFromFattura() != false;
    }

    public String getTracciamentoDatasource() throws ProtocolException {
        if (this.tracciamentoDatasource_read == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.sdi.tracce.dataSource");
                if (value != null) {
                    this.tracciamentoDatasource = value = value.trim();
                }
            }
            catch (Exception e) {
                this.logError("Proprieta' di openspcoop 'org.openspcoop2.protocol.sdi.tracce.dataSource', errore:" + e.getMessage());
                throw new ProtocolException((Throwable)e);
            }
            finally {
                this.tracciamentoDatasource_read = true;
            }
        }
        return this.tracciamentoDatasource;
    }

    public String getTracciamentoTipoDatabase() throws ProtocolException {
        if (this.tracciamentoTipoDatabase_read == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.sdi.tracce.tipoDatabase");
                if (value != null) {
                    this.tracciamentoTipoDatabase = value = value.trim();
                }
            }
            catch (Exception e) {
                this.logError("Proprieta' di openspcoop 'org.openspcoop2.protocol.sdi.tracce.tipoDatabase', errore:" + e.getMessage());
                throw new ProtocolException((Throwable)e);
            }
            finally {
                this.tracciamentoTipoDatabase_read = true;
            }
        }
        return this.tracciamentoTipoDatabase;
    }

    public Properties getTracciamentoDatasource_jndiContext() throws ProtocolException {
        if (this.tracciamentoDatasource_jndiContext == null) {
            try {
                this.tracciamentoDatasource_jndiContext = this.reader.readPropertiesConvertEnvProperties("org.openspcoop2.protocol.sdi.tracce.dataSource.property.");
                if (this.tracciamentoDatasource_jndiContext == null || this.tracciamentoDatasource_jndiContext.size() < 0) {
                    this.tracciamentoDatasource_jndiContext = new Properties();
                }
            }
            catch (Exception e) {
                this.logError("Proprieta' di openspcoop 'org.openspcoop2.protocol.sdi.tracce.dataSource.property.*', errore:" + e.getMessage());
                throw new ProtocolException((Throwable)e);
            }
        }
        return this.tracciamentoDatasource_jndiContext;
    }

    public Boolean isEnableAccessoMetadati() throws ProtocolException {
        if (this.isEnableAccessoMetadati == null) {
            String propertyName = "org.openspcoop2.protocol.sdi.accesso.campiMetadati.enable";
            try {
                String value = this.reader.getValueConvertEnvProperties(propertyName);
                if (value == null) {
                    throw new Exception("Non definita");
                }
                value = value.trim();
                this.isEnableAccessoMetadati = Boolean.parseBoolean(value);
            }
            catch (Exception e) {
                String msg = "Riscontrato errore durante la lettura della proprieta' '" + propertyName + "': " + e.getMessage();
                this.logError(msg, e);
                throw new ProtocolException(msg, (Throwable)e);
            }
        }
        return this.isEnableAccessoMetadati;
    }

    public Boolean isEnableAccessoFattura() throws ProtocolException {
        if (this.isEnableAccessoFattura == null) {
            String propertyName = "org.openspcoop2.protocol.sdi.accesso.campiFattura.enable";
            try {
                String value = this.reader.getValueConvertEnvProperties(propertyName);
                if (value == null) {
                    throw new Exception("Non definita");
                }
                value = value.trim();
                this.isEnableAccessoFattura = Boolean.parseBoolean(value);
            }
            catch (Exception e) {
                String msg = "Riscontrato errore durante la lettura della proprieta' '" + propertyName + "': " + e.getMessage();
                this.logError(msg, e);
                throw new ProtocolException(msg, (Throwable)e);
            }
        }
        return this.isEnableAccessoFattura;
    }

    public Boolean isEnableAccessoMessaggi() throws ProtocolException {
        if (this.isEnableAccessoMessaggi == null) {
            String propertyName = "org.openspcoop2.protocol.sdi.accesso.campiMessaggi.enable";
            try {
                String value = this.reader.getValueConvertEnvProperties(propertyName);
                if (value == null) {
                    throw new Exception("Non definita");
                }
                value = value.trim();
                this.isEnableAccessoMessaggi = Boolean.parseBoolean(value);
            }
            catch (Exception e) {
                String msg = "Riscontrato errore durante la lettura della proprieta' '" + propertyName + "': " + e.getMessage();
                this.logError(msg, e);
                throw new ProtocolException(msg, (Throwable)e);
            }
        }
        return this.isEnableAccessoMessaggi;
    }

    public Boolean isEnableAccessoMetadatiWarningMode() throws ProtocolException {
        if (this.isEnableAccessoMetadatiWarningMode == null) {
            String propertyName = "org.openspcoop2.protocol.sdi.accesso.campiMetadati.enable.throwError";
            try {
                String value = this.reader.getValueConvertEnvProperties(propertyName);
                if (value == null) {
                    throw new Exception("Non definita");
                }
                this.isEnableAccessoMetadatiWarningMode = !Boolean.parseBoolean(value = value.trim());
            }
            catch (Exception e) {
                String msg = "Riscontrato errore durante la lettura della proprieta' '" + propertyName + "': " + e.getMessage();
                this.logError(msg, e);
                throw new ProtocolException(msg, (Throwable)e);
            }
        }
        return this.isEnableAccessoMetadatiWarningMode;
    }

    public Boolean isEnableAccessoFatturaWarningMode() throws ProtocolException {
        if (this.isEnableAccessoFatturaWarningMode == null) {
            String propertyName = "org.openspcoop2.protocol.sdi.accesso.campiFattura.enable.throwError";
            try {
                String value = this.reader.getValueConvertEnvProperties(propertyName);
                if (value == null) {
                    throw new Exception("Non definita");
                }
                this.isEnableAccessoFatturaWarningMode = !Boolean.parseBoolean(value = value.trim());
            }
            catch (Exception e) {
                String msg = "Riscontrato errore durante la lettura della proprieta' '" + propertyName + "': " + e.getMessage();
                this.logError(msg, e);
                throw new ProtocolException(msg, (Throwable)e);
            }
        }
        return this.isEnableAccessoFatturaWarningMode;
    }

    public Boolean isEnableAccessoMessaggiWarningMode() throws ProtocolException {
        if (this.isEnableAccessoMessaggiWarningMode == null) {
            String propertyName = "org.openspcoop2.protocol.sdi.accesso.campiMessaggi.enable.throwError";
            try {
                String value = this.reader.getValueConvertEnvProperties(propertyName);
                if (value == null) {
                    throw new Exception("Non definita");
                }
                this.isEnableAccessoMessaggiWarningMode = !Boolean.parseBoolean(value = value.trim());
            }
            catch (Exception e) {
                String msg = "Riscontrato errore durante la lettura della proprieta' '" + propertyName + "': " + e.getMessage();
                this.logError(msg, e);
                throw new ProtocolException(msg, (Throwable)e);
            }
        }
        return this.isEnableAccessoMessaggiWarningMode;
    }

    public Boolean isEnableValidazioneXsdMetadati() throws ProtocolException {
        if (this.isEnableValidazioneXsdMetadati == null) {
            String propertyName = "org.openspcoop2.protocol.sdi.validazione.xsd.metadati";
            try {
                String value = this.reader.getValueConvertEnvProperties(propertyName);
                if (value == null) {
                    throw new Exception("Non definita");
                }
                value = value.trim();
                this.isEnableValidazioneXsdMetadati = Boolean.parseBoolean(value);
            }
            catch (Exception e) {
                String msg = "Riscontrato errore durante la lettura della proprieta' '" + propertyName + "': " + e.getMessage();
                this.logError(msg, e);
                throw new ProtocolException(msg, (Throwable)e);
            }
        }
        return this.isEnableValidazioneXsdMetadati;
    }

    public Boolean isEnableValidazioneXsdFattura() throws ProtocolException {
        if (this.isEnableValidazioneXsdFattura == null) {
            String propertyName = "org.openspcoop2.protocol.sdi.validazione.xsd.fattura";
            try {
                String value = this.reader.getValueConvertEnvProperties(propertyName);
                if (value == null) {
                    throw new Exception("Non definita");
                }
                value = value.trim();
                this.isEnableValidazioneXsdFattura = Boolean.parseBoolean(value);
            }
            catch (Exception e) {
                String msg = "Riscontrato errore durante la lettura della proprieta' '" + propertyName + "': " + e.getMessage();
                this.logError(msg, e);
                throw new ProtocolException(msg, (Throwable)e);
            }
        }
        return this.isEnableValidazioneXsdFattura;
    }

    public Boolean isEnableValidazioneXsdMessaggi() throws ProtocolException {
        if (this.isEnableValidazioneXsdMessaggi == null) {
            String propertyName = "org.openspcoop2.protocol.sdi.validazione.xsd.messaggi";
            try {
                String value = this.reader.getValueConvertEnvProperties(propertyName);
                if (value == null) {
                    throw new Exception("Non definita");
                }
                value = value.trim();
                this.isEnableValidazioneXsdMessaggi = Boolean.parseBoolean(value);
            }
            catch (Exception e) {
                String msg = "Riscontrato errore durante la lettura della proprieta' '" + propertyName + "': " + e.getMessage();
                this.logError(msg, e);
                throw new ProtocolException(msg, (Throwable)e);
            }
        }
        return this.isEnableValidazioneXsdMessaggi;
    }

    public Boolean isEnableValidazioneCampiInterniMetadati() throws ProtocolException {
        if (this.isEnableValidazioneCampiInterniMetadati == null) {
            String propertyName = "org.openspcoop2.protocol.sdi.validazione.campiMetadati.enable";
            try {
                String value = this.reader.getValueConvertEnvProperties(propertyName);
                if (value == null) {
                    throw new Exception("Non definita");
                }
                value = value.trim();
                this.isEnableValidazioneCampiInterniMetadati = Boolean.parseBoolean(value);
            }
            catch (Exception e) {
                String msg = "Riscontrato errore durante la lettura della proprieta' '" + propertyName + "': " + e.getMessage();
                this.logError(msg, e);
                throw new ProtocolException(msg, (Throwable)e);
            }
        }
        return this.isEnableValidazioneCampiInterniMetadati;
    }

    public Boolean isEnableValidazioneCampiInterniFattura() throws ProtocolException {
        if (this.isEnableValidazioneCampiInterniFattura == null) {
            String propertyName = "org.openspcoop2.protocol.sdi.validazione.campiFattura.enable";
            try {
                String value = this.reader.getValueConvertEnvProperties(propertyName);
                if (value == null) {
                    throw new Exception("Non definita");
                }
                value = value.trim();
                this.isEnableValidazioneCampiInterniFattura = Boolean.parseBoolean(value);
            }
            catch (Exception e) {
                String msg = "Riscontrato errore durante la lettura della proprieta' '" + propertyName + "': " + e.getMessage();
                this.logError(msg, e);
                throw new ProtocolException(msg, (Throwable)e);
            }
        }
        return this.isEnableValidazioneCampiInterniFattura;
    }

    public Boolean isEnableValidazioneCampiInterniMessaggi() throws ProtocolException {
        if (this.isEnableValidazioneCampiInterniMessaggi == null) {
            String propertyName = "org.openspcoop2.protocol.sdi.validazione.campiMessaggi.enable";
            try {
                String value = this.reader.getValueConvertEnvProperties(propertyName);
                if (value == null) {
                    throw new Exception("Non definita");
                }
                value = value.trim();
                this.isEnableValidazioneCampiInterniMessaggi = Boolean.parseBoolean(value);
            }
            catch (Exception e) {
                String msg = "Riscontrato errore durante la lettura della proprieta' '" + propertyName + "': " + e.getMessage();
                this.logError(msg, e);
                throw new ProtocolException(msg, (Throwable)e);
            }
        }
        return this.isEnableValidazioneCampiInterniMessaggi;
    }

    public Boolean isSaveFatturaInContext() throws ProtocolException {
        if (this.isSaveFatturaInContext == null) {
            String propertyName = "org.openspcoop2.protocol.sdi.parse.fattura.saveInContext";
            try {
                String value = this.reader.getValueConvertEnvProperties(propertyName);
                if (value == null) {
                    throw new Exception("Non definita");
                }
                value = value.trim();
                this.isSaveFatturaInContext = Boolean.parseBoolean(value);
            }
            catch (Exception e) {
                String msg = "Riscontrato errore durante la lettura della proprieta' '" + propertyName + "': " + e.getMessage();
                this.logError(msg, e);
                throw new ProtocolException(msg, (Throwable)e);
            }
        }
        return this.isSaveFatturaInContext;
    }

    public Boolean isSaveMessaggiInContext() throws ProtocolException {
        if (this.isSaveMessaggiInContext == null) {
            String propertyName = "org.openspcoop2.protocol.sdi.parse.messaggi.saveInContext";
            try {
                String value = this.reader.getValueConvertEnvProperties(propertyName);
                if (value == null) {
                    throw new Exception("Non definita");
                }
                value = value.trim();
                this.isSaveMessaggiInContext = Boolean.parseBoolean(value);
            }
            catch (Exception e) {
                String msg = "Riscontrato errore durante la lettura della proprieta' '" + propertyName + "': " + e.getMessage();
                this.logError(msg, e);
                throw new ProtocolException(msg, (Throwable)e);
            }
        }
        return this.isSaveMessaggiInContext;
    }

    public Boolean isNotificaATConsegnaSoloAttestato() throws ProtocolException {
        if (this.isNotificaATConsegnaSoloAttestato == null) {
            String propertyName = "org.openspcoop2.protocol.sdi.notifica.attestazioneTrasmissioneImpossibilitaRecapito.consegnaSoloAttestato";
            try {
                String value = this.reader.getValueConvertEnvProperties(propertyName);
                if (value == null) {
                    throw new Exception("Non definita");
                }
                value = value.trim();
                this.isNotificaATConsegnaSoloAttestato = Boolean.parseBoolean(value);
            }
            catch (Exception e) {
                String msg = "Riscontrato errore durante la lettura della proprieta' '" + propertyName + "': " + e.getMessage();
                this.logError(msg, e);
                throw new ProtocolException(msg, (Throwable)e);
            }
        }
        return this.isNotificaATConsegnaSoloAttestato;
    }

    public Boolean isBehaviourCreaProtocolloSDI() throws ProtocolException {
        if (this.isBehaviourCreaProtocolloSDI == null) {
            String propertyName = "org.openspcoop2.protocol.sdi.behaviour.creaProtocolloSDI";
            try {
                String value = this.reader.getValueConvertEnvProperties(propertyName);
                if (value == null) {
                    throw new Exception("Non definita");
                }
                value = value.trim();
                this.isBehaviourCreaProtocolloSDI = Boolean.parseBoolean(value);
            }
            catch (Exception e) {
                String msg = "Riscontrato errore durante la lettura della proprieta' '" + propertyName + "': " + e.getMessage();
                this.logError(msg, e);
                throw new ProtocolException(msg, (Throwable)e);
            }
        }
        return this.isBehaviourCreaProtocolloSDI;
    }

    public List<String> getSoggettiWhiteList() throws ProtocolException {
        if (this.soggettiWhiteList == null) {
            String propertyName = "org.openspcoop2.protocol.sdi.whiteList.soggetti";
            try {
                String value = this.reader.getValueConvertEnvProperties(propertyName);
                this.soggettiWhiteList = new ArrayList<String>();
                if (value != null) {
                    value = value.trim();
                    String[] tmp = value.split(",");
                    for (int i = 0; i < tmp.length; ++i) {
                        this.soggettiWhiteList.add(tmp[i]);
                    }
                }
            }
            catch (Exception e) {
                String msg = "Riscontrato errore durante la lettura della proprieta' '" + propertyName + "': " + e.getMessage();
                this.logError(msg, e);
                throw new ProtocolException(msg, (Throwable)e);
            }
        }
        return this.soggettiWhiteList;
    }

    public List<String> getServiziWhiteList() throws ProtocolException {
        if (this.serviziWhiteList == null) {
            String propertyName = "org.openspcoop2.protocol.sdi.whiteList.servizi";
            try {
                String value = this.reader.getValueConvertEnvProperties(propertyName);
                this.serviziWhiteList = new ArrayList<String>();
                if (value != null) {
                    value = value.trim();
                    String[] tmp = value.split(",");
                    for (int i = 0; i < tmp.length; ++i) {
                        this.serviziWhiteList.add(tmp[i]);
                    }
                }
            }
            catch (Exception e) {
                String msg = "Riscontrato errore durante la lettura della proprieta' '" + propertyName + "': " + e.getMessage();
                this.logError(msg, e);
                throw new ProtocolException(msg, (Throwable)e);
            }
        }
        return this.serviziWhiteList;
    }

    public List<String> getAzioniWhiteList() throws ProtocolException {
        if (this.azioniWhiteList == null) {
            String propertyName = "org.openspcoop2.protocol.sdi.whiteList.azioni";
            try {
                String value = this.reader.getValueConvertEnvProperties(propertyName);
                this.azioniWhiteList = new ArrayList<String>();
                if (value != null) {
                    value = value.trim();
                    String[] tmp = value.split(",");
                    for (int i = 0; i < tmp.length; ++i) {
                        this.azioniWhiteList.add(tmp[i]);
                    }
                }
            }
            catch (Exception e) {
                String msg = "Riscontrato errore durante la lettura della proprieta' '" + propertyName + "': " + e.getMessage();
                this.logError(msg, e);
                throw new ProtocolException(msg, (Throwable)e);
            }
        }
        return this.azioniWhiteList;
    }

    public List<String> getNamespaceWhiteList() throws ProtocolException {
        if (this.namespaceWhiteList == null) {
            String propertyName = "org.openspcoop2.protocol.sdi.whiteList.namespace";
            try {
                String value = this.reader.getValueConvertEnvProperties(propertyName);
                this.namespaceWhiteList = new ArrayList<String>();
                if (value != null) {
                    value = value.trim();
                    String[] tmp = value.split(",");
                    for (int i = 0; i < tmp.length; ++i) {
                        this.namespaceWhiteList.add(tmp[i]);
                    }
                }
            }
            catch (Exception e) {
                String msg = "Riscontrato errore durante la lettura della proprieta' '" + propertyName + "': " + e.getMessage();
                this.logError(msg, e);
                throw new ProtocolException(msg, (Throwable)e);
            }
        }
        return this.namespaceWhiteList;
    }

    public Boolean isPortaApplicativaBustaErrore_personalizzaElementiFault() {
        if (this.isPortaApplicativaBustaErrore_personalizzaElementiFaultRead == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.sdi.pa.bustaErrore.personalizzaElementiFault");
                if (value != null) {
                    value = value.trim();
                    this.isPortaApplicativaBustaErrore_personalizzaElementiFault = Boolean.parseBoolean(value);
                } else {
                    this.log.debug("Proprieta' di openspcoop 'org.openspcoop2.protocol.sdi.pa.bustaErrore.personalizzaElementiFault' non impostata, viene utilizzato il default associato al Servizio Applicativo (faultApplicativo.enrichDetails)");
                    this.isPortaApplicativaBustaErrore_personalizzaElementiFault = null;
                }
                this.isPortaApplicativaBustaErrore_personalizzaElementiFaultRead = true;
            }
            catch (Exception e) {
                this.log.warn("Proprieta' di openspcoop 'org.openspcoop2.protocol.sdi.pa.bustaErrore.personalizzaElementiFault' non impostata, viene utilizzato il default associato al Servizio Applicativo (faultApplicativo.enrichDetails), errore:" + e.getMessage());
                this.isPortaApplicativaBustaErrore_personalizzaElementiFault = null;
                this.isPortaApplicativaBustaErrore_personalizzaElementiFaultRead = true;
            }
        }
        return this.isPortaApplicativaBustaErrore_personalizzaElementiFault;
    }

    public Boolean isPortaApplicativaBustaErrore_aggiungiErroreApplicativo() {
        if (this.isPortaApplicativaBustaErrore_aggiungiErroreApplicativoRead == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.sdi.pa.bustaErrore.aggiungiErroreApplicativo");
                if (value != null) {
                    value = value.trim();
                    this.isPortaApplicativaBustaErrore_aggiungiErroreApplicativo = Boolean.parseBoolean(value);
                } else {
                    this.log.debug("Proprieta' di openspcoop 'org.openspcoop2.protocol.sdi.pa.bustaErrore.aggiungiErroreApplicativo' non impostata, viene utilizzato il default associato al Servizio Applicativo (faultApplicativo.enrichDetails)");
                    this.isPortaApplicativaBustaErrore_aggiungiErroreApplicativo = null;
                }
                this.isPortaApplicativaBustaErrore_aggiungiErroreApplicativoRead = true;
            }
            catch (Exception e) {
                this.log.warn("Proprieta' di openspcoop 'org.openspcoop2.protocol.sdi.pa.bustaErrore.aggiungiErroreApplicativo' non impostata, viene utilizzato il default associato al Servizio Applicativo (faultApplicativo.enrichDetails), errore:" + e.getMessage());
                this.isPortaApplicativaBustaErrore_aggiungiErroreApplicativo = null;
                this.isPortaApplicativaBustaErrore_aggiungiErroreApplicativoRead = true;
            }
        }
        return this.isPortaApplicativaBustaErrore_aggiungiErroreApplicativo;
    }

    public boolean isGenerazioneDetailsSOAPFaultProtocolValidazione() {
        if (this.isGenerazioneDetailsSOAPFaultProtocolValidazione == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.sdi.generazioneDetailsSoapFault.protocol.eccezioneIntestazione");
                if (value != null) {
                    value = value.trim();
                    this.isGenerazioneDetailsSOAPFaultProtocolValidazione = Boolean.parseBoolean(value);
                } else {
                    this.log.warn("Proprieta' di openspcoop 'org.openspcoop2.protocol.sdi.generazioneDetailsSoapFault.protocol.eccezioneIntestazione' non impostata, viene utilizzato il default=false");
                    this.isGenerazioneDetailsSOAPFaultProtocolValidazione = false;
                }
            }
            catch (Exception e) {
                this.log.warn("Proprieta' di openspcoop 'org.openspcoop2.protocol.sdi.generazioneDetailsSoapFault.protocol.eccezioneIntestazione' non impostata, viene utilizzato il default=false, errore:" + e.getMessage());
                this.isGenerazioneDetailsSOAPFaultProtocolValidazione = false;
            }
        }
        return this.isGenerazioneDetailsSOAPFaultProtocolValidazione;
    }

    public boolean isGenerazioneDetailsSOAPFaultProtocolProcessamento() {
        if (this.isGenerazioneDetailsSOAPFaultProtocolProcessamento == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.sdi.generazioneDetailsSoapFault.protocol.eccezioneProcessamento");
                if (value != null) {
                    value = value.trim();
                    this.isGenerazioneDetailsSOAPFaultProtocolProcessamento = Boolean.parseBoolean(value);
                } else {
                    this.log.warn("Proprieta' di openspcoop 'org.openspcoop2.protocol.sdi.generazioneDetailsSoapFault.protocol.eccezioneProcessamento' non impostata, viene utilizzato il default=true");
                    this.isGenerazioneDetailsSOAPFaultProtocolProcessamento = true;
                }
            }
            catch (Exception e) {
                this.log.warn("Proprieta' di openspcoop 'org.openspcoop2.protocol.sdi.generazioneDetailsSoapFault.protocol.eccezioneProcessamento' non impostata, viene utilizzato il default=true, errore:" + e.getMessage());
                this.isGenerazioneDetailsSOAPFaultProtocolProcessamento = true;
            }
        }
        return this.isGenerazioneDetailsSOAPFaultProtocolProcessamento;
    }

    public boolean isGenerazioneDetailsSOAPFaultProtocolWithStackTrace() {
        if (this.isGenerazioneDetailsSOAPFaultProtocolWithStackTrace == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.sdi.generazioneDetailsSoapFault.protocol.stackTrace");
                if (value != null) {
                    value = value.trim();
                    this.isGenerazioneDetailsSOAPFaultProtocolWithStackTrace = Boolean.parseBoolean(value);
                } else {
                    this.log.warn("Proprieta' di openspcoop 'org.openspcoop2.protocol.sdi.generazioneDetailsSoapFault.protocol.stackTrace' non impostata, viene utilizzato il default=false");
                    this.isGenerazioneDetailsSOAPFaultProtocolWithStackTrace = false;
                }
            }
            catch (Exception e) {
                this.log.warn("Proprieta' di openspcoop 'org.openspcoop2.protocol.sdi.generazioneDetailsSoapFault.protocol.stackTrace' non impostata, viene utilizzato il default=false, errore:" + e.getMessage());
                this.isGenerazioneDetailsSOAPFaultProtocolWithStackTrace = false;
            }
        }
        return this.isGenerazioneDetailsSOAPFaultProtocolWithStackTrace;
    }

    public boolean isGenerazioneDetailsSOAPFaultProtocolConInformazioniGeneriche() {
        if (this.isGenerazioneDetailsSOAPFaultProtocolConInformazioniGeneriche == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.sdi.generazioneDetailsSoapFault.protocol.informazioniGeneriche");
                if (value != null) {
                    value = value.trim();
                    this.isGenerazioneDetailsSOAPFaultProtocolConInformazioniGeneriche = Boolean.parseBoolean(value);
                } else {
                    this.log.warn("Proprieta' di openspcoop 'org.openspcoop2.protocol.sdi.generazioneDetailsSoapFault.protocol.informazioniGeneriche' non impostata, viene utilizzato il default=true");
                    this.isGenerazioneDetailsSOAPFaultProtocolConInformazioniGeneriche = true;
                }
            }
            catch (Exception e) {
                this.log.warn("Proprieta' di openspcoop 'org.openspcoop2.protocol.sdi.generazioneDetailsSoapFault.protocol.informazioniGeneriche' non impostata, viene utilizzato il default=true, errore:" + e.getMessage());
                this.isGenerazioneDetailsSOAPFaultProtocolConInformazioniGeneriche = true;
            }
        }
        return this.isGenerazioneDetailsSOAPFaultProtocolConInformazioniGeneriche;
    }

    public boolean isGenerazioneDetailsSOAPFaultIntegrationServerError() {
        if (this.isGenerazioneDetailsSOAPFaultIntegrationServerError == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.sdi.generazioneDetailsSoapFault.integration.serverError");
                if (value != null) {
                    value = value.trim();
                    this.isGenerazioneDetailsSOAPFaultIntegrationServerError = Boolean.parseBoolean(value);
                } else {
                    this.log.warn("Proprieta' di openspcoop 'org.openspcoop2.protocol.sdi.generazioneDetailsSoapFault.integration.serverError' non impostata, viene utilizzato il default=true");
                    this.isGenerazioneDetailsSOAPFaultIntegrationServerError = true;
                }
            }
            catch (Exception e) {
                this.log.warn("Proprieta' di openspcoop 'org.openspcoop2.protocol.sdi.generazioneDetailsSoapFault.integration.serverError' non impostata, viene utilizzato il default=true, errore:" + e.getMessage());
                this.isGenerazioneDetailsSOAPFaultIntegrationServerError = true;
            }
        }
        return this.isGenerazioneDetailsSOAPFaultIntegrationServerError;
    }

    public boolean isGenerazioneDetailsSOAPFaultIntegrationClientError() {
        if (this.isGenerazioneDetailsSOAPFaultIntegrationClientError == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.sdi.generazioneDetailsSoapFault.integration.clientError");
                if (value != null) {
                    value = value.trim();
                    this.isGenerazioneDetailsSOAPFaultIntegrationClientError = Boolean.parseBoolean(value);
                } else {
                    this.log.warn("Proprieta' di openspcoop 'org.openspcoop2.protocol.sdi.generazioneDetailsSoapFault.integration.clientError' non impostata, viene utilizzato il default=false");
                    this.isGenerazioneDetailsSOAPFaultIntegrationClientError = false;
                }
            }
            catch (Exception e) {
                this.log.warn("Proprieta' di openspcoop 'org.openspcoop2.protocol.sdi.generazioneDetailsSoapFault.integration.clientError' non impostata, viene utilizzato il default=false, errore:" + e.getMessage());
                this.isGenerazioneDetailsSOAPFaultIntegrationClientError = false;
            }
        }
        return this.isGenerazioneDetailsSOAPFaultIntegrationClientError;
    }

    public boolean isGenerazioneDetailsSOAPFaultIntegrationWithStackTrace() {
        if (this.isGenerazioneDetailsSOAPFaultIntegrationWithStackTrace == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.sdi.generazioneDetailsSoapFault.integration.stackTrace");
                if (value != null) {
                    value = value.trim();
                    this.isGenerazioneDetailsSOAPFaultIntegrationWithStackTrace = Boolean.parseBoolean(value);
                } else {
                    this.log.warn("Proprieta' di openspcoop 'org.openspcoop2.protocol.sdi.generazioneDetailsSoapFault.integration.stackTrace' non impostata, viene utilizzato il default=false");
                    this.isGenerazioneDetailsSOAPFaultIntegrationWithStackTrace = false;
                }
            }
            catch (Exception e) {
                this.log.warn("Proprieta' di openspcoop 'org.openspcoop2.protocol.sdi.generazioneDetailsSoapFault.integration.stackTrace' non impostata, viene utilizzato il default=false, errore:" + e.getMessage());
                this.isGenerazioneDetailsSOAPFaultIntegrationWithStackTrace = false;
            }
        }
        return this.isGenerazioneDetailsSOAPFaultIntegrationWithStackTrace;
    }

    public Boolean isGenerazioneDetailsSOAPFaultIntegrazionConInformazioniGeneriche() {
        if (this.isGenerazioneDetailsSOAPFaultIntegrationConInformazioniGenericheRead == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.sdi.generazioneDetailsSoapFault.integration.informazioniGeneriche");
                if (value != null) {
                    value = value.trim();
                    this.isGenerazioneDetailsSOAPFaultIntegrationConInformazioniGeneriche = Boolean.parseBoolean(value);
                } else {
                    this.log.debug("Proprieta' di openspcoop 'org.openspcoop2.protocol.sdi.generazioneDetailsSoapFault.integration.informazioniGeneriche' non impostata, viene utilizzato il default associato al Servizio Applicativo (faultAsGenericCode)");
                    this.isGenerazioneDetailsSOAPFaultIntegrationConInformazioniGeneriche = null;
                }
                this.isGenerazioneDetailsSOAPFaultIntegrationConInformazioniGenericheRead = true;
            }
            catch (Exception e) {
                this.log.warn("Proprieta' di openspcoop 'org.openspcoop2.protocol.sdi.generazioneDetailsSoapFault.integration.informazioniGeneriche' non impostata, viene utilizzato il default associato al Servizio Applicativo (faultAsGenericCode), errore:" + e.getMessage());
                this.isGenerazioneDetailsSOAPFaultIntegrationConInformazioniGeneriche = null;
                this.isGenerazioneDetailsSOAPFaultIntegrationConInformazioniGenericheRead = true;
            }
        }
        return this.isGenerazioneDetailsSOAPFaultIntegrationConInformazioniGeneriche;
    }

    public BooleanNullable isAggiungiDetailErroreApplicativo_SoapFaultApplicativo() {
        if (this.isAggiungiDetailErroreApplicativo_SoapFaultApplicativoRead == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.sdi.erroreApplicativo.faultApplicativo.enrichDetails");
                if (value != null) {
                    Boolean b = Boolean.parseBoolean(value = value.trim());
                    this.isAggiungiDetailErroreApplicativo_SoapFaultApplicativo = b != false ? BooleanNullable.TRUE() : BooleanNullable.FALSE();
                } else {
                    this.log.debug("Proprieta' di openspcoop 'org.openspcoop2.protocol.sdi.erroreApplicativo.faultApplicativo.enrichDetails' non impostata, viene utilizzato il default associato al Servizio Applicativo (faultApplicativo.enrichDetails)");
                    this.isAggiungiDetailErroreApplicativo_SoapFaultApplicativo = BooleanNullable.NULL();
                }
                this.isAggiungiDetailErroreApplicativo_SoapFaultApplicativoRead = true;
            }
            catch (Exception e) {
                this.log.warn("Proprieta' di openspcoop 'org.openspcoop2.protocol.sdi.erroreApplicativo.faultApplicativo.enrichDetails' non impostata, viene utilizzato il default associato al Servizio Applicativo (faultApplicativo.enrichDetails), errore:" + e.getMessage());
                this.isAggiungiDetailErroreApplicativo_SoapFaultApplicativo = BooleanNullable.NULL();
                this.isAggiungiDetailErroreApplicativo_SoapFaultApplicativoRead = true;
            }
        }
        return this.isAggiungiDetailErroreApplicativo_SoapFaultApplicativo;
    }

    public BooleanNullable isAggiungiDetailErroreApplicativo_SoapFaultPdD() {
        if (this.isAggiungiDetailErroreApplicativo_SoapFaultPdDRead == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.sdi.erroreApplicativo.faultPdD.enrichDetails");
                if (value != null) {
                    Boolean b = Boolean.parseBoolean(value = value.trim());
                    this.isAggiungiDetailErroreApplicativo_SoapFaultPdD = b != false ? BooleanNullable.TRUE() : BooleanNullable.FALSE();
                } else {
                    this.log.debug("Proprieta' di openspcoop 'org.openspcoop2.protocol.sdi.erroreApplicativo.faultPdD.enrichDetails' non impostata, viene utilizzato il default associato al Servizio Applicativo (faultPdD.enrichDetails)");
                    this.isAggiungiDetailErroreApplicativo_SoapFaultPdD = BooleanNullable.NULL();
                }
                this.isAggiungiDetailErroreApplicativo_SoapFaultPdDRead = true;
            }
            catch (Exception e) {
                this.log.warn("Proprieta' di openspcoop 'org.openspcoop2.protocol.sdi.erroreApplicativo.faultPdD.enrichDetails' non impostata, viene utilizzato il default associato al Servizio Applicativo (faultPdD.enrichDetails), errore:" + e.getMessage());
                this.isAggiungiDetailErroreApplicativo_SoapFaultPdD = BooleanNullable.NULL();
                this.isAggiungiDetailErroreApplicativo_SoapFaultPdDRead = true;
            }
        }
        return this.isAggiungiDetailErroreApplicativo_SoapFaultPdD;
    }

    private Boolean useConfigStaticInstance() {
        if (this.useConfigStaticInstance == null) {
            Boolean defaultValue = true;
            String propertyName = "org.openspcoop2.protocol.sdi.factory.config.staticInstance";
            try {
                String value = this.reader.getValueConvertEnvProperties(propertyName);
                if (value != null) {
                    value = value.trim();
                    this.useConfigStaticInstance = Boolean.parseBoolean(value);
                } else {
                    this.log.debug("Proprieta' di openspcoop '" + propertyName + "' non impostata, viene utilizzato il default=" + defaultValue);
                    this.useConfigStaticInstance = defaultValue;
                }
            }
            catch (Exception e) {
                this.log.debug("Proprieta' di openspcoop '" + propertyName + "' non impostata, viene utilizzato il default=" + defaultValue + ", errore:" + e.getMessage());
                this.useConfigStaticInstance = defaultValue;
            }
        }
        return this.useConfigStaticInstance;
    }

    private Boolean useErroreApplicativoStaticInstance() {
        if (this.useErroreApplicativoStaticInstance == null) {
            Boolean defaultValue = true;
            String propertyName = "org.openspcoop2.protocol.sdi.factory.erroreApplicativo.staticInstance";
            try {
                String value = this.reader.getValueConvertEnvProperties(propertyName);
                if (value != null) {
                    value = value.trim();
                    this.useErroreApplicativoStaticInstance = Boolean.parseBoolean(value);
                } else {
                    this.log.debug("Proprieta' di openspcoop '" + propertyName + "' non impostata, viene utilizzato il default=" + defaultValue);
                    this.useErroreApplicativoStaticInstance = defaultValue;
                }
            }
            catch (Exception e) {
                this.log.debug("Proprieta' di openspcoop '" + propertyName + "' non impostata, viene utilizzato il default=" + defaultValue + ", errore:" + e.getMessage());
                this.useErroreApplicativoStaticInstance = defaultValue;
            }
        }
        return this.useErroreApplicativoStaticInstance;
    }

    private Boolean useEsitoStaticInstance() {
        if (this.useEsitoStaticInstance == null) {
            Boolean defaultValue = true;
            String propertyName = "org.openspcoop2.protocol.sdi.factory.esito.staticInstance";
            try {
                String value = this.reader.getValueConvertEnvProperties(propertyName);
                if (value != null) {
                    value = value.trim();
                    this.useEsitoStaticInstance = Boolean.parseBoolean(value);
                } else {
                    this.log.debug("Proprieta' di openspcoop '" + propertyName + "' non impostata, viene utilizzato il default=" + defaultValue);
                    this.useEsitoStaticInstance = defaultValue;
                }
            }
            catch (Exception e) {
                this.log.debug("Proprieta' di openspcoop '" + propertyName + "' non impostata, viene utilizzato il default=" + defaultValue + ", errore:" + e.getMessage());
                this.useEsitoStaticInstance = defaultValue;
            }
        }
        return this.useEsitoStaticInstance;
    }

    public BasicStaticInstanceConfig getStaticInstanceConfig() {
        if (this.staticInstanceConfig == null) {
            this.staticInstanceConfig = new BasicStaticInstanceConfig();
            if (this.useConfigStaticInstance() != null) {
                this.staticInstanceConfig.setStaticConfig(this.useConfigStaticInstance().booleanValue());
            }
            if (this.useErroreApplicativoStaticInstance() != null) {
                this.staticInstanceConfig.setStaticErrorBuilder(this.useErroreApplicativoStaticInstance().booleanValue());
            }
            if (this.useEsitoStaticInstance() != null) {
                this.staticInstanceConfig.setStaticEsitoBuilder(this.useEsitoStaticInstance().booleanValue());
            }
        }
        return this.staticInstanceConfig;
    }
}

