/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.sdi.config;

import java.util.Map;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.constants.MessageRole;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.protocol.basic.config.BasicManager;
import org.openspcoop2.protocol.sdi.config.SDIProperties;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.constants.FaultIntegrationGenericInfoMode;
import org.openspcoop2.protocol.sdk.constants.TipoIntegrazione;
import org.openspcoop2.protocol.sdk.registry.IRegistryReader;
import org.openspcoop2.utils.BooleanNullable;
import org.openspcoop2.utils.io.notifier.NotifierInputStreamParams;
import org.openspcoop2.utils.transport.TransportRequestContext;
import org.openspcoop2.utils.transport.TransportResponseContext;
import org.slf4j.Logger;

public class SDIProtocolManager
extends BasicManager {
    protected SDIProperties sdiProperties = null;
    protected Logger logger = this.getProtocolFactory().getLogger();

    public SDIProtocolManager(IProtocolFactory<?> protocolFactory) throws ProtocolException {
        super(protocolFactory);
        this.sdiProperties = SDIProperties.getInstance(this.logger);
    }

    public boolean isIgnoraEccezioniNonGravi() {
        return true;
    }

    public boolean isGenerazioneListaEccezioniErroreProcessamento() {
        return true;
    }

    public boolean isGenerazioneDetailsFaultProtocollo_EccezioneValidazione() {
        return this.sdiProperties.isGenerazioneDetailsSOAPFaultProtocolValidazione();
    }

    public boolean isGenerazioneDetailsFaultProtocollo_EccezioneProcessamento() {
        return this.sdiProperties.isGenerazioneDetailsSOAPFaultProtocolProcessamento();
    }

    public boolean isGenerazioneDetailsFaultProtocolloConStackTrace() {
        return this.sdiProperties.isGenerazioneDetailsSOAPFaultProtocolWithStackTrace();
    }

    public boolean isGenerazioneDetailsFaultProtocolloConInformazioniGeneriche() {
        return this.sdiProperties.isGenerazioneDetailsSOAPFaultProtocolConInformazioniGeneriche();
    }

    public boolean isGenerazioneDetailsFaultIntegratione_erroreServer() {
        return this.sdiProperties.isGenerazioneDetailsSOAPFaultIntegrationServerError();
    }

    public boolean isGenerazioneDetailsFaultIntegratione_erroreClient() {
        return this.sdiProperties.isGenerazioneDetailsSOAPFaultIntegrationClientError();
    }

    public boolean isGenerazioneDetailsFaultIntegrationeConStackTrace() {
        return this.sdiProperties.isGenerazioneDetailsSOAPFaultIntegrationWithStackTrace();
    }

    public FaultIntegrationGenericInfoMode getModalitaGenerazioneInformazioniGeneriche_DetailsFaultIntegrazione() {
        Boolean value = this.sdiProperties.isGenerazioneDetailsSOAPFaultIntegrazionConInformazioniGeneriche();
        if (value == null) {
            return FaultIntegrationGenericInfoMode.SERVIZIO_APPLICATIVO;
        }
        if (value.booleanValue()) {
            return FaultIntegrationGenericInfoMode.ABILITATO;
        }
        return FaultIntegrationGenericInfoMode.DISABILITATO;
    }

    public BooleanNullable isAggiungiDetailErroreApplicativo_FaultApplicativo() {
        return this.sdiProperties.isAggiungiDetailErroreApplicativo_SoapFaultApplicativo();
    }

    public BooleanNullable isAggiungiDetailErroreApplicativo_FaultPdD() {
        return this.sdiProperties.isAggiungiDetailErroreApplicativo_SoapFaultPdD();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Map<String, String> buildIntegrationProperties(Busta busta, boolean isRichiesta, TipoIntegrazione tipoIntegrazione) throws ProtocolException {
        if (busta == null) {
            return null;
        }
        boolean buildInfo = false;
        if (busta != null && busta.sizeProperties() > 0) {
            busta.removeProperty("EsitoCommittente");
            busta.removeProperty("Errori");
        }
        if (isRichiesta) {
            if ("TrasmissioneFatture".equals(busta.getServizio())) {
                if ("RicevutaConsegna".equals(busta.getAzione())) {
                    buildInfo = true;
                } else if ("NotificaMancataConsegna".equals(busta.getAzione())) {
                    buildInfo = true;
                } else if ("NotificaScarto".equals(busta.getAzione())) {
                    buildInfo = true;
                } else if ("NotificaEsito".equals(busta.getAzione())) {
                    buildInfo = true;
                } else if ("NotificaDecorrenzaTermini".equals(busta.getAzione())) {
                    buildInfo = true;
                } else {
                    if (!"AttestazioneTrasmissioneFattura".equals(busta.getAzione())) throw new ProtocolException("Servizio[" + busta.getServizio() + "] con Azione[" + busta.getAzione() + "] non gestita dal protocollo durante la fase di richiesta");
                    buildInfo = true;
                }
            } else if ("RicezioneFatture".equals(busta.getServizio())) {
                if ("RiceviFatture".equals(busta.getAzione())) {
                    buildInfo = true;
                } else {
                    if (!"NotificaDecorrenzaTermini".equals(busta.getAzione())) throw new ProtocolException("Servizio[" + busta.getServizio() + "] con Azione[" + busta.getAzione() + "] non gestita dal protocollo durante la fase di richiesta");
                    buildInfo = true;
                }
            } else {
                if ("SdIRiceviFile".equals(busta.getServizio())) {
                    return null;
                }
                if ("SdIRiceviNotifica".equals(busta.getServizio())) {
                    return null;
                }
                boolean whiteList = false;
                if (busta.getServizio() != null && this.sdiProperties.getServiziWhiteList().contains(busta.getServizio()) && busta.getAzione() != null && this.sdiProperties.getAzioniWhiteList().contains(busta.getAzione())) {
                    this.logger.debug("Servizio [" + busta.getServizio() + "] e Azione [" + busta.getAzione() + "] in white list");
                    whiteList = true;
                }
                if (!whiteList) {
                    throw new ProtocolException("Servizio[" + busta.getServizio() + "] non gestite dal protocollo durante la fase di richiesta");
                }
            }
        } else if ("SdIRiceviFile".equals(busta.getServizio()) && "RiceviFile".equals(busta.getAzione())) {
            buildInfo = true;
        } else if ("SdIRiceviNotifica".equals(busta.getServizio()) && "NotificaEsito".equals(busta.getAzione())) {
            buildInfo = true;
        } else {
            if ("TrasmissioneFatture".equals(busta.getServizio())) {
                return null;
            }
            if ("RicezioneFatture".equals(busta.getServizio())) {
                return null;
            }
            boolean whiteList = false;
            if (busta.getServizio() != null && this.sdiProperties.getServiziWhiteList().contains(busta.getServizio()) && busta.getAzione() != null && this.sdiProperties.getAzioniWhiteList().contains(busta.getAzione())) {
                this.logger.debug("Servizio [" + busta.getServizio() + "] e Azione [" + busta.getAzione() + "] in white list");
                whiteList = true;
            }
            if (!whiteList) {
                throw new ProtocolException("Servizio[" + busta.getServizio() + "] e Azione[" + busta.getAzione() + "] non gestite dal protocollo durante la fase di risposta");
            }
        }
        if (!buildInfo) return null;
        return super.buildIntegrationProperties(busta, isRichiesta, tipoIntegrazione);
    }

    public OpenSPCoop2Message updateOpenSPCoop2MessageResponse(OpenSPCoop2Message msg, Busta busta, NotifierInputStreamParams notifierInputStreamParams, TransportRequestContext transportRequestContext, TransportResponseContext transportResponseContext, IRegistryReader registryReader, boolean integration) throws ProtocolException {
        if ("RicezioneFatture".equals(busta.getServizio()) && "RiceviFatture".equals(busta.getAzione()) && (transportResponseContext == null || transportResponseContext.getErrore() == null)) {
            OpenSPCoop2MessageFactory messageFactory = msg != null ? msg.getFactory() : OpenSPCoop2MessageFactory.getDefaultMessageFactory();
            OpenSPCoop2Message msgR = messageFactory.createEmptyMessage(MessageType.SOAP_11, MessageRole.RESPONSE, notifierInputStreamParams);
            msgR.setTransportRequestContext(transportRequestContext);
            msgR.setTransportResponseContext(transportResponseContext);
            return msgR;
        }
        return super.updateOpenSPCoop2MessageResponse(msg, busta, notifierInputStreamParams, transportRequestContext, transportResponseContext, registryReader, integration);
    }

    public Integer getHttpReturnCodeEmptyResponseOneWay() {
        return 202;
    }
}

