/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.sdi.utils;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.util.io.pem.PemReader;
import org.openspcoop2.utils.io.Base64Utilities;
import org.slf4j.Logger;

public class P7MInfo {
    private byte[] xmlDecoded;
    private boolean base64Encoded = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public P7MInfo(byte[] fattura, Logger log) throws Throwable {
        try {
            CMSSignedData cmsSignedData = new CMSSignedData((InputStream)new ByteArrayInputStream(fattura));
            this.xmlDecoded = (byte[])cmsSignedData.getSignedContent().getContent();
        }
        catch (Throwable e) {
            byte[] decoded = null;
            try {
                String fatturaS = new String(fattura);
                if (fatturaS.trim().startsWith("-----BEGIN")) {
                    PemReader pemReader = null;
                    StringReader stringReader = null;
                    try {
                        stringReader = new StringReader(fatturaS);
                        pemReader = new PemReader((Reader)stringReader);
                        decoded = pemReader.readPemObject().getContent();
                    }
                    catch (Throwable eDecodePEM) {
                        log.error("DecodificaBase64 via PEMReader non riuscita: " + eDecodePEM.getMessage(), eDecodePEM);
                    }
                    finally {
                        try {
                            if (pemReader != null) {
                                pemReader.close();
                            }
                        }
                        catch (Throwable throwable) {}
                        try {
                            if (stringReader != null) {
                                stringReader.close();
                            }
                        }
                        catch (Throwable throwable) {}
                    }
                }
                if (decoded == null) {
                    decoded = Base64Utilities.decode((String)fatturaS);
                }
            }
            catch (Throwable eDecode) {
                log.error("DecodificaBase64 non riuscita: " + eDecode.getMessage(), eDecode);
                throw e;
            }
            this.base64Encoded = true;
            CMSSignedData cmsSignedData = new CMSSignedData((InputStream)new ByteArrayInputStream(decoded));
            this.xmlDecoded = (byte[])cmsSignedData.getSignedContent().getContent();
        }
    }

    public byte[] getXmlDecoded() {
        return this.xmlDecoded;
    }

    public boolean isBase64Encoded() {
        return this.base64Encoded;
    }
}

