/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.sdi.validator;

import it.gov.fatturapa.sdi.messaggi.v1_0.constants.TipiMessaggi;
import java.net.ProtocolException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.openspcoop2.utils.regexp.RegularExpressionEngine;

public class SDIValidatoreNomeFile {
    private static List<String> CODICI_PAESE = null;

    private static synchronized void initCodiciPaese() {
        if (CODICI_PAESE == null) {
            CODICI_PAESE = new ArrayList<String>();
            String[] l = Locale.getISOCountries();
            for (int i = 0; i < l.length; ++i) {
                CODICI_PAESE.add(l[i]);
            }
        }
    }

    private static void validaCodicePaese(String codicePaese) throws ProtocolException {
        if (CODICI_PAESE == null) {
            SDIValidatoreNomeFile.initCodiciPaese();
        }
        if (!CODICI_PAESE.contains(codicePaese)) {
            throw new ProtocolException("CodicePaese [" + codicePaese + "] sconosciuto");
        }
    }

    public static void validaNomeFileFattura(String nomeFile, boolean isRicezione) throws ProtocolException {
        if (nomeFile == null) {
            throw new ProtocolException("NomeFile Fattura non fornito");
        }
        if (nomeFile.length() < 10) {
            throw new ProtocolException("NomeFile Fattura [" + nomeFile + "] con struttura non corretto (length=" + nomeFile.length() + "<10)");
        }
        if (!nomeFile.contains("_")) {
            throw new ProtocolException("NomeFile Fattura [" + nomeFile + "] con struttura non corretto ('_' non presente)");
        }
        if (!nomeFile.contains(".")) {
            throw new ProtocolException("NomeFile Fattura [" + nomeFile + "] con struttura non corretto ('.' non presente)");
        }
        String[] splitUnderscore = nomeFile.split("_");
        if (splitUnderscore.length != 2) {
            throw new ProtocolException("NomeFile Fattura [" + nomeFile + "] con struttura non corretto (split('_')=" + splitUnderscore.length + "<>2)");
        }
        String leftCode = splitUnderscore[0];
        String rightCode = splitUnderscore[1];
        if (!rightCode.contains(".")) {
            throw new ProtocolException("NomeFile Fattura [" + nomeFile + "] con struttura non corretto (rightUnderscore=[" + rightCode + "] '.' non presente)");
        }
        String[] splitPoint = rightCode.split("\\.");
        if (splitPoint.length != 2 && splitPoint.length != 3) {
            throw new ProtocolException("NomeFile Fattura [" + nomeFile + "] con struttura non corretto (split('.')=" + splitPoint.length + "<>2/3)");
        }
        String codicePaese = nomeFile.substring(0, 2);
        SDIValidatoreNomeFile.validaCodicePaese(codicePaese);
        String identificativoTrasmittente = null;
        if ("IT".equals(codicePaese)) {
            if (leftCode.length() < 13) {
                throw new ProtocolException("NomeFile Fattura [" + nomeFile + "] con struttura non corretto (leftUnderscore=[" + leftCode + "] length=" + leftCode.length() + "<13)");
            }
            if (leftCode.length() > 18) {
                throw new ProtocolException("NomeFile Fattura [" + nomeFile + "] con struttura non corretto (leftUnderscore=[" + leftCode + "] length=" + leftCode.length() + ">18)");
            }
        } else {
            if (leftCode.length() < 4) {
                throw new ProtocolException("NomeFile Fattura [" + nomeFile + "] con struttura non corretto (leftUnderscore=[" + leftCode + "] length=" + leftCode.length() + "<4)");
            }
            if (leftCode.length() > 30) {
                throw new ProtocolException("NomeFile Fattura [" + nomeFile + "] con struttura non corretto (leftUnderscore=[" + leftCode + "] length=" + leftCode.length() + ">30)");
            }
        }
        identificativoTrasmittente = leftCode.substring(2);
        String progressivoUnivoco = splitPoint[0];
        if (progressivoUnivoco.length() < 1) {
            throw new ProtocolException("NomeFile Fattura [" + nomeFile + "] con struttura non corretto (progressivoUnivoco=[" + progressivoUnivoco + "] length=" + progressivoUnivoco.length() + "<1)");
        }
        if (progressivoUnivoco.length() > 5) {
            throw new ProtocolException("NomeFile Fattura [" + nomeFile + "] con struttura non corretto (progressivoUnivoco=[" + progressivoUnivoco + "] length=" + progressivoUnivoco.length() + ">5)");
        }
        try {
            if (!RegularExpressionEngine.isMatch((String)progressivoUnivoco, (String)"^[A-Za-z0-9]*$")) {
                throw new ProtocolException("Sono presenti caratteri non alfanumerici");
            }
        }
        catch (Exception e) {
            throw new ProtocolException("NomeFile Fattura [" + nomeFile + "] con struttura non corretto (progressivoUnivoco=[" + progressivoUnivoco + "] " + e.getMessage() + ")");
        }
        String ext = rightCode.substring((progressivoUnivoco + ".").length(), rightCode.length());
        if (ext == null) {
            throw new ProtocolException("NomeFile Fattura [" + nomeFile + "] con struttura non corretto (extension non presente)");
        }
        if (isRicezione) {
            if (!"xml".equalsIgnoreCase(ext) && !"xml.p7m".equalsIgnoreCase(ext)) {
                throw new ProtocolException("NomeFile Fattura [" + nomeFile + "] con struttura non corretto (extension=[" + ext + "] non valida, attesa xml o xml.p7m)");
            }
        } else if (!("xml".equalsIgnoreCase(ext) || "xml.p7m".equalsIgnoreCase(ext) || "zip".equalsIgnoreCase(ext))) {
            throw new ProtocolException("NomeFile Fattura [" + nomeFile + "] con struttura non corretto (extension=[" + ext + "] non valida, attesa xml o xml.p7m o zip)");
        }
    }

    public static String getNomeFileFatturaSenzaEstensione(String nomeFileFattura) {
        String nomeFileFatturaSenzaEstensione = new String(nomeFileFattura);
        if (nomeFileFatturaSenzaEstensione.toLowerCase().endsWith("xml") && nomeFileFatturaSenzaEstensione.length() > "xml".length() + 1) {
            nomeFileFatturaSenzaEstensione = nomeFileFatturaSenzaEstensione.substring(0, nomeFileFatturaSenzaEstensione.length() - ("xml".length() + 1));
        } else if (nomeFileFatturaSenzaEstensione.toLowerCase().endsWith("xml.p7m") && nomeFileFatturaSenzaEstensione.length() > "xml.p7m".length() + 1) {
            nomeFileFatturaSenzaEstensione = nomeFileFatturaSenzaEstensione.substring(0, nomeFileFatturaSenzaEstensione.length() - ("xml.p7m".length() + 1));
        } else if (nomeFileFatturaSenzaEstensione.toLowerCase().endsWith("zip") && nomeFileFatturaSenzaEstensione.length() > "zip".length() + 1) {
            nomeFileFatturaSenzaEstensione = nomeFileFatturaSenzaEstensione.substring(0, nomeFileFatturaSenzaEstensione.length() - ("zip".length() + 1));
        }
        return nomeFileFatturaSenzaEstensione;
    }

    public static String getNomeFileFatturaPerMessaggi(String nomeFileFattura) {
        String nomeFileFatturaSenzaEstensione = SDIValidatoreNomeFile.getNomeFileFatturaSenzaEstensione(nomeFileFattura);
        if (nomeFileFatturaSenzaEstensione.length() > 36) {
            return nomeFileFatturaSenzaEstensione.substring(0, 36);
        }
        return nomeFileFatturaSenzaEstensione;
    }

    public static void validaNomeFileMessaggi(String nomeFile, TipiMessaggi tipoMessaggio) throws ProtocolException {
        SDIValidatoreNomeFile.validaNomeFileMessaggi(null, nomeFile, tipoMessaggio);
    }

    public static void validaNomeFileMessaggi(String nomeFileFattura, String nomeFile, TipiMessaggi tipoMessaggio) throws ProtocolException {
        if (nomeFile == null) {
            throw new ProtocolException("NomeFile (" + tipoMessaggio.name() + ") non fornito");
        }
        if (nomeFile.length() < 19) {
            throw new ProtocolException("NomeFile (" + tipoMessaggio.name() + ")[" + nomeFile + "] con struttura non corretto (length=" + nomeFile.length() + "<19)");
        }
        if (!nomeFile.contains("_")) {
            throw new ProtocolException("NomeFile (" + tipoMessaggio.name() + ")[" + nomeFile + "] con struttura non corretto ('_' non presente)");
        }
        if (!nomeFile.contains(".")) {
            throw new ProtocolException("NomeFile (" + tipoMessaggio.name() + ")[" + nomeFile + "] con struttura non corretto ('.' non presente)");
        }
        String[] splitUnderscore = nomeFile.split("_");
        if (splitUnderscore.length != 4) {
            throw new ProtocolException("NomeFile (" + tipoMessaggio.name() + ")[" + nomeFile + "] con struttura non corretto (split('_')=" + splitUnderscore.length + "<>4)");
        }
        String nomeFileFatturaInterno = splitUnderscore[0] + "_" + splitUnderscore[1];
        if (nomeFileFattura != null) {
            String nomeFileFatturaSenzaEstensione = SDIValidatoreNomeFile.getNomeFileFatturaSenzaEstensione(nomeFileFattura);
            if (nomeFileFatturaSenzaEstensione.length() > 36) {
                if (!nomeFileFatturaSenzaEstensione.substring(0, 36).equals(nomeFileFatturaInterno)) {
                    throw new ProtocolException("NomeFile (" + tipoMessaggio.name() + ")[" + nomeFile + "] con struttura non corretto (nomeFattura.substring(36)=[" + nomeFileFatturaSenzaEstensione + "] non riportato correttamente nel nome del file " + tipoMessaggio.name() + ")");
                }
            } else if (!nomeFileFatturaSenzaEstensione.equals(nomeFileFatturaInterno)) {
                throw new ProtocolException("NomeFile (" + tipoMessaggio.name() + ")[" + nomeFile + "] con struttura non corretto (nomeFattura=[" + nomeFileFatturaSenzaEstensione + "] non riportato correttamente nel nome del file " + tipoMessaggio.name() + ")");
            }
        }
        if (nomeFile.length() <= nomeFileFatturaInterno.length()) {
            throw new ProtocolException("NomeFile (" + tipoMessaggio.name() + ")[" + nomeFile + "] con struttura non corretto (informazioni dopo nomeFattura non presenti)");
        }
        String nomeFileMessaggio = nomeFile.substring(nomeFileFatturaInterno.length());
        if (nomeFileMessaggio == null) {
            throw new ProtocolException("NomeFile (" + tipoMessaggio.name() + ")[" + nomeFile + "] con struttura non corretto (informazioni dopo nomeFattura non presenti [null])");
        }
        if (nomeFileMessaggio.length() < 9) {
            throw new ProtocolException("NomeFile (" + tipoMessaggio.name() + ")[" + nomeFile + "] con struttura non corretto (informazioni dopo nomeFattura [" + nomeFileMessaggio + "], lenght=" + nomeFileMessaggio.length() + "<9)");
        }
        if (!nomeFileMessaggio.startsWith("_")) {
            throw new ProtocolException("NomeFile (" + tipoMessaggio.name() + ")[" + nomeFile + "] con struttura non corretto (informazioni dopo nomeFattura [" + nomeFileMessaggio + "], '_' atteso dopo il nome della fattura)");
        }
        if (!(nomeFileMessaggio = nomeFileMessaggio.substring(1)).contains("_")) {
            throw new ProtocolException("NomeFile (" + tipoMessaggio.name() + ")[" + nomeFile + "] con struttura non corretto (informazioni dopo nomeFattura [" + nomeFileMessaggio + "], '_' non presente)");
        }
        if (!nomeFileMessaggio.contains(".")) {
            throw new ProtocolException("NomeFile (" + tipoMessaggio.name() + ")[" + nomeFile + "] con struttura non corretto (informazioni dopo nomeFattura [" + nomeFileMessaggio + "], '.' non presente)");
        }
        String[] splitUnderscoreMessaggio = nomeFileMessaggio.split("_");
        if (splitUnderscoreMessaggio.length != 2) {
            throw new ProtocolException("NomeFile (" + tipoMessaggio.name() + ")[" + nomeFile + "] con struttura non corretto (informazioni dopo nomeFattura [" + nomeFileMessaggio + "], split('_')=" + splitUnderscoreMessaggio.length + "<>2)");
        }
        if (!splitUnderscoreMessaggio[1].contains(".")) {
            throw new ProtocolException("NomeFile (" + tipoMessaggio.name() + ")[" + nomeFile + "] con struttura non corretto (informazioni dopo nomeFattura [" + nomeFileMessaggio + "], '.' non presente dopo il tipoMessaggio)");
        }
        String[] splitPointMessaggio = nomeFileMessaggio.split("\\.");
        if (splitPointMessaggio.length != 2) {
            throw new ProtocolException("NomeFile (" + tipoMessaggio.name() + ")[" + nomeFile + "] con struttura non corretto (informazioni dopo nomeFattura [" + nomeFileMessaggio + "], split('.')=" + splitPointMessaggio.length + "<>2)");
        }
        String[] splitPointMessaggioUnderscore = splitPointMessaggio[0].split("_");
        if (splitPointMessaggioUnderscore.length != 2) {
            throw new ProtocolException("NomeFile (" + tipoMessaggio.name() + ")[" + nomeFile + "] con struttura non corretto (informazioni dopo nomeFattura [" + splitPointMessaggio[0] + "] senza ext, split('_')=" + splitPointMessaggioUnderscore.length + "<>2)");
        }
        String tipoMessaggioPresente = splitUnderscoreMessaggio[0];
        if (!tipoMessaggio.name().equals(tipoMessaggioPresente)) {
            throw new ProtocolException("NomeFile (" + tipoMessaggio.name() + ")[" + nomeFile + "] con struttura non corretto (informazioni dopo nomeFattura [" + nomeFileMessaggio + "], tipoMessaggio '" + tipoMessaggioPresente + "' differente da quello atteso '" + tipoMessaggio.name() + "')");
        }
        String progressivoUnivoco = splitPointMessaggioUnderscore[1];
        if (progressivoUnivoco.length() < 1) {
            throw new ProtocolException("NomeFile (" + tipoMessaggio.name() + ")[" + nomeFile + "] con struttura non corretto (progressivoUnivoco=[" + progressivoUnivoco + "] length=" + progressivoUnivoco.length() + "<1)");
        }
        if (progressivoUnivoco.length() > 3) {
            throw new ProtocolException("NomeFile (" + tipoMessaggio.name() + ")[" + nomeFile + "] con struttura non corretto (progressivoUnivoco=[" + progressivoUnivoco + "] length=" + progressivoUnivoco.length() + ">3)");
        }
        try {
            if (!RegularExpressionEngine.isMatch((String)progressivoUnivoco, (String)"^[A-Za-z0-9]*$")) {
                throw new ProtocolException("Sono presenti caratteri non alfanumerici");
            }
        }
        catch (Exception e) {
            throw new ProtocolException("NomeFile (" + tipoMessaggio.name() + ")[" + nomeFile + "] con struttura non corretto (progressivoUnivoco=[" + progressivoUnivoco + "] " + e.getMessage() + ")");
        }
        String ext = splitPointMessaggio[1];
        if (ext == null) {
            throw new ProtocolException("NomeFile (" + tipoMessaggio.name() + ")[" + nomeFile + "] con struttura non corretto (extension non presente)");
        }
        if (TipiMessaggi.AT.equals(tipoMessaggio)) {
            if (!"zip".equalsIgnoreCase(ext)) {
                throw new ProtocolException("NomeFile (" + tipoMessaggio.name() + ")[" + nomeFile + "] con struttura non corretto (extension[" + ext + "] non valida, attesa zip)");
            }
        } else if (!"xml".equalsIgnoreCase(ext)) {
            throw new ProtocolException("NomeFile (" + tipoMessaggio.name() + ")[" + nomeFile + "] con struttura non corretto (extension[" + ext + "] non valida, attesa xml)");
        }
    }
}

