/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.sdi.validator;

import it.gov.fatturapa.sdi.ws.trasmissione.v1_0.types.constants.ErroreInvioType;
import it.gov.fatturapa.sdi.ws.trasmissione.v1_0.types.utils.ProjectInfo;
import jakarta.xml.soap.SOAPElement;
import java.util.List;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.soap.SoapUtils;
import org.openspcoop2.protocol.sdi.validator.SDIValidazioneSemantica;
import org.openspcoop2.protocol.sdi.validator.SDIValidazioneSintattica;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.constants.CodiceErroreCooperazione;

public class SDIValidatoreServizioRiceviFile {
    private SDIValidazioneSintattica sdiValidazioneSintattica;
    private SDIValidazioneSemantica sdiValidazioneSemantica;
    private OpenSPCoop2Message msg;
    private boolean isRichiesta;
    private SOAPElement sdiMessage;
    private String namespace;
    private Busta busta;

    public SDIValidatoreServizioRiceviFile(SDIValidazioneSintattica sdiValidazioneSintattica, OpenSPCoop2Message msg, boolean isRichiesta, SOAPElement sdiMessage, Busta busta) {
        this.sdiValidazioneSintattica = sdiValidazioneSintattica;
        this.msg = msg;
        this.isRichiesta = isRichiesta;
        this.sdiMessage = sdiMessage;
        this.namespace = ProjectInfo.getInstance().getProjectNamespace();
        this.busta = busta;
    }

    public SDIValidatoreServizioRiceviFile(SDIValidazioneSemantica sdiValidazioneSemantica, OpenSPCoop2Message msg, boolean isRichiesta, SOAPElement sdiMessage, Busta busta) {
        this.sdiValidazioneSemantica = sdiValidazioneSemantica;
        this.msg = msg;
        this.isRichiesta = isRichiesta;
        this.sdiMessage = sdiMessage;
        this.namespace = ProjectInfo.getInstance().getProjectNamespace();
        this.busta = busta;
    }

    private boolean checkServiceNamespace() throws Exception {
        if (!this.namespace.equals(this.sdiMessage.getNamespaceURI())) {
            this.sdiValidazioneSintattica.erroriValidazione.add(this.sdiValidazioneSintattica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Namespace [" + this.sdiMessage.getNamespaceURI() + "] differente da quello atteso [" + this.namespace + "]"));
            return false;
        }
        return true;
    }

    public void validaRiceviFile() throws Exception {
        if (!this.checkServiceNamespace()) {
            return;
        }
        if (this.sdiValidazioneSintattica != null) {
            if (this.isRichiesta) {
                throw new Exception("NotImplemented");
            }
            this._validazioneSintattica_RiceviFile_risposta();
        } else if (this.isRichiesta) {
            throw new Exception("NotImplemented");
        }
    }

    private void _validazioneSintattica_RiceviFile_risposta() throws Exception {
        String errore;
        if (!"rispostaSdIRiceviFile".equals(this.sdiMessage.getLocalName())) {
            this.sdiValidazioneSintattica.erroriValidazione.add(this.sdiValidazioneSintattica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "LocalName [" + this.sdiMessage.getLocalName() + "] differente da quello atteso [rispostaSdIRiceviFile]"));
            return;
        }
        List elementChilds = SoapUtils.getNotEmptyChildSOAPElement((SOAPElement)this.sdiMessage);
        if (elementChilds == null || elementChilds.size() <= 0) {
            this.sdiValidazioneSintattica.erroriValidazione.add(this.sdiValidazioneSintattica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "RootElement [{" + this.namespace + "}" + this.sdiMessage.getLocalName() + "] non contiene elementi"));
            return;
        }
        String identificativoSdI = null;
        String data = null;
        StringBuilder erroreSB = new StringBuilder();
        for (int i = 0; i < elementChilds.size(); ++i) {
            SOAPElement child = (SOAPElement)elementChilds.get(i);
            if ("IdentificativoSdI".equals(child.getLocalName())) {
                if (identificativoSdI != null) {
                    this.sdiValidazioneSintattica.erroriValidazione.add(this.sdiValidazioneSintattica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.IDENTIFICATIVO_MESSAGGIO_PRESENTE_PIU_VOLTE));
                    return;
                }
                if (child.getTextContent() == null) {
                    this.sdiValidazioneSintattica.erroriValidazione.add(this.sdiValidazioneSintattica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.IDENTIFICATIVO_MESSAGGIO_NON_VALORIZZATO));
                    return;
                }
                identificativoSdI = child.getTextContent();
            } else if ("DataOraRicezione".equals(child.getLocalName())) {
                if (data != null) {
                    this.sdiValidazioneSintattica.erroriValidazione.add(this.sdiValidazioneSintattica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Elemento [DataOraRicezione] presente piu' volte"));
                    return;
                }
                if (child.getTextContent() == null) {
                    this.sdiValidazioneSintattica.erroriValidazione.add(this.sdiValidazioneSintattica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Elemento [DataOraRicezione] non valorizzato"));
                    return;
                }
                data = child.getTextContent();
            } else if ("Errore".equals(child.getLocalName())) {
                if (erroreSB != null && erroreSB.length() > 0) {
                    this.sdiValidazioneSintattica.erroriValidazione.add(this.sdiValidazioneSintattica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Elemento [Errore] presente piu' volte"));
                    return;
                }
                if (child.getTextContent() == null) {
                    this.sdiValidazioneSintattica.erroriValidazione.add(this.sdiValidazioneSintattica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Elemento [Errore] non valorizzato"));
                    return;
                }
                String errore2 = child.getTextContent();
                if (errore2 != null) {
                    erroreSB.append(errore2);
                }
            } else {
                this.sdiValidazioneSintattica.erroriValidazione.add(this.sdiValidazioneSintattica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Element [" + child.getLocalName() + "] sconosciuto"));
                return;
            }
            if (child.getNamespaceURI() == null) continue;
            this.sdiValidazioneSintattica.erroriValidazione.add(this.sdiValidazioneSintattica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Element [" + child.getLocalName() + "] appartiene al namespace (" + child.getNamespaceURI() + "). Era atteso un elemento senza namespace"));
            return;
        }
        if (identificativoSdI == null) {
            this.sdiValidazioneSintattica.erroriValidazione.add(this.sdiValidazioneSintattica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.IDENTIFICATIVO_MESSAGGIO_NON_PRESENTE));
            return;
        }
        if (data == null) {
            this.sdiValidazioneSintattica.erroriValidazione.add(this.sdiValidazioneSintattica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Elemento [DataOraRicezione] non presente"));
            return;
        }
        String string = errore = erroreSB.length() > 0 ? erroreSB.toString() : null;
        if (errore != null) {
            try {
                if (!(ErroreInvioType.EI01.name().equals(errore) || ErroreInvioType.EI02.name().equals(errore) || ErroreInvioType.EI03.name().equals(errore))) {
                    throw new Exception("Valore [" + errore + "] differente dai valori attesi: [" + ErroreInvioType.EI01.name() + "," + ErroreInvioType.EI02.name() + "," + ErroreInvioType.EI03.name() + "]");
                }
            }
            catch (Exception e) {
                this.sdiValidazioneSintattica.erroriValidazione.add(this.sdiValidazioneSintattica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Elemento [Errore] non valido: " + e.getMessage(), e));
                return;
            }
            String motivo = null;
            if (ErroreInvioType.EI01.name().equals(errore)) {
                motivo = "EI01 - FILE VUOTO";
            } else if (ErroreInvioType.EI02.name().equals(errore)) {
                motivo = "EI02 - SERVIZIO NON DISPONIBILE";
            } else if (ErroreInvioType.EI03.name().equals(errore)) {
                motivo = "EI03 - UTENTE NON ABILITATO";
            }
            this.sdiValidazioneSintattica.erroriValidazione.add(this.sdiValidazioneSintattica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Elemento [Errore] indica uno stato del SdI in errore: " + motivo));
        }
        this.busta.addProperty("IdentificativoSdI", identificativoSdI);
        this.busta.addProperty("DataOraRicezione", data);
        if (errore != null) {
            this.busta.addProperty("Errore", errore);
        }
    }
}

