/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.monitor.engine.alarm;

import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.monitor.engine.alarm.AlarmConfigProperties;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.mail.SenderType;
import org.openspcoop2.utils.transport.http.HttpLibrary;
import org.openspcoop2.utils.transport.http.HttpLibraryConnection;
import org.openspcoop2.utils.transport.http.SSLConfig;
import org.slf4j.Logger;

public class AlarmEngineConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String activeAlarmServiceUrl;
    private String activeAlarmServiceUrlManagerUsername;
    private String activeAlarmServiceUrlManagerPassword;
    private Integer activeAlarmServiceUrlConnectionTimeout = 10000;
    private Integer activeAlarmServiceUrlReadConnectionTimeout = 120000;
    private boolean activeAlarmServiceUrlHttps = false;
    private boolean activeAlarmServiceUrlHttpsVerificaHostName = true;
    private boolean activeAlarmServiceUrlHttpsAutenticazioneServer = true;
    private String activeAlarmServiceUrlHttpsTruststorePath = null;
    private String activeAlarmServiceUrlHttpsTruststoreType = null;
    private String activeAlarmServiceUrlHttpsTruststorePassword = null;
    private HttpLibrary httpLibrary = HttpLibraryConnection.getDefaultLibrary();
    private boolean historyEnabled = true;
    private SenderType mailSenderType;
    private Integer mailSenderConnectionTimeout;
    private Integer mailSenderReadTimeout;
    private String mailHost;
    private Integer mailPort;
    private String mailUsername;
    private String mailPassword;
    private SSLConfig mailSSLConfig;
    private boolean mailStartTls;
    private String mailAgent;
    private String mailFrom;
    private String mailSubject;
    private String mailBody;
    private boolean mailDebug;
    private boolean mailSendChangeStatusOk;
    private boolean mailCheckAcknowledgedStatus;
    private boolean mailShowAllOptions;
    private String defaultScriptPath;
    private String defaultScriptArgs;
    private boolean scriptDebug;
    private boolean scriptSendChangeStatusOk;
    private boolean scriptCheckAcknowledgedStatus;
    private boolean scriptShowAllOptions;
    private boolean optionsUpdateStateActiveAlarm;
    private boolean optionsUpdateStatePassiveAlarm;
    private boolean optionsUpdateAckCriteriaActiveAlarm;
    private boolean optionsUpdateAckCriteriaPassiveAlarm;
    private boolean optionsAcknowledgedStatusAssociation;
    private boolean optionsGroupByApi;
    private boolean optionsFilterApi;
    private boolean optionsFilterApiOrganization;

    public HttpLibrary getHttpLibrary() {
        return this.httpLibrary;
    }

    public void setHttpLibrary(HttpLibrary httpLibrary) {
        this.httpLibrary = httpLibrary;
    }

    public boolean isHistoryEnabled() {
        return this.historyEnabled;
    }

    public void setHistoryEnabled(boolean historyEnabled) {
        this.historyEnabled = historyEnabled;
    }

    public SenderType getMailSenderType() {
        return this.mailSenderType;
    }

    public void setMailSenderType(SenderType mailSenderType) {
        this.mailSenderType = mailSenderType;
    }

    public Integer getMailSenderConnectionTimeout() {
        return this.mailSenderConnectionTimeout;
    }

    public void setMailSenderConnectionTimeout(Integer mailSenderConnectionTimeout) {
        this.mailSenderConnectionTimeout = mailSenderConnectionTimeout;
    }

    public Integer getMailSenderReadTimeout() {
        return this.mailSenderReadTimeout;
    }

    public void setMailSenderReadTimeout(Integer mailSenderReadTimeout) {
        this.mailSenderReadTimeout = mailSenderReadTimeout;
    }

    public String getMailHost() {
        return this.mailHost;
    }

    public void setMailHost(String mailHost) {
        this.mailHost = mailHost;
    }

    public Integer getMailPort() {
        return this.mailPort;
    }

    public void setMailPort(Integer mailPort) {
        this.mailPort = mailPort;
    }

    public String getMailUsername() {
        return this.mailUsername;
    }

    public void setMailUsername(String mailUsername) {
        this.mailUsername = mailUsername;
    }

    public String getMailPassword() {
        return this.mailPassword;
    }

    public void setMailPassword(String mailPassword) {
        this.mailPassword = mailPassword;
    }

    public SSLConfig getMailSSLConfig() {
        return this.mailSSLConfig;
    }

    public void setMailSSLConfig(SSLConfig mailSSLConfig) {
        this.mailSSLConfig = mailSSLConfig;
    }

    public boolean isMailStartTls() {
        return this.mailStartTls;
    }

    public void setMailStartTls(boolean mailStartTls) {
        this.mailStartTls = mailStartTls;
    }

    public String getMailAgent() {
        return this.mailAgent;
    }

    public void setMailAgent(String mailAgent) {
        this.mailAgent = mailAgent;
    }

    public String getMailFrom() {
        return this.mailFrom;
    }

    public void setMailFrom(String mailFrom) {
        this.mailFrom = mailFrom;
    }

    public String getMailSubject() {
        return this.mailSubject;
    }

    public void setMailSubject(String mailSubject) {
        this.mailSubject = mailSubject;
    }

    public String getMailBody() {
        return this.mailBody;
    }

    public void setMailBody(String mailBody) {
        this.mailBody = mailBody;
    }

    public String getDefaultScriptPath() {
        return this.defaultScriptPath;
    }

    public void setDefaultScriptPath(String defaultScriptPath) {
        this.defaultScriptPath = defaultScriptPath;
    }

    public String getDefaultScriptArgs() {
        return this.defaultScriptArgs;
    }

    public void setDefaultScriptArgs(String defaultScriptArgs) {
        this.defaultScriptArgs = defaultScriptArgs;
    }

    public boolean isMailCheckAcknowledgedStatus() {
        return this.mailCheckAcknowledgedStatus;
    }

    public void setMailCheckAcknowledgedStatus(boolean mailCheckAcknowledgedStatus) {
        this.mailCheckAcknowledgedStatus = mailCheckAcknowledgedStatus;
    }

    public boolean isMailSendChangeStatusOk() {
        return this.mailSendChangeStatusOk;
    }

    public void setMailSendChangeStatusOk(boolean mailSendChangeStatusOk) {
        this.mailSendChangeStatusOk = mailSendChangeStatusOk;
    }

    public boolean isMailShowAllOptions() {
        return this.mailShowAllOptions;
    }

    public void setMailShowAllOptions(boolean mailShowAllOptions) {
        this.mailShowAllOptions = mailShowAllOptions;
    }

    public boolean isMailDebug() {
        return this.mailDebug;
    }

    public void setMailDebug(boolean mailDebug) {
        this.mailDebug = mailDebug;
    }

    public boolean isScriptDebug() {
        return this.scriptDebug;
    }

    public void setScriptDebug(boolean scriptDebug) {
        this.scriptDebug = scriptDebug;
    }

    public boolean isScriptCheckAcknowledgedStatus() {
        return this.scriptCheckAcknowledgedStatus;
    }

    public void setScriptCheckAcknowledgedStatus(boolean scriptCheckAcknowledgedStatus) {
        this.scriptCheckAcknowledgedStatus = scriptCheckAcknowledgedStatus;
    }

    public boolean isScriptSendChangeStatusOk() {
        return this.scriptSendChangeStatusOk;
    }

    public void setScriptSendChangeStatusOk(boolean scriptSendChangeStatusOk) {
        this.scriptSendChangeStatusOk = scriptSendChangeStatusOk;
    }

    public boolean isScriptShowAllOptions() {
        return this.scriptShowAllOptions;
    }

    public void setScriptShowAllOptions(boolean scriptShowAllOptions) {
        this.scriptShowAllOptions = scriptShowAllOptions;
    }

    public String getActiveAlarmServiceUrl() {
        return this.activeAlarmServiceUrl;
    }

    public void setActiveAlarmServiceUrl(String activeAlarmServiceUrl) {
        this.activeAlarmServiceUrl = activeAlarmServiceUrl;
    }

    public String getActiveAlarmServiceUrlManagerUsername() {
        return this.activeAlarmServiceUrlManagerUsername;
    }

    public void setActiveAlarmServiceUrlManagerUsername(String activeAlarmServiceUrlManagerUsername) {
        this.activeAlarmServiceUrlManagerUsername = activeAlarmServiceUrlManagerUsername;
    }

    public String getActiveAlarmServiceUrlManagerPassword() {
        return this.activeAlarmServiceUrlManagerPassword;
    }

    public void setActiveAlarmServiceUrlManagerPassword(String activeAlarmServiceUrlManagerPassword) {
        this.activeAlarmServiceUrlManagerPassword = activeAlarmServiceUrlManagerPassword;
    }

    public Integer getActiveAlarmServiceUrlConnectionTimeout() {
        return this.activeAlarmServiceUrlConnectionTimeout;
    }

    public void setActiveAlarmServiceUrlConnectionTimeout(Integer activeAlarmServiceUrlConnectionTimeout) {
        this.activeAlarmServiceUrlConnectionTimeout = activeAlarmServiceUrlConnectionTimeout;
    }

    public Integer getActiveAlarmServiceUrlReadConnectionTimeout() {
        return this.activeAlarmServiceUrlReadConnectionTimeout;
    }

    public void setActiveAlarmServiceUrlReadConnectionTimeout(Integer activeAlarmServiceUrlReadConnectionTimeout) {
        this.activeAlarmServiceUrlReadConnectionTimeout = activeAlarmServiceUrlReadConnectionTimeout;
    }

    public boolean isActiveAlarmServiceUrlHttps() {
        return this.activeAlarmServiceUrlHttps;
    }

    public void setActiveAlarmServiceUrlHttps(boolean activeAlarmServiceUrlHttps) {
        this.activeAlarmServiceUrlHttps = activeAlarmServiceUrlHttps;
    }

    public boolean isActiveAlarmServiceUrlHttpsVerificaHostName() {
        return this.activeAlarmServiceUrlHttpsVerificaHostName;
    }

    public void setActiveAlarmServiceUrlHttpsVerificaHostName(boolean activeAlarmServiceUrlHttpsVerificaHostName) {
        this.activeAlarmServiceUrlHttpsVerificaHostName = activeAlarmServiceUrlHttpsVerificaHostName;
    }

    public boolean isActiveAlarmServiceUrlHttpsAutenticazioneServer() {
        return this.activeAlarmServiceUrlHttpsAutenticazioneServer;
    }

    public void setActiveAlarmServiceUrlHttpsAutenticazioneServer(boolean activeAlarmServiceUrlHttpsAutenticazioneServer) {
        this.activeAlarmServiceUrlHttpsAutenticazioneServer = activeAlarmServiceUrlHttpsAutenticazioneServer;
    }

    public String getActiveAlarmServiceUrlHttpsTruststorePath() {
        return this.activeAlarmServiceUrlHttpsTruststorePath;
    }

    public void setActiveAlarmServiceUrlHttpsTruststorePath(String activeAlarmServiceUrlHttpsTruststorePath) {
        this.activeAlarmServiceUrlHttpsTruststorePath = activeAlarmServiceUrlHttpsTruststorePath;
    }

    public String getActiveAlarmServiceUrlHttpsTruststoreType() {
        return this.activeAlarmServiceUrlHttpsTruststoreType;
    }

    public void setActiveAlarmServiceUrlHttpsTruststoreType(String activeAlarmServiceUrlHttpsTruststoreType) {
        this.activeAlarmServiceUrlHttpsTruststoreType = activeAlarmServiceUrlHttpsTruststoreType;
    }

    public String getActiveAlarmServiceUrlHttpsTruststorePassword() {
        return this.activeAlarmServiceUrlHttpsTruststorePassword;
    }

    public void setActiveAlarmServiceUrlHttpsTruststorePassword(String activeAlarmServiceUrlHttpsTruststorePassword) {
        this.activeAlarmServiceUrlHttpsTruststorePassword = activeAlarmServiceUrlHttpsTruststorePassword;
    }

    public boolean isOptionsUpdateStateActiveAlarm() {
        return this.optionsUpdateStateActiveAlarm;
    }

    public void setOptionsUpdateStateActiveAlarm(boolean optionsUpdateState) {
        this.optionsUpdateStateActiveAlarm = optionsUpdateState;
    }

    public boolean isOptionsUpdateStatePassiveAlarm() {
        return this.optionsUpdateStatePassiveAlarm;
    }

    public void setOptionsUpdateStatePassiveAlarm(boolean optionsUpdateState) {
        this.optionsUpdateStatePassiveAlarm = optionsUpdateState;
    }

    public boolean isOptionsUpdateAckCriteriaActiveAlarm() {
        return this.optionsUpdateAckCriteriaActiveAlarm;
    }

    public void setOptionsUpdateAckCriteriaActiveAlarm(boolean optionsUpdateAckCriteria) {
        this.optionsUpdateAckCriteriaActiveAlarm = optionsUpdateAckCriteria;
    }

    public boolean isOptionsUpdateAckCriteriaPassiveAlarm() {
        return this.optionsUpdateAckCriteriaPassiveAlarm;
    }

    public void setOptionsUpdateAckCriteriaPassiveAlarm(boolean optionsUpdateAckCriteria) {
        this.optionsUpdateAckCriteriaPassiveAlarm = optionsUpdateAckCriteria;
    }

    public boolean isOptionsAcknowledgedStatusAssociation() {
        return this.optionsAcknowledgedStatusAssociation;
    }

    public void setOptionsAcknowledgedStatusAssociation(boolean optionsAcknowledgedStatusAssociation) {
        this.optionsAcknowledgedStatusAssociation = optionsAcknowledgedStatusAssociation;
    }

    public boolean isOptionsGroupByApi() {
        return this.optionsGroupByApi;
    }

    public void setOptionsGroupByApi(boolean optionsGroupByApi) {
        this.optionsGroupByApi = optionsGroupByApi;
    }

    public boolean isOptionsFilterApi() {
        return this.optionsFilterApi;
    }

    public void setOptionsFilterApi(boolean optionsFilterApi) {
        this.optionsFilterApi = optionsFilterApi;
    }

    public boolean isOptionsFilterApiOrganization() {
        return this.optionsFilterApiOrganization;
    }

    public void setOptionsFilterApiOrganization(boolean optionsFilterApiOrganization) {
        this.optionsFilterApiOrganization = optionsFilterApiOrganization;
    }

    protected static AlarmEngineConfig readAlarmEngineConfig(Logger log, AlarmConfigProperties alarmConfigProperties) throws UtilsException {
        String alarmScript;
        String mailSenderHost;
        String alarmHistoryEnabled;
        String httpLib;
        String https;
        String connectionTimeout;
        if (log != null) {
            // empty if block
        }
        AlarmEngineConfig config = new AlarmEngineConfig();
        config.setActiveAlarmServiceUrl(alarmConfigProperties.getProperty("org.openspcoop2.monitor.alarm.active.service.url", true, true));
        config.setActiveAlarmServiceUrlManagerUsername(alarmConfigProperties.getProperty("org.openspcoop2.monitor.alarm.active.service.manager.username", true, true));
        config.setActiveAlarmServiceUrlManagerPassword(alarmConfigProperties.getProperty("org.openspcoop2.monitor.alarm.active.service.manager.password", true, true));
        String readConnectionTimeout = alarmConfigProperties.getProperty("org.openspcoop2.monitor.alarm.active.service.readConnectionTimeout", false, true);
        if (StringUtils.isNotEmpty((CharSequence)readConnectionTimeout)) {
            config.setActiveAlarmServiceUrlReadConnectionTimeout(Integer.valueOf(readConnectionTimeout));
        }
        if (StringUtils.isNotEmpty((CharSequence)(connectionTimeout = alarmConfigProperties.getProperty("org.openspcoop2.monitor.alarm.active.service.connectionTimeout", false, true)))) {
            config.setActiveAlarmServiceUrlReadConnectionTimeout(Integer.valueOf(connectionTimeout));
        }
        if ((https = alarmConfigProperties.getProperty("org.openspcoop2.monitor.alarm.active.service.https", false, true)) != null) {
            config.setActiveAlarmServiceUrlHttps(Boolean.parseBoolean(https));
        }
        if (config.isActiveAlarmServiceUrlHttps()) {
            String serverAuth;
            String hostnameVerifier = alarmConfigProperties.getProperty("org.openspcoop2.monitor.alarm.active.service.https.hostnameVerifier", false, true);
            if (hostnameVerifier != null) {
                config.setActiveAlarmServiceUrlHttpsVerificaHostName(Boolean.parseBoolean(hostnameVerifier));
            }
            if ((serverAuth = alarmConfigProperties.getProperty("org.openspcoop2.monitor.alarm.active.service.https.serverAuth", false, true)) != null) {
                config.setActiveAlarmServiceUrlHttpsAutenticazioneServer(Boolean.parseBoolean(serverAuth));
            }
            if (config.isActiveAlarmServiceUrlHttpsAutenticazioneServer()) {
                config.setActiveAlarmServiceUrlHttpsTruststorePath(alarmConfigProperties.getProperty("org.openspcoop2.monitor.alarm.active.service.https.serverAuth.truststorePath", true, true));
                config.setActiveAlarmServiceUrlHttpsTruststoreType(alarmConfigProperties.getProperty("org.openspcoop2.monitor.alarm.active.service.https.serverAuth.truststoreType", true, true));
                config.setActiveAlarmServiceUrlHttpsTruststorePassword(alarmConfigProperties.getProperty("org.openspcoop2.monitor.alarm.active.service.https.serverAuth.truststorePassword", true, true));
            }
        }
        if ((httpLib = alarmConfigProperties.getProperty("org.openspcoop2.monitor.alarm.active.service.httpLibrary", false, true)) != null) {
            config.setHttpLibrary(HttpLibrary.fromName((String)httpLib));
        }
        if ((alarmHistoryEnabled = alarmConfigProperties.getProperty("org.openspcoop2.monitor.alarm.history.enabled", false, true)) != null) {
            config.setHistoryEnabled(Boolean.parseBoolean(alarmHistoryEnabled));
        }
        if ((mailSenderHost = alarmConfigProperties.getProperty("org.openspcoop2.monitor.alarm.mail.host", false, true)) != null) {
            String mailSenderSSLType;
            String mailSenderPassword;
            String mailSenderReadTimeout;
            config.setMailHost(mailSenderHost);
            String mailSenderType = alarmConfigProperties.getProperty("org.openspcoop2.monitor.alarm.mailSender.type", true, true);
            config.setMailSenderType(SenderType.valueOf((String)mailSenderType));
            String mailSenderConnectionTimeout = alarmConfigProperties.getProperty("org.openspcoop2.monitor.alarm.mailSender.connectionTimeout", false, true);
            if (mailSenderConnectionTimeout != null) {
                config.setMailSenderConnectionTimeout(Integer.parseInt(mailSenderConnectionTimeout));
            }
            if ((mailSenderReadTimeout = alarmConfigProperties.getProperty("org.openspcoop2.monitor.alarm.mailSender.readTimeout", false, true)) != null) {
                config.setMailSenderReadTimeout(Integer.parseInt(mailSenderReadTimeout));
            }
            config.setMailPort(Integer.parseInt(alarmConfigProperties.getProperty("org.openspcoop2.monitor.alarm.mail.port", true, true)));
            String mailSenderUsername = alarmConfigProperties.getProperty("org.openspcoop2.monitor.alarm.mail.username", false, true);
            if (mailSenderUsername != null) {
                config.setMailUsername(mailSenderUsername);
            }
            if ((mailSenderPassword = alarmConfigProperties.getProperty("org.openspcoop2.monitor.alarm.mail.password", false, true)) != null) {
                config.setMailPassword(mailSenderPassword);
            }
            if ((mailSenderSSLType = alarmConfigProperties.getProperty("org.openspcoop2.monitor.alarm.mail.ssl.type", false, true)) != null) {
                SSLConfig mailSSLConfig = new SSLConfig();
                mailSSLConfig.setSslType(mailSenderSSLType);
                mailSSLConfig.setHostnameVerifier(Boolean.parseBoolean(alarmConfigProperties.getProperty("org.openspcoop2.monitor.alarm.mail.ssl.hostnameVerifier", true, true)));
                boolean serverAuth = Boolean.parseBoolean(alarmConfigProperties.getProperty("org.openspcoop2.monitor.alarm.mail.ssl.serverAuth", true, true));
                if (serverAuth) {
                    mailSSLConfig.setTrustStoreLocation(alarmConfigProperties.getProperty("org.openspcoop2.monitor.alarm.mail.ssl.trustStore.location", true, true));
                    mailSSLConfig.setTrustStoreType(alarmConfigProperties.getProperty("org.openspcoop2.monitor.alarm.mail.ssl.trustStore.type", true, true));
                    mailSSLConfig.setTrustStorePassword(alarmConfigProperties.getProperty("org.openspcoop2.monitor.alarm.mail.ssl.trustStore.password", true, true));
                    mailSSLConfig.setTrustManagementAlgorithm(alarmConfigProperties.getProperty("org.openspcoop2.monitor.alarm.mail.ssl.trustStore.managementAlgorithm", true, true));
                } else {
                    mailSSLConfig.setTrustAllCerts(true);
                }
                config.setMailStartTls(Boolean.parseBoolean(alarmConfigProperties.getProperty("org.openspcoop2.monitor.alarm.mail.ssl.startTls", true, true)));
                config.setMailSSLConfig(mailSSLConfig);
            }
            config.setMailAgent(alarmConfigProperties.getProperty("org.openspcoop2.monitor.alarm.mail.agent", false, true));
            config.setMailFrom(alarmConfigProperties.getProperty("org.openspcoop2.monitor.alarm.mail.from", true, true));
            config.setMailSubject(alarmConfigProperties.getProperty("org.openspcoop2.monitor.alarm.mail.subject", true, true));
            config.setMailBody(alarmConfigProperties.getProperty("org.openspcoop2.monitor.alarm.mail.body", true, true));
            config.setMailDebug(Boolean.parseBoolean(alarmConfigProperties.getProperty("org.openspcoop2.monitor.alarm.mail.debug", true, true)));
            config.setMailCheckAcknowledgedStatus(Boolean.parseBoolean(alarmConfigProperties.getProperty("org.openspcoop2.monitor.alarm.mail.checkAcknowledgedStatus", true, true)));
            config.setMailSendChangeStatusOk(Boolean.parseBoolean(alarmConfigProperties.getProperty("org.openspcoop2.monitor.alarm.mail.sendChangeStatusOk", true, true)));
            config.setMailShowAllOptions(Boolean.parseBoolean(alarmConfigProperties.getProperty("org.openspcoop2.monitor.alarm.mail.showAllOptions", true, true)));
        }
        if ((alarmScript = alarmConfigProperties.getProperty("org.openspcoop2.monitor.alarm.script.path", false, true)) != null) {
            config.setDefaultScriptPath(alarmScript);
            config.setDefaultScriptArgs(alarmConfigProperties.getProperty("org.openspcoop2.monitor.alarm.script.args", true, true));
        }
        config.setScriptDebug(Boolean.parseBoolean(alarmConfigProperties.getProperty("org.openspcoop2.monitor.alarm.script.debug", true, true)));
        config.setScriptCheckAcknowledgedStatus(Boolean.parseBoolean(alarmConfigProperties.getProperty("org.openspcoop2.monitor.alarm.script.checkAcknowledgedStatus", true, true)));
        config.setScriptSendChangeStatusOk(Boolean.parseBoolean(alarmConfigProperties.getProperty("org.openspcoop2.monitor.alarm.script.sendChangeStatusOk", true, true)));
        config.setScriptShowAllOptions(Boolean.parseBoolean(alarmConfigProperties.getProperty("org.openspcoop2.monitor.alarm.script.showAllOptions", true, true)));
        config.setOptionsUpdateStateActiveAlarm(Boolean.parseBoolean(alarmConfigProperties.getProperty("org.openspcoop2.monitor.alarm.govwayMonitor.updateStateActiveAlarm", true, true)));
        config.setOptionsUpdateStatePassiveAlarm(Boolean.parseBoolean(alarmConfigProperties.getProperty("org.openspcoop2.monitor.alarm.govwayMonitor.updateStatePassiveAlarm", true, true)));
        config.setOptionsAcknowledgedStatusAssociation(Boolean.parseBoolean(alarmConfigProperties.getProperty("org.openspcoop2.monitor.alarm.acknowledged.statusAssociation", true, true)));
        String s = alarmConfigProperties.getProperty("org.openspcoop2.monitor.alarm.govwayMonitor.updateAckCriteriaActiveAlarm", false, true);
        if (StringUtils.isNotEmpty((CharSequence)s)) {
            config.setOptionsUpdateAckCriteriaActiveAlarm(Boolean.parseBoolean(s));
        } else {
            config.setOptionsUpdateAckCriteriaActiveAlarm(true);
        }
        s = alarmConfigProperties.getProperty("org.openspcoop2.monitor.alarm.govwayMonitor.updateAckCriteriaPassiveAlarm", false, true);
        if (StringUtils.isNotEmpty((CharSequence)s)) {
            config.setOptionsUpdateAckCriteriaPassiveAlarm(Boolean.parseBoolean(s));
        } else {
            config.setOptionsUpdateAckCriteriaPassiveAlarm(false);
        }
        config.setOptionsGroupByApi(Boolean.parseBoolean(alarmConfigProperties.getProperty("org.openspcoop2.monitor.alarm.groupBy.api", true, true)));
        config.setOptionsFilterApi(Boolean.parseBoolean(alarmConfigProperties.getProperty("org.openspcoop2.monitor.alarm.filter.api", true, true)));
        config.setOptionsFilterApiOrganization(Boolean.parseBoolean(alarmConfigProperties.getProperty("org.openspcoop2.monitor.alarm.filter.api.organization", true, true)));
        return config;
    }
}

