/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.monitor.engine.alarm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.openspcoop2.core.allarmi.Allarme;
import org.openspcoop2.core.allarmi.IdAllarme;
import org.openspcoop2.core.allarmi.constants.TipoAllarme;
import org.openspcoop2.core.allarmi.constants.TipoPeriodo;
import org.openspcoop2.core.allarmi.dao.IAllarmeServiceSearch;
import org.openspcoop2.core.allarmi.dao.IServiceManager;
import org.openspcoop2.core.allarmi.utils.AllarmiConverterUtils;
import org.openspcoop2.core.allarmi.utils.ProjectInfo;
import org.openspcoop2.core.commons.dao.DAOFactory;
import org.openspcoop2.generic_project.beans.IProjectInfo;
import org.openspcoop2.generic_project.exception.ExpressionException;
import org.openspcoop2.generic_project.exception.ExpressionNotImplementedException;
import org.openspcoop2.generic_project.exception.MultipleResultException;
import org.openspcoop2.generic_project.exception.NotFoundException;
import org.openspcoop2.generic_project.exception.NotImplementedException;
import org.openspcoop2.generic_project.exception.ServiceException;
import org.openspcoop2.generic_project.expression.IExpression;
import org.openspcoop2.generic_project.expression.IPaginatedExpression;
import org.openspcoop2.monitor.engine.alarm.AlarmEngineConfig;
import org.openspcoop2.monitor.engine.alarm.AlarmImpl;
import org.openspcoop2.monitor.engine.alarm.AlarmManager;
import org.openspcoop2.monitor.engine.alarm.AlarmThread;
import org.openspcoop2.monitor.sdk.alarm.IAlarm;
import org.openspcoop2.monitor.sdk.constants.AlarmStateValues;
import org.openspcoop2.monitor.sdk.exceptions.AlarmException;
import org.openspcoop2.utils.Utilities;
import org.slf4j.Logger;

public class AlarmLibrary {
    private IAllarmeServiceSearch allarmeSearchDAO;
    private Logger log;
    private AlarmEngineConfig alarmEngineConfig;
    private DAOFactory daoFactory;
    private Map<String, AlarmThread> activeThreads = null;
    private boolean stop = false;
    private boolean stopLibrary = false;

    private String getMessageAlarmNotExists(String name) {
        return "Alarm [" + name + "] not exists";
    }

    public AlarmLibrary(DAOFactory daoFactory, Logger log, AlarmEngineConfig alarmEngineConfig) throws AlarmException {
        try {
            this.daoFactory = daoFactory;
            IServiceManager pluginSM = (IServiceManager)this.daoFactory.getServiceManager((IProjectInfo)ProjectInfo.getInstance());
            this.allarmeSearchDAO = pluginSM.getAllarmeServiceSearch();
            this.log = log;
            this.alarmEngineConfig = alarmEngineConfig;
            AlarmManager.setAlarmEngineConfig(alarmEngineConfig);
        }
        catch (Exception e) {
            throw new AlarmException(e.getMessage(), (Throwable)e);
        }
    }

    public void sleep() {
        for (int i = 0; i < 60; ++i) {
            Utilities.sleep((long)1000L);
            if (this.stop) break;
        }
    }

    public void stop() {
        if (this.activeThreads != null && this.activeThreads.size() > 0) {
            for (AlarmThread alarmThread : this.activeThreads.values()) {
                this.stopAlarm(alarmThread);
            }
        }
        this.stop = true;
        this.activeThreads = null;
    }

    public void stopAlarm(String name, boolean throwExceptionNotFound) throws AlarmException {
        if (this.activeThreads != null && this.activeThreads.size() > 0 && this.activeThreads.containsKey(name)) {
            AlarmThread alarmThread = this.activeThreads.get(name);
            this.stopAlarm(alarmThread);
            this.activeThreads.remove(name);
        } else if (throwExceptionNotFound) {
            throw new AlarmException(this.getMessageAlarmNotExists(name));
        }
    }

    private void stopAlarm(AlarmThread alarmThread) {
        alarmThread.setStop(true);
        int max = 3000;
        int increment = 100;
        for (int offset = 0; offset < max && !alarmThread.isTerminated(); offset += increment) {
            Utilities.sleep((long)increment);
        }
    }

    public void setStopLibrary(boolean stopLibrary) {
        this.stopLibrary = stopLibrary;
    }

    public void executeAlarms(boolean exitAfterExecution) throws AlarmException {
        try {
            this.activeThreads = this.getActiveAlarmThreads(this.allarmeSearchDAO, this.log);
            if (this.activeThreads.size() > 0) {
                for (AlarmThread alarmThread : this.activeThreads.values()) {
                    Thread t = new Thread(alarmThread);
                    t.start();
                }
                if (!exitAfterExecution) {
                    while (!this.stopLibrary) {
                        this.sleep();
                    }
                }
            } else {
                this.log.warn("Non sono stati trovati allarmi");
            }
        }
        catch (Exception e) {
            throw new AlarmException(e.getMessage(), (Throwable)e);
        }
    }

    private Allarme getAlarmConf(String name) throws AlarmException {
        Allarme conf = null;
        try {
            conf = this.getActiveAlarmThread(this.allarmeSearchDAO, name);
        }
        catch (Exception e) {
            throw new AlarmException(e.getMessage(), (Throwable)e);
        }
        if (conf == null) {
            throw new AlarmException(this.getMessageAlarmNotExists(name));
        }
        return conf;
    }

    public void executeAlarm(String name) throws AlarmException {
        try {
            AlarmThread alarmThread;
            Allarme conf = this.getAlarmConf(name);
            if (conf.getEnabled() == 1 && TipoAllarme.ATTIVO.equals((Object)conf.getTipoAllarme()) && (alarmThread = this.createAlarmThread(conf)) != null) {
                if (this.activeThreads == null) {
                    this.activeThreads = new ConcurrentHashMap<String, AlarmThread>();
                }
                this.activeThreads.put(conf.getNome(), alarmThread);
                Thread t = new Thread(alarmThread);
                t.start();
            }
        }
        catch (Exception e) {
            throw new AlarmException(e.getMessage(), (Throwable)e);
        }
    }

    public void forceNewCheckAlarm(String name) throws AlarmException {
        try {
            this.getAlarmConf(name);
            AlarmThread alarmThread = this.activeThreads.get(name);
            alarmThread.forceNewCheck();
        }
        catch (Exception e) {
            throw new AlarmException(e.getMessage(), (Throwable)e);
        }
    }

    public void updateStateAlarm(String name, AlarmStateValues alarmStatus) throws AlarmException {
        try {
            this.getAlarmConf(name);
            AlarmThread alarmThread = this.activeThreads.get(name);
            alarmThread.updateState(alarmStatus);
        }
        catch (Exception e) {
            throw new AlarmException(e.getMessage(), (Throwable)e);
        }
    }

    public void updateAcknoledgement(String name, boolean acknoledgement) throws AlarmException {
        try {
            this.getAlarmConf(name);
            AlarmThread alarmThread = this.activeThreads.get(name);
            alarmThread.updateAcknowledged(acknoledgement);
        }
        catch (Exception e) {
            throw new AlarmException(e.getMessage(), (Throwable)e);
        }
    }

    public String getAlarmImage(String name) throws AlarmException {
        if (this.activeThreads != null && this.activeThreads.size() > 0 && this.activeThreads.containsKey(name)) {
            AlarmThread alarmThread = this.activeThreads.get(name);
            return alarmThread.getStatoAllarme();
        }
        throw new AlarmException(this.getMessageAlarmNotExists(name));
    }

    public String getAlarmsImages() {
        if (this.activeThreads != null && this.activeThreads.size() > 0) {
            ArrayList<String> list = new ArrayList<String>();
            for (String idAllarme : this.activeThreads.keySet()) {
                list.add(idAllarme);
            }
            Collections.sort(list);
            StringBuilder sb = new StringBuilder();
            for (String idAllarme : list) {
                if (sb.length() > 0) {
                    sb.append("\n");
                }
                sb.append(idAllarme);
            }
            return sb.toString();
        }
        return "";
    }

    public boolean existsAlarm(String name) {
        return this.activeThreads != null && this.activeThreads.size() > 0 && this.activeThreads.containsKey(name);
    }

    private Map<String, AlarmThread> getActiveAlarmThreads(IAllarmeServiceSearch allarmeSearchDAO, Logger log) throws ServiceException, NotImplementedException, ExpressionNotImplementedException, ExpressionException {
        IExpression expr = allarmeSearchDAO.newExpression();
        expr.and();
        expr.notEquals(Allarme.model().ENABLED, (Object)0);
        expr.notEquals(Allarme.model().TIPO_ALLARME, (Object)TipoAllarme.PASSIVO);
        IPaginatedExpression pagExpr = allarmeSearchDAO.toPaginatedExpression(expr);
        List list = allarmeSearchDAO.findAll(pagExpr);
        ConcurrentHashMap<String, AlarmThread> listAlarmThread = new ConcurrentHashMap<String, AlarmThread>();
        for (Allarme confAllarme : list) {
            try {
                AlarmThread alarmThread = this.createAlarmThread(confAllarme);
                if (alarmThread == null) continue;
                listAlarmThread.put(confAllarme.getNome(), alarmThread);
            }
            catch (Exception t) {
                log.error("Creazione allarme con id '" + confAllarme.getNome() + "' (alias: " + confAllarme.getAlias() + ") non riuscita: " + t.getMessage(), (Throwable)t);
            }
        }
        return listAlarmThread;
    }

    private Allarme getActiveAlarmThread(IAllarmeServiceSearch allarmeSearchDAO, String name) throws ServiceException, NotFoundException, MultipleResultException, NotImplementedException {
        IdAllarme id = new IdAllarme();
        id.setNome(name);
        return (Allarme)allarmeSearchDAO.get((Object)id);
    }

    private AlarmThread createAlarmThread(Allarme confAllarme) throws AlarmException {
        IAlarm alarm = AlarmManager.getAlarm(confAllarme, this.log, this.daoFactory);
        String classname = ((AlarmImpl)alarm).getPluginClassName();
        TipoPeriodo tipoPeriodo = AllarmiConverterUtils.toTipoPeriodo((String)confAllarme.getTipoPeriodo());
        int periodo = confAllarme.getPeriodo();
        AlarmThread alarmThread = null;
        try {
            alarmThread = new AlarmThread(this.log, confAllarme.getTipo(), classname, alarm, this.alarmEngineConfig);
            if (periodo != 0) {
                switch (tipoPeriodo) {
                    case G: {
                        alarmThread.setPeriodByDays(periodo);
                        break;
                    }
                    case H: {
                        alarmThread.setPeriodByHours(periodo);
                        break;
                    }
                    case M: {
                        alarmThread.setPeriodByMinutes(periodo);
                        break;
                    }
                    default: {
                        alarmThread.setPeriodBySeconds(periodo);
                    }
                }
            }
        }
        catch (AlarmException e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return alarmThread;
    }
}

