/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.monitor.engine.alarm.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.core.allarmi.Allarme;
import org.openspcoop2.core.allarmi.AllarmeFiltro;
import org.openspcoop2.core.allarmi.constants.StatoAllarme;
import org.openspcoop2.core.allarmi.constants.TipoAllarme;
import org.openspcoop2.core.allarmi.utils.AllarmiConverterUtils;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.plugins.constants.TipoPlugin;
import org.openspcoop2.monitor.engine.alarm.AlarmEngineConfig;
import org.openspcoop2.monitor.engine.alarm.wrapper.ConfigurazioneAllarmeBean;
import org.openspcoop2.monitor.engine.dynamic.DynamicFactory;
import org.openspcoop2.monitor.engine.dynamic.IDynamicLoader;
import org.openspcoop2.monitor.sdk.condition.Context;
import org.openspcoop2.monitor.sdk.plugins.IAlarmProcessing;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.engine.utils.NamingUtils;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.utils.beans.BeanUtils;
import org.openspcoop2.utils.transport.http.HttpRequest;
import org.openspcoop2.utils.transport.http.HttpRequestMethod;
import org.openspcoop2.utils.transport.http.HttpResponse;
import org.openspcoop2.utils.transport.http.HttpUtilities;
import org.slf4j.Logger;

public class AllarmiUtils {
    public static boolean controllaTipiIndicatiNelFiltro(AllarmeFiltro filtro, String valoreQualsiasi) throws Exception {
        IProtocolFactory protocolFactory;
        String tipoMittente = filtro.getTipoFruitore();
        String tipoDestinatario = filtro.getTipoErogatore();
        String tipoServizio = filtro.getTipoServizio();
        ArrayList<String> protocolloMittente = new ArrayList<String>();
        ArrayList<String> protocolloDestinatario = new ArrayList<String>();
        ArrayList<String> protocolloServizio = new ArrayList<String>();
        if (!tipoDestinatario.equals(valoreQualsiasi)) {
            protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByOrganizationType(tipoDestinatario);
            protocolloDestinatario.add(protocolFactory.getProtocol());
        }
        if (!tipoMittente.equals(valoreQualsiasi)) {
            protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByOrganizationType(tipoMittente);
            protocolloMittente.add(protocolFactory.getProtocol());
        }
        if (!tipoServizio.equals(valoreQualsiasi)) {
            protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByServiceType(tipoServizio);
            protocolloServizio.add(protocolFactory.getProtocol());
        }
        HashMap<String, String> mappaProtocolli = new HashMap<String, String>();
        if (protocolloServizio != null && protocolloServizio.size() > 0) {
            for (String tipo : protocolloServizio) {
                if (mappaProtocolli.containsKey(tipo)) continue;
                mappaProtocolli.put(tipo, tipo);
            }
        }
        if (protocolloMittente != null && protocolloMittente.size() > 0) {
            for (String tipo : protocolloMittente) {
                if (mappaProtocolli.containsKey(tipo)) continue;
                mappaProtocolli.put(tipo, tipo);
            }
        }
        if (protocolloDestinatario != null && protocolloDestinatario.size() > 0) {
            for (String tipo : protocolloDestinatario) {
                if (mappaProtocolli.containsKey(tipo)) continue;
                mappaProtocolli.put(tipo, tipo);
            }
        }
        if (protocolloDestinatario.size() > 0 && protocolloDestinatario.size() != mappaProtocolli.keySet().size()) {
            return false;
        }
        if (protocolloMittente.size() > 0 && protocolloMittente.size() != mappaProtocolli.keySet().size()) {
            return false;
        }
        return protocolloServizio.size() <= 0 || protocolloServizio.size() == mappaProtocolli.keySet().size();
    }

    private static HttpRequest buildHttpRequest(AlarmEngineConfig allarmiConfig, String url, HttpRequestMethod method, byte[] content, String contentType) {
        HttpRequest request = new HttpRequest();
        request.setUrl(url);
        request.setContent(content);
        request.setMethod(method);
        request.setContentType(contentType);
        request.setUsername(allarmiConfig.getActiveAlarmServiceUrlManagerUsername());
        request.setPassword(allarmiConfig.getActiveAlarmServiceUrlManagerPassword());
        request.setHttpLibrary(allarmiConfig.getHttpLibrary());
        request.setConnectTimeout(allarmiConfig.getActiveAlarmServiceUrlConnectionTimeout().intValue());
        request.setReadTimeout(allarmiConfig.getActiveAlarmServiceUrlReadConnectionTimeout().intValue());
        if (allarmiConfig.isActiveAlarmServiceUrlHttps()) {
            request.setHostnameVerifier(allarmiConfig.isActiveAlarmServiceUrlHttpsVerificaHostName());
            if (allarmiConfig.isActiveAlarmServiceUrlHttpsAutenticazioneServer()) {
                request.setTrustStorePath(allarmiConfig.getActiveAlarmServiceUrlHttpsTruststorePath());
                request.setTrustStoreType(allarmiConfig.getActiveAlarmServiceUrlHttpsTruststoreType());
                request.setTrustStorePassword(allarmiConfig.getActiveAlarmServiceUrlHttpsTruststorePassword());
            } else {
                request.setTrustAllCerts(true);
            }
        }
        return request;
    }

    public static void sendToAllarmi(AlarmEngineConfig allarmiConfig, List<String> post_urls, List<String> post_contents, Logger log) throws Exception {
        if (post_urls != null && post_urls.size() > 0) {
            for (int i = 0; i < post_urls.size(); ++i) {
                String url = post_urls.get(i);
                String content = post_contents.get(i);
                log.debug("Invoke [" + url + "] ...");
                HttpRequest request = AllarmiUtils.buildHttpRequest(allarmiConfig, url, HttpRequestMethod.POST, content.getBytes(), "application/json");
                HttpResponse response = HttpUtilities.httpInvoke((HttpRequest)request);
                if (response.getContent() != null) {
                    log.debug("Invoked [" + url + "] Status[" + response.getResultHTTPOperation() + "] Message[" + new String(response.getContent()) + "]");
                } else {
                    log.debug("Invoked [" + url + "] Status[" + response.getResultHTTPOperation() + "]");
                }
                if (response.getResultHTTPOperation() <= 202) continue;
                throw new Exception("Error occurs during invoke url[" + url + "] Status[" + response.getResultHTTPOperation() + "] Message[" + new String(response.getContent()) + "]");
            }
        }
    }

    public static String sendToAllarme(AlarmEngineConfig allarmiConfig, String get_url, Logger log) throws Exception {
        log.debug("Invoke [" + get_url + "] ...");
        HttpRequest request = AllarmiUtils.buildHttpRequest(allarmiConfig, get_url, HttpRequestMethod.GET, null, null);
        HttpResponse response = HttpUtilities.httpInvoke((HttpRequest)request);
        String responseS = null;
        if (response.getContent() != null) {
            responseS = new String(response.getContent());
            log.debug("Invoked [" + get_url + "] Status[" + response.getResultHTTPOperation() + "] Payload[" + responseS + "]");
        } else {
            log.debug("Invoked [" + get_url + "] Status[" + response.getResultHTTPOperation() + "]");
            responseS = "";
        }
        if (response.getResultHTTPOperation() > 202) {
            throw new Exception("Error occurs during invoke url[" + get_url + "] Status[" + response.getResultHTTPOperation() + "] Payload[" + responseS + "]");
        }
        return responseS;
    }

    public static void notifyStateActiveThread(boolean isAdd, boolean modificatoStato, boolean modificatoAckwoldegment, ConfigurazioneAllarmeBean oldAllarmePrimaModifica, ConfigurazioneAllarmeBean allarme, Logger log, AlarmEngineConfig allarmiConfig) throws Exception {
        if (TipoAllarme.PASSIVO.equals((Object)allarme.getTipoAllarme())) {
            log.debug("Allarme [" + allarme.getNome() + "] \u00e8 passivo. Non viene attivato alcun thread");
            return;
        }
        Object prefixUrl = allarmiConfig.getActiveAlarmServiceUrl();
        if (!((String)prefixUrl).endsWith("/")) {
            prefixUrl = (String)prefixUrl + "/";
        }
        prefixUrl = (String)prefixUrl + "gestione/attivi/" + allarme.getNome();
        ArrayList<String> post_urls = new ArrayList<String>();
        ArrayList<String> post_contents = new ArrayList<String>();
        if (isAdd) {
            if (allarme.getEnabled() == 1) {
                post_urls.add((String)prefixUrl);
                post_contents.add("{\"operazione\": \"start\"}");
            }
        } else {
            boolean equals = false;
            StringBuilder bfDiff = null;
            if (oldAllarmePrimaModifica != null) {
                ArrayList<String> fieldEsclusi = new ArrayList<String>();
                fieldEsclusi.add("id");
                if (modificatoStato) {
                    fieldEsclusi.add("stato");
                    fieldEsclusi.add("_value_stato");
                    fieldEsclusi.add("precedenteStato");
                    fieldEsclusi.add("_value_precedenteStato");
                    fieldEsclusi.add("dettaglioStato");
                }
                if (modificatoAckwoldegment) {
                    fieldEsclusi.add("acknowledged");
                }
                Allarme old = new Allarme();
                BeanUtils.copy((Object)old, (Object)((Object)oldAllarmePrimaModifica), null);
                Allarme attuale = new Allarme();
                BeanUtils.copy((Object)attuale, (Object)((Object)allarme), null);
                equals = attuale.equals((Object)old, fieldEsclusi);
                if (!equals) {
                    bfDiff = new StringBuilder();
                    attuale.diff((Object)old, bfDiff, false, fieldEsclusi);
                }
            }
            if (equals) {
                if (modificatoStato) {
                    StatoAllarme statoAllarme = AllarmiConverterUtils.toStatoAllarme((Integer)allarme.getStato());
                    post_urls.add((String)prefixUrl + "/stato");
                    switch (statoAllarme) {
                        case OK: {
                            post_contents.add("{\"stato\": \"OK\"}");
                            break;
                        }
                        case WARNING: {
                            post_contents.add("{\"stato\": \"WARNING\"}");
                            break;
                        }
                        case ERROR: {
                            post_contents.add("{\"stato\": \"ERROR\"}");
                        }
                    }
                }
                if (modificatoAckwoldegment) {
                    post_urls.add((String)prefixUrl + "/acknoledgement");
                    if (allarme.getAcknowledged() == 1) {
                        post_contents.add("{\"acknoledgement\": true}");
                    } else {
                        post_contents.add("{\"acknoledgement\": false}");
                    }
                }
            } else {
                if (bfDiff != null) {
                    log.debug("Rilevata modifica, diff: " + bfDiff.toString());
                }
                if (allarme.getEnabled() == 0) {
                    post_urls.add((String)prefixUrl);
                    post_contents.add("{\"operazione\": \"stop\"}");
                } else {
                    post_urls.add((String)prefixUrl);
                    post_contents.add("{\"operazione\": \"restart\"}");
                }
            }
        }
        AllarmiUtils.sendToAllarmi(allarmiConfig, post_urls, post_contents, log);
    }

    public static void stopActiveThreads(List<String> allarmi, Logger log, AlarmEngineConfig allarmiConfig) throws Exception {
        ArrayList<String> post_urls = new ArrayList<String>();
        ArrayList<String> post_contents = new ArrayList<String>();
        if (!allarmi.isEmpty()) {
            for (String nomeAllarme : allarmi) {
                Object prefixUrl = allarmiConfig.getActiveAlarmServiceUrl();
                if (!((String)prefixUrl).endsWith("/")) {
                    prefixUrl = (String)prefixUrl + "/";
                }
                prefixUrl = (String)prefixUrl + "gestione/attivi/" + nomeAllarme;
                post_urls.add((String)prefixUrl);
                post_contents.add("{\"operazione\": \"stop\"}");
            }
        }
        if (!post_urls.isEmpty()) {
            AllarmiUtils.sendToAllarmi(allarmiConfig, post_urls, post_contents, log);
        }
    }

    public static void startActiveThread(ConfigurazioneAllarmeBean allarme, Logger log, AlarmEngineConfig allarmiConfig) throws Exception {
        AllarmiUtils._manageActiveThreads(allarme, log, allarmiConfig, "start");
    }

    public static void restartActiveThread(ConfigurazioneAllarmeBean allarme, Logger log, AlarmEngineConfig allarmiConfig) throws Exception {
        AllarmiUtils._manageActiveThreads(allarme, log, allarmiConfig, "restart");
    }

    public static void stopActiveThread(ConfigurazioneAllarmeBean allarme, Logger log, AlarmEngineConfig allarmiConfig) throws Exception {
        AllarmiUtils._manageActiveThreads(allarme, log, allarmiConfig, "stop");
    }

    public static void _manageActiveThreads(ConfigurazioneAllarmeBean allarme, Logger log, AlarmEngineConfig allarmiConfig, String operazione) throws Exception {
        ArrayList<String> post_urls = new ArrayList<String>();
        ArrayList<String> post_contents = new ArrayList<String>();
        Object prefixUrl = allarmiConfig.getActiveAlarmServiceUrl();
        if (!((String)prefixUrl).endsWith("/")) {
            prefixUrl = (String)prefixUrl + "/";
        }
        prefixUrl = (String)prefixUrl + "gestione/attivi/" + allarme.getNome();
        post_urls.add((String)prefixUrl);
        post_contents.add("{\"operazione\": \"" + operazione + "\"}");
        AllarmiUtils.sendToAllarmi(allarmiConfig, post_urls, post_contents, log);
    }

    public static boolean existsActiveThread(ConfigurazioneAllarmeBean allarme, Logger log, AlarmEngineConfig allarmiConfig) throws Exception {
        if (TipoAllarme.PASSIVO.equals((Object)allarme.getTipoAllarme())) {
            log.debug("Allarme [" + allarme.getNome() + "] \u00e8 passivo. Non contiene una immagine");
            return false;
        }
        Object prefixUrl = allarmiConfig.getActiveAlarmServiceUrl();
        if (!((String)prefixUrl).endsWith("/")) {
            prefixUrl = (String)prefixUrl + "/";
        }
        prefixUrl = (String)prefixUrl + "gestione/attivi/" + allarme.getNome() + "/image";
        log.debug("Invoke [" + (String)prefixUrl + "] ...");
        HttpRequest request = AllarmiUtils.buildHttpRequest(allarmiConfig, (String)prefixUrl, HttpRequestMethod.GET, null, null);
        HttpResponse response = HttpUtilities.httpInvoke((HttpRequest)request);
        return response.getResultHTTPOperation() == 200;
    }

    public static String getActiveThreadImage(ConfigurazioneAllarmeBean allarme, Logger log, AlarmEngineConfig allarmiConfig) throws Exception {
        if (TipoAllarme.PASSIVO.equals((Object)allarme.getTipoAllarme())) {
            log.debug("Allarme [" + allarme.getNome() + "] \u00e8 passivo. Non contiene una immagine");
            return "L'allarme \u00e8 passivo";
        }
        Object prefixUrl = allarmiConfig.getActiveAlarmServiceUrl();
        if (!((String)prefixUrl).endsWith("/")) {
            prefixUrl = (String)prefixUrl + "/";
        }
        prefixUrl = (String)prefixUrl + "gestione/attivi/" + allarme.getNome() + "/image";
        return AllarmiUtils.sendToAllarme(allarmiConfig, ((String)prefixUrl).toString(), log);
    }

    public static void refreshActiveThreadState(ConfigurazioneAllarmeBean allarme, Logger log, AlarmEngineConfig allarmiConfig) throws Exception {
        if (TipoAllarme.PASSIVO.equals((Object)allarme.getTipoAllarme())) {
            log.debug("Allarme [" + allarme.getNome() + "] \u00e8 passivo. Non contiene una immagine");
            return;
        }
        Object prefixUrl = allarmiConfig.getActiveAlarmServiceUrl();
        if (!((String)prefixUrl).endsWith("/")) {
            prefixUrl = (String)prefixUrl + "/";
        }
        prefixUrl = (String)prefixUrl + "gestione/attivi/" + allarme.getNome() + "/refresh";
        AllarmiUtils.sendToAllarme(allarmiConfig, ((String)prefixUrl).toString(), log);
    }

    public static String getActiveThreadImages(Logger log, AlarmEngineConfig allarmiConfig) throws Exception {
        Object prefixUrl = allarmiConfig.getActiveAlarmServiceUrl();
        if (!((String)prefixUrl).endsWith("/")) {
            prefixUrl = (String)prefixUrl + "/";
        }
        prefixUrl = (String)prefixUrl + "gestione/attivi/image";
        return AllarmiUtils.sendToAllarme(allarmiConfig, ((String)prefixUrl).toString(), log);
    }

    public static void startActiveThreads(Logger log, AlarmEngineConfig allarmiConfig) throws Exception {
        AllarmiUtils._manageActiveThreads(log, allarmiConfig, "start");
    }

    public static void restartActiveThreads(Logger log, AlarmEngineConfig allarmiConfig) throws Exception {
        AllarmiUtils._manageActiveThreads(log, allarmiConfig, "restart");
    }

    public static void stopActiveThreads(Logger log, AlarmEngineConfig allarmiConfig) throws Exception {
        AllarmiUtils._manageActiveThreads(log, allarmiConfig, "stop");
    }

    public static void _manageActiveThreads(Logger log, AlarmEngineConfig allarmiConfig, String operazione) throws Exception {
        ArrayList<String> post_urls = new ArrayList<String>();
        ArrayList<String> post_contents = new ArrayList<String>();
        Object prefixUrl = allarmiConfig.getActiveAlarmServiceUrl();
        if (!((String)prefixUrl).endsWith("/")) {
            prefixUrl = (String)prefixUrl + "/";
        }
        prefixUrl = (String)prefixUrl + "gestione/attivi";
        post_urls.add((String)prefixUrl);
        post_contents.add("{\"operazione\": \"" + operazione + "\"}");
        AllarmiUtils.sendToAllarmi(allarmiConfig, post_urls, post_contents, log);
    }

    public static String getTipoNomeMittente(AllarmeFiltro configurazioneFiltro) {
        if (configurazioneFiltro != null && StringUtils.isNotEmpty((CharSequence)configurazioneFiltro.getNomeFruitore()) && !"*".equals(configurazioneFiltro.getNomeFruitore())) {
            String res = configurazioneFiltro.getTipoFruitore() + "/" + configurazioneFiltro.getNomeFruitore();
            return res;
        }
        return null;
    }

    public static String getTipoNomeDestinatario(AllarmeFiltro configurazioneFiltro) {
        if (configurazioneFiltro != null && StringUtils.isNotEmpty((CharSequence)configurazioneFiltro.getNomeErogatore()) && !"*".equals(configurazioneFiltro.getNomeErogatore())) {
            String res = configurazioneFiltro.getTipoErogatore() + "/" + configurazioneFiltro.getNomeErogatore();
            return res;
        }
        return null;
    }

    public static String getTipoNomeServizio(AllarmeFiltro configurazioneFiltro, Logger log, boolean controlloAllarmiFiltroApiSoggettoErogatore) {
        if (configurazioneFiltro != null && StringUtils.isNotEmpty((CharSequence)configurazioneFiltro.getNomeServizio()) && !"*".equals(configurazioneFiltro.getNomeServizio())) {
            IDServizio idServizio = new IDServizio();
            idServizio.setNome(configurazioneFiltro.getNomeServizio());
            idServizio.setTipo(configurazioneFiltro.getTipoServizio());
            idServizio.setVersione(configurazioneFiltro.getVersioneServizio());
            try {
                String res;
                if (controlloAllarmiFiltroApiSoggettoErogatore) {
                    IDSoggetto erogatore = new IDSoggetto(configurazioneFiltro.getTipoErogatore(), configurazioneFiltro.getNomeErogatore());
                    idServizio.setSoggettoErogatore(erogatore);
                    res = NamingUtils.getLabelAccordoServizioParteSpecifica((IDServizio)idServizio);
                } else {
                    res = NamingUtils.getLabelAccordoServizioParteSpecificaSenzaErogatore((IDServizio)idServizio);
                }
                return res;
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    public static String getAzione(AllarmeFiltro configurazioneFiltro) {
        if (configurazioneFiltro != null && StringUtils.isNotEmpty((CharSequence)configurazioneFiltro.getAzione()) && !"*".equals(configurazioneFiltro.getAzione())) {
            String res = configurazioneFiltro.getAzione();
            return res;
        }
        return null;
    }

    private static String normalizeLabelPlugin(ConfigurazioneAllarmeBean allarme) {
        String nome = allarme.getPlugin().getLabel();
        StringBuilder bf = new StringBuilder();
        String[] tmp = nome.split(" ");
        for (int i = 0; i < tmp.length; ++i) {
            String t = tmp[i].trim();
            if (t == null || t.length() < 1) continue;
            if (Character.isDigit(t.charAt(0))) {
                bf.append(t);
                continue;
            }
            bf.append(("" + t.charAt(0)).toUpperCase());
            if (t.length() <= 1) continue;
            bf.append(t.substring(1, t.length()));
        }
        return bf.toString();
    }

    public static String costruisciAliasAllarme(ConfigurazioneAllarmeBean allarme, Logger log, Context context) {
        StringBuilder bf = new StringBuilder();
        bf.append(AllarmiUtils.normalizeLabelPlugin(allarme));
        String nome = bf.toString();
        String p = "";
        String s = "";
        try {
            if (allarme != null && allarme.getPlugin() != null && allarme.getPlugin().getClassName() != null) {
                IDynamicLoader dl = DynamicFactory.getInstance().newDynamicLoader(TipoPlugin.ALLARME, allarme.getTipo(), allarme.getPlugin().getClassName(), log);
                IAlarmProcessing alarm = (IAlarmProcessing)dl.newInstance();
                p = alarm.getAutomaticPrefixName(context);
                s = alarm.getAutomaticSuffixName(context);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        if (p == null) {
            p = "";
        }
        if (s == null) {
            s = "";
        }
        return p + nome + s;
    }

    public static String getLabelStato(StatoAllarme stato) {
        if (stato != null) {
            switch (stato) {
                case OK: {
                    return "Ok";
                }
                case WARNING: {
                    return "Warning";
                }
                case ERROR: {
                    return "Error";
                }
            }
        }
        return null;
    }
}

