/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.monitor.engine.dynamic;

import org.openspcoop2.monitor.engine.dynamic.DynamicFactory;
import org.openspcoop2.monitor.engine.dynamic.IDynamicFilter;
import org.openspcoop2.monitor.engine.dynamic.IDynamicLoader;
import org.openspcoop2.monitor.sdk.condition.Context;
import org.openspcoop2.monitor.sdk.condition.IFilter;
import org.openspcoop2.monitor.sdk.condition.StatisticsContext;
import org.openspcoop2.monitor.sdk.exceptions.SearchException;
import org.openspcoop2.monitor.sdk.plugins.ISearchArguments;
import org.openspcoop2.monitor.sdk.plugins.ISearchProcessing;
import org.openspcoop2.monitor.sdk.plugins.IStatisticProcessing;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.slf4j.Logger;

public class BasicFilter
implements IDynamicFilter {
    private static Logger log = LoggerWrapperFactory.getLogger(BasicFilter.class);
    private String tipoPlugin;
    private String tipo;
    private String className;

    protected BasicFilter(String tipoPlugin, String tipo, String className) {
        this.tipoPlugin = tipoPlugin;
        this.tipo = tipo;
        this.className = className;
    }

    @Override
    public IFilter createConditionFilter(Context context) throws SearchException {
        try {
            IDynamicLoader bl = DynamicFactory.getInstance().newDynamicLoader(this.tipoPlugin, this.tipo, this.className, log);
            Object obj = bl.newInstance();
            if (obj instanceof ISearchProcessing) {
                return ((ISearchProcessing)obj).createSearchFilter(context);
            }
            if (obj instanceof IStatisticProcessing && context instanceof StatisticsContext) {
                return ((IStatisticProcessing)obj).createSearchFilter((StatisticsContext)context);
            }
            String iface = ISearchArguments.class.getName();
            throw new Exception("La classe [" + this.className + "] non implementa l'interfaccia [" + iface + "]");
        }
        catch (ClassNotFoundException cnfe) {
            throw new SearchException("Impossibile caricare il plugin. La classe indicata [" + this.className + "] non esiste.");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new SearchException("Si e' verificato un errore: " + e.getMessage());
        }
    }
}

