/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.monitor.engine.dynamic;

import java.util.List;
import org.openspcoop2.monitor.engine.dynamic.IDynamicLoader;
import org.openspcoop2.monitor.sdk.condition.Context;
import org.openspcoop2.monitor.sdk.constants.StatisticType;
import org.openspcoop2.monitor.sdk.exceptions.SearchException;
import org.openspcoop2.monitor.sdk.parameters.Parameter;
import org.openspcoop2.monitor.sdk.plugins.ISearchArguments;
import org.openspcoop2.monitor.sdk.plugins.ISearchProcessing;
import org.openspcoop2.monitor.sdk.plugins.IStatisticProcessing;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.Utilities;
import org.slf4j.Logger;

public class BasicLoader
implements IDynamicLoader {
    private String tipoPlugin;
    private String tipo;
    private String className;
    private Class<?> c;
    private Logger log;

    protected BasicLoader(String tipoPlugin, String tipo, String className, Class<?> c, Logger log) {
        this.tipoPlugin = tipoPlugin;
        this.tipo = tipo;
        this.className = className;
        this.c = c;
        this.log = log == null ? LoggerWrapperFactory.getLogger(BasicLoader.class) : log;
    }

    @Override
    public String getTipoPlugin() {
        return this.tipoPlugin;
    }

    @Override
    public String getTipo() {
        return this.tipo;
    }

    @Override
    public String getClassName() throws SearchException {
        if (this.c != null) {
            return this.c.getName();
        }
        throw new SearchException("Class undefined");
    }

    @Override
    public String getClassSimpleName() throws SearchException {
        if (this.c != null) {
            return this.c.getSimpleName();
        }
        throw new SearchException("Class undefined");
    }

    @Override
    public Object newInstance() throws SearchException {
        try {
            return Utilities.newInstance(this.c);
        }
        catch (Exception e) {
            throw new SearchException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public List<Parameter<?>> getParameters(Context context) throws SearchException {
        try {
            Object obj = Utilities.newInstance(this.c);
            if (obj instanceof ISearchProcessing) {
                return ((ISearchProcessing)obj).getParameters(context);
            }
            if (obj instanceof IStatisticProcessing) {
                return ((IStatisticProcessing)obj).getParameters(context);
            }
            if (obj instanceof ISearchArguments) {
                return ((ISearchArguments)obj).getParameters(context);
            }
            String iface = ISearchArguments.class.getName();
            throw new SearchException("La classe [" + this.className + "] non implementa l'interfaccia [" + iface + "]");
        }
        catch (SearchException re) {
            throw re;
        }
        catch (Exception e) {
            this.log.error("Impossibile ottenere informazioni per il rendereng dal Loader: " + e.getMessage(), (Throwable)e);
            throw new SearchException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void updateRendering(Parameter<?> parameter, Context context) throws SearchException {
        block6: {
            try {
                Object obj = Utilities.newInstance(this.c);
                if (obj instanceof ISearchProcessing) {
                    ((ISearchProcessing)obj).updateRendering(parameter, context);
                    break block6;
                }
                if (obj instanceof IStatisticProcessing) {
                    ((IStatisticProcessing)obj).updateRendering(parameter, context);
                    break block6;
                }
                if (obj instanceof ISearchArguments) {
                    ((ISearchArguments)obj).updateRendering(parameter, context);
                    break block6;
                }
                String iface = ISearchArguments.class.getName();
                throw new SearchException("La classe [" + this.className + "] non implementa l'interfaccia [" + iface + "]");
            }
            catch (SearchException re) {
                throw re;
            }
            catch (Exception e) {
                this.log.error("Impossibile ottenere informazioni per il rendereng dal Loader: " + e.getMessage(), (Throwable)e);
                throw new SearchException(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void valueSelectedListener(Parameter<?> parameter, Context context) {
        block5: {
            try {
                Object obj = Utilities.newInstance(this.c);
                if (obj instanceof ISearchProcessing) {
                    ((ISearchProcessing)obj).onChangeValue(parameter, context);
                    break block5;
                }
                if (obj instanceof IStatisticProcessing) {
                    ((IStatisticProcessing)obj).onChangeValue(parameter, context);
                    break block5;
                }
                if (obj instanceof ISearchArguments) {
                    ((ISearchArguments)obj).onChangeValue(parameter, context);
                    break block5;
                }
                String iface = ISearchArguments.class.getName();
                throw new SearchException("La classe [" + this.className + "] non implementa l'interfaccia [" + iface + "]");
            }
            catch (Exception e) {
                this.log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public List<StatisticType> getEnabledStatisticType(Context context) throws SearchException {
        try {
            Object obj = Utilities.newInstance(this.c);
            if (obj instanceof IStatisticProcessing) {
                return ((IStatisticProcessing)obj).getEnabledStatisticType();
            }
            String iface = ISearchArguments.class.getName();
            throw new SearchException("La classe [" + this.className + "] non implementa l'interfaccia [" + iface + "]");
        }
        catch (SearchException re) {
            throw re;
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new SearchException(e.getMessage(), (Throwable)e);
        }
    }
}

