/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.monitor.engine.fs_recovery;

import java.io.File;
import java.sql.Connection;
import org.openspcoop2.core.eventi.Evento;
import org.openspcoop2.core.eventi.dao.IServiceManager;
import org.openspcoop2.core.eventi.utils.serializer.JaxbDeserializer;
import org.openspcoop2.monitor.engine.fs_recovery.AbstractFSRecovery;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.UtilsMultiException;
import org.slf4j.Logger;

public class FSRecoveryEventiImpl
extends AbstractFSRecovery {
    private IServiceManager pluginsEventiSM;

    public FSRecoveryEventiImpl(Logger log, boolean debug, IServiceManager pluginsEventiSM, File directory, File directoryDLQ, int tentativi, long msAttesaProcessingFile, long maxFileProcessed) {
        super(log, debug, directory, directoryDLQ, tentativi, msAttesaProcessingFile, maxFileProcessed);
        this.pluginsEventiSM = pluginsEventiSM;
    }

    @Override
    public long process(Connection connection) {
        this.log.info("Recovery Eventi ...");
        long l = super.process(connection);
        this.log.info("Recovery Eventi completato");
        return l;
    }

    @Override
    public void insertObject(File file, Connection connection) throws UtilsException, UtilsMultiException {
        JaxbDeserializer deserializer = new JaxbDeserializer();
        try {
            Evento evento = deserializer.readEvento(file);
            this.pluginsEventiSM.getEventoService().create((Object)evento);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), (Throwable)e);
        }
    }
}

