/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.monitor.engine.fs_recovery;

import java.sql.Connection;
import java.sql.DriverManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.sql.DataSource;
import org.openspcoop2.core.commons.dao.DAOFactory;
import org.openspcoop2.core.commons.dao.DAOFactoryProperties;
import org.openspcoop2.core.config.OpenspcoopAppender;
import org.openspcoop2.core.config.Property;
import org.openspcoop2.core.config.utils.OpenSPCoopAppenderUtilities;
import org.openspcoop2.core.eventi.dao.IServiceManager;
import org.openspcoop2.core.transazioni.utils.ProjectInfo;
import org.openspcoop2.generic_project.beans.IProjectInfo;
import org.openspcoop2.generic_project.utils.ServiceManagerProperties;
import org.openspcoop2.monitor.engine.config.MonitorProperties;
import org.openspcoop2.monitor.engine.exceptions.EngineException;
import org.openspcoop2.monitor.engine.fs_recovery.FSRecoveryConfig;
import org.openspcoop2.monitor.engine.fs_recovery.FSRecoveryLibrary;
import org.openspcoop2.protocol.engine.BasicProtocolFactory;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.sdk.ConfigurazionePdD;
import org.openspcoop2.protocol.sdk.diagnostica.IDiagnosticProducer;
import org.openspcoop2.protocol.sdk.dump.IDumpProducer;
import org.openspcoop2.protocol.sdk.tracciamento.ITracciaProducer;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.resources.GestoreJNDI;
import org.openspcoop2.utils.resources.Loader;
import org.slf4j.Logger;

public class TimerFSRecoveryThread
extends Thread {
    private long timeout = 10L;
    private FSRecoveryConfig fsRepositoryConfig;
    private DataSource ds;
    private String dsJndiName;
    private Connection connection;
    private String connectionUrl = null;
    private String connectionDriver = null;
    private String connectionUsername = null;
    private String connectionPassword = null;
    private DAOFactory daoFactory;
    private ServiceManagerProperties daoFactoryServiceManagerPropertiesTransazioni = null;
    private org.openspcoop2.core.transazioni.dao.IServiceManager transazioniSM = null;
    private IServiceManager pluginsEventiSM = null;
    private ITracciaProducer tracciamentoAppender;
    private IDiagnosticProducer diagnosticoAppender;
    private IDumpProducer dumpAppender;
    private boolean transazioniRegistrazioneDumpHeadersCompactEnabled;
    private boolean stop = false;

    public boolean isStop() {
        return this.stop;
    }

    public void setStop(boolean stop) {
        this.stop = stop;
    }

    public TimerFSRecoveryThread(DataSource ds, ITracciaProducer tracciamentoAppender, IDiagnosticProducer diagnosticoAppender, IDumpProducer dumpAppender, boolean transazioniRegistrazioneDumpHeadersCompactEnabled, FSRecoveryConfig fsRepositoryConfig) throws EngineException {
        this(fsRepositoryConfig);
        this.ds = ds;
        this.tracciamentoAppender = tracciamentoAppender;
        this.diagnosticoAppender = diagnosticoAppender;
        this.dumpAppender = dumpAppender;
        this.transazioniRegistrazioneDumpHeadersCompactEnabled = transazioniRegistrazioneDumpHeadersCompactEnabled;
    }

    public TimerFSRecoveryThread(String ds, Properties dsContext, FSRecoveryConfig fsRepositoryConfig) throws EngineException {
        this(fsRepositoryConfig);
        GestoreJNDI jndi = new GestoreJNDI(dsContext);
        try {
            this.dsJndiName = ds;
            this.ds = (DataSource)jndi.lookup(ds);
        }
        catch (Exception e) {
            throw new EngineException(e.getMessage(), e);
        }
    }

    public TimerFSRecoveryThread(Connection connection, ITracciaProducer tracciamentoAppender, IDiagnosticProducer diagnosticoAppender, IDumpProducer dumpAppender, boolean transazioniRegistrazioneDumpHeadersCompactEnabled, OpenspcoopAppender appenderProperties, FSRecoveryConfig fsRepositoryConfig) throws EngineException {
        this(fsRepositoryConfig);
        this.connection = connection;
        this.tracciamentoAppender = tracciamentoAppender;
        this.diagnosticoAppender = diagnosticoAppender;
        this.dumpAppender = dumpAppender;
        this.transazioniRegistrazioneDumpHeadersCompactEnabled = transazioniRegistrazioneDumpHeadersCompactEnabled;
    }

    public TimerFSRecoveryThread(String connectionUrl, String driverJDBC, String username, String password, FSRecoveryConfig fsRepositoryConfig) throws EngineException {
        this(fsRepositoryConfig);
        try {
            this.connectionUrl = connectionUrl;
            this.connectionDriver = driverJDBC;
            this.connectionUsername = username;
            this.connectionPassword = password;
            Class.forName(driverJDBC);
            this.connection = DriverManager.getConnection(connectionUrl, username, password);
        }
        catch (Exception e) {
            throw new EngineException(e.getMessage(), e);
        }
    }

    public TimerFSRecoveryThread(FSRecoveryConfig fsRepositoryConfig) throws EngineException {
        try {
            MonitorProperties props = MonitorProperties.getInstance(fsRepositoryConfig.getLogCore());
            try {
                this.timeout = Integer.parseInt(props.getProperty("org.openspcoop2.monitor.fileSystemRecovery.timeout", "10", true));
            }
            catch (NumberFormatException e) {
                this.timeout = 10L;
            }
            this.fsRepositoryConfig = fsRepositoryConfig;
            this.daoFactory = DAOFactory.getInstance((Logger)this.fsRepositoryConfig.getLogSql());
            this.daoFactoryServiceManagerPropertiesTransazioni = DAOFactoryProperties.getInstance((Logger)this.fsRepositoryConfig.getLogSql()).getServiceManagerProperties((IProjectInfo)ProjectInfo.getInstance());
        }
        catch (Exception e) {
            throw new EngineException(e.getMessage(), e);
        }
    }

    @Override
    public void run() {
        this.initResources();
        block0: while (!this.stop) {
            FSRecoveryLibrary.generate(this.fsRepositoryConfig, this.daoFactory, this.fsRepositoryConfig.getLogSql(), this.daoFactoryServiceManagerPropertiesTransazioni, 60000L, 100, this.transazioniSM, this.tracciamentoAppender, this.diagnosticoAppender, this.dumpAppender, this.transazioniRegistrazioneDumpHeadersCompactEnabled, this.pluginsEventiSM);
            if (this.stop) continue;
            int i = 0;
            while ((long)i < this.timeout) {
                Utilities.sleep((long)1000L);
                if (this.stop) continue block0;
                ++i;
            }
        }
        this.fsRepositoryConfig.getLogCore().info("Thread per il recovery da file system terminato");
    }

    private void initResources() {
        if (this.fsRepositoryConfig.isRipristinoTransazioni()) {
            try {
                this.transazioniSM = this.ds != null ? (org.openspcoop2.core.transazioni.dao.IServiceManager)this.daoFactory.getServiceManager((IProjectInfo)ProjectInfo.getInstance(), this.ds) : (this.connection != null ? (org.openspcoop2.core.transazioni.dao.IServiceManager)this.daoFactory.getServiceManager((IProjectInfo)ProjectInfo.getInstance(), this.connection) : (org.openspcoop2.core.transazioni.dao.IServiceManager)this.daoFactory.getServiceManager((IProjectInfo)ProjectInfo.getInstance()));
            }
            catch (Exception e) {
                this.fsRepositoryConfig.getLogCore().error("Errore durante l'inizializzazione del Service Manager per le transazioni: " + e.getMessage(), (Throwable)e);
            }
        }
        if (this.fsRepositoryConfig.isRipristinoEventi()) {
            try {
                this.pluginsEventiSM = this.ds != null ? (IServiceManager)this.daoFactory.getServiceManager((IProjectInfo)org.openspcoop2.core.eventi.utils.ProjectInfo.getInstance(), this.ds) : (this.connection != null ? (IServiceManager)this.daoFactory.getServiceManager((IProjectInfo)org.openspcoop2.core.eventi.utils.ProjectInfo.getInstance(), this.connection) : (IServiceManager)this.daoFactory.getServiceManager((IProjectInfo)org.openspcoop2.core.eventi.utils.ProjectInfo.getInstance()));
            }
            catch (Exception e) {
                this.fsRepositoryConfig.getLogCore().error("Errore durante l'inizializzazione del Service Manager per i plugins eventi: " + e.getMessage(), (Throwable)e);
            }
        }
        if (this.fsRepositoryConfig.isRipristinoTransazioni() && (this.tracciamentoAppender == null || this.diagnosticoAppender == null)) {
            try {
                ConfigurazionePdD configPdD = new ConfigurazionePdD();
                configPdD.setAttesaAttivaJDBC(-1L);
                configPdD.setCheckIntervalJDBC(-1);
                configPdD.setLoader(new Loader(this.getClass().getClassLoader()));
                configPdD.setLog(this.fsRepositoryConfig.getLogCore());
                ProtocolFactoryManager.initialize((Logger)this.fsRepositoryConfig.getLogCore(), (ConfigurazionePdD)configPdD, (String)this.fsRepositoryConfig.getDefaultProtocol());
            }
            catch (Exception e) {
                this.fsRepositoryConfig.getLogCore().error("Errore durante l'inizializzazione del ProtocolFactoryManager: " + e.getMessage(), (Throwable)e);
            }
        }
        if (this.fsRepositoryConfig.isRipristinoTransazioni() && this.tracciamentoAppender == null) {
            try {
                this.tracciamentoAppender = new BasicProtocolFactory(this.fsRepositoryConfig.getLogCore()).createTracciaProducer();
                OpenspcoopAppender tracciamentoOpenSPCoopAppender = new OpenspcoopAppender();
                tracciamentoOpenSPCoopAppender.setTipo("__threadLibraryFileSystemRecovery");
                ArrayList<Property> tracciamentoOpenSPCoopAppenderProperties = new ArrayList<Property>();
                this.addParameters(tracciamentoOpenSPCoopAppenderProperties);
                tracciamentoOpenSPCoopAppender.setPropertyList(tracciamentoOpenSPCoopAppenderProperties);
                this.tracciamentoAppender.initializeAppender(tracciamentoOpenSPCoopAppender);
                this.tracciamentoAppender.isAlive();
            }
            catch (Exception e) {
                this.fsRepositoryConfig.getLogCore().error("Errore durante l'inizializzazione del TracciamentoAppender: " + e.getMessage(), (Throwable)e);
            }
        }
        if (this.fsRepositoryConfig.isRipristinoTransazioni() && this.diagnosticoAppender == null) {
            try {
                this.diagnosticoAppender = new BasicProtocolFactory(this.fsRepositoryConfig.getLogCore()).createDiagnosticProducer();
                OpenspcoopAppender diagnosticoOpenSPCoopAppender = new OpenspcoopAppender();
                diagnosticoOpenSPCoopAppender.setTipo("__threadLibraryFileSystemRecovery");
                ArrayList<Property> diagnosticoOpenSPCoopAppenderProperties = new ArrayList<Property>();
                this.addParameters(diagnosticoOpenSPCoopAppenderProperties);
                diagnosticoOpenSPCoopAppender.setPropertyList(diagnosticoOpenSPCoopAppenderProperties);
                this.diagnosticoAppender.initializeAppender(diagnosticoOpenSPCoopAppender);
                this.diagnosticoAppender.isAlive();
            }
            catch (Exception e) {
                this.fsRepositoryConfig.getLogCore().error("Errore durante l'inizializzazione del DiagnosticoAppender: " + e.getMessage(), (Throwable)e);
            }
        }
        if (this.fsRepositoryConfig.isRipristinoTransazioni() && this.dumpAppender == null) {
            try {
                this.dumpAppender = new BasicProtocolFactory(this.fsRepositoryConfig.getLogCore()).createDumpProducer();
                OpenspcoopAppender dumpOpenSPCoopAppender = new OpenspcoopAppender();
                dumpOpenSPCoopAppender.setTipo("__threadLibraryFileSystemRecovery");
                ArrayList<Property> dumpOpenSPCoopAppenderProperties = new ArrayList<Property>();
                this.addParameters(dumpOpenSPCoopAppenderProperties);
                dumpOpenSPCoopAppender.setPropertyList(dumpOpenSPCoopAppenderProperties);
                this.diagnosticoAppender.initializeAppender(dumpOpenSPCoopAppender);
                this.diagnosticoAppender.isAlive();
            }
            catch (Exception e) {
                this.fsRepositoryConfig.getLogCore().error("Errore durante l'inizializzazione del DiagnosticoAppender: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    private void addParameters(List<Property> appenderProperties) throws Exception {
        DAOFactoryProperties daoFactoryProperties = DAOFactoryProperties.getInstance((Logger)this.fsRepositoryConfig.getLogSql());
        String tipoDatabase = daoFactoryProperties.getTipoDatabase((IProjectInfo)ProjectInfo.getInstance());
        String dsJndiName = null;
        String connectionUrl = null;
        String connectionDriver = null;
        String connectionUsername = null;
        String connectionPassword = null;
        if (this.dsJndiName != null) {
            dsJndiName = this.dsJndiName;
        } else if (this.connectionUrl != null) {
            connectionUrl = this.connectionUrl;
            connectionDriver = this.connectionDriver;
            connectionUsername = this.connectionUsername;
            connectionPassword = this.connectionPassword;
        } else if (daoFactoryProperties.isTipoAccessoTramiteDatasource((IProjectInfo)ProjectInfo.getInstance())) {
            dsJndiName = daoFactoryProperties.getDatasourceJNDIName((IProjectInfo)ProjectInfo.getInstance());
        } else {
            connectionUrl = daoFactoryProperties.getConnectionUrl((IProjectInfo)ProjectInfo.getInstance());
            connectionDriver = daoFactoryProperties.getConnectionDriverJDBC((IProjectInfo)ProjectInfo.getInstance());
            connectionUsername = daoFactoryProperties.getConnectionAuthUsername((IProjectInfo)ProjectInfo.getInstance());
            connectionPassword = daoFactoryProperties.getConnectionAuthPassword((IProjectInfo)ProjectInfo.getInstance());
        }
        boolean debug = daoFactoryProperties.isShowSql((IProjectInfo)ProjectInfo.getInstance());
        OpenSPCoopAppenderUtilities.addParameters((Logger)this.fsRepositoryConfig.getLogCore(), appenderProperties, (String)dsJndiName, (String)connectionUrl, (String)connectionDriver, (String)connectionUsername, (String)connectionPassword, (String)tipoDatabase, (boolean)true, (boolean)debug);
    }
}

