/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.monitor.engine.statistic;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.core.commons.search.constants.TipoPdD;
import org.openspcoop2.core.commons.search.dao.IServiceManager;
import org.openspcoop2.core.commons.search.dao.jdbc.JDBCSoggettoServiceSearch;
import org.openspcoop2.core.constants.ProprietariProtocolProperty;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.generic_project.exception.ExpressionException;
import org.openspcoop2.generic_project.exception.NotFoundException;
import org.openspcoop2.generic_project.exception.NotImplementedException;
import org.openspcoop2.generic_project.exception.ServiceException;
import org.openspcoop2.monitor.engine.statistic.PdndTracciamentoInfo;
import org.openspcoop2.monitor.engine.statistic.PdndTracciamentoSoggetto;
import org.openspcoop2.monitor.engine.statistic.StatisticsConfig;
import org.openspcoop2.monitor.engine.statistic.StatisticsEngineException;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.utils.TipiDatabase;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;
import org.openspcoop2.utils.sql.SQLQueryObjectException;
import org.slf4j.Logger;

public class PdndTracciamentoUtils {
    private PdndTracciamentoUtils() {
    }

    public static void logDebugSoggettiAbilitati(PdndTracciamentoInfo internalPddCodes, Logger logger) {
        int dimensione = 0;
        if (internalPddCodes != null && internalPddCodes.getSoggetti() != null) {
            dimensione = internalPddCodes.getSoggetti().size();
        }
        logger.debug("Soggetti abilitato al tracing PDND: {}", (Object)dimensione);
        if (internalPddCodes != null && internalPddCodes.getSoggetti() != null) {
            for (PdndTracciamentoSoggetto soggettoEntry : internalPddCodes.getSoggetti()) {
                String nomeSoggetto = soggettoEntry.getIdSoggetto().getNome();
                List<String> soggettiAggregati = PdndTracciamentoUtils.getNomiSoggettiAggregati(soggettoEntry);
                logger.debug("Soggetto abilitato al tracing PDND: {} (soggetti aggregati: {})", (Object)nomeSoggetto, soggettiAggregati);
            }
        }
    }

    public static List<String> getNomiSoggettiAggregati(PdndTracciamentoSoggetto soggettoEntry) {
        ArrayList<String> soggettiAggregati = new ArrayList<String>();
        if (soggettoEntry.getIdSoggettiAggregati() != null && !soggettoEntry.getIdSoggettiAggregati().isEmpty()) {
            for (IDSoggetto idSoggettoAggregato : soggettoEntry.getIdSoggettiAggregati()) {
                soggettiAggregati.add(idSoggettoAggregato.getCodicePorta());
            }
        }
        return soggettiAggregati;
    }

    public static PdndTracciamentoInfo getEnabledPddCodes(IServiceManager utilsSM, StatisticsConfig config) throws SQLQueryObjectException, StatisticsEngineException, ServiceException, NotImplementedException, ExpressionException, NotFoundException, ProtocolException {
        if (!(utilsSM.getSoggettoServiceSearch() instanceof JDBCSoggettoServiceSearch)) {
            throw new StatisticsEngineException("service manager non di tipo JDBC");
        }
        JDBCSoggettoServiceSearch soggettiSM = (JDBCSoggettoServiceSearch)utilsSM.getSoggettoServiceSearch();
        Set<String> defaultEnabled = config.getPdndTracciamentoSoggettiEnabled();
        Map<String, String> internalPdd = PdndTracciamentoUtils.getCodesSoggettiInterni(soggettiSM);
        PdndTracciamentoInfo infoTracciamento = PdndTracciamentoUtils.getInfoTracciamento(soggettiSM, config.getLogCore());
        if (defaultEnabled.isEmpty()) {
            defaultEnabled = config.isPdndTracciamentoSoggettiDisabled() ? new HashSet<String>() : new HashSet<String>(internalPdd.values());
        }
        return PdndTracciamentoUtils.getMergeEnabledPddCodes(defaultEnabled, internalPdd, infoTracciamento, config);
    }

    private static PdndTracciamentoInfo getMergeEnabledPddCodes(Set<String> defaultEnabled, Map<String, String> internalPdd, PdndTracciamentoInfo infoTracciamento, StatisticsConfig config) throws ProtocolException {
        if (config != null) {
            // empty if block
        }
        PdndTracciamentoInfo regoleTracciamentoMergeGovWayProperties = new PdndTracciamentoInfo();
        for (Map.Entry<String, String> entry : internalPdd.entrySet()) {
            String codicePortaSoggetto = entry.getKey();
            String nomeSoggetto = entry.getValue();
            PdndTracciamentoSoggetto customConfigSoggettoAggregato = infoTracciamento.getInfoByIdentificativoPorta(codicePortaSoggetto, false, true);
            if (customConfigSoggettoAggregato != null) continue;
            PdndTracciamentoUtils.addSoggetto(defaultEnabled, infoTracciamento, codicePortaSoggetto, nomeSoggetto, regoleTracciamentoMergeGovWayProperties);
        }
        return regoleTracciamentoMergeGovWayProperties;
    }

    private static void addSoggetto(Set<String> defaultEnabled, PdndTracciamentoInfo infoTracciamento, String codicePortaSoggetto, String nomeSoggetto, PdndTracciamentoInfo regoleTracciamentoMergeGovWayProperties) throws ProtocolException {
        PdndTracciamentoSoggetto customConfig = infoTracciamento.getInfoByIdentificativoPorta(codicePortaSoggetto, true, false);
        if (customConfig == null || customConfig.isTracciamentoDefault()) {
            if (defaultEnabled.contains(nomeSoggetto)) {
                if (customConfig == null) {
                    customConfig = new PdndTracciamentoSoggetto(new IDSoggetto("modipa", nomeSoggetto, codicePortaSoggetto), "-1");
                }
                regoleTracciamentoMergeGovWayProperties.addSoggetto(customConfig);
            }
        } else if (customConfig.isTracciamentoAbilitato()) {
            regoleTracciamentoMergeGovWayProperties.addSoggetto(customConfig);
        }
    }

    private static Map<String, String> getCodesSoggettiInterni(JDBCSoggettoServiceSearch soggettiSM) throws SQLQueryObjectException, ServiceException, NotImplementedException, ExpressionException, NotFoundException {
        TipiDatabase tipoDb = soggettiSM.getFieldConverter().getDatabaseType();
        ISQLQueryObject query = SQLObjectFactory.createSQLQueryObject((TipiDatabase)tipoDb);
        query.addFromTable("soggetti");
        query.addFromTable("pdd");
        query.addSelectField("soggetti", "identificativo_porta");
        query.addSelectField("soggetti", "nome_soggetto");
        query.addWhereCondition(true, new String[]{"soggetti.server=pdd.nome", "pdd.tipo= '" + TipoPdD.OPERATIVO.getValue() + "'", "soggetti.tipo_soggetto='modipa'"});
        return soggettiSM.nativeQuery(query.createSQLQuery(), List.of(String.class, String.class), new Object[0]).stream().collect(Collectors.toMap(e -> e.get(0).toString(), e -> e.get(1).toString()));
    }

    public static PdndTracciamentoInfo getInfoTracciamento(JDBCSoggettoServiceSearch soggettiSM, Logger log) throws SQLQueryObjectException, ServiceException, NotImplementedException, ExpressionException, ProtocolException {
        if (log != null) {
            // empty if block
        }
        PdndTracciamentoInfo info = new PdndTracciamentoInfo();
        List<List<Object>> result = PdndTracciamentoUtils.readInfoTracciamento(soggettiSM, "modipaSoggettoPdndTracingEnabled");
        if (result != null && !result.isEmpty()) {
            for (List<Object> list : result) {
                if (list == null || list.isEmpty()) continue;
                IDSoggetto idSoggetto = new IDSoggetto(PdndTracciamentoUtils.getStringValueFromList(list, 0), PdndTracciamentoUtils.getStringValueFromList(list, 1), PdndTracciamentoUtils.getStringValueFromList(list, 2));
                String valoreProprieta = PdndTracciamentoUtils.getStringValueFromList(list, 3);
                PdndTracciamentoSoggetto soggetto = new PdndTracciamentoSoggetto(idSoggetto, valoreProprieta);
                info.addSoggetto(soggetto);
            }
        }
        PdndTracciamentoUtils.addSoggettiAggregati(soggettiSM, info, log);
        return info;
    }

    private static void addSoggettiAggregati(JDBCSoggettoServiceSearch soggettiSM, PdndTracciamentoInfo info, Logger log) throws ProtocolException, SQLQueryObjectException, ServiceException, NotImplementedException, ExpressionException {
        List<List<Object>> resultAggregati;
        if (log != null) {
            // empty if block
        }
        if ((resultAggregati = PdndTracciamentoUtils.readInfoTracciamento(soggettiSM, "modipaSoggettoPdndTracingAggregato")) != null && !resultAggregati.isEmpty()) {
            for (List<Object> list : resultAggregati) {
                if (list == null || list.isEmpty()) continue;
                PdndTracciamentoUtils.addSoggettoAggregato(list, info, log);
            }
        }
    }

    private static void addSoggettoAggregato(List<Object> list, PdndTracciamentoInfo info, Logger log) throws ProtocolException {
        IDSoggetto idSoggetto;
        PdndTracciamentoSoggetto soggetto;
        if (log != null) {
            // empty if block
        }
        if ((soggetto = info.getInfoByNomeSoggetto((idSoggetto = new IDSoggetto(PdndTracciamentoUtils.getStringValueFromList(list, 0), PdndTracciamentoUtils.getStringValueFromList(list, 1), PdndTracciamentoUtils.getStringValueFromList(list, 2))).getNome(), true, false)) == null) {
            throw new ProtocolException("Soggetto '" + idSoggetto.getNome() + "' non esistente nella configurazione PdndTracciamento ?");
        }
        String valoreProprieta = PdndTracciamentoUtils.getStringValueFromList(list, 3);
        if (valoreProprieta != null && StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{valoreProprieta})) {
            PdndTracciamentoSoggetto soggettoAggregato = info.getInfoByNomeSoggetto(valoreProprieta, true, false);
            if (soggettoAggregato == null) {
                throw new ProtocolException("Soggetto '" + valoreProprieta + "' non esistente nella configurazione PdndTracciamento (ricerca per aggregato); verifica che il soggetto possieda il tracciamento abilitato?");
            }
            soggettoAggregato.addSoggettoAggregato(idSoggetto);
        }
    }

    private static List<List<Object>> readInfoTracciamento(JDBCSoggettoServiceSearch soggettiSM, String pName) throws SQLQueryObjectException, ServiceException, NotImplementedException, ExpressionException {
        TipiDatabase tipoDb = soggettiSM.getFieldConverter().getDatabaseType();
        ISQLQueryObject query = SQLObjectFactory.createSQLQueryObject((TipiDatabase)tipoDb);
        query.addFromTable("soggetti");
        query.addFromTable("pdd");
        query.addFromTable("protocol_properties");
        query.addSelectAliasField("soggetti", "tipo_soggetto", "tipoSoggetto");
        query.addSelectAliasField("soggetti", "nome_soggetto", "nomeSoggetto");
        query.addSelectAliasField("soggetti", "identificativo_porta", "codicePorta");
        query.addSelectAliasField("protocol_properties", "value_string", "valoreProprieta");
        query.addWhereCondition(true, new String[]{"soggetti.server=pdd.nome", "pdd.tipo= '" + TipoPdD.OPERATIVO.getValue() + "'", "soggetti.tipo_soggetto='modipa'", "protocol_properties.id_proprietario= soggetti.id", "protocol_properties.tipo_proprietario= '" + ProprietariProtocolProperty.SOGGETTO.name() + "'", "protocol_properties.name= '" + pName + "'"});
        List result = null;
        try {
            result = soggettiSM.nativeQuery(query.createSQLQuery(), List.of(String.class, String.class, String.class, String.class), new Object[0]);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        return result;
    }

    private static String getStringValueFromList(List<Object> list, int index) {
        Object o;
        if (list != null && !list.isEmpty() && list.size() >= index + 1 && (o = list.get(index)) instanceof String) {
            return (String)o;
        }
        return null;
    }
}

