/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.monitor.engine.statistic;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.openspcoop2.core.transazioni.Transazione;
import org.openspcoop2.generic_project.beans.IModel;
import org.openspcoop2.generic_project.expression.Index;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.properties.InstanceProperties;

public class StatisticsForceIndexConfig {
    private List<Index> transazioniForceIndexGroupByNumeroDimensione = null;
    private List<Index> transazioniForceIndexGroupByLatenze = null;
    private List<Index> transazioniForceIndexGroupByCustomNumeroDimensione = null;
    private List<Index> transazioniForceIndexGroupByCustomLatenze = null;
    private static final String P_REPO = "statistiche.generazione.forceIndex.repository";
    private static final String P_GROUPBY_NUMERO_DIMENSIONE = "statistiche.generazione.forceIndex.groupBy.numero_dimensione";
    private static final String P_GROUPBY_LATENZA = "statistiche.generazione.forceIndex.groupBy.latenza";
    private static final String P_GROUPBY_CUSTOM_NUMERO_DIMENSIONE = "statistiche.generazione.forceIndex.groupBy.custom.numero_dimensione";
    private static final String P_GROUPBY_CUSTOM_LATENZA = "statistiche.generazione.forceIndex.groupBy.custom.latenza";

    public StatisticsForceIndexConfig() {
    }

    public StatisticsForceIndexConfig(Properties p) throws IOException {
        String tmpRepo = p.getProperty(P_REPO);
        Properties pRepoExternal = this.getExternalRepository(tmpRepo);
        String groupByNumeroDimensione = p.getProperty(P_GROUPBY_NUMERO_DIMENSIONE);
        if (groupByNumeroDimensione != null) {
            groupByNumeroDimensione = groupByNumeroDimensione.trim();
        }
        this.transazioniForceIndexGroupByNumeroDimensione = this.getIndexList(P_GROUPBY_NUMERO_DIMENSIONE, groupByNumeroDimensione, pRepoExternal);
        String groupByLatenza = p.getProperty(P_GROUPBY_LATENZA);
        if (groupByLatenza != null) {
            groupByLatenza = groupByLatenza.trim();
        }
        this.transazioniForceIndexGroupByLatenze = this.getIndexList(P_GROUPBY_LATENZA, groupByLatenza, pRepoExternal);
        String groupCustomByNumeroDimensione = p.getProperty(P_GROUPBY_CUSTOM_NUMERO_DIMENSIONE);
        if (groupCustomByNumeroDimensione != null) {
            groupCustomByNumeroDimensione = groupCustomByNumeroDimensione.trim();
        }
        this.transazioniForceIndexGroupByCustomNumeroDimensione = this.getIndexList(P_GROUPBY_CUSTOM_NUMERO_DIMENSIONE, groupCustomByNumeroDimensione, pRepoExternal);
        String groupCustomByLatenza = p.getProperty(P_GROUPBY_CUSTOM_LATENZA);
        if (groupCustomByLatenza != null) {
            groupCustomByLatenza = groupCustomByLatenza.trim();
        }
        this.transazioniForceIndexGroupByCustomLatenze = this.getIndexList(P_GROUPBY_CUSTOM_LATENZA, groupCustomByLatenza, pRepoExternal);
    }

    public StatisticsForceIndexConfig(InstanceProperties p) throws IOException, UtilsException {
        String tmpRepo = p.getValueConvertEnvProperties(P_REPO);
        Properties pRepoExternal = this.getExternalRepository(tmpRepo);
        String groupByNumeroDimensione = p.getValueConvertEnvProperties(P_GROUPBY_NUMERO_DIMENSIONE);
        if (groupByNumeroDimensione != null) {
            groupByNumeroDimensione = groupByNumeroDimensione.trim();
        }
        this.transazioniForceIndexGroupByNumeroDimensione = this.getIndexList(P_GROUPBY_NUMERO_DIMENSIONE, groupByNumeroDimensione, pRepoExternal);
        String groupByLatenza = p.getValueConvertEnvProperties(P_GROUPBY_LATENZA);
        if (groupByLatenza != null) {
            groupByLatenza = groupByLatenza.trim();
        }
        this.transazioniForceIndexGroupByLatenze = this.getIndexList(P_GROUPBY_LATENZA, groupByLatenza, pRepoExternal);
        String groupCustomByNumeroDimensione = p.getValueConvertEnvProperties(P_GROUPBY_CUSTOM_NUMERO_DIMENSIONE);
        if (groupCustomByNumeroDimensione != null) {
            groupCustomByNumeroDimensione = groupCustomByNumeroDimensione.trim();
        }
        this.transazioniForceIndexGroupByCustomNumeroDimensione = this.getIndexList(P_GROUPBY_CUSTOM_NUMERO_DIMENSIONE, groupCustomByNumeroDimensione, pRepoExternal);
        String groupCustomByLatenza = p.getValueConvertEnvProperties(P_GROUPBY_CUSTOM_LATENZA);
        if (groupCustomByLatenza != null) {
            groupCustomByLatenza = groupCustomByLatenza.trim();
        }
        this.transazioniForceIndexGroupByCustomLatenze = this.getIndexList(P_GROUPBY_CUSTOM_LATENZA, groupCustomByLatenza, pRepoExternal);
    }

    private Properties getExternalRepository(String tmpRepo) throws IOException {
        Properties pRepoExternal = null;
        if (tmpRepo != null) {
            File f = new File(tmpRepo);
            try (InputStream is = f.exists() ? new FileInputStream(f) : StatisticsForceIndexConfig.class.getResourceAsStream(tmpRepo);){
                if (is != null) {
                    pRepoExternal = new Properties();
                    pRepoExternal.load(is);
                }
            }
        }
        return pRepoExternal;
    }

    private List<Index> getIndexList(String propertyName, String propertyValue, Properties externalRepository) {
        String tmp;
        String s = null;
        if (externalRepository != null && (tmp = externalRepository.getProperty(propertyName)) != null) {
            s = tmp.trim();
        }
        if (s == null) {
            s = propertyValue;
        }
        ArrayList<Index> l = null;
        if (s != null) {
            l = new ArrayList<Index>();
            if (s.contains(",")) {
                String[] split = s.split(",");
                for (int i = 0; i < split.length; ++i) {
                    l.add(new Index((IModel)Transazione.model(), split[i]));
                }
            } else {
                l.add(new Index((IModel)Transazione.model(), s));
            }
            return l;
        }
        return l;
    }

    public List<Index> getTransazioniForceIndexGroupByNumeroDimensione() {
        return this.transazioniForceIndexGroupByNumeroDimensione;
    }

    public void setTransazioniForceIndexGroupByNumeroDimensione(List<Index> transazioniForceIndexGroupByNumeroDimensione) {
        this.transazioniForceIndexGroupByNumeroDimensione = transazioniForceIndexGroupByNumeroDimensione;
    }

    public List<Index> getTransazioniForceIndexGroupByLatenze() {
        return this.transazioniForceIndexGroupByLatenze;
    }

    public void setTransazioniForceIndexGroupByLatenze(List<Index> transazioniForceIndexGroupByLatenze) {
        this.transazioniForceIndexGroupByLatenze = transazioniForceIndexGroupByLatenze;
    }

    public List<Index> getTransazioniForceIndexGroupByCustomNumeroDimensione() {
        return this.transazioniForceIndexGroupByCustomNumeroDimensione;
    }

    public void setTransazioniForceIndexGroupByCustomNumeroDimensione(List<Index> transazioniForceIndexGroupByCustomNumeroDimensione) {
        this.transazioniForceIndexGroupByCustomNumeroDimensione = transazioniForceIndexGroupByCustomNumeroDimensione;
    }

    public List<Index> getTransazioniForceIndexGroupByCustomLatenze() {
        return this.transazioniForceIndexGroupByCustomLatenze;
    }

    public void setTransazioniForceIndexGroupByCustomLatenze(List<Index> transazioniForceIndexGroupByCustomLatenze) {
        this.transazioniForceIndexGroupByCustomLatenze = transazioniForceIndexGroupByCustomLatenze;
    }
}

