/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.monitor.engine.statistic;

import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Properties;
import javax.sql.DataSource;
import org.openspcoop2.core.commons.dao.DAOFactory;
import org.openspcoop2.core.plugins.dao.IServiceManager;
import org.openspcoop2.core.transazioni.utils.ProjectInfo;
import org.openspcoop2.generic_project.beans.IProjectInfo;
import org.openspcoop2.monitor.engine.config.MonitorProperties;
import org.openspcoop2.monitor.engine.exceptions.EngineException;
import org.openspcoop2.monitor.engine.statistic.StatisticsConfig;
import org.openspcoop2.monitor.engine.statistic.StatisticsLibrary;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.resources.GestoreJNDI;
import org.slf4j.Logger;

public class TimerStatisticheThread
extends Thread {
    private long timeout = 10L;
    private StatisticsConfig statisticsConfig;
    private DataSource ds;
    private Connection connection;
    private DAOFactory daoFactory;
    private org.openspcoop2.core.statistiche.dao.IServiceManager statisticheSM = null;
    private org.openspcoop2.core.transazioni.dao.IServiceManager transazioniSM = null;
    private org.openspcoop2.monitor.engine.config.statistiche.dao.IServiceManager pluginsStatisticheSM = null;
    private IServiceManager pluginsBaseSM;
    private org.openspcoop2.core.commons.search.dao.IServiceManager utilsSM;
    private org.openspcoop2.monitor.engine.config.transazioni.dao.IServiceManager pluginsTransazioniSM;
    private boolean stop = false;

    public boolean isStop() {
        return this.stop;
    }

    public void setStop(boolean stop) {
        this.stop = stop;
    }

    public TimerStatisticheThread(DataSource ds, StatisticsConfig statisticsConfig) throws EngineException {
        this(statisticsConfig);
        this.ds = ds;
    }

    public TimerStatisticheThread(String ds, Properties dsContext, StatisticsConfig statisticsConfig) throws EngineException {
        this(statisticsConfig);
        GestoreJNDI jndi = new GestoreJNDI(dsContext);
        try {
            this.ds = (DataSource)jndi.lookup(ds);
        }
        catch (Exception e) {
            throw new EngineException(e.getMessage(), e);
        }
    }

    public TimerStatisticheThread(Connection connection, StatisticsConfig statisticsConfig) throws EngineException {
        this(statisticsConfig);
        this.connection = connection;
    }

    public TimerStatisticheThread(String connectionUrl, String driverJDBC, String username, String password, StatisticsConfig statisticsConfig) throws EngineException {
        this(statisticsConfig);
        try {
            Class.forName(driverJDBC);
            this.connection = DriverManager.getConnection(connectionUrl, username, password);
        }
        catch (Exception e) {
            throw new EngineException(e.getMessage(), e);
        }
    }

    public TimerStatisticheThread(StatisticsConfig statisticsConfig) throws EngineException {
        try {
            MonitorProperties props = MonitorProperties.getInstance(statisticsConfig.getLogCore());
            try {
                this.timeout = Integer.parseInt(props.getProperty("org.openspcoop2.monitor.statistic.timeout", "10", true));
            }
            catch (NumberFormatException e) {
                this.timeout = 10L;
            }
            this.statisticsConfig = statisticsConfig;
            this.daoFactory = DAOFactory.getInstance((Logger)this.statisticsConfig.getLogSql());
        }
        catch (Exception e) {
            throw new EngineException(e.getMessage(), e);
        }
    }

    @Override
    public void run() {
        this.initResources();
        block0: while (!this.stop) {
            StatisticsLibrary sLibrary = new StatisticsLibrary(this.statisticsConfig, this.statisticheSM, this.transazioniSM, this.pluginsStatisticheSM, this.pluginsBaseSM, this.utilsSM, this.pluginsTransazioniSM);
            sLibrary.generateStatisticaOraria();
            sLibrary.generateStatisticaGiornaliera();
            sLibrary.generateStatisticaSettimanale();
            sLibrary.generateStatisticaMensile();
            sLibrary.generatePdndGenerazioneTracciamento();
            sLibrary.generatePdndPubblicazioneTracciamento();
            if (this.stop) continue;
            int i = 0;
            while ((long)i < this.timeout) {
                Utilities.sleep((long)1000L);
                if (this.stop) continue block0;
                ++i;
            }
        }
        this.statisticsConfig.getLogCore().info("Thread per la generazione delle statistiche terminato");
    }

    private void initResources() {
        try {
            this.statisticheSM = this.ds != null ? (org.openspcoop2.core.statistiche.dao.IServiceManager)this.daoFactory.getServiceManager((IProjectInfo)org.openspcoop2.core.statistiche.utils.ProjectInfo.getInstance(), this.ds) : (this.connection != null ? (org.openspcoop2.core.statistiche.dao.IServiceManager)this.daoFactory.getServiceManager((IProjectInfo)org.openspcoop2.core.statistiche.utils.ProjectInfo.getInstance(), this.connection) : (org.openspcoop2.core.statistiche.dao.IServiceManager)this.daoFactory.getServiceManager((IProjectInfo)org.openspcoop2.core.statistiche.utils.ProjectInfo.getInstance()));
        }
        catch (Exception e) {
            this.statisticsConfig.getLogCore().error("Errore durante l'inizializzazione del Service Manager per le statistiche: " + e.getMessage(), (Throwable)e);
        }
        try {
            this.transazioniSM = this.ds != null ? (org.openspcoop2.core.transazioni.dao.IServiceManager)this.daoFactory.getServiceManager((IProjectInfo)ProjectInfo.getInstance(), this.ds) : (this.connection != null ? (org.openspcoop2.core.transazioni.dao.IServiceManager)this.daoFactory.getServiceManager((IProjectInfo)ProjectInfo.getInstance(), this.connection) : (org.openspcoop2.core.transazioni.dao.IServiceManager)this.daoFactory.getServiceManager((IProjectInfo)ProjectInfo.getInstance()));
        }
        catch (Exception e) {
            this.statisticsConfig.getLogCore().error("Errore durante l'inizializzazione del Service Manager per le transazioni: " + e.getMessage(), (Throwable)e);
        }
        if (this.statisticsConfig.isGenerazioneStatisticheCustom() || this.statisticsConfig.isPdndTracciamentoGenerazione() || this.statisticsConfig.isPdndTracciamentoPubblicazione()) {
            try {
                this.pluginsStatisticheSM = this.ds != null ? (org.openspcoop2.monitor.engine.config.statistiche.dao.IServiceManager)this.daoFactory.getServiceManager((IProjectInfo)org.openspcoop2.monitor.engine.config.statistiche.utils.ProjectInfo.getInstance(), this.ds) : (this.connection != null ? (org.openspcoop2.monitor.engine.config.statistiche.dao.IServiceManager)this.daoFactory.getServiceManager((IProjectInfo)org.openspcoop2.monitor.engine.config.statistiche.utils.ProjectInfo.getInstance(), this.connection) : (org.openspcoop2.monitor.engine.config.statistiche.dao.IServiceManager)this.daoFactory.getServiceManager((IProjectInfo)org.openspcoop2.monitor.engine.config.statistiche.utils.ProjectInfo.getInstance()));
                this.pluginsBaseSM = this.ds != null ? (IServiceManager)this.daoFactory.getServiceManager((IProjectInfo)org.openspcoop2.core.plugins.utils.ProjectInfo.getInstance(), this.ds) : (this.connection != null ? (IServiceManager)this.daoFactory.getServiceManager((IProjectInfo)org.openspcoop2.core.plugins.utils.ProjectInfo.getInstance(), this.connection) : (IServiceManager)this.daoFactory.getServiceManager((IProjectInfo)org.openspcoop2.core.plugins.utils.ProjectInfo.getInstance()));
                this.utilsSM = this.ds != null ? (org.openspcoop2.core.commons.search.dao.IServiceManager)this.daoFactory.getServiceManager((IProjectInfo)org.openspcoop2.core.commons.search.utils.ProjectInfo.getInstance(), this.ds) : (this.connection != null ? (org.openspcoop2.core.commons.search.dao.IServiceManager)this.daoFactory.getServiceManager((IProjectInfo)org.openspcoop2.core.commons.search.utils.ProjectInfo.getInstance(), this.connection) : (org.openspcoop2.core.commons.search.dao.IServiceManager)this.daoFactory.getServiceManager((IProjectInfo)org.openspcoop2.core.commons.search.utils.ProjectInfo.getInstance()));
                if (this.statisticsConfig.isAnalisiTransazioniCustom()) {
                    this.pluginsTransazioniSM = this.ds != null ? (org.openspcoop2.monitor.engine.config.transazioni.dao.IServiceManager)this.daoFactory.getServiceManager((IProjectInfo)org.openspcoop2.monitor.engine.config.transazioni.utils.ProjectInfo.getInstance(), this.ds) : (this.connection != null ? (org.openspcoop2.monitor.engine.config.transazioni.dao.IServiceManager)this.daoFactory.getServiceManager((IProjectInfo)org.openspcoop2.monitor.engine.config.transazioni.utils.ProjectInfo.getInstance(), this.connection) : (org.openspcoop2.monitor.engine.config.transazioni.dao.IServiceManager)this.daoFactory.getServiceManager((IProjectInfo)org.openspcoop2.monitor.engine.config.transazioni.utils.ProjectInfo.getInstance()));
                }
            }
            catch (Exception e) {
                this.statisticsConfig.getLogCore().error("Errore durante l'inizializzazione del Service Manager per i plugins: " + e.getMessage(), (Throwable)e);
            }
        }
    }
}

