/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ldap.ldif.support;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.directory.Attribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ldap.core.LdapAttribute;
import org.springframework.ldap.ldif.InvalidAttributeFormatException;
import org.springframework.ldap.ldif.support.AttributeValidationPolicy;
import org.springframework.ldap.support.LdapEncoder;
import org.springframework.util.StringUtils;

public class DefaultAttributeValidationPolicy
implements AttributeValidationPolicy {
    private static Logger log = LoggerFactory.getLogger(DefaultAttributeValidationPolicy.class);
    private static final String DIGIT = "\\p{Digit}";
    private static final String LOW_ALPHA = "\\p{Lower}";
    private static final String HIGH_ALPHA = "\\p{Upper}";
    private static final String ALPHA = "\\p{Alpha}";
    private static final String ALPHANUM = "\\p{Alnum}";
    private static final String HEX = "\\p{XDigit}";
    private static final String SAFE = "[\\x24\\x2D\\x5F\\x2E\\x2B]";
    private static final String EXTRA = "[\\x21\\x2A\\x27\\x7B\\x7D\\x2C]";
    private static final String PUNCTUATION = "[\\x3C\\x3E\\x23\\x25\\x22]";
    private static final String ESCAPE = "%\\p{XDigit}{2}";
    private static final String RESERVED = "[\\x3B\\x2F\\x3F\\x3A\\x40\\x26\\x3D]";
    private static final String UNRESERVED = "[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]";
    private static final String UCHAR = "(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})";
    private static final String XCHAR = "(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|[\\x3B\\x2F\\x3F\\x3A\\x40\\x26\\x3D]|%\\p{XDigit}{2})";
    private static final String DIGITS = "\\p{Digit}+";
    private static final String ATTRIBUTE_SEPARATOR = ":";
    private static final String OPTION_SEPARATOR = ";";
    private static final String BASE64_INDICATOR = ":";
    private static final String URL_INDICATOR = "<";
    private static final String ATTRIBUTE_TYPE_CHARS = "\\p{Alpha}\\p{Digit}-";
    private static final String LDAP_OID = "[[0-9]|[1-9][0-9]+][\\.(?:[0-9]|[1-9][0-9]+)]+";
    private static final String OPTION = "[\\p{Alpha}\\p{Digit}-]+";
    private static final String OPTIONS = "[;[\\p{Alpha}\\p{Digit}-]+]*";
    private static final String ATTRIBUTE_TYPE = "[[0-9]|[1-9][0-9]+][\\.(?:[0-9]|[1-9][0-9]+)]+|\\p{Alnum}[\\p{Alpha}\\p{Digit}-]*";
    private static final String ATTRIBUTE_DESCRIPTION = "([[0-9]|[1-9][0-9]+][\\.(?:[0-9]|[1-9][0-9]+)]+|\\p{Alnum}[\\p{Alpha}\\p{Digit}-]*)([;[\\p{Alpha}\\p{Digit}-]+]*)";
    private static final String SAFE_CHAR = "[\\p{ASCII}&&[^\\x00\\x0A\\x0D]]";
    private static final String SAFE_INIT_CHAR = "[\\p{ASCII}&&[^ \\x00\\x0A\\x0D\\x3A\\x3C]]";
    private static final String SAFE_STRING = "([\\p{ASCII}&&[^ \\x00\\x0A\\x0D\\x3A\\x3C]][\\p{ASCII}&&[^\\x00\\x0A\\x0D]]*)";
    private static final String FILL = "[ ]*";
    private static final String BASE64_CHAR = "[\\x2B\\x2F\\x30-\\x39\\x3D\\x41-\\x5A\\x61-\\x7A]";
    private static final String BASE64_STRING = "([\\x2B\\x2F\\x30-\\x39\\x3D\\x41-\\x5A\\x61-\\x7A]*)";
    private static final String UTF8_CHAR = "[\\p{L}|[0-9]|\\s]";
    private static final String UTF8_STRING = "([\\p{L}|[0-9]|\\s]+)";
    private static final String USER = "[(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})\\x3B\\x3F\\x26\\x3D]*";
    private static final String PASSWORD = "[(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})\\x3B\\x3F\\x26\\x3D]*";
    private static final String DOMAINLABEL = "\\p{Alnum}|\\p{Alnum}[\\p{Alnum}-]*\\p{Alnum}";
    private static final String TOPLABEL = "\\p{Alpha}|\\p{Alpha}[\\p{Alnum}-]*\\p{Alnum}";
    private static final String HOSTNAME = "(?:\\p{Alnum}|\\p{Alnum}[\\p{Alnum}-]*\\p{Alnum}\\.)*\\p{Alpha}|\\p{Alpha}[\\p{Alnum}-]*\\p{Alnum}";
    private static final String IPADDRESS = "(?:\\p{Digit}{1,3}\\.){3}\\p{Digit}{1,3}";
    private static final String HOST = "(?:(?:\\p{Alnum}|\\p{Alnum}[\\p{Alnum}-]*\\p{Alnum}\\.)*\\p{Alpha}|\\p{Alpha}[\\p{Alnum}-]*\\p{Alnum}|(?:\\p{Digit}{1,3}\\.){3}\\p{Digit}{1,3})";
    private static final String PORT = "\\p{Digit}+";
    private static final String HOSTPORT = "(?:(?:\\p{Alnum}|\\p{Alnum}[\\p{Alnum}-]*\\p{Alnum}\\.)*\\p{Alpha}|\\p{Alpha}[\\p{Alnum}-]*\\p{Alnum}|(?:\\p{Digit}{1,3}\\.){3}\\p{Digit}{1,3})(?::\\p{Digit}+)?";
    private static final String URLPATH = "(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|[\\x3B\\x2F\\x3F\\x3A\\x40\\x26\\x3D]|%\\p{XDigit}{2})*";
    private static final String LOGIN = "(?:[(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})\\x3B\\x3F\\x26\\x3D]*(?::[(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})\\x3B\\x3F\\x26\\x3D]*)?@)?(?:(?:\\p{Alnum}|\\p{Alnum}[\\p{Alnum}-]*\\p{Alnum}\\.)*\\p{Alpha}|\\p{Alpha}[\\p{Alnum}-]*\\p{Alnum}|(?:\\p{Digit}{1,3}\\.){3}\\p{Digit}{1,3})(?::\\p{Digit}+)?";
    private static final String SCHEME = "[\\p{Lower}\\p{Digit}\\x2B\\x2D\\x2E]+";
    private static final String IP_SCHEMEPART = "//(?:[(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})\\x3B\\x3F\\x26\\x3D]*(?::[(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})\\x3B\\x3F\\x26\\x3D]*)?@)?(?:(?:\\p{Alnum}|\\p{Alnum}[\\p{Alnum}-]*\\p{Alnum}\\.)*\\p{Alpha}|\\p{Alpha}[\\p{Alnum}-]*\\p{Alnum}|(?:\\p{Digit}{1,3}\\.){3}\\p{Digit}{1,3})(?::\\p{Digit}+)?(?:/(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|[\\x3B\\x2F\\x3F\\x3A\\x40\\x26\\x3D]|%\\p{XDigit}{2})*)?";
    private static final String SCHEMEPART = "(?:(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|[\\x3B\\x2F\\x3F\\x3A\\x40\\x26\\x3D]|%\\p{XDigit}{2})*|//(?:[(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})\\x3B\\x3F\\x26\\x3D]*(?::[(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})\\x3B\\x3F\\x26\\x3D]*)?@)?(?:(?:\\p{Alnum}|\\p{Alnum}[\\p{Alnum}-]*\\p{Alnum}\\.)*\\p{Alpha}|\\p{Alpha}[\\p{Alnum}-]*\\p{Alnum}|(?:\\p{Digit}{1,3}\\.){3}\\p{Digit}{1,3})(?::\\p{Digit}+)?(?:/(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|[\\x3B\\x2F\\x3F\\x3A\\x40\\x26\\x3D]|%\\p{XDigit}{2})*)?)";
    private static final String GENERIC_URL = "[\\p{Lower}\\p{Digit}\\x2B\\x2D\\x2E]+:(?:(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|[\\x3B\\x2F\\x3F\\x3A\\x40\\x26\\x3D]|%\\p{XDigit}{2})*|//(?:[(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})\\x3B\\x3F\\x26\\x3D]*(?::[(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})\\x3B\\x3F\\x26\\x3D]*)?@)?(?:(?:\\p{Alnum}|\\p{Alnum}[\\p{Alnum}-]*\\p{Alnum}\\.)*\\p{Alpha}|\\p{Alpha}[\\p{Alnum}-]*\\p{Alnum}|(?:\\p{Digit}{1,3}\\.){3}\\p{Digit}{1,3})(?::\\p{Digit}+)?(?:/(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|[\\x3B\\x2F\\x3F\\x3A\\x40\\x26\\x3D]|%\\p{XDigit}{2})*)?)";
    private static final String HSEGMENT = "[(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})\\x3A\\x3B\\x26\\x3D\\x40]*";
    private static final String HPATH = "[(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})\\x3A\\x3B\\x26\\x3D\\x40]*[/[(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})\\x3A\\x3B\\x26\\x3D\\x40]*]*";
    private static final String SEARCH = "[(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})\\x3A\\x3B\\x26\\x3D\\x40]*";
    private static final String HTTP_URL = "http://(?:(?:\\p{Alnum}|\\p{Alnum}[\\p{Alnum}-]*\\p{Alnum}\\.)*\\p{Alpha}|\\p{Alpha}[\\p{Alnum}-]*\\p{Alnum}|(?:\\p{Digit}{1,3}\\.){3}\\p{Digit}{1,3})(?::\\p{Digit}+)?(?:/[(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})\\x3A\\x3B\\x26\\x3D\\x40]*[/[(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})\\x3A\\x3B\\x26\\x3D\\x40]*]*(?:\\x3F[(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})\\x3A\\x3B\\x26\\x3D\\x40]*)?)?";
    private static final String FSEGMENT = "[(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})\\x3F\\x3A\\x26\\x3D\\x40]*";
    private static final String FPATH = "[(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})\\x3F\\x3A\\x26\\x3D\\x40]*[/[(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})\\x3F\\x3A\\x26\\x3D\\x40]*]*";
    private static final String FTPTYPE = "[AIDaid]";
    private static final String FTP_URL = "ftp://(?:[(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})\\x3B\\x3F\\x26\\x3D]*(?::[(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})\\x3B\\x3F\\x26\\x3D]*)?@)?(?:(?:\\p{Alnum}|\\p{Alnum}[\\p{Alnum}-]*\\p{Alnum}\\.)*\\p{Alpha}|\\p{Alpha}[\\p{Alnum}-]*\\p{Alnum}|(?:\\p{Digit}{1,3}\\.){3}\\p{Digit}{1,3})(?::\\p{Digit}+)?(?:/[(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})\\x3F\\x3A\\x26\\x3D\\x40]*[/[(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})\\x3F\\x3A\\x26\\x3D\\x40]*]*(?:;type=[AIDaid])?)?";
    private static final String GROUP = "\\p{Alpha}[\\p{Alpha}\\p{Digit}\\x2D\\x2E\\x2B\\x5F]*";
    private static final String ARTICLE = "[(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})\\x3A\\x3B\\x2F\\x3F\\x26\\x3D]@(?:(?:\\p{Alnum}|\\p{Alnum}[\\p{Alnum}-]*\\p{Alnum}\\.)*\\p{Alpha}|\\p{Alpha}[\\p{Alnum}-]*\\p{Alnum}|(?:\\p{Digit}{1,3}\\.){3}\\p{Digit}{1,3})";
    private static final String GROUPPART = "(?:\\x2A|\\p{Alpha}[\\p{Alpha}\\p{Digit}\\x2D\\x2E\\x2B\\x5F]*|[(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})\\x3A\\x3B\\x2F\\x3F\\x26\\x3D]@(?:(?:\\p{Alnum}|\\p{Alnum}[\\p{Alnum}-]*\\p{Alnum}\\.)*\\p{Alpha}|\\p{Alpha}[\\p{Alnum}-]*\\p{Alnum}|(?:\\p{Digit}{1,3}\\.){3}\\p{Digit}{1,3}))";
    private static final String NEWS_URL = "news:(?:\\x2A|\\p{Alpha}[\\p{Alpha}\\p{Digit}\\x2D\\x2E\\x2B\\x5F]*|[(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})\\x3A\\x3B\\x2F\\x3F\\x26\\x3D]@(?:(?:\\p{Alnum}|\\p{Alnum}[\\p{Alnum}-]*\\p{Alnum}\\.)*\\p{Alpha}|\\p{Alpha}[\\p{Alnum}-]*\\p{Alnum}|(?:\\p{Digit}{1,3}\\.){3}\\p{Digit}{1,3}))";
    private static final String NNTP_URL = "nntp://(?:(?:\\p{Alnum}|\\p{Alnum}[\\p{Alnum}-]*\\p{Alnum}\\.)*\\p{Alpha}|\\p{Alpha}[\\p{Alnum}-]*\\p{Alnum}|(?:\\p{Digit}{1,3}\\.){3}\\p{Digit}{1,3})(?::\\p{Digit}+)?/\\p{Alpha}[\\p{Alpha}\\p{Digit}\\x2D\\x2E\\x2B\\x5F]*/\\p{Digit}+";
    private static final String TELNET_URL = "telnet://(?:[(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})\\x3B\\x3F\\x26\\x3D]*(?::[(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})\\x3B\\x3F\\x26\\x3D]*)?@)?(?:(?:\\p{Alnum}|\\p{Alnum}[\\p{Alnum}-]*\\p{Alnum}\\.)*\\p{Alpha}|\\p{Alpha}[\\p{Alnum}-]*\\p{Alnum}|(?:\\p{Digit}{1,3}\\.){3}\\p{Digit}{1,3})(?::\\p{Digit}+)?[/]?";
    private static final String GTYPE = "(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|[\\x3B\\x2F\\x3F\\x3A\\x40\\x26\\x3D]|%\\p{XDigit}{2})";
    private static final String SELECTOR = "(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|[\\x3B\\x2F\\x3F\\x3A\\x40\\x26\\x3D]|%\\p{XDigit}{2})*";
    private static final String GOPHER_STRING = "(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|[\\x3B\\x2F\\x3F\\x3A\\x40\\x26\\x3D]|%\\p{XDigit}{2})*";
    private static final String GOPHER_URL = "gopher://(?:(?:\\p{Alnum}|\\p{Alnum}[\\p{Alnum}-]*\\p{Alnum}\\.)*\\p{Alpha}|\\p{Alpha}[\\p{Alnum}-]*\\p{Alnum}|(?:\\p{Digit}{1,3}\\.){3}\\p{Digit}{1,3})(?::\\p{Digit}+)?(?:/(?:(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|[\\x3B\\x2F\\x3F\\x3A\\x40\\x26\\x3D]|%\\p{XDigit}{2})(?:(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|[\\x3B\\x2F\\x3F\\x3A\\x40\\x26\\x3D]|%\\p{XDigit}{2})*(?:%09[(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})\\x3A\\x3B\\x26\\x3D\\x40]*(?:%09(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|[\\x3B\\x2F\\x3F\\x3A\\x40\\x26\\x3D]|%\\p{XDigit}{2})*)?)?)?)?)?";
    private static final String WPATH = "(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})*";
    private static final String WTYPE = "(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})*";
    private static final String DATABASE = "(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})*";
    private static final String WAIS_DOC = "wais://(?:(?:\\p{Alnum}|\\p{Alnum}[\\p{Alnum}-]*\\p{Alnum}\\.)*\\p{Alpha}|\\p{Alpha}[\\p{Alnum}-]*\\p{Alnum}|(?:\\p{Digit}{1,3}\\.){3}\\p{Digit}{1,3})(?::\\p{Digit}+)?/(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})*/(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})*/(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})*";
    private static final String WAIS_INDEX = "wais://(?:(?:\\p{Alnum}|\\p{Alnum}[\\p{Alnum}-]*\\p{Alnum}\\.)*\\p{Alpha}|\\p{Alpha}[\\p{Alnum}-]*\\p{Alnum}|(?:\\p{Digit}{1,3}\\.){3}\\p{Digit}{1,3})(?::\\p{Digit}+)?/(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})*\\?[(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})\\x3A\\x3B\\x26\\x3D\\x40]*";
    private static final String WAIS_DATABASE = "wais://(?:(?:\\p{Alnum}|\\p{Alnum}[\\p{Alnum}-]*\\p{Alnum}\\.)*\\p{Alpha}|\\p{Alpha}[\\p{Alnum}-]*\\p{Alnum}|(?:\\p{Digit}{1,3}\\.){3}\\p{Digit}{1,3})(?::\\p{Digit}+)?/(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})*";
    private static final String WAIS_URL = "wais://(?:(?:\\p{Alnum}|\\p{Alnum}[\\p{Alnum}-]*\\p{Alnum}\\.)*\\p{Alpha}|\\p{Alpha}[\\p{Alnum}-]*\\p{Alnum}|(?:\\p{Digit}{1,3}\\.){3}\\p{Digit}{1,3})(?::\\p{Digit}+)?/(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})*|wais://(?:(?:\\p{Alnum}|\\p{Alnum}[\\p{Alnum}-]*\\p{Alnum}\\.)*\\p{Alpha}|\\p{Alpha}[\\p{Alnum}-]*\\p{Alnum}|(?:\\p{Digit}{1,3}\\.){3}\\p{Digit}{1,3})(?::\\p{Digit}+)?/(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})*\\?[(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})\\x3A\\x3B\\x26\\x3D\\x40]*|wais://(?:(?:\\p{Alnum}|\\p{Alnum}[\\p{Alnum}-]*\\p{Alnum}\\.)*\\p{Alpha}|\\p{Alpha}[\\p{Alnum}-]*\\p{Alnum}|(?:\\p{Digit}{1,3}\\.){3}\\p{Digit}{1,3})(?::\\p{Digit}+)?/(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})*/(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})*/(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})*";
    private static final String ENCODED_822_ADDR = "(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|[\\x3B\\x2F\\x3F\\x3A\\x40\\x26\\x3D]|%\\p{XDigit}{2})+";
    private static final String MAILTO_URL = "mailto:(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|[\\x3B\\x2F\\x3F\\x3A\\x40\\x26\\x3D]|%\\p{XDigit}{2})+";
    private static final String FILE_URL = "file://(?:(?:(?:\\p{Alnum}|\\p{Alnum}[\\p{Alnum}-]*\\p{Alnum}\\.)*\\p{Alpha}|\\p{Alpha}[\\p{Alnum}-]*\\p{Alnum}|(?:\\p{Digit}{1,3}\\.){3}\\p{Digit}{1,3})|localhost)?/[(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})\\x3F\\x3A\\x26\\x3D\\x40]*[/[(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})\\x3F\\x3A\\x26\\x3D\\x40]*]*";
    private static final String FIELD_VALUE = "[(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})\\x3F\\x3A\\x40\\x26]*";
    private static final String FIELD_NAME = "[(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})\\x3F\\x3A\\x40\\x26]*";
    private static final String FIELD_SPEC = ";[(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})\\x3F\\x3A\\x40\\x26]*=[(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})\\x3F\\x3A\\x40\\x26]*";
    private static final String PSEGMENT = "[(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})\\x3F\\x3A\\x40\\x26\\x3D]*";
    private static final String PPATH = "[(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})\\x3F\\x3A\\x40\\x26\\x3D]*(?:/[(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})\\x3F\\x3A\\x40\\x26\\x3D]*)*";
    private static final String PROSPERO_URL = "prospero://(?:(?:\\p{Alnum}|\\p{Alnum}[\\p{Alnum}-]*\\p{Alnum}\\.)*\\p{Alpha}|\\p{Alpha}[\\p{Alnum}-]*\\p{Alnum}|(?:\\p{Digit}{1,3}\\.){3}\\p{Digit}{1,3})(?::\\p{Digit}+)?/[(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})\\x3F\\x3A\\x40\\x26\\x3D]*(?:/[(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})\\x3F\\x3A\\x40\\x26\\x3D]*)*(?:;[(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})\\x3F\\x3A\\x40\\x26]*=[(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})\\x3F\\x3A\\x40\\x26]*)*";
    private static final String OTHER_URL = "[\\p{Lower}\\p{Digit}\\x2B\\x2D\\x2E]+:(?:(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|[\\x3B\\x2F\\x3F\\x3A\\x40\\x26\\x3D]|%\\p{XDigit}{2})*|//(?:[(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})\\x3B\\x3F\\x26\\x3D]*(?::[(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})\\x3B\\x3F\\x26\\x3D]*)?@)?(?:(?:\\p{Alnum}|\\p{Alnum}[\\p{Alnum}-]*\\p{Alnum}\\.)*\\p{Alpha}|\\p{Alpha}[\\p{Alnum}-]*\\p{Alnum}|(?:\\p{Digit}{1,3}\\.){3}\\p{Digit}{1,3})(?::\\p{Digit}+)?(?:/(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|[\\x3B\\x2F\\x3F\\x3A\\x40\\x26\\x3D]|%\\p{XDigit}{2})*)?)";
    private static final String URL = "((?:http://(?:(?:\\p{Alnum}|\\p{Alnum}[\\p{Alnum}-]*\\p{Alnum}\\.)*\\p{Alpha}|\\p{Alpha}[\\p{Alnum}-]*\\p{Alnum}|(?:\\p{Digit}{1,3}\\.){3}\\p{Digit}{1,3})(?::\\p{Digit}+)?(?:/[(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})\\x3A\\x3B\\x26\\x3D\\x40]*[/[(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})\\x3A\\x3B\\x26\\x3D\\x40]*]*(?:\\x3F[(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})\\x3A\\x3B\\x26\\x3D\\x40]*)?)?)|(?:ftp://(?:[(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})\\x3B\\x3F\\x26\\x3D]*(?::[(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})\\x3B\\x3F\\x26\\x3D]*)?@)?(?:(?:\\p{Alnum}|\\p{Alnum}[\\p{Alnum}-]*\\p{Alnum}\\.)*\\p{Alpha}|\\p{Alpha}[\\p{Alnum}-]*\\p{Alnum}|(?:\\p{Digit}{1,3}\\.){3}\\p{Digit}{1,3})(?::\\p{Digit}+)?(?:/[(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})\\x3F\\x3A\\x26\\x3D\\x40]*[/[(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})\\x3F\\x3A\\x26\\x3D\\x40]*]*(?:;type=[AIDaid])?)?)|(?:news:(?:\\x2A|\\p{Alpha}[\\p{Alpha}\\p{Digit}\\x2D\\x2E\\x2B\\x5F]*|[(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})\\x3A\\x3B\\x2F\\x3F\\x26\\x3D]@(?:(?:\\p{Alnum}|\\p{Alnum}[\\p{Alnum}-]*\\p{Alnum}\\.)*\\p{Alpha}|\\p{Alpha}[\\p{Alnum}-]*\\p{Alnum}|(?:\\p{Digit}{1,3}\\.){3}\\p{Digit}{1,3})))|(?:nntp://(?:(?:\\p{Alnum}|\\p{Alnum}[\\p{Alnum}-]*\\p{Alnum}\\.)*\\p{Alpha}|\\p{Alpha}[\\p{Alnum}-]*\\p{Alnum}|(?:\\p{Digit}{1,3}\\.){3}\\p{Digit}{1,3})(?::\\p{Digit}+)?/\\p{Alpha}[\\p{Alpha}\\p{Digit}\\x2D\\x2E\\x2B\\x5F]*/\\p{Digit}+)|(?:telnet://(?:[(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})\\x3B\\x3F\\x26\\x3D]*(?::[(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})\\x3B\\x3F\\x26\\x3D]*)?@)?(?:(?:\\p{Alnum}|\\p{Alnum}[\\p{Alnum}-]*\\p{Alnum}\\.)*\\p{Alpha}|\\p{Alpha}[\\p{Alnum}-]*\\p{Alnum}|(?:\\p{Digit}{1,3}\\.){3}\\p{Digit}{1,3})(?::\\p{Digit}+)?[/]?)|(?:gopher://(?:(?:\\p{Alnum}|\\p{Alnum}[\\p{Alnum}-]*\\p{Alnum}\\.)*\\p{Alpha}|\\p{Alpha}[\\p{Alnum}-]*\\p{Alnum}|(?:\\p{Digit}{1,3}\\.){3}\\p{Digit}{1,3})(?::\\p{Digit}+)?(?:/(?:(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|[\\x3B\\x2F\\x3F\\x3A\\x40\\x26\\x3D]|%\\p{XDigit}{2})(?:(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|[\\x3B\\x2F\\x3F\\x3A\\x40\\x26\\x3D]|%\\p{XDigit}{2})*(?:%09[(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})\\x3A\\x3B\\x26\\x3D\\x40]*(?:%09(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|[\\x3B\\x2F\\x3F\\x3A\\x40\\x26\\x3D]|%\\p{XDigit}{2})*)?)?)?)?)?)|(?:wais://(?:(?:\\p{Alnum}|\\p{Alnum}[\\p{Alnum}-]*\\p{Alnum}\\.)*\\p{Alpha}|\\p{Alpha}[\\p{Alnum}-]*\\p{Alnum}|(?:\\p{Digit}{1,3}\\.){3}\\p{Digit}{1,3})(?::\\p{Digit}+)?/(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})*|wais://(?:(?:\\p{Alnum}|\\p{Alnum}[\\p{Alnum}-]*\\p{Alnum}\\.)*\\p{Alpha}|\\p{Alpha}[\\p{Alnum}-]*\\p{Alnum}|(?:\\p{Digit}{1,3}\\.){3}\\p{Digit}{1,3})(?::\\p{Digit}+)?/(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})*\\?[(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})\\x3A\\x3B\\x26\\x3D\\x40]*|wais://(?:(?:\\p{Alnum}|\\p{Alnum}[\\p{Alnum}-]*\\p{Alnum}\\.)*\\p{Alpha}|\\p{Alpha}[\\p{Alnum}-]*\\p{Alnum}|(?:\\p{Digit}{1,3}\\.){3}\\p{Digit}{1,3})(?::\\p{Digit}+)?/(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})*/(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})*/(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})*)|(?:mailto:(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|[\\x3B\\x2F\\x3F\\x3A\\x40\\x26\\x3D]|%\\p{XDigit}{2})+)|(?:file://(?:(?:(?:\\p{Alnum}|\\p{Alnum}[\\p{Alnum}-]*\\p{Alnum}\\.)*\\p{Alpha}|\\p{Alpha}[\\p{Alnum}-]*\\p{Alnum}|(?:\\p{Digit}{1,3}\\.){3}\\p{Digit}{1,3})|localhost)?/[(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})\\x3F\\x3A\\x26\\x3D\\x40]*[/[(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})\\x3F\\x3A\\x26\\x3D\\x40]*]*)|(?:prospero://(?:(?:\\p{Alnum}|\\p{Alnum}[\\p{Alnum}-]*\\p{Alnum}\\.)*\\p{Alpha}|\\p{Alpha}[\\p{Alnum}-]*\\p{Alnum}|(?:\\p{Digit}{1,3}\\.){3}\\p{Digit}{1,3})(?::\\p{Digit}+)?/[(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})\\x3F\\x3A\\x40\\x26\\x3D]*(?:/[(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})\\x3F\\x3A\\x40\\x26\\x3D]*)*(?:;[(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})\\x3F\\x3A\\x40\\x26]*=[(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})\\x3F\\x3A\\x40\\x26]*)*)|(?:[\\p{Lower}\\p{Digit}\\x2B\\x2D\\x2E]+:(?:(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|[\\x3B\\x2F\\x3F\\x3A\\x40\\x26\\x3D]|%\\p{XDigit}{2})*|//(?:[(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})\\x3B\\x3F\\x26\\x3D]*(?::[(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})\\x3B\\x3F\\x26\\x3D]*)?@)?(?:(?:\\p{Alnum}|\\p{Alnum}[\\p{Alnum}-]*\\p{Alnum}\\.)*\\p{Alpha}|\\p{Alpha}[\\p{Alnum}-]*\\p{Alnum}|(?:\\p{Digit}{1,3}\\.){3}\\p{Digit}{1,3})(?::\\p{Digit}+)?(?:/(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|[\\x3B\\x2F\\x3F\\x3A\\x40\\x26\\x3D]|%\\p{XDigit}{2})*)?)))";
    private static final String ATTRIBUTE_EXPRESSION = "^([[0-9]|[1-9][0-9]+][\\.(?:[0-9]|[1-9][0-9]+)]+|\\p{Alnum}[\\p{Alpha}\\p{Digit}-]*)([;[\\p{Alpha}\\p{Digit}-]+]*):[ ]*([\\p{ASCII}&&[^ \\x00\\x0A\\x0D\\x3A\\x3C]][\\p{ASCII}&&[^\\x00\\x0A\\x0D]]*){0,1}$";
    private static final String BASE64_ATTRIBUTE_EXPRESSION = "^([[0-9]|[1-9][0-9]+][\\.(?:[0-9]|[1-9][0-9]+)]+|\\p{Alnum}[\\p{Alpha}\\p{Digit}-]*)([;[\\p{Alpha}\\p{Digit}-]+]*)::[ ]*([\\x2B\\x2F\\x30-\\x39\\x3D\\x41-\\x5A\\x61-\\x7A]*)$";
    private static final String URL_ATTRIBUTE_EXPRESSION = "^([[0-9]|[1-9][0-9]+][\\.(?:[0-9]|[1-9][0-9]+)]+|\\p{Alnum}[\\p{Alpha}\\p{Digit}-]*)([;[\\p{Alpha}\\p{Digit}-]+]*):<[ ]*((?:http://(?:(?:\\p{Alnum}|\\p{Alnum}[\\p{Alnum}-]*\\p{Alnum}\\.)*\\p{Alpha}|\\p{Alpha}[\\p{Alnum}-]*\\p{Alnum}|(?:\\p{Digit}{1,3}\\.){3}\\p{Digit}{1,3})(?::\\p{Digit}+)?(?:/[(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})\\x3A\\x3B\\x26\\x3D\\x40]*[/[(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})\\x3A\\x3B\\x26\\x3D\\x40]*]*(?:\\x3F[(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})\\x3A\\x3B\\x26\\x3D\\x40]*)?)?)|(?:ftp://(?:[(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})\\x3B\\x3F\\x26\\x3D]*(?::[(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})\\x3B\\x3F\\x26\\x3D]*)?@)?(?:(?:\\p{Alnum}|\\p{Alnum}[\\p{Alnum}-]*\\p{Alnum}\\.)*\\p{Alpha}|\\p{Alpha}[\\p{Alnum}-]*\\p{Alnum}|(?:\\p{Digit}{1,3}\\.){3}\\p{Digit}{1,3})(?::\\p{Digit}+)?(?:/[(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})\\x3F\\x3A\\x26\\x3D\\x40]*[/[(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})\\x3F\\x3A\\x26\\x3D\\x40]*]*(?:;type=[AIDaid])?)?)|(?:news:(?:\\x2A|\\p{Alpha}[\\p{Alpha}\\p{Digit}\\x2D\\x2E\\x2B\\x5F]*|[(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})\\x3A\\x3B\\x2F\\x3F\\x26\\x3D]@(?:(?:\\p{Alnum}|\\p{Alnum}[\\p{Alnum}-]*\\p{Alnum}\\.)*\\p{Alpha}|\\p{Alpha}[\\p{Alnum}-]*\\p{Alnum}|(?:\\p{Digit}{1,3}\\.){3}\\p{Digit}{1,3})))|(?:nntp://(?:(?:\\p{Alnum}|\\p{Alnum}[\\p{Alnum}-]*\\p{Alnum}\\.)*\\p{Alpha}|\\p{Alpha}[\\p{Alnum}-]*\\p{Alnum}|(?:\\p{Digit}{1,3}\\.){3}\\p{Digit}{1,3})(?::\\p{Digit}+)?/\\p{Alpha}[\\p{Alpha}\\p{Digit}\\x2D\\x2E\\x2B\\x5F]*/\\p{Digit}+)|(?:telnet://(?:[(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})\\x3B\\x3F\\x26\\x3D]*(?::[(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})\\x3B\\x3F\\x26\\x3D]*)?@)?(?:(?:\\p{Alnum}|\\p{Alnum}[\\p{Alnum}-]*\\p{Alnum}\\.)*\\p{Alpha}|\\p{Alpha}[\\p{Alnum}-]*\\p{Alnum}|(?:\\p{Digit}{1,3}\\.){3}\\p{Digit}{1,3})(?::\\p{Digit}+)?[/]?)|(?:gopher://(?:(?:\\p{Alnum}|\\p{Alnum}[\\p{Alnum}-]*\\p{Alnum}\\.)*\\p{Alpha}|\\p{Alpha}[\\p{Alnum}-]*\\p{Alnum}|(?:\\p{Digit}{1,3}\\.){3}\\p{Digit}{1,3})(?::\\p{Digit}+)?(?:/(?:(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|[\\x3B\\x2F\\x3F\\x3A\\x40\\x26\\x3D]|%\\p{XDigit}{2})(?:(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|[\\x3B\\x2F\\x3F\\x3A\\x40\\x26\\x3D]|%\\p{XDigit}{2})*(?:%09[(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})\\x3A\\x3B\\x26\\x3D\\x40]*(?:%09(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|[\\x3B\\x2F\\x3F\\x3A\\x40\\x26\\x3D]|%\\p{XDigit}{2})*)?)?)?)?)?)|(?:wais://(?:(?:\\p{Alnum}|\\p{Alnum}[\\p{Alnum}-]*\\p{Alnum}\\.)*\\p{Alpha}|\\p{Alpha}[\\p{Alnum}-]*\\p{Alnum}|(?:\\p{Digit}{1,3}\\.){3}\\p{Digit}{1,3})(?::\\p{Digit}+)?/(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})*|wais://(?:(?:\\p{Alnum}|\\p{Alnum}[\\p{Alnum}-]*\\p{Alnum}\\.)*\\p{Alpha}|\\p{Alpha}[\\p{Alnum}-]*\\p{Alnum}|(?:\\p{Digit}{1,3}\\.){3}\\p{Digit}{1,3})(?::\\p{Digit}+)?/(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})*\\?[(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})\\x3A\\x3B\\x26\\x3D\\x40]*|wais://(?:(?:\\p{Alnum}|\\p{Alnum}[\\p{Alnum}-]*\\p{Alnum}\\.)*\\p{Alpha}|\\p{Alpha}[\\p{Alnum}-]*\\p{Alnum}|(?:\\p{Digit}{1,3}\\.){3}\\p{Digit}{1,3})(?::\\p{Digit}+)?/(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})*/(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})*/(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})*)|(?:mailto:(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|[\\x3B\\x2F\\x3F\\x3A\\x40\\x26\\x3D]|%\\p{XDigit}{2})+)|(?:file://(?:(?:(?:\\p{Alnum}|\\p{Alnum}[\\p{Alnum}-]*\\p{Alnum}\\.)*\\p{Alpha}|\\p{Alpha}[\\p{Alnum}-]*\\p{Alnum}|(?:\\p{Digit}{1,3}\\.){3}\\p{Digit}{1,3})|localhost)?/[(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})\\x3F\\x3A\\x26\\x3D\\x40]*[/[(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})\\x3F\\x3A\\x26\\x3D\\x40]*]*)|(?:prospero://(?:(?:\\p{Alnum}|\\p{Alnum}[\\p{Alnum}-]*\\p{Alnum}\\.)*\\p{Alpha}|\\p{Alpha}[\\p{Alnum}-]*\\p{Alnum}|(?:\\p{Digit}{1,3}\\.){3}\\p{Digit}{1,3})(?::\\p{Digit}+)?/[(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})\\x3F\\x3A\\x40\\x26\\x3D]*(?:/[(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})\\x3F\\x3A\\x40\\x26\\x3D]*)*(?:;[(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})\\x3F\\x3A\\x40\\x26]*=[(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})\\x3F\\x3A\\x40\\x26]*)*)|(?:[\\p{Lower}\\p{Digit}\\x2B\\x2D\\x2E]+:(?:(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|[\\x3B\\x2F\\x3F\\x3A\\x40\\x26\\x3D]|%\\p{XDigit}{2})*|//(?:[(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})\\x3B\\x3F\\x26\\x3D]*(?::[(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})\\x3B\\x3F\\x26\\x3D]*)?@)?(?:(?:\\p{Alnum}|\\p{Alnum}[\\p{Alnum}-]*\\p{Alnum}\\.)*\\p{Alpha}|\\p{Alpha}[\\p{Alnum}-]*\\p{Alnum}|(?:\\p{Digit}{1,3}\\.){3}\\p{Digit}{1,3})(?::\\p{Digit}+)?(?:/(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|[\\x3B\\x2F\\x3F\\x3A\\x40\\x26\\x3D]|%\\p{XDigit}{2})*)?)))$";
    private static final String UTF8_ATTRIBUTE_EXPRESSION = "^([[0-9]|[1-9][0-9]+][\\.(?:[0-9]|[1-9][0-9]+)]+|\\p{Alnum}[\\p{Alpha}\\p{Digit}-]*)([;[\\p{Alpha}\\p{Digit}-]+]*):[ ]*([\\p{L}|[0-9]|\\s]+)";
    private static final Pattern ATTRIBUTE_PATTERN = Pattern.compile("^([[0-9]|[1-9][0-9]+][\\.(?:[0-9]|[1-9][0-9]+)]+|\\p{Alnum}[\\p{Alpha}\\p{Digit}-]*)([;[\\p{Alpha}\\p{Digit}-]+]*):[ ]*([\\p{ASCII}&&[^ \\x00\\x0A\\x0D\\x3A\\x3C]][\\p{ASCII}&&[^\\x00\\x0A\\x0D]]*){0,1}$");
    private static final Pattern BASE64_ATTRIBUTE_PATTERN = Pattern.compile("^([[0-9]|[1-9][0-9]+][\\.(?:[0-9]|[1-9][0-9]+)]+|\\p{Alnum}[\\p{Alpha}\\p{Digit}-]*)([;[\\p{Alpha}\\p{Digit}-]+]*)::[ ]*([\\x2B\\x2F\\x30-\\x39\\x3D\\x41-\\x5A\\x61-\\x7A]*)$");
    private static final Pattern URL_ATTRIBUTE_PATTERN = Pattern.compile("^([[0-9]|[1-9][0-9]+][\\.(?:[0-9]|[1-9][0-9]+)]+|\\p{Alnum}[\\p{Alpha}\\p{Digit}-]*)([;[\\p{Alpha}\\p{Digit}-]+]*):<[ ]*((?:http://(?:(?:\\p{Alnum}|\\p{Alnum}[\\p{Alnum}-]*\\p{Alnum}\\.)*\\p{Alpha}|\\p{Alpha}[\\p{Alnum}-]*\\p{Alnum}|(?:\\p{Digit}{1,3}\\.){3}\\p{Digit}{1,3})(?::\\p{Digit}+)?(?:/[(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})\\x3A\\x3B\\x26\\x3D\\x40]*[/[(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})\\x3A\\x3B\\x26\\x3D\\x40]*]*(?:\\x3F[(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})\\x3A\\x3B\\x26\\x3D\\x40]*)?)?)|(?:ftp://(?:[(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})\\x3B\\x3F\\x26\\x3D]*(?::[(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})\\x3B\\x3F\\x26\\x3D]*)?@)?(?:(?:\\p{Alnum}|\\p{Alnum}[\\p{Alnum}-]*\\p{Alnum}\\.)*\\p{Alpha}|\\p{Alpha}[\\p{Alnum}-]*\\p{Alnum}|(?:\\p{Digit}{1,3}\\.){3}\\p{Digit}{1,3})(?::\\p{Digit}+)?(?:/[(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})\\x3F\\x3A\\x26\\x3D\\x40]*[/[(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})\\x3F\\x3A\\x26\\x3D\\x40]*]*(?:;type=[AIDaid])?)?)|(?:news:(?:\\x2A|\\p{Alpha}[\\p{Alpha}\\p{Digit}\\x2D\\x2E\\x2B\\x5F]*|[(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})\\x3A\\x3B\\x2F\\x3F\\x26\\x3D]@(?:(?:\\p{Alnum}|\\p{Alnum}[\\p{Alnum}-]*\\p{Alnum}\\.)*\\p{Alpha}|\\p{Alpha}[\\p{Alnum}-]*\\p{Alnum}|(?:\\p{Digit}{1,3}\\.){3}\\p{Digit}{1,3})))|(?:nntp://(?:(?:\\p{Alnum}|\\p{Alnum}[\\p{Alnum}-]*\\p{Alnum}\\.)*\\p{Alpha}|\\p{Alpha}[\\p{Alnum}-]*\\p{Alnum}|(?:\\p{Digit}{1,3}\\.){3}\\p{Digit}{1,3})(?::\\p{Digit}+)?/\\p{Alpha}[\\p{Alpha}\\p{Digit}\\x2D\\x2E\\x2B\\x5F]*/\\p{Digit}+)|(?:telnet://(?:[(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})\\x3B\\x3F\\x26\\x3D]*(?::[(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})\\x3B\\x3F\\x26\\x3D]*)?@)?(?:(?:\\p{Alnum}|\\p{Alnum}[\\p{Alnum}-]*\\p{Alnum}\\.)*\\p{Alpha}|\\p{Alpha}[\\p{Alnum}-]*\\p{Alnum}|(?:\\p{Digit}{1,3}\\.){3}\\p{Digit}{1,3})(?::\\p{Digit}+)?[/]?)|(?:gopher://(?:(?:\\p{Alnum}|\\p{Alnum}[\\p{Alnum}-]*\\p{Alnum}\\.)*\\p{Alpha}|\\p{Alpha}[\\p{Alnum}-]*\\p{Alnum}|(?:\\p{Digit}{1,3}\\.){3}\\p{Digit}{1,3})(?::\\p{Digit}+)?(?:/(?:(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|[\\x3B\\x2F\\x3F\\x3A\\x40\\x26\\x3D]|%\\p{XDigit}{2})(?:(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|[\\x3B\\x2F\\x3F\\x3A\\x40\\x26\\x3D]|%\\p{XDigit}{2})*(?:%09[(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})\\x3A\\x3B\\x26\\x3D\\x40]*(?:%09(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|[\\x3B\\x2F\\x3F\\x3A\\x40\\x26\\x3D]|%\\p{XDigit}{2})*)?)?)?)?)?)|(?:wais://(?:(?:\\p{Alnum}|\\p{Alnum}[\\p{Alnum}-]*\\p{Alnum}\\.)*\\p{Alpha}|\\p{Alpha}[\\p{Alnum}-]*\\p{Alnum}|(?:\\p{Digit}{1,3}\\.){3}\\p{Digit}{1,3})(?::\\p{Digit}+)?/(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})*|wais://(?:(?:\\p{Alnum}|\\p{Alnum}[\\p{Alnum}-]*\\p{Alnum}\\.)*\\p{Alpha}|\\p{Alpha}[\\p{Alnum}-]*\\p{Alnum}|(?:\\p{Digit}{1,3}\\.){3}\\p{Digit}{1,3})(?::\\p{Digit}+)?/(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})*\\?[(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})\\x3A\\x3B\\x26\\x3D\\x40]*|wais://(?:(?:\\p{Alnum}|\\p{Alnum}[\\p{Alnum}-]*\\p{Alnum}\\.)*\\p{Alpha}|\\p{Alpha}[\\p{Alnum}-]*\\p{Alnum}|(?:\\p{Digit}{1,3}\\.){3}\\p{Digit}{1,3})(?::\\p{Digit}+)?/(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})*/(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})*/(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})*)|(?:mailto:(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|[\\x3B\\x2F\\x3F\\x3A\\x40\\x26\\x3D]|%\\p{XDigit}{2})+)|(?:file://(?:(?:(?:\\p{Alnum}|\\p{Alnum}[\\p{Alnum}-]*\\p{Alnum}\\.)*\\p{Alpha}|\\p{Alpha}[\\p{Alnum}-]*\\p{Alnum}|(?:\\p{Digit}{1,3}\\.){3}\\p{Digit}{1,3})|localhost)?/[(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})\\x3F\\x3A\\x26\\x3D\\x40]*[/[(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})\\x3F\\x3A\\x26\\x3D\\x40]*]*)|(?:prospero://(?:(?:\\p{Alnum}|\\p{Alnum}[\\p{Alnum}-]*\\p{Alnum}\\.)*\\p{Alpha}|\\p{Alpha}[\\p{Alnum}-]*\\p{Alnum}|(?:\\p{Digit}{1,3}\\.){3}\\p{Digit}{1,3})(?::\\p{Digit}+)?/[(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})\\x3F\\x3A\\x40\\x26\\x3D]*(?:/[(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})\\x3F\\x3A\\x40\\x26\\x3D]*)*(?:;[(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})\\x3F\\x3A\\x40\\x26]*=[(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})\\x3F\\x3A\\x40\\x26]*)*)|(?:[\\p{Lower}\\p{Digit}\\x2B\\x2D\\x2E]+:(?:(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|[\\x3B\\x2F\\x3F\\x3A\\x40\\x26\\x3D]|%\\p{XDigit}{2})*|//(?:[(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})\\x3B\\x3F\\x26\\x3D]*(?::[(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|%\\p{XDigit}{2})\\x3B\\x3F\\x26\\x3D]*)?@)?(?:(?:\\p{Alnum}|\\p{Alnum}[\\p{Alnum}-]*\\p{Alnum}\\.)*\\p{Alpha}|\\p{Alpha}[\\p{Alnum}-]*\\p{Alnum}|(?:\\p{Digit}{1,3}\\.){3}\\p{Digit}{1,3})(?::\\p{Digit}+)?(?:/(?:[\\p{Alpha}\\p{Digit}[\\x24\\x2D\\x5F\\x2E\\x2B][\\x21\\x2A\\x27\\x7B\\x7D\\x2C]]|[\\x3B\\x2F\\x3F\\x3A\\x40\\x26\\x3D]|%\\p{XDigit}{2})*)?)))$");
    private static final Pattern UTF8_ATTRIBUTE_PATTERN = Pattern.compile("^([[0-9]|[1-9][0-9]+][\\.(?:[0-9]|[1-9][0-9]+)]+|\\p{Alnum}[\\p{Alpha}\\p{Digit}-]*)([;[\\p{Alpha}\\p{Digit}-]+]*):[ ]*([\\p{L}|[0-9]|\\s]+)");
    private boolean ordered = false;

    public DefaultAttributeValidationPolicy() {
    }

    public DefaultAttributeValidationPolicy(boolean ordered) {
        this.ordered = ordered;
    }

    public void setOrdered(boolean ordered) {
        this.ordered = ordered;
    }

    @Override
    public Attribute parse(String buffer) {
        log.trace("Parsing --> [" + buffer + "]");
        Matcher matcher = ATTRIBUTE_PATTERN.matcher(buffer);
        if (matcher.matches()) {
            return this.parseStringAttribute(matcher);
        }
        matcher = BASE64_ATTRIBUTE_PATTERN.matcher(buffer);
        if (matcher.matches()) {
            return this.parseBase64Attribute(matcher);
        }
        matcher = URL_ATTRIBUTE_PATTERN.matcher(buffer);
        if (matcher.matches()) {
            return this.parseUrlAttribute(matcher);
        }
        matcher = UTF8_ATTRIBUTE_PATTERN.matcher(buffer);
        if (matcher.matches()) {
            return this.parseUtf8Attribute(matcher);
        }
        throw new InvalidAttributeFormatException("Not a valid attribute: [" + buffer + "]");
    }

    private LdapAttribute parseStringAttribute(Matcher matcher) {
        String id = matcher.group(1);
        String value = matcher.group(3);
        List<String> options = Arrays.asList(!StringUtils.hasLength((String)matcher.group(2)) ? new String[]{} : matcher.group(2).replaceFirst(OPTION_SEPARATOR, "").split(OPTION_SEPARATOR));
        if (options.isEmpty()) {
            return new LdapAttribute(id, (Object)value, this.ordered);
        }
        return new LdapAttribute(id, (Object)value, options, this.ordered);
    }

    private LdapAttribute parseBase64Attribute(Matcher matcher) {
        try {
            String id = matcher.group(1);
            String value = matcher.group(3);
            List<String> options = Arrays.asList(StringUtils.isEmpty((Object)matcher.group(2)) ? new String[]{} : matcher.group(2).replaceFirst(OPTION_SEPARATOR, "").split(OPTION_SEPARATOR));
            if (options.isEmpty()) {
                return new LdapAttribute(id, (Object)LdapEncoder.parseBase64Binary((String)value), this.ordered);
            }
            return new LdapAttribute(id, (Object)LdapEncoder.parseBase64Binary((String)value), options, this.ordered);
        }
        catch (IllegalArgumentException ex) {
            throw new InvalidAttributeFormatException(ex);
        }
    }

    private LdapAttribute parseUrlAttribute(Matcher matcher) {
        try {
            String id = matcher.group(1);
            String value = matcher.group(3);
            List<String> options = Arrays.asList(StringUtils.isEmpty((Object)matcher.group(2)) ? new String[]{} : matcher.group(2).replaceFirst(OPTION_SEPARATOR, "").split(OPTION_SEPARATOR));
            if (options.isEmpty()) {
                return new LdapAttribute(id, (Object)new URI(value), this.ordered);
            }
            return new LdapAttribute(id, (Object)new URI(value), options, this.ordered);
        }
        catch (URISyntaxException ex) {
            throw new InvalidAttributeFormatException(ex);
        }
    }

    private LdapAttribute parseUtf8Attribute(Matcher matcher) {
        String id = matcher.group(1);
        String value = matcher.group(3);
        List<String> options = Arrays.asList(!StringUtils.hasLength((String)matcher.group(2)) ? new String[]{} : matcher.group(2).replaceFirst(OPTION_SEPARATOR, "").split(OPTION_SEPARATOR));
        if (options.isEmpty()) {
            return new LdapAttribute(id, (Object)value, this.ordered);
        }
        return new LdapAttribute(id, (Object)value, options, this.ordered);
    }
}

