/*
 * Decompiled with CFR 0.152.
 */
package org.herasaf.xacml.core.combiningAlgorithm.policy.impl;

import java.util.ArrayList;
import java.util.List;
import org.herasaf.xacml.core.combiningAlgorithm.CombiningAlgorithm;
import org.herasaf.xacml.core.combiningAlgorithm.policy.PolicyUnorderedCombiningAlgorithm;
import org.herasaf.xacml.core.context.EvaluationContext;
import org.herasaf.xacml.core.context.StatusCode;
import org.herasaf.xacml.core.context.XACMLDefaultStatusCode;
import org.herasaf.xacml.core.context.impl.DecisionType;
import org.herasaf.xacml.core.context.impl.MissingAttributeDetailType;
import org.herasaf.xacml.core.context.impl.RequestType;
import org.herasaf.xacml.core.policy.Evaluatable;
import org.herasaf.xacml.core.policy.impl.EffectType;
import org.herasaf.xacml.core.policy.impl.IdReferenceType;
import org.herasaf.xacml.core.policy.impl.ObligationType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class PolicyOnlyOneApplicableAlgorithm
extends PolicyUnorderedCombiningAlgorithm {
    public static final String ID = "urn:oasis:names:tc:xacml:1.0:policy-combining-algorithm:only-one-applicable";
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(PolicyOnlyOneApplicableAlgorithm.class);

    @Override
    public DecisionType evaluateEvaluatableList(RequestType request, List<Evaluatable> possiblePolicies, EvaluationContext evaluationContext) {
        if (possiblePolicies == null) {
            logger.error("The possiblePolicies list was null. This is an illegal state.");
            evaluationContext.updateStatusCode(XACMLDefaultStatusCode.SYNTAX_ERROR);
            return DecisionType.INDETERMINATE;
        }
        DecisionType firstApplicableDecision = null;
        StatusCode statusCode = null;
        ArrayList<MissingAttributeDetailType> missingAttributes = new ArrayList<MissingAttributeDetailType>();
        ArrayList<ObligationType> obligationsOfFirstApplicableEval = new ArrayList<ObligationType>();
        block3: for (int i = 0; i < possiblePolicies.size(); ++i) {
            DecisionType decision;
            CombiningAlgorithm combiningAlg;
            Evaluatable eval = possiblePolicies.get(i);
            if (eval instanceof IdReferenceType) {
                eval = evaluationContext.getPolicyRetrievalPoint().getEvaluatable(eval.getId());
            }
            if (eval == null) {
                logger.error("The list of possible policies must not contain any null values.");
                evaluationContext.updateStatusCode(XACMLDefaultStatusCode.SYNTAX_ERROR);
                return DecisionType.INDETERMINATE;
            }
            evaluationContext.resetStatus();
            if (logger.isDebugEnabled()) {
                MDC.put((String)"org:herasaf:xacml:evaluation:evaluatableid", (String)eval.getId().toString());
                logger.debug("Starting evaluation of: {}", (Object)eval.getId().toString());
            }
            if ((combiningAlg = eval.getCombiningAlg()) == null) {
                logger.error("Unable to locate combining algorithm for policy {}", (Object)eval.getId());
                evaluationContext.updateStatusCode(XACMLDefaultStatusCode.SYNTAX_ERROR);
                decision = DecisionType.INDETERMINATE;
            } else {
                decision = combiningAlg.evaluate(request, eval, evaluationContext);
            }
            if (logger.isDebugEnabled()) {
                MDC.put((String)"org:herasaf:xacml:evaluation:evaluatableid", (String)eval.getId().toString());
                logger.debug("Evaluation of {} was: {}", (Object)eval.getId().toString(), (Object)decision.toString());
                MDC.remove((String)"org:herasaf:xacml:evaluation:evaluatableid");
            }
            if (decision == DecisionType.PERMIT || decision == DecisionType.DENY) {
                obligationsOfFirstApplicableEval.addAll(eval.getContainedObligations(EffectType.fromValue(decision.toString())));
                obligationsOfFirstApplicableEval.addAll(evaluationContext.getObligations().getObligations());
            }
            evaluationContext.clearObligations();
            switch (decision) {
                case NOT_APPLICABLE: {
                    if (!evaluationContext.isTargetMatched()) continue block3;
                    if (firstApplicableDecision != null) {
                        evaluationContext.resetStatus();
                        evaluationContext.updateStatusCode(XACMLDefaultStatusCode.PROCESSING_ERROR);
                        return DecisionType.INDETERMINATE;
                    }
                    statusCode = evaluationContext.getStatusCode();
                    missingAttributes.addAll(evaluationContext.getMissingAttributes());
                    firstApplicableDecision = decision;
                    continue block3;
                }
                default: {
                    if (firstApplicableDecision == null) {
                        firstApplicableDecision = decision;
                        statusCode = evaluationContext.getStatusCode();
                        missingAttributes.addAll(evaluationContext.getMissingAttributes());
                        continue block3;
                    }
                    evaluationContext.resetStatus();
                    evaluationContext.updateStatusCode(XACMLDefaultStatusCode.PROCESSING_ERROR);
                    return DecisionType.INDETERMINATE;
                }
            }
        }
        evaluationContext.resetStatus();
        if (firstApplicableDecision != null) {
            evaluationContext.setMissingAttributes(missingAttributes);
            evaluationContext.updateStatusCode(statusCode);
            if (firstApplicableDecision == DecisionType.DENY) {
                evaluationContext.addObligations(obligationsOfFirstApplicableEval, EffectType.DENY);
            } else if (firstApplicableDecision == DecisionType.PERMIT) {
                evaluationContext.addObligations(obligationsOfFirstApplicableEval, EffectType.PERMIT);
            }
            return firstApplicableDecision;
        }
        return DecisionType.NOT_APPLICABLE;
    }

    @Override
    public String getCombiningAlgorithmId() {
        return ID;
    }
}

