/*
 * Decompiled with CFR 0.152.
 */
package org.herasaf.xacml.core.combiningAlgorithm.rule;

import org.herasaf.xacml.core.combiningAlgorithm.rule.AbstractRuleCombiningAlgorithm;
import org.herasaf.xacml.core.context.EvaluationContext;
import org.herasaf.xacml.core.context.XACMLDefaultStatusCode;
import org.herasaf.xacml.core.context.impl.DecisionType;
import org.herasaf.xacml.core.context.impl.RequestType;
import org.herasaf.xacml.core.policy.Evaluatable;
import org.herasaf.xacml.core.policy.impl.PolicyType;
import org.herasaf.xacml.core.targetMatcher.TargetMatchingResult;

public abstract class RuleUnorderedCombiningAlgorithm
extends AbstractRuleCombiningAlgorithm {
    private static final long serialVersionUID = 1L;

    @Override
    public DecisionType evaluate(RequestType request, Evaluatable evals, EvaluationContext evaluationContext) {
        TargetMatchingResult decision = this.matchTarget(request, evals.getTarget(), evaluationContext);
        if (decision == TargetMatchingResult.NO_MATCH) {
            return DecisionType.NOT_APPLICABLE;
        }
        if (decision == TargetMatchingResult.INDETERMINATE) {
            return DecisionType.INDETERMINATE;
        }
        try {
            evaluationContext.setVariableDefinitions(((PolicyType)evals).getVariables());
            DecisionType dec = this.evaluateRuleList(request, ((PolicyType)evals).getUnorderedRules(), evaluationContext);
            evaluationContext.setTargetMatched(true);
            return dec;
        }
        catch (ClassCastException e) {
            evaluationContext.updateStatusCode(XACMLDefaultStatusCode.SYNTAX_ERROR);
            return DecisionType.INDETERMINATE;
        }
    }
}

