/*
 * Decompiled with CFR 0.152.
 */
package org.herasaf.xacml.core.function.impl.nonNumericComparisonFunctions;

import org.herasaf.xacml.core.function.AbstractFunction;
import org.herasaf.xacml.core.function.FunctionProcessingException;
import org.herasaf.xacml.core.types.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateGreaterThanOrEqualFunction
extends AbstractFunction {
    public static final String ID = "urn:oasis:names:tc:xacml:1.0:function:date-greater-than-or-equal";
    private static final Logger logger = LoggerFactory.getLogger(DateGreaterThanOrEqualFunction.class);
    private static final long serialVersionUID = 1L;

    @Override
    public Object handle(Object ... args) throws FunctionProcessingException {
        try {
            if (args.length != 2) {
                logger.error("Function {} requires two arguments but {} arguments were passed.", (Object)ID, (Object)args.length);
                throw new FunctionProcessingException("Invalid number of parameters");
            }
            int result = ((Date)args[0]).compareTo((Date)args[1]);
            if (result < 0) {
                return false;
            }
            if (result > 0) {
                return true;
            }
            return true;
        }
        catch (IllegalArgumentException e) {
            logger.error("Either argument is not supported by this function.");
            throw new FunctionProcessingException(e);
        }
        catch (Exception e) {
            logger.error("An unexpected error occured.");
            throw new FunctionProcessingException(e);
        }
    }

    @Override
    public String getFunctionId() {
        return ID;
    }
}

