/*
 * Decompiled with CFR 0.152.
 */
package org.herasaf.xacml.core.policy;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.PropertyException;
import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.ValidationEventHandler;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import org.herasaf.xacml.core.NotInitializedException;
import org.herasaf.xacml.core.SyntaxException;
import org.herasaf.xacml.core.WritingException;
import org.herasaf.xacml.core.policy.Evaluatable;
import org.herasaf.xacml.core.policy.impl.ObjectFactory;
import org.herasaf.xacml.core.policy.impl.PolicySetType;
import org.herasaf.xacml.core.policy.impl.PolicyType;
import org.herasaf.xacml.core.utils.DefaultValidationEventHandler;
import org.herasaf.xacml.core.utils.JAXBMarshallerConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;

public final class PolicyMarshaller {
    private static final transient Logger LOGGER = LoggerFactory.getLogger(PolicyMarshaller.class);
    private static JAXBContext CONTEXT;
    private static JAXBMarshallerConfiguration CONFIGURATION;
    private static final ObjectFactory OBJECT_FACTORY;

    public static void setJAXBContext(JAXBContext policyContext) {
        CONTEXT = policyContext;
    }

    public static void setJAXBMarshallerConfiguration(JAXBMarshallerConfiguration jmc) {
        CONFIGURATION = jmc;
    }

    private PolicyMarshaller() {
    }

    private static Marshaller createMarshaller() throws JAXBException, PropertyException {
        if (CONTEXT == null || CONFIGURATION == null) {
            throw new NotInitializedException("JAXB Context and/or Configuration not initialized.");
        }
        Marshaller marshaller = CONTEXT.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)CONFIGURATION.isFormattedOutput());
        marshaller.setProperty("jaxb.fragment", (Object)CONFIGURATION.isFragment());
        if (CONFIGURATION.isWriteSchemaLocation()) {
            if ("".equals(CONFIGURATION)) {
                LOGGER.error("SchemaLocation not initialized.");
                throw new NotInitializedException("SchemaLocation not initialized.");
            }
            marshaller.setProperty("jaxb.schemaLocation", (Object)CONFIGURATION.getSchemaLocationAsString());
        }
        if (CONFIGURATION.isValidateWriting()) {
            if (CONFIGURATION.getSchema() == null) {
                LOGGER.error("Schema not initialized.");
                throw new NotInitializedException("Schema not initialized");
            }
            marshaller.setSchema(CONFIGURATION.getSchema());
        }
        if (CONFIGURATION.getValidationEventHandler() == null) {
            marshaller.setEventHandler((ValidationEventHandler)new DefaultValidationEventHandler());
        } else {
            marshaller.setEventHandler(CONFIGURATION.getValidationEventHandler());
        }
        return marshaller;
    }

    private static Unmarshaller createUnmarshaller() throws JAXBException, PropertyException {
        if (CONTEXT == null || CONFIGURATION == null) {
            throw new NotInitializedException("JAXB Context and/or Configuration not initialized.");
        }
        Unmarshaller unmarshaller = CONTEXT.createUnmarshaller();
        if (CONFIGURATION.isValidateParsing()) {
            if (CONFIGURATION.getSchema() == null) {
                LOGGER.error("Schema not initialized.");
                throw new NotInitializedException("Schema not initialized");
            }
            unmarshaller.setSchema(CONFIGURATION.getSchema());
        }
        if (CONFIGURATION.getValidationEventHandler() == null) {
            unmarshaller.setEventHandler((ValidationEventHandler)new DefaultValidationEventHandler());
        } else {
            unmarshaller.setEventHandler(CONFIGURATION.getValidationEventHandler());
        }
        return unmarshaller;
    }

    public static void marshal(Evaluatable evaluatable, ContentHandler ch) throws WritingException {
        block7: {
            Marshaller marshaller;
            try {
                marshaller = PolicyMarshaller.createMarshaller();
            }
            catch (PropertyException e) {
                WritingException we = new WritingException("Unable to create a JAXB Marshaller.", e);
                LOGGER.error(we.getMessage());
                throw we;
            }
            catch (JAXBException e) {
                WritingException we = new WritingException("Unable to create a JAXB Marshaller.", e);
                LOGGER.error(we.getMessage());
                throw we;
            }
            try {
                if (evaluatable instanceof PolicySetType) {
                    marshaller.marshal(OBJECT_FACTORY.createPolicySet((PolicySetType)evaluatable), ch);
                    break block7;
                }
                if (evaluatable instanceof PolicyType) {
                    marshaller.marshal(OBJECT_FACTORY.createPolicy((PolicyType)evaluatable), ch);
                    break block7;
                }
                WritingException e = new WritingException("Unable to marshal an object of type: " + evaluatable.getClass());
                LOGGER.error(e.getMessage());
                throw e;
            }
            catch (JAXBException e) {
                WritingException ie = new WritingException("Unable to write to the context handler.", e);
                LOGGER.error(ie.getMessage());
                throw ie;
            }
        }
    }

    public static void marshal(Evaluatable evaluatable, File file) throws WritingException {
        block7: {
            Marshaller marshaller;
            try {
                marshaller = PolicyMarshaller.createMarshaller();
            }
            catch (PropertyException e) {
                WritingException we = new WritingException("Unable to create a JAXB Marshaller.", e);
                LOGGER.error(we.getMessage());
                throw we;
            }
            catch (JAXBException e) {
                WritingException we = new WritingException("Unable to create a JAXB Marshaller.", e);
                LOGGER.error(we.getMessage());
                throw we;
            }
            try {
                if (evaluatable instanceof PolicySetType) {
                    marshaller.marshal(OBJECT_FACTORY.createPolicySet((PolicySetType)evaluatable), file);
                    break block7;
                }
                if (evaluatable instanceof PolicyType) {
                    marshaller.marshal(OBJECT_FACTORY.createPolicy((PolicyType)evaluatable), file);
                    break block7;
                }
                WritingException e = new WritingException("Unable to marshal an object of type: " + evaluatable.getClass());
                LOGGER.error(e.getMessage());
                throw e;
            }
            catch (JAXBException e) {
                WritingException ie = new WritingException("Unable to write to the file.", e);
                LOGGER.error(ie.getMessage());
                throw ie;
            }
        }
    }

    public static void marshal(Evaluatable evaluatable, Result result) throws WritingException {
        block7: {
            Marshaller marshaller;
            try {
                marshaller = PolicyMarshaller.createMarshaller();
            }
            catch (PropertyException e) {
                WritingException we = new WritingException("Unable to create a JAXB Marshaller.", e);
                LOGGER.error(we.getMessage());
                throw we;
            }
            catch (JAXBException e) {
                WritingException we = new WritingException("Unable to create a JAXB Marshaller.", e);
                LOGGER.error(we.getMessage());
                throw we;
            }
            try {
                if (evaluatable instanceof PolicySetType) {
                    marshaller.marshal(OBJECT_FACTORY.createPolicySet((PolicySetType)evaluatable), result);
                    break block7;
                }
                if (evaluatable instanceof PolicyType) {
                    marshaller.marshal(OBJECT_FACTORY.createPolicy((PolicyType)evaluatable), result);
                    break block7;
                }
                WritingException e = new WritingException("Unable to marshal an object of type: " + evaluatable.getClass());
                LOGGER.error(e.getMessage());
                throw e;
            }
            catch (JAXBException e) {
                WritingException ie = new WritingException("Unable to write to the result.", e);
                LOGGER.error(ie.getMessage());
                throw ie;
            }
        }
    }

    public static void marshal(Evaluatable evaluatable, OutputStream out) throws WritingException {
        block7: {
            Marshaller marshaller;
            try {
                marshaller = PolicyMarshaller.createMarshaller();
            }
            catch (PropertyException e) {
                WritingException we = new WritingException("Unable to create a JAXB Marshaller.", e);
                LOGGER.error(we.getMessage());
                throw we;
            }
            catch (JAXBException e) {
                WritingException we = new WritingException("Unable to create a JAXB Marshaller.", e);
                LOGGER.error(we.getMessage());
                throw we;
            }
            try {
                if (evaluatable instanceof PolicySetType) {
                    marshaller.marshal(OBJECT_FACTORY.createPolicySet((PolicySetType)evaluatable), out);
                    break block7;
                }
                if (evaluatable instanceof PolicyType) {
                    marshaller.marshal(OBJECT_FACTORY.createPolicy((PolicyType)evaluatable), out);
                    break block7;
                }
                WritingException e = new WritingException("Unable to marshal an object of type: " + evaluatable.getClass());
                LOGGER.error(e.getMessage());
                throw e;
            }
            catch (JAXBException e) {
                WritingException ie = new WritingException("Unable to write to the output stream.", e);
                LOGGER.error(ie.getMessage());
                throw ie;
            }
        }
    }

    public static void marshal(Evaluatable evaluatable, Writer writer) throws WritingException {
        block7: {
            Marshaller marshaller;
            try {
                marshaller = PolicyMarshaller.createMarshaller();
            }
            catch (PropertyException e) {
                WritingException we = new WritingException("Unable to create a JAXB Marshaller.", e);
                LOGGER.error(we.getMessage());
                throw we;
            }
            catch (JAXBException e) {
                WritingException we = new WritingException("Unable to create a JAXB Marshaller.", e);
                LOGGER.error(we.getMessage());
                throw we;
            }
            try {
                if (evaluatable instanceof PolicySetType) {
                    marshaller.marshal(OBJECT_FACTORY.createPolicySet((PolicySetType)evaluatable), writer);
                    break block7;
                }
                if (evaluatable instanceof PolicyType) {
                    marshaller.marshal(OBJECT_FACTORY.createPolicy((PolicyType)evaluatable), writer);
                    break block7;
                }
                WritingException e = new WritingException("Unable to marshal an object of type: " + evaluatable.getClass());
                LOGGER.error(e.getMessage());
                throw e;
            }
            catch (JAXBException e) {
                WritingException ie = new WritingException("Unable to write to the writer.", e);
                LOGGER.error(ie.getMessage());
                throw ie;
            }
        }
    }

    public static void marshal(Evaluatable evaluatable, Node node) throws WritingException {
        block7: {
            Marshaller marshaller;
            try {
                marshaller = PolicyMarshaller.createMarshaller();
            }
            catch (PropertyException e) {
                WritingException we = new WritingException("Unable to create a JAXB Marshaller.", e);
                LOGGER.error(we.getMessage());
                throw we;
            }
            catch (JAXBException e) {
                WritingException we = new WritingException("Unable to create a JAXB Marshaller.", e);
                LOGGER.error(we.getMessage());
                throw we;
            }
            try {
                if (evaluatable instanceof PolicySetType) {
                    marshaller.marshal(OBJECT_FACTORY.createPolicySet((PolicySetType)evaluatable), node);
                    break block7;
                }
                if (evaluatable instanceof PolicyType) {
                    marshaller.marshal(OBJECT_FACTORY.createPolicy((PolicyType)evaluatable), node);
                    break block7;
                }
                WritingException e = new WritingException("Unable to marshal an object of type: " + evaluatable.getClass());
                LOGGER.error(e.getMessage());
                throw e;
            }
            catch (JAXBException e) {
                WritingException ie = new WritingException("Unable to write to the node.", e);
                LOGGER.error(ie.getMessage());
                throw ie;
            }
        }
    }

    public static void marshal(Evaluatable evaluatable, XMLStreamWriter xmlStreamWriter) throws WritingException {
        block7: {
            Marshaller marshaller;
            try {
                marshaller = PolicyMarshaller.createMarshaller();
            }
            catch (PropertyException e) {
                WritingException we = new WritingException("Unable to create a JAXB Marshaller.", e);
                LOGGER.error(we.getMessage());
                throw we;
            }
            catch (JAXBException e) {
                WritingException we = new WritingException("Unable to create a JAXB Marshaller.", e);
                LOGGER.error(we.getMessage());
                throw we;
            }
            try {
                if (evaluatable instanceof PolicySetType) {
                    marshaller.marshal(OBJECT_FACTORY.createPolicySet((PolicySetType)evaluatable), xmlStreamWriter);
                    break block7;
                }
                if (evaluatable instanceof PolicyType) {
                    marshaller.marshal(OBJECT_FACTORY.createPolicy((PolicyType)evaluatable), xmlStreamWriter);
                    break block7;
                }
                WritingException e = new WritingException("Unable to marshal an object of type: " + evaluatable.getClass());
                LOGGER.error(e.getMessage());
                throw e;
            }
            catch (JAXBException e) {
                WritingException ie = new WritingException("Unable to write to the xml stream writer.", e);
                LOGGER.error(ie.getMessage());
                throw ie;
            }
        }
    }

    public static void marshal(Evaluatable evaluatable, XMLEventWriter xmlEventWriter) throws WritingException {
        block7: {
            Marshaller marshaller;
            try {
                marshaller = PolicyMarshaller.createMarshaller();
            }
            catch (PropertyException e) {
                WritingException we = new WritingException("Unable to create a JAXB Marshaller.", e);
                LOGGER.error(we.getMessage());
                throw we;
            }
            catch (JAXBException e) {
                WritingException we = new WritingException("Unable to create a JAXB Marshaller.", e);
                LOGGER.error(we.getMessage());
                throw we;
            }
            try {
                if (evaluatable instanceof PolicySetType) {
                    marshaller.marshal(OBJECT_FACTORY.createPolicySet((PolicySetType)evaluatable), xmlEventWriter);
                    break block7;
                }
                if (evaluatable instanceof PolicyType) {
                    marshaller.marshal(OBJECT_FACTORY.createPolicy((PolicyType)evaluatable), xmlEventWriter);
                    break block7;
                }
                WritingException e = new WritingException("Unable to marshal an object of type: " + evaluatable.getClass());
                LOGGER.error(e.getMessage());
                throw e;
            }
            catch (JAXBException e) {
                WritingException ie = new WritingException("Unable to write to the xml event writer.", e);
                LOGGER.error(ie.getMessage());
                throw ie;
            }
        }
    }

    public static Evaluatable unmarshal(File file) throws SyntaxException {
        Unmarshaller unmarshaller;
        try {
            unmarshaller = PolicyMarshaller.createUnmarshaller();
        }
        catch (PropertyException e) {
            SyntaxException se = new SyntaxException("Unable to create a JAXB Unmarshaller.", e);
            LOGGER.error(se.getMessage());
            throw se;
        }
        catch (JAXBException e) {
            SyntaxException se = new SyntaxException("Unable to create a JAXB Unmarshaller.", e);
            LOGGER.error(se.getMessage());
            throw se;
        }
        try {
            return (Evaluatable)((JAXBElement)unmarshaller.unmarshal(file)).getValue();
        }
        catch (JAXBException e) {
            SyntaxException se = new SyntaxException("Unable to unmarshal the file.", e);
            LOGGER.error(se.getMessage(), (Throwable)e);
            throw se;
        }
        catch (ClassCastException e) {
            SyntaxException se = new SyntaxException("Unable to unmarshal the file.", e);
            LOGGER.error(se.getMessage(), (Throwable)e);
            throw se;
        }
    }

    public static Evaluatable unmarshal(InputStream inputStream) throws SyntaxException {
        Unmarshaller unmarshaller;
        try {
            unmarshaller = PolicyMarshaller.createUnmarshaller();
        }
        catch (PropertyException e) {
            SyntaxException se = new SyntaxException("Unable to create a JAXB Unmarshaller.", e);
            LOGGER.error(se.getMessage());
            throw se;
        }
        catch (JAXBException e) {
            SyntaxException se = new SyntaxException("Unable to create a JAXB Unmarshaller.", e);
            LOGGER.error(se.getMessage());
            throw se;
        }
        try {
            return (Evaluatable)((JAXBElement)unmarshaller.unmarshal(inputStream)).getValue();
        }
        catch (JAXBException e) {
            SyntaxException se = new SyntaxException("Unable to unmarshal the input stream.", e);
            LOGGER.error(se.getMessage(), (Throwable)e);
            throw se;
        }
        catch (ClassCastException e) {
            SyntaxException se = new SyntaxException("Unable to unmarshal the input stream.", e);
            LOGGER.error(se.getMessage(), (Throwable)e);
            throw se;
        }
    }

    public static Evaluatable unmarshal(Reader reader) throws SyntaxException {
        Unmarshaller unmarshaller;
        try {
            unmarshaller = PolicyMarshaller.createUnmarshaller();
        }
        catch (PropertyException e) {
            SyntaxException se = new SyntaxException("Unable to create a JAXB Unmarshaller.", e);
            LOGGER.error(se.getMessage());
            throw se;
        }
        catch (JAXBException e) {
            SyntaxException se = new SyntaxException("Unable to create a JAXB Unmarshaller.", e);
            LOGGER.error(se.getMessage());
            throw se;
        }
        try {
            return (Evaluatable)((JAXBElement)unmarshaller.unmarshal(reader)).getValue();
        }
        catch (JAXBException e) {
            SyntaxException se = new SyntaxException("Unable to unmarshal the reader.", e);
            LOGGER.error(se.getMessage(), (Throwable)e);
            throw se;
        }
        catch (ClassCastException e) {
            SyntaxException se = new SyntaxException("Unable to unmarshal the reader.", e);
            LOGGER.error(se.getMessage(), (Throwable)e);
            throw se;
        }
    }

    public static Evaluatable unmarshal(URL url) throws SyntaxException {
        Unmarshaller unmarshaller;
        try {
            unmarshaller = PolicyMarshaller.createUnmarshaller();
        }
        catch (PropertyException e) {
            SyntaxException se = new SyntaxException("Unable to create a JAXB Unmarshaller.", e);
            LOGGER.error(se.getMessage());
            throw se;
        }
        catch (JAXBException e) {
            SyntaxException se = new SyntaxException("Unable to create a JAXB Unmarshaller.", e);
            LOGGER.error(se.getMessage());
            throw se;
        }
        try {
            return (Evaluatable)((JAXBElement)unmarshaller.unmarshal(url)).getValue();
        }
        catch (JAXBException e) {
            SyntaxException se = new SyntaxException("Unable to unmarshal the url.", e);
            LOGGER.error(se.getMessage(), (Throwable)e);
            throw se;
        }
        catch (ClassCastException e) {
            SyntaxException se = new SyntaxException("Unable to unmarshal the url.", e);
            LOGGER.error(se.getMessage(), (Throwable)e);
            throw se;
        }
    }

    public static Evaluatable unmarshal(InputSource inputSource) throws SyntaxException {
        Unmarshaller unmarshaller;
        try {
            unmarshaller = PolicyMarshaller.createUnmarshaller();
        }
        catch (PropertyException e) {
            SyntaxException se = new SyntaxException("Unable to create a JAXB Unmarshaller.", e);
            LOGGER.error(se.getMessage());
            throw se;
        }
        catch (JAXBException e) {
            SyntaxException se = new SyntaxException("Unable to create a JAXB Unmarshaller.", e);
            LOGGER.error(se.getMessage());
            throw se;
        }
        try {
            return (Evaluatable)((JAXBElement)unmarshaller.unmarshal(inputSource)).getValue();
        }
        catch (JAXBException e) {
            SyntaxException se = new SyntaxException("Unable to unmarshal the input source.", e);
            LOGGER.error(se.getMessage(), (Throwable)e);
            throw se;
        }
        catch (ClassCastException e) {
            SyntaxException se = new SyntaxException("Unable to unmarshal the input source.", e);
            LOGGER.error(se.getMessage(), (Throwable)e);
            throw se;
        }
    }

    public static Evaluatable unmarshal(Node node) throws SyntaxException {
        Unmarshaller unmarshaller;
        try {
            unmarshaller = PolicyMarshaller.createUnmarshaller();
        }
        catch (PropertyException e) {
            SyntaxException se = new SyntaxException("Unable to create a JAXB Unmarshaller.", e);
            LOGGER.error(se.getMessage());
            throw se;
        }
        catch (JAXBException e) {
            SyntaxException se = new SyntaxException("Unable to create a JAXB Unmarshaller.", e);
            LOGGER.error(se.getMessage());
            throw se;
        }
        try {
            return (Evaluatable)((JAXBElement)unmarshaller.unmarshal(node)).getValue();
        }
        catch (JAXBException e) {
            SyntaxException se = new SyntaxException("Unable to unmarshal the node.", e);
            LOGGER.error(se.getMessage(), (Throwable)e);
            throw se;
        }
        catch (ClassCastException e) {
            SyntaxException se = new SyntaxException("Unable to unmarshal the node.", e);
            LOGGER.error(se.getMessage(), (Throwable)e);
            throw se;
        }
    }

    public static Evaluatable unmarshal(Source source) throws SyntaxException {
        Unmarshaller unmarshaller;
        try {
            unmarshaller = PolicyMarshaller.createUnmarshaller();
        }
        catch (PropertyException e) {
            SyntaxException se = new SyntaxException("Unable to create a JAXB Unmarshaller.", e);
            LOGGER.error(se.getMessage());
            throw se;
        }
        catch (JAXBException e) {
            SyntaxException se = new SyntaxException("Unable to create a JAXB Unmarshaller.", e);
            LOGGER.error(se.getMessage());
            throw se;
        }
        try {
            return (Evaluatable)((JAXBElement)unmarshaller.unmarshal(source)).getValue();
        }
        catch (JAXBException e) {
            SyntaxException se = new SyntaxException("Unable to unmarshal the source.", e);
            LOGGER.error(se.getMessage(), (Throwable)e);
            throw se;
        }
        catch (ClassCastException e) {
            SyntaxException se = new SyntaxException("Unable to unmarshal the source.", e);
            LOGGER.error(se.getMessage(), (Throwable)e);
            throw se;
        }
    }

    public static Evaluatable unmarshal(XMLStreamReader xmlStreamReader) throws SyntaxException {
        Unmarshaller unmarshaller;
        try {
            unmarshaller = PolicyMarshaller.createUnmarshaller();
        }
        catch (PropertyException e) {
            SyntaxException se = new SyntaxException("Unable to create a JAXB Unmarshaller.", e);
            LOGGER.error(se.getMessage());
            throw se;
        }
        catch (JAXBException e) {
            SyntaxException se = new SyntaxException("Unable to create a JAXB Unmarshaller.", e);
            LOGGER.error(se.getMessage());
            throw se;
        }
        try {
            return (Evaluatable)((JAXBElement)unmarshaller.unmarshal(xmlStreamReader)).getValue();
        }
        catch (JAXBException e) {
            SyntaxException se = new SyntaxException("Unable to unmarshal the xml stream reader.", e);
            LOGGER.error(se.getMessage(), (Throwable)e);
            throw se;
        }
        catch (ClassCastException e) {
            SyntaxException se = new SyntaxException("Unable to unmarshal the xml stream reader.", e);
            LOGGER.error(se.getMessage(), (Throwable)e);
            throw se;
        }
    }

    public static Evaluatable unmarshal(XMLEventReader xmlEventReader) throws SyntaxException {
        Unmarshaller unmarshaller;
        try {
            unmarshaller = PolicyMarshaller.createUnmarshaller();
        }
        catch (PropertyException e) {
            SyntaxException se = new SyntaxException("Unable to create a JAXB Unmarshaller.", e);
            LOGGER.error(se.getMessage());
            throw se;
        }
        catch (JAXBException e) {
            SyntaxException se = new SyntaxException("Unable to create a JAXB Unmarshaller.", e);
            LOGGER.error(se.getMessage());
            throw se;
        }
        try {
            return (Evaluatable)((JAXBElement)unmarshaller.unmarshal(xmlEventReader)).getValue();
        }
        catch (JAXBException e) {
            SyntaxException se = new SyntaxException("Unable to unmarshal the xml event reader.", e);
            LOGGER.error(se.getMessage(), (Throwable)e);
            throw se;
        }
        catch (ClassCastException e) {
            SyntaxException se = new SyntaxException("Unable to unmarshal the xml event reader.", e);
            LOGGER.error(se.getMessage(), (Throwable)e);
            throw se;
        }
    }

    static {
        OBJECT_FACTORY = new ObjectFactory();
    }
}

