/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.modipa.builder;

import java.util.Date;
import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.config.ServiceBindingConfiguration;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.protocol.basic.builder.BustaBuilder;
import org.openspcoop2.protocol.modipa.AbstractModISecurityToken;
import org.openspcoop2.protocol.modipa.builder.ModIImbustamento;
import org.openspcoop2.protocol.modipa.config.ModIProperties;
import org.openspcoop2.protocol.modipa.constants.ModICostanti;
import org.openspcoop2.protocol.modipa.validator.ModIRESTSecurity;
import org.openspcoop2.protocol.modipa.validator.ModISOAPSecurity;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.Context;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.ProtocolMessage;
import org.openspcoop2.protocol.sdk.builder.ProprietaManifestAttachments;
import org.openspcoop2.protocol.sdk.constants.FaseImbustamento;
import org.openspcoop2.protocol.sdk.constants.FaseSbustamento;
import org.openspcoop2.protocol.sdk.constants.RuoloMessaggio;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.protocol.sdk.state.RequestInfo;

public class ModIBustaBuilder
extends BustaBuilder<AbstractModISecurityToken<?>> {
    private ModIProperties modipaProperties = ModIProperties.getInstance();

    public ModIBustaBuilder(IProtocolFactory<?> factory, IState state) throws ProtocolException {
        super(factory, state);
    }

    public ProtocolMessage imbustamento(OpenSPCoop2Message msg, Context context, Busta busta, Busta bustaRichiesta, RuoloMessaggio ruoloMessaggio, ProprietaManifestAttachments proprietaManifestAttachments, FaseImbustamento faseImbustamento) throws ProtocolException {
        boolean ignoraEccezioniNonGravi;
        if (FaseImbustamento.PRIMA_SICUREZZA_MESSAGGIO.equals((Object)faseImbustamento)) {
            ProtocolMessage protocolMessage = new ProtocolMessage();
            protocolMessage.setPhaseUnsupported(true);
            return protocolMessage;
        }
        RequestInfo requestInfo = null;
        if (context != null && context.containsKey(Costanti.REQUEST_INFO)) {
            requestInfo = (RequestInfo)context.getObject(Costanti.REQUEST_INFO);
        }
        ProtocolMessage protocolMessage = super.imbustamento(msg, context, busta, bustaRichiesta, ruoloMessaggio, proprietaManifestAttachments, faseImbustamento);
        boolean imbusta = true;
        if (RuoloMessaggio.RISPOSTA.equals((Object)ruoloMessaggio) && busta.sizeListaEccezioni() > 0) {
            ignoraEccezioniNonGravi = this.protocolFactory.createProtocolManager().isIgnoraEccezioniNonGravi();
            if (ignoraEccezioniNonGravi) {
                if (busta.containsEccezioniGravi()) {
                    imbusta = false;
                }
            } else {
                imbusta = false;
            }
        }
        if (imbusta) {
            ModIImbustamento imbustamento = new ModIImbustamento(this.getLog());
            protocolMessage = imbustamento.buildMessage(msg, context, busta, bustaRichiesta, ruoloMessaggio, this.getProtocolFactory().getCachedRegistryReader(this.state, requestInfo), this.getProtocolFactory().getCachedConfigIntegrationReader(this.state, requestInfo), this.getProtocolFactory(), this.state);
        }
        if (RuoloMessaggio.RISPOSTA.equals((Object)ruoloMessaggio) && busta.sizeListaEccezioni() > 0) {
            ignoraEccezioniNonGravi = this.protocolFactory.createProtocolManager().isIgnoraEccezioniNonGravi();
            if (ignoraEccezioniNonGravi) {
                if (busta.containsEccezioniGravi()) {
                    this.enrichFault(msg, busta, ignoraEccezioniNonGravi, this.modipaProperties.isPortaApplicativaBustaErrorePersonalizzaElementiFault(), this.modipaProperties.isPortaApplicativaBustaErroreAggiungiErroreApplicativo());
                }
            } else {
                this.enrichFault(msg, busta, ignoraEccezioniNonGravi, this.modipaProperties.isPortaApplicativaBustaErrorePersonalizzaElementiFault(), this.modipaProperties.isPortaApplicativaBustaErroreAggiungiErroreApplicativo());
            }
        }
        return protocolMessage;
    }

    public ProtocolMessage sbustamento(OpenSPCoop2Message msg, Context context, Busta busta, RuoloMessaggio ruoloMessaggio, ProprietaManifestAttachments proprietaManifestAttachments, FaseSbustamento faseSbustamento, ServiceBinding integrationServiceBinding, ServiceBindingConfiguration serviceBindingConfiguration) throws ProtocolException {
        ProtocolMessage protocolMessage = null;
        if (FaseSbustamento.PRE_CONSEGNA_RICHIESTA.equals((Object)faseSbustamento) || FaseSbustamento.PRE_CONSEGNA_RISPOSTA.equals((Object)faseSbustamento)) {
            protocolMessage = new ProtocolMessage();
            if (msg != null) {
                Object soapInfo = msg.getContextProperty(ModICostanti.MODIPA_OPENSPCOOP2_MSG_CONTEXT_SBUSTAMENTO_SOAP);
                Object restInfo = msg.getContextProperty(ModICostanti.MODIPA_OPENSPCOOP2_MSG_CONTEXT_SBUSTAMENTO_REST);
                if (soapInfo != null) {
                    ModISOAPSecurity soapSecurity = (ModISOAPSecurity)soapInfo;
                    try {
                        soapSecurity.clean(msg.castAsSoap());
                    }
                    catch (Exception e) {
                        throw new ProtocolException(e.getMessage(), (Throwable)e);
                    }
                }
                if (restInfo != null) {
                    ModIRESTSecurity restSecurity = (ModIRESTSecurity)restInfo;
                    try {
                        restSecurity.clean(msg);
                    }
                    catch (Exception e) {
                        throw new ProtocolException(e.getMessage(), (Throwable)e);
                    }
                }
            }
            protocolMessage.setMessage(msg);
        } else {
            protocolMessage = super.sbustamento(msg, context, busta, ruoloMessaggio, proprietaManifestAttachments, faseSbustamento, integrationServiceBinding, serviceBindingConfiguration);
        }
        protocolMessage.setUseBustaRawContentReadByValidation(true);
        return protocolMessage;
    }

    public String newID(IDSoggetto idSoggetto, String idTransazione, RuoloMessaggio ruoloMessaggio) throws ProtocolException {
        return super.newID(idSoggetto, idTransazione, ruoloMessaggio, this.modipaProperties.generateIDasUUID().booleanValue());
    }

    public Date extractDateFromID(String id) throws ProtocolException {
        return this.extractDateFromID(id, this.modipaProperties.generateIDasUUID());
    }
}

