/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.modipa.utils;

import java.io.BufferedReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.protocol.sdk.ProtocolException;

public class SOAPHeader {
    private String localName;
    private String namespace;

    public String getLocalName() {
        return this.localName;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public SOAPHeader(String namespace, String localName) {
        this.namespace = namespace;
        this.localName = localName;
    }

    public static void remove(List<SOAPHeader> list, String namespace, String localName) {
        if (list != null && !list.isEmpty()) {
            boolean find = true;
            while (find) {
                int i;
                find = false;
                for (i = 0; i < list.size(); ++i) {
                    SOAPHeader hdr = list.get(i);
                    if (!hdr.getLocalName().equals(localName) || !hdr.getNamespace().equals(namespace)) continue;
                    find = true;
                    break;
                }
                if (!find) continue;
                list.remove(i);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<SOAPHeader> parse(String value) throws ProtocolException {
        ArrayList<SOAPHeader> list = new ArrayList<SOAPHeader>();
        if (value != null && value.length() > 0) {
            try (StringReader sr = new StringReader(value);
                 BufferedReader reader = new BufferedReader(sr);){
                String line = reader.readLine();
                while (line != null) {
                    try {
                        if ((line = line.trim()).startsWith("#")) continue;
                        if (!line.startsWith("{")) {
                            throw new Exception("Wrong format (expected '{namespace}localName') in row '" + line + "'");
                        }
                        if (!line.contains("}")) {
                            throw new Exception("Wrong format (expected '{namespace}localName') in row '" + line + "'");
                        }
                        StringBuilder sbNamespace = new StringBuilder();
                        StringBuilder sbLocalname = new StringBuilder();
                        boolean localName = false;
                        for (int i = 1; i < line.length(); ++i) {
                            char c = line.charAt(i);
                            if (c == '}') {
                                localName = true;
                                continue;
                            }
                            if (localName) {
                                sbLocalname.append(c);
                                continue;
                            }
                            sbNamespace.append(c);
                        }
                        if (sbNamespace.length() <= 0) {
                            throw new Exception("Wrong format (expected '{namespace}localName') in row '" + line + "' (namespace not found)");
                        }
                        if (sbNamespace.toString().contains("{") || sbNamespace.toString().contains("}")) {
                            throw new Exception("Wrong format (expected '{namespace}localName') in row '" + line + "'");
                        }
                        if (sbLocalname.length() <= 0) {
                            throw new Exception("Wrong format (expected '{namespace}localName') in row '" + line + "' (localName not found)");
                        }
                        if (sbLocalname.toString().contains("{") || sbLocalname.toString().contains("}")) {
                            throw new Exception("Wrong format (expected '{namespace}localName') in row '" + line + "'");
                        }
                        SOAPHeader hdr = new SOAPHeader(sbNamespace.toString(), sbLocalname.toString());
                        list.add(hdr);
                    }
                    finally {
                        line = reader.readLine();
                    }
                }
            }
            catch (Exception e) {
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
        }
        return list;
    }
}

