/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.modipa.validator;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.core.config.AutorizzazioneRuoli;
import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.config.PortaApplicativaAutorizzazioneServizioApplicativo;
import org.openspcoop2.core.config.ServizioApplicativo;
import org.openspcoop2.core.config.constants.RuoloTipoMatch;
import org.openspcoop2.core.config.constants.RuoloTipologia;
import org.openspcoop2.core.config.constants.StatoFunzionalita;
import org.openspcoop2.core.constants.TipoPdD;
import org.openspcoop2.core.id.IDPortaApplicativa;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.Soggetto;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.pdd.config.ConfigurazionePdDReader;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.config.PDNDResolver;
import org.openspcoop2.pdd.core.CostantiPdD;
import org.openspcoop2.pdd.core.token.Costanti;
import org.openspcoop2.pdd.core.token.InformazioniToken;
import org.openspcoop2.pdd.core.token.TokenUtilities;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.protocol.basic.validator.ValidazioneSemantica;
import org.openspcoop2.protocol.engine.SecurityTokenUtilities;
import org.openspcoop2.protocol.modipa.config.ModIProperties;
import org.openspcoop2.protocol.modipa.constants.ModICostanti;
import org.openspcoop2.protocol.modipa.utils.ModISecurityConfig;
import org.openspcoop2.protocol.modipa.utils.ModIUtilities;
import org.openspcoop2.protocol.modipa.validator.IdentificazioneApplicativoMittenteUtils;
import org.openspcoop2.protocol.modipa.validator.ModIValidazioneSintattica;
import org.openspcoop2.protocol.registry.RegistroServiziManager;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.Context;
import org.openspcoop2.protocol.sdk.Eccezione;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.RestMessageSecurityToken;
import org.openspcoop2.protocol.sdk.SecurityToken;
import org.openspcoop2.protocol.sdk.constants.CodiceErroreCooperazione;
import org.openspcoop2.protocol.sdk.constants.RuoloBusta;
import org.openspcoop2.protocol.sdk.properties.ProtocolPropertiesUtils;
import org.openspcoop2.protocol.sdk.registry.IRegistryReader;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.protocol.sdk.validator.ProprietaValidazione;
import org.openspcoop2.protocol.sdk.validator.ValidazioneSemanticaResult;
import org.openspcoop2.protocol.sdk.validator.ValidazioneUtils;
import org.openspcoop2.protocol.utils.ModIUtils;
import org.openspcoop2.protocol.utils.ModIValidazioneSemanticaProfiloSicurezza;
import org.openspcoop2.utils.SortedMap;
import org.openspcoop2.utils.certificate.remote.RemoteStoreConfig;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.date.DateUtils;
import org.openspcoop2.utils.digest.DigestEncoding;
import org.openspcoop2.utils.digest.DigestUtils;
import org.openspcoop2.utils.properties.PropertiesUtilities;

public class ModIValidazioneSemantica
extends ValidazioneSemantica {
    protected ValidazioneUtils validazioneUtils;
    protected ModIProperties modiProperties;
    protected List<Eccezione> erroriValidazione = new ArrayList<Eccezione>();
    protected List<Eccezione> erroriProcessamento = new ArrayList<Eccezione>();
    private static final String DIAGNOSTIC_VALIDATE = "validazioneSemantica";
    private static final String DIAGNOSTIC_IN_CORSO = "inCorso";
    private static final String DIAGNOSTIC_COMPLETATA = "completata";
    private static final String DIAGNOSTIC_FALLITA = "fallita";
    private static final String MSG_ERRORE_NON_PRESENTE = "non presente";

    public ModIValidazioneSemantica(IProtocolFactory<?> factory, IState state) throws ProtocolException {
        super(factory, state);
        this.modiProperties = ModIProperties.getInstance();
        this.validazioneUtils = new ValidazioneUtils(factory);
    }

    private String getErroreClaimNonValido(String claim) {
        return "Token contenente un claim '" + claim + "' non valido";
    }

    private String getErroreClaimNonPresente(String claim) {
        return "Token non contiene il claim '" + claim + "'";
    }

    private Eccezione getErroreMittenteNonAutorizzato(Busta busta, String msgErrore) throws ProtocolException {
        String idApp = busta.getServizioApplicativoFruitore() + " (Soggetto: " + busta.getMittente() + ")";
        return this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.SICUREZZA_AUTORIZZAZIONE_FALLITA, "Applicativo Mittente " + idApp + " non autorizzato" + (String)(msgErrore != null ? "; " + msgErrore : ""));
    }

    private void addErroreMittenteNonAutorizzato(Busta busta, String msgErrore) throws ProtocolException {
        this.erroriValidazione.add(this.getErroreMittenteNonAutorizzato(busta, msgErrore));
    }

    private String getPrefixHeader(String hdr) {
        return "[Header '" + hdr + "'] ";
    }

    public ValidazioneSemanticaResult valida(OpenSPCoop2Message msg, Busta busta, ProprietaValidazione proprietaValidazione, RuoloBusta tipoBusta) throws ProtocolException {
        this.valida(msg, busta, tipoBusta, this.protocolFactory, this.state);
        List<Eccezione> erroriValidazioneList = null;
        if (!this.erroriValidazione.isEmpty()) {
            erroriValidazioneList = this.erroriValidazione;
            if (this.context != null) {
                this.context.addObject(org.openspcoop2.core.constants.Costanti.ERRORE_VALIDAZIONE_PROTOCOLLO, (Object)"true");
            }
        }
        List erroriProcessamentoList = null;
        if (!this.erroriProcessamento.isEmpty()) {
            erroriValidazioneList = this.erroriProcessamento;
        }
        return new ValidazioneSemanticaResult(erroriValidazioneList, erroriProcessamentoList, null, null, null, null);
    }

    private void valida(OpenSPCoop2Message msg, Busta busta, RuoloBusta tipoBusta, IProtocolFactory<?> factory, IState state) throws ProtocolException {
        block102: {
            MsgDiagnostico msgDiag = null;
            String tipoDiagnostico = null;
            boolean verifica = false;
            boolean autorizzazione = false;
            int sizeListaErroriValidazionePrimaAutorizzazione = -1;
            int sizeListaProcessamentoValidazionePrimaAutorizzazione = -1;
            try {
                int sizeListaEccezioniDipoAutorizzazione;
                int sizeListaEccezioniPrimaAutorizzazione;
                IDSoggetto idSoggetto;
                boolean rest;
                String prefixIntegrity = this.getPrefixHeader(this.modiProperties.getRestSecurityTokenHeaderModI());
                RequestInfo requestInfo = null;
                if (this.context != null && this.context.containsKey(org.openspcoop2.core.constants.Costanti.REQUEST_INFO)) {
                    requestInfo = (RequestInfo)this.context.getObject(org.openspcoop2.core.constants.Costanti.REQUEST_INFO);
                }
                boolean isRichiesta = RuoloBusta.RICHIESTA.equals((Object)tipoBusta);
                boolean bl = rest = msg != null && ServiceBinding.REST.equals((Object)msg.getServiceBinding());
                if (busta == null) {
                    throw new ProtocolException("Busta undefined");
                }
                IRegistryReader registryReader = null;
                TipoPdD tipoPdD = isRichiesta ? TipoPdD.APPLICATIVA : TipoPdD.DELEGATA;
                IDSoggetto iDSoggetto = idSoggetto = TipoPdD.DELEGATA.equals((Object)tipoPdD) ? new IDSoggetto(busta.getTipoMittente(), busta.getMittente()) : new IDSoggetto(busta.getTipoDestinatario(), busta.getDestinatario());
                if (idSoggetto == null || idSoggetto.getTipo() == null || idSoggetto.getNome() == null) {
                    idSoggetto = OpenSPCoop2Properties.getInstance().getIdentitaPortaDefault(this.protocolFactory.getProtocol(), requestInfo);
                } else {
                    registryReader = this.getProtocolFactory().getCachedRegistryReader(this.state, requestInfo);
                    idSoggetto.setCodicePorta(registryReader.getDominio(idSoggetto));
                }
                msgDiag = MsgDiagnostico.newInstance((TipoPdD)TipoPdD.DELEGATA, (IDSoggetto)idSoggetto, (String)"ModI", requestInfo != null && requestInfo.getProtocolContext() != null ? requestInfo.getProtocolContext().getInterfaceName() : null, (RequestInfo)requestInfo, (IState)this.state);
                if (TipoPdD.DELEGATA.equals((Object)tipoPdD)) {
                    msgDiag.setPrefixMsgPersonalizzati("ricezioneContenutiApplicativi.");
                } else {
                    msgDiag.setPrefixMsgPersonalizzati("ricezioneBuste.");
                }
                msgDiag.setPddContext(this.context, this.protocolFactory);
                tipoDiagnostico = isRichiesta ? ".richiesta." : ".risposta.";
                Date now = DateManager.getDate();
                ModIValidazioneSemanticaProfiloSicurezza modIValidazioneSemanticaProfiloSicurezza = new ModIValidazioneSemanticaProfiloSicurezza(busta, isRichiesta);
                boolean sicurezzaTokenOauth = modIValidazioneSemanticaProfiloSicurezza.isSicurezzaTokenOauth();
                String securityMessageProfileSorgenteTokenIdAuth = modIValidazioneSemanticaProfiloSicurezza.getSecurityMessageProfileSorgenteTokenIdAuth();
                boolean sicurezzaMessaggio = modIValidazioneSemanticaProfiloSicurezza.isSicurezzaMessaggio();
                boolean sicurezzaMessaggioIDAR04 = modIValidazioneSemanticaProfiloSicurezza.isSicurezzaMessaggioIDAR04();
                boolean sicurezzaAudit = modIValidazioneSemanticaProfiloSicurezza.isSicurezzaAudit();
                String securityAuditPattern = modIValidazioneSemanticaProfiloSicurezza.getSecurityAuditPattern();
                if (sicurezzaMessaggio || sicurezzaAudit) {
                    msgDiag.logPersonalizzato(DIAGNOSTIC_VALIDATE + tipoDiagnostico + DIAGNOSTIC_IN_CORSO);
                    verifica = true;
                }
                PortaApplicativa pa = null;
                RemoteStoreConfig rsc = null;
                if (isRichiesta && sicurezzaTokenOauth) {
                    String prefixAuthorization = this.getPrefixHeader("Authorization");
                    boolean sicurezzaToken = this.context.containsKey(Costanti.PDD_CONTEXT_TOKEN_INFORMAZIONI_NORMALIZZATE);
                    if (!sicurezzaToken) {
                        this.erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.SICUREZZA_TOKEN_NON_PRESENTE, prefixAuthorization + MSG_ERRORE_NON_PRESENTE));
                    } else {
                        this.validateTokenAuthorizationId(msg, prefixAuthorization, modIValidazioneSemanticaProfiloSicurezza);
                        boolean checkAudienceByModIConfig = sicurezzaMessaggio || sicurezzaAudit;
                        pa = this.validateTokenAuthorizationAudience(msg, factory, state, requestInfo, isRichiesta, prefixAuthorization, checkAudienceByModIConfig);
                        PDNDResolver pdndResolver = new PDNDResolver(this.context, this.modiProperties.getRemoteStoreConfig());
                        rsc = pdndResolver.enrichTokenInfo(requestInfo, sicurezzaMessaggio, sicurezzaAudit, idSoggetto);
                        boolean claimValidi = this.validateTokenAuthorizationClaims(rsc, idSoggetto, isRichiesta, prefixAuthorization);
                        if (claimValidi) {
                            boolean isOk;
                            if (registryReader == null) {
                                registryReader = this.getProtocolFactory().getCachedRegistryReader(this.state, requestInfo);
                            }
                            if (isOk = this.validateTokenAuthorizationProducerIdByModIConfig(registryReader, idSoggetto, isRichiesta, prefixAuthorization)) {
                                this.validateTokenAuthorizationServiceDescriptorIdByModIConfig(registryReader, busta, isRichiesta, prefixAuthorization);
                            }
                        }
                    }
                }
                if (sicurezzaMessaggio) {
                    String iatIntegrity;
                    String iat;
                    String nbfIntegrity;
                    String nbf;
                    String expIntegrity;
                    String exp;
                    String jti;
                    String id;
                    if (isRichiesta && sicurezzaTokenOauth && ((id = busta.getProperty("ProfiloSicurezzaMessaggio-MessageId")) == null || StringUtils.isEmpty((CharSequence)id)) && (jti = TokenUtilities.readJtiFromInformazioniToken((Context)this.context)) != null && StringUtils.isNotEmpty((CharSequence)jti)) {
                        ModIUtils.replaceBustaIdWithJtiTokenId((ModIValidazioneSemanticaProfiloSicurezza)modIValidazioneSemanticaProfiloSicurezza, (String)jti);
                        msgDiag.updateKeywordIdMessaggioRichiesta(busta.getID());
                        if (this.context != null) {
                            this.context.put(org.openspcoop2.core.constants.Costanti.MODI_JTI_REQUEST_ID_UPDATE_DIAGNOSTIC, (Object)busta.getID());
                        }
                    }
                    if ((exp = busta.getProperty("ProfiloSicurezzaMessaggio-Expiration")) != null) {
                        this.checkExp(exp, now, rest, "");
                    }
                    if ((expIntegrity = busta.getProperty("ProfiloSicurezzaMessaggio-IntegrityExpiration")) != null) {
                        this.checkExp(expIntegrity, now, rest, prefixIntegrity);
                    }
                    if ((nbf = busta.getProperty("ProfiloSicurezzaMessaggio-NotBefore")) != null) {
                        this.checkNbf(nbf, now, "");
                    }
                    if ((nbfIntegrity = busta.getProperty("ProfiloSicurezzaMessaggio-IntegrityNotBefore")) != null) {
                        this.checkNbf(nbfIntegrity, now, prefixIntegrity);
                    }
                    if ((iat = busta.getProperty("ProfiloSicurezzaMessaggio-IssuedAt")) != null) {
                        this.checkIat(iat, msg, rest, "");
                    }
                    if ((iatIntegrity = busta.getProperty("ProfiloSicurezzaMessaggio-IntegrityIssuedAt")) != null) {
                        this.checkIat(iatIntegrity, msg, rest, prefixIntegrity);
                    }
                    String audienceBusta = busta.getProperty(rest ? "ProfiloSicurezzaMessaggio-Audience" : "ProfiloSicurezzaMessaggio-WSA-To");
                    List<String> listAudienceBusta = null;
                    if (rest && this.modiProperties.isRestSecurityTokenAudienceProcessArrayModeEnabled()) {
                        listAudienceBusta = ModIUtilities.getArrayStringAsList(audienceBusta, true);
                    }
                    Object audienceAttesoObject = null;
                    if (msg != null) {
                        audienceAttesoObject = msg.getContextProperty(ModICostanti.MODIPA_OPENSPCOOP2_MSG_CONTEXT_AUDIENCE_CHECK);
                    }
                    String audienceAtteso = null;
                    if (audienceAttesoObject != null) {
                        audienceAtteso = (String)audienceAttesoObject;
                    }
                    Object audienceAttesoOAuthObject = null;
                    if (msg != null) {
                        audienceAttesoOAuthObject = msg.getContextProperty(ModICostanti.MODIPA_OPENSPCOOP2_MSG_CONTEXT_AUDIENCE_CHECK_OAUTH);
                    }
                    Object audienceOAuthAtteso = null;
                    if (audienceAttesoOAuthObject != null) {
                        audienceOAuthAtteso = (String)audienceAttesoOAuthObject;
                    }
                    if (audienceAtteso != null || audienceOAuthAtteso != null) {
                        boolean checkAudience = this.isAudienceValid(audienceAtteso, audienceBusta, listAudienceBusta);
                        boolean checkAudienceOAuth = this.isAudienceValid((String)audienceOAuthAtteso, audienceBusta, listAudienceBusta);
                        if (!checkAudience && !checkAudienceOAuth) {
                            boolean buildSecurityTokenInRequest = true;
                            Object buildSecurityTokenInRequestObject = msg.getContextProperty(ModICostanti.MODIPA_OPENSPCOOP2_MSG_CONTEXT_BUILD_SECURITY_REQUEST_TOKEN);
                            if (buildSecurityTokenInRequestObject instanceof Boolean) {
                                buildSecurityTokenInRequest = (Boolean)buildSecurityTokenInRequestObject;
                            }
                            if (isRichiesta || buildSecurityTokenInRequest) {
                                this.erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(isRichiesta ? CodiceErroreCooperazione.SERVIZIO_APPLICATIVO_EROGATORE_NON_VALIDO : CodiceErroreCooperazione.SERVIZIO_APPLICATIVO_FRUITORE_NON_VALIDO, this.getErroreClaimNonValido("aud")));
                            }
                        }
                    }
                    if (rest) {
                        Object audienceIntegrityAttesoObject = null;
                        if (msg != null) {
                            audienceIntegrityAttesoObject = msg.getContextProperty(ModICostanti.MODIPA_OPENSPCOOP2_MSG_CONTEXT_AUDIENCE_INTEGRITY_CHECK);
                        }
                        String audienceIntegrityAtteso = null;
                        if (audienceIntegrityAttesoObject != null) {
                            audienceIntegrityAtteso = (String)audienceIntegrityAttesoObject;
                        }
                        Object audienceIntegrityAttesoOAuthObject = null;
                        if (msg != null) {
                            audienceIntegrityAttesoOAuthObject = msg.getContextProperty(ModICostanti.MODIPA_OPENSPCOOP2_MSG_CONTEXT_AUDIENCE_INTEGRITY_CHECK_OAUTH);
                        }
                        String audienceIntegrityOAuthAtteso = null;
                        if (audienceIntegrityAttesoOAuthObject != null) {
                            audienceIntegrityOAuthAtteso = (String)audienceIntegrityAttesoOAuthObject;
                        }
                        if (audienceIntegrityAtteso != null || audienceIntegrityOAuthAtteso != null) {
                            String audienceIntegrityBusta = busta.getProperty("ProfiloSicurezzaMessaggio-IntegrityAudience");
                            if (audienceIntegrityBusta == null) {
                                audienceIntegrityBusta = busta.getProperty("ProfiloSicurezzaMessaggio-Audience");
                            }
                            List<String> listAudienceIntegrityBusta = null;
                            if (audienceIntegrityBusta != null && rest && this.modiProperties.isRestSecurityTokenAudienceProcessArrayModeEnabled()) {
                                listAudienceIntegrityBusta = ModIUtilities.getArrayStringAsList(audienceIntegrityBusta, true);
                            }
                            boolean checkAudience = this.isAudienceValid(audienceIntegrityAtteso, audienceIntegrityBusta, listAudienceIntegrityBusta);
                            boolean checkAudienceOAuth = this.isAudienceValid(audienceIntegrityOAuthAtteso, audienceIntegrityBusta, listAudienceIntegrityBusta);
                            if (!checkAudience && !checkAudienceOAuth) {
                                this.erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(isRichiesta ? CodiceErroreCooperazione.SERVIZIO_APPLICATIVO_EROGATORE_NON_VALIDO : CodiceErroreCooperazione.SERVIZIO_APPLICATIVO_FRUITORE_NON_VALIDO, prefixIntegrity + this.getErroreClaimNonValido("aud")));
                            }
                        }
                    }
                }
                if (sicurezzaAudit) {
                    String iat;
                    String nbf;
                    String prefixAudit = this.getPrefixHeader(this.modiProperties.getSecurityTokenHeaderModIAudit());
                    boolean audit02 = "audit02".equals(securityAuditPattern);
                    String exp = busta.getProperty("ProfiloSicurezzaMessaggioAudit-Expiration");
                    if (exp != null) {
                        this.checkExp(exp, now, rest, prefixAudit);
                    }
                    if ((nbf = busta.getProperty("ProfiloSicurezzaMessaggioAudit-NotBefore")) != null) {
                        this.checkNbf(nbf, now, prefixAudit);
                    }
                    if ((iat = busta.getProperty("ProfiloSicurezzaMessaggioAudit-IssuedAt")) != null) {
                        this.checkIat(iat, msg, rest, prefixAudit);
                    }
                    Object audienceAuditAttesoObject = null;
                    if (msg != null) {
                        audienceAuditAttesoObject = msg.getContextProperty(ModICostanti.MODIPA_OPENSPCOOP2_MSG_CONTEXT_AUDIENCE_AUDIT_CHECK);
                    }
                    if (audienceAuditAttesoObject != null) {
                        boolean checkAudienceAudit;
                        String audienceAuditAtteso = (String)audienceAuditAttesoObject;
                        String audienceAuditBusta = busta.getProperty("ProfiloSicurezzaMessaggioAudit-Audience");
                        if (audienceAuditBusta == null) {
                            audienceAuditBusta = busta.getProperty("ProfiloSicurezzaMessaggio-Audience");
                        }
                        List<String> listAudienceAuditBusta = null;
                        if (audienceAuditBusta != null && this.modiProperties.isSecurityTokenAuditProcessArrayModeEnabled()) {
                            listAudienceAuditBusta = ModIUtilities.getArrayStringAsList(audienceAuditBusta, true);
                        }
                        if (!(checkAudienceAudit = this.isAudienceValid(audienceAuditAtteso, audienceAuditBusta, listAudienceAuditBusta))) {
                            this.erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(isRichiesta ? CodiceErroreCooperazione.SERVIZIO_APPLICATIVO_EROGATORE_NON_VALIDO : CodiceErroreCooperazione.SERVIZIO_APPLICATIVO_FRUITORE_NON_VALIDO, prefixAudit + this.getErroreClaimNonValido("aud")));
                        }
                    }
                    if (rsc != null) {
                        this.validatePurposeId(rsc, prefixAudit, securityAuditPattern);
                    }
                    if (audit02) {
                        this.validateAudit02(securityMessageProfileSorgenteTokenIdAuth, rest, prefixAudit);
                    }
                }
                if (verifica) {
                    if (this.erroriValidazione.isEmpty() && this.erroriProcessamento.isEmpty()) {
                        msgDiag.logPersonalizzato(DIAGNOSTIC_VALIDATE + tipoDiagnostico + DIAGNOSTIC_COMPLETATA);
                    } else {
                        String errore = null;
                        errore = !this.erroriValidazione.isEmpty() ? ModIValidazioneSintattica.buildErrore(this.erroriValidazione, factory) : ModIValidazioneSintattica.buildErrore(this.erroriProcessamento, factory);
                        msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", errore);
                        msgDiag.logPersonalizzato(DIAGNOSTIC_VALIDATE + tipoDiagnostico + DIAGNOSTIC_FALLITA);
                    }
                    verifica = false;
                }
                if (!isRichiesta) break block102;
                tipoDiagnostico = ".autorizzazione.";
                msgDiag.logPersonalizzato(DIAGNOSTIC_VALIDATE + tipoDiagnostico + DIAGNOSTIC_IN_CORSO);
                autorizzazione = true;
                sizeListaErroriValidazionePrimaAutorizzazione = this.erroriValidazione.size();
                sizeListaProcessamentoValidazionePrimaAutorizzazione = this.erroriProcessamento.size();
                if (pa == null) {
                    String interfaceName = null;
                    if (msg != null && msg.getTransportRequestContext() != null && msg.getTransportRequestContext().getInterfaceName() != null) {
                        interfaceName = msg.getTransportRequestContext().getInterfaceName();
                    } else if (requestInfo != null && requestInfo.getProtocolContext() != null && requestInfo.getProtocolContext().getInterfaceName() != null) {
                        interfaceName = requestInfo.getProtocolContext().getInterfaceName();
                    }
                    if (interfaceName == null) {
                        throw new ProtocolException("ID Porta non presente");
                    }
                    IDPortaApplicativa idPA = new IDPortaApplicativa();
                    idPA.setNome(interfaceName);
                    pa = factory.getCachedConfigIntegrationReader(state, requestInfo).getPortaApplicativa(idPA);
                }
                boolean saIdentificatoBySecurity = busta.getServizioApplicativoFruitore() != null && !"Anonimo".equals(busta.getServizioApplicativoFruitore());
                boolean sicurezzaToken = this.context.containsKey(Costanti.PDD_CONTEXT_TOKEN_INFORMAZIONI_NORMALIZZATE);
                boolean saIdentificatoByToken = false;
                boolean saVerificatoBySecurity = false;
                if (sicurezzaToken) {
                    SecurityToken securityTokenForContext;
                    IDServizioApplicativo idSAbyToken = null;
                    StringBuilder sbError = new StringBuilder();
                    try {
                        idSAbyToken = IdentificazioneApplicativoMittenteUtils.identificazioneApplicativoMittenteByToken(this.log, state, busta, this.context, requestInfo, msgDiag, sbError);
                    }
                    catch (Exception e) {
                        if (sbError != null && sbError.length() > 0) {
                            this.context.addObject(org.openspcoop2.core.constants.Costanti.ERRORE_AUTORIZZAZIONE, (Object)"true");
                            this.erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.SICUREZZA_AUTORIZZAZIONE_FALLITA, sbError.toString()));
                            return;
                        }
                        throw e;
                    }
                    boolean bl2 = saIdentificatoByToken = idSAbyToken != null;
                    if (saIdentificatoByToken && (securityTokenForContext = SecurityTokenUtilities.readSecurityToken((Context)this.context)) != null) {
                        try {
                            String tipoToken;
                            if (securityTokenForContext.getAuthorization() != null && securityTokenForContext.getAuthorization().getCertificate() != null) {
                                sbError = new StringBuilder();
                                tipoToken = securityTokenForContext.getAuthorization().getHttpHeaderName() != null ? securityTokenForContext.getAuthorization().getHttpHeaderName() : "Authorization";
                                IdentificazioneApplicativoMittenteUtils.checkApplicativoTokenByX509(this.log, idSAbyToken, state, requestInfo, tipoToken, securityTokenForContext.getAuthorization().getCertificate(), sbError);
                                saVerificatoBySecurity = true;
                            }
                            if (securityTokenForContext.getIntegrity() != null && securityTokenForContext.getIntegrity().getCertificate() != null) {
                                sbError = new StringBuilder();
                                tipoToken = securityTokenForContext.getIntegrity().getHttpHeaderName() != null ? securityTokenForContext.getIntegrity().getHttpHeaderName() : this.modiProperties.getRestSecurityTokenHeaderModI();
                                IdentificazioneApplicativoMittenteUtils.checkApplicativoTokenByX509(this.log, idSAbyToken, state, requestInfo, tipoToken, securityTokenForContext.getIntegrity().getCertificate(), sbError);
                                saVerificatoBySecurity = true;
                            }
                            if (securityTokenForContext.getEnvelope() != null && securityTokenForContext.getEnvelope().getCertificate() != null) {
                                sbError = new StringBuilder();
                                tipoToken = "WSSecurity";
                                IdentificazioneApplicativoMittenteUtils.checkApplicativoTokenByX509(this.log, idSAbyToken, state, requestInfo, tipoToken, securityTokenForContext.getEnvelope().getCertificate(), sbError);
                                saVerificatoBySecurity = true;
                            }
                        }
                        catch (Exception e) {
                            if (sbError != null && sbError.length() > 0) {
                                this.context.addObject(org.openspcoop2.core.constants.Costanti.ERRORE_AUTORIZZAZIONE, (Object)"true");
                                this.erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.SICUREZZA_AUTORIZZAZIONE_FALLITA, sbError.toString()));
                                return;
                            }
                            throw e;
                        }
                    }
                }
                boolean saFruitoreAnonimo = busta.getServizioApplicativoFruitore() == null || "Anonimo".equals(busta.getServizioApplicativoFruitore());
                boolean autorizzazionePerRichiedente = false;
                if (pa.getAutorizzazioneToken() != null) {
                    autorizzazionePerRichiedente = StatoFunzionalita.ABILITATO.equals((Object)pa.getAutorizzazioneToken().getAutorizzazioneApplicativi());
                }
                if (!autorizzazionePerRichiedente && pa.getServiziApplicativiAutorizzati() != null) {
                    autorizzazionePerRichiedente = pa.getServiziApplicativiAutorizzati().sizeServizioApplicativoList() > 0;
                }
                boolean autorizzazionePerRuolo = false;
                boolean checkRuoloRegistro = false;
                boolean checkRuoloEsterno = false;
                if (pa.getAutorizzazioneToken() != null) {
                    autorizzazionePerRuolo = StatoFunzionalita.ABILITATO.equals((Object)pa.getAutorizzazioneToken().getAutorizzazioneRuoli());
                }
                if (autorizzazionePerRuolo) {
                    if (pa.getAutorizzazioneToken().getTipologiaRuoli() == null || RuoloTipologia.QUALSIASI.equals((Object)pa.getAutorizzazioneToken().getTipologiaRuoli())) {
                        checkRuoloRegistro = true;
                        checkRuoloEsterno = true;
                    } else if (RuoloTipologia.INTERNO.equals((Object)pa.getAutorizzazioneToken().getTipologiaRuoli())) {
                        checkRuoloRegistro = true;
                    } else if (RuoloTipologia.ESTERNO.equals((Object)pa.getAutorizzazioneToken().getTipologiaRuoli())) {
                        checkRuoloEsterno = true;
                    }
                }
                if ((autorizzazionePerRichiedente || autorizzazionePerRuolo && checkRuoloRegistro && !checkRuoloEsterno) && saFruitoreAnonimo) {
                    this.context.addObject(org.openspcoop2.core.constants.Costanti.ERRORE_AUTORIZZAZIONE, (Object)"true");
                    this.erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.SICUREZZA_AUTORIZZAZIONE_FALLITA, "Applicativo Mittente non identificato"));
                    return;
                }
                if (!saFruitoreAnonimo && (autorizzazionePerRichiedente || checkRuoloRegistro)) {
                    if (sicurezzaMessaggio && !sicurezzaMessaggioIDAR04 && !saIdentificatoBySecurity && !saVerificatoBySecurity) {
                        this.context.addObject(org.openspcoop2.core.constants.Costanti.ERRORE_AUTORIZZAZIONE, (Object)"true");
                        this.addErroreMittenteNonAutorizzato(busta, "il certificato di firma non corrisponde all'applicativo");
                        return;
                    }
                    if (sicurezzaToken && !saIdentificatoByToken) {
                        this.context.addObject(org.openspcoop2.core.constants.Costanti.ERRORE_AUTORIZZAZIONE, (Object)"true");
                        this.addErroreMittenteNonAutorizzato(busta, "il claim 'clientId' presente nel token non corrisponde all'applicativo");
                        return;
                    }
                }
                Eccezione eccezioneAutorizzazionePerRichiedente = null;
                if (autorizzazionePerRichiedente) {
                    boolean autorizzato = false;
                    if (pa.getServiziApplicativiAutorizzati() != null) {
                        for (PortaApplicativaAutorizzazioneServizioApplicativo paSA : pa.getServiziApplicativiAutorizzati().getServizioApplicativoList()) {
                            if (!paSA.getTipoSoggettoProprietario().equals(busta.getTipoMittente()) || !paSA.getNomeSoggettoProprietario().equals(busta.getMittente()) || !paSA.getNome().equals(busta.getServizioApplicativoFruitore())) continue;
                            autorizzato = true;
                        }
                    }
                    if (!autorizzato) {
                        eccezioneAutorizzazionePerRichiedente = this.getErroreMittenteNonAutorizzato(busta, null);
                    }
                }
                Eccezione eccezioneAutorizzazionePerRuolo = null;
                if (autorizzazionePerRuolo) {
                    boolean authRuoli;
                    StringBuilder detailsBufferRuoli = new StringBuilder();
                    ServizioApplicativo sa = null;
                    if (!saFruitoreAnonimo) {
                        IDServizioApplicativo idSA = new IDServizioApplicativo();
                        idSA.setIdSoggettoProprietario(new IDSoggetto(busta.getTipoMittente(), busta.getMittente()));
                        idSA.setNome(busta.getServizioApplicativoFruitore());
                        sa = factory.getCachedConfigIntegrationReader(state, requestInfo).getServizioApplicativo(idSA);
                    }
                    if (!(authRuoli = ConfigurazionePdDReader._autorizzazioneRoles((RegistroServiziManager)RegistroServiziManager.getInstance((IState)state), null, sa, null, (boolean)false, (Context)this.context, (RequestInfo)requestInfo, (boolean)checkRuoloRegistro, (boolean)checkRuoloEsterno, (StringBuilder)detailsBufferRuoli, (RuoloTipoMatch)pa.getAutorizzazioneToken().getRuoli().getMatch(), (AutorizzazioneRuoli)pa.getAutorizzazioneToken().getRuoli(), (boolean)true))) {
                        Object errore = "Applicativo Mittente";
                        if (!saFruitoreAnonimo) {
                            errore = (String)errore + " " + busta.getServizioApplicativoFruitore() + " (Soggetto: " + busta.getMittente() + ")";
                        }
                        errore = (String)errore + " non autorizzato; ";
                        eccezioneAutorizzazionePerRuolo = this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.SICUREZZA_AUTORIZZAZIONE_FALLITA, (String)errore + detailsBufferRuoli.toString());
                    }
                }
                if (autorizzazionePerRichiedente && autorizzazionePerRuolo) {
                    if (eccezioneAutorizzazionePerRichiedente != null && eccezioneAutorizzazionePerRuolo != null) {
                        this.context.addObject(org.openspcoop2.core.constants.Costanti.ERRORE_AUTORIZZAZIONE, (Object)"true");
                        this.erroriValidazione.add(eccezioneAutorizzazionePerRuolo);
                    }
                } else if (eccezioneAutorizzazionePerRichiedente != null || eccezioneAutorizzazionePerRuolo != null) {
                    this.context.addObject(org.openspcoop2.core.constants.Costanti.ERRORE_AUTORIZZAZIONE, (Object)"true");
                    if (eccezioneAutorizzazionePerRichiedente != null) {
                        this.erroriValidazione.add(eccezioneAutorizzazionePerRichiedente);
                    } else {
                        this.erroriValidazione.add(eccezioneAutorizzazionePerRuolo);
                    }
                }
                if ((sizeListaEccezioniPrimaAutorizzazione = sizeListaErroriValidazionePrimaAutorizzazione + sizeListaProcessamentoValidazionePrimaAutorizzazione) == (sizeListaEccezioniDipoAutorizzazione = this.erroriValidazione.size() + this.erroriProcessamento.size())) {
                    msgDiag.logPersonalizzato(DIAGNOSTIC_VALIDATE + tipoDiagnostico + DIAGNOSTIC_COMPLETATA);
                } else {
                    String errore = null;
                    errore = sizeListaErroriValidazionePrimaAutorizzazione != this.erroriValidazione.size() ? ModIValidazioneSintattica.buildErrore(this.erroriValidazione, sizeListaErroriValidazionePrimaAutorizzazione, factory) : ModIValidazioneSintattica.buildErrore(this.erroriProcessamento, sizeListaProcessamentoValidazionePrimaAutorizzazione, factory);
                    msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", errore);
                    msgDiag.logPersonalizzato(DIAGNOSTIC_VALIDATE + tipoDiagnostico + DIAGNOSTIC_FALLITA);
                }
                autorizzazione = false;
            }
            catch (Exception e) {
                if (msgDiag != null && (verifica || autorizzazione)) {
                    msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", e.getMessage());
                    msgDiag.logPersonalizzato(DIAGNOSTIC_VALIDATE + tipoDiagnostico + DIAGNOSTIC_FALLITA);
                }
                this.erroriProcessamento.add(this.validazioneUtils.newEccezioneProcessamento(CodiceErroreCooperazione.ERRORE_GENERICO_PROCESSAMENTO_MESSAGGIO, e.getMessage(), (Throwable)e));
            }
        }
    }

    private boolean isAudienceValid(String audienceAtteso, String audience, List<String> listAudience) {
        boolean checkAudience = false;
        if (audienceAtteso != null && !(checkAudience = audienceAtteso.equals(audience)) && listAudience != null && !listAudience.isEmpty()) {
            for (String check : listAudience) {
                if (!audienceAtteso.equals(check)) continue;
                checkAudience = true;
                break;
            }
        }
        return checkAudience;
    }

    private void checkExp(String exp, Date now, boolean rest, String prefix) throws ProtocolException {
        boolean enabled = true;
        enabled = rest ? this.modiProperties.isRestSecurityTokenClaimsExpTimeCheck() : this.modiProperties.isSoapSecurityTokenTimestampExpiresTimeCheck();
        if (!enabled) {
            return;
        }
        if (prefix == null) {
            prefix = "";
        }
        Date dateExp = null;
        try {
            dateExp = DateUtils.getSimpleDateFormatMs().parse(exp);
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
        Date checkNow = now;
        Long tolerance = null;
        tolerance = rest ? this.modiProperties.getRestSecurityTokenClaimsExpTimeCheckToleranceMilliseconds() : this.modiProperties.getSoapSecurityTokenTimestampExpiresTimeCheckToleranceMilliseconds();
        if (tolerance != null && tolerance > 0L) {
            checkNow = new Date(now.getTime() - tolerance);
        }
        if (!checkNow.before(dateExp)) {
            this.erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.MESSAGGIO_SCADUTO, prefix + "Token scaduto in data '" + exp + "'"));
        }
    }

    private void checkNbf(String nbf, Date now, String prefix) throws ProtocolException {
        if (prefix == null) {
            prefix = "";
        }
        Date dateNbf = null;
        try {
            dateNbf = DateUtils.getSimpleDateFormatMs().parse(nbf);
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
        Long future = this.modiProperties.getRestSecurityTokenClaimsNbfTimeCheckToleranceMilliseconds();
        Date futureMax = now;
        if (future != null && future > 0L) {
            futureMax = new Date(now.getTime() + future);
        }
        if (!dateNbf.before(futureMax)) {
            this.erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.MESSAGGIO_SCADUTO, prefix + "Token non utilizzabile prima della data '" + nbf + "'"));
        }
    }

    private void checkIat(String iat, OpenSPCoop2Message msg, boolean rest, String prefix) throws ProtocolException {
        Date oldMax;
        if (prefix == null) {
            prefix = "";
        }
        Date dateIat = null;
        try {
            dateIat = DateUtils.getSimpleDateFormatMs().parse(iat);
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
        Long old = null;
        Object iatObject = null;
        if (msg != null) {
            iatObject = msg.getContextProperty(ModICostanti.MODIPA_OPENSPCOOP2_MSG_CONTEXT_IAT_TTL_CHECK);
        }
        if (iatObject instanceof Long) {
            old = (Long)iatObject;
        }
        if (old == null) {
            old = rest ? this.modiProperties.getRestSecurityTokenClaimsIatTimeCheckMilliseconds() : this.modiProperties.getSoapSecurityTokenTimestampCreatedTimeCheckMilliseconds();
        }
        if (old != null && dateIat.before(oldMax = new Date(DateManager.getTimeMillis() - old))) {
            this.logError(prefix + "Token creato da troppo tempo (data creazione: '" + iat + "', data pi\u00f9 vecchia consentita: '" + DateUtils.getSimpleDateFormatMs().format(oldMax) + "', configurazione ms: '" + old + "')");
            this.erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.MESSAGGIO_SCADUTO, prefix + "Token creato da troppo tempo (data creazione: '" + iat + "')"));
        }
        this.checkIatFuture(dateIat, prefix, iat, rest);
    }

    private void checkIatFuture(Date dateIat, String prefix, String iat, boolean rest) throws ProtocolException {
        Date futureMax;
        Long future = null;
        future = rest ? this.modiProperties.getRestSecurityTokenClaimsIatTimeCheckFutureToleranceMilliseconds() : this.modiProperties.getSoapSecurityTokenTimestampCreatedTimeCheckFutureToleranceMilliseconds();
        if (future != null && future > 0L && dateIat.after(futureMax = new Date(DateManager.getTimeMillis() + future))) {
            this.logError(prefix + "Token creato nel futuro (data creazione: '" + iat + "', data massima futura consentita: '" + DateUtils.getSimpleDateFormatMs().format(futureMax) + "', configurazione ms: '" + future + "')");
            this.erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.ORA_REGISTRAZIONE_NON_VALIDA, prefix + "Token creato nel futuro (data creazione: '" + iat + "')"));
        }
    }

    private void validatePurposeId(RemoteStoreConfig rsc, String prefixAudit, String securityAuditPattern) throws ProtocolException {
        try {
            if (rsc != null && (this.modiProperties.isSecurityTokenAuditExpectedPurposeId() || this.modiProperties.isSecurityTokenAuditCompareAuthorizationPurposeId())) {
                SecurityToken securityToken = ModIUtilities.readSecurityToken(this.context);
                if (securityToken == null) {
                    this.erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.SICUREZZA_NON_PRESENTE, "Token di sicurezza non presenti"));
                    return;
                }
                RestMessageSecurityToken restSecurityToken = securityToken.getAccessToken();
                String prefixAuthorization = this.getPrefixHeader("Authorization");
                String labelAuditPattern = "audit02".equals(securityAuditPattern) ? "AUDIT_REST_02" : "AUDIT_REST_01";
                String suffixAudit02 = " (richiesto con pattern '" + labelAuditPattern + "')";
                if (restSecurityToken == null) {
                    this.erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.SICUREZZA_NON_PRESENTE, prefixAuthorization + MSG_ERRORE_NON_PRESENTE + suffixAudit02));
                    return;
                }
                RestMessageSecurityToken auditToken = securityToken.getAudit();
                if (auditToken == null) {
                    this.erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.SICUREZZA_NON_PRESENTE, prefixAudit + MSG_ERRORE_NON_PRESENTE));
                    return;
                }
                boolean expected = this.modiProperties.isSecurityTokenAuditExpectedPurposeId();
                String purposeIdAuthorization = this.readPurposeId(restSecurityToken, prefixAuthorization, expected);
                String purposeIdAudit = this.readPurposeId(auditToken, prefixAudit, expected);
                if (this.modiProperties.isSecurityTokenAuditCompareAuthorizationPurposeId() && purposeIdAuthorization != null && purposeIdAudit != null && !purposeIdAuthorization.equals(purposeIdAudit)) {
                    String claim = "purposeId";
                    this.erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.SICUREZZA_NON_PRESENTE, prefixAudit + "Claim '" + claim + "' presente nel token contiene un valore '" + purposeIdAudit + "' differente da quello presente nel token Authorization (" + purposeIdAuthorization + ")"));
                }
            }
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
    }

    private String readPurposeId(RestMessageSecurityToken restSecurityToken, String prefixAuthorization, boolean required) throws ProtocolException {
        String purposeId = null;
        String purposeIdClaim = "purposeId";
        try {
            purposeId = restSecurityToken.getPayloadClaim(purposeIdClaim);
            if ((purposeId == null || StringUtils.isEmpty((CharSequence)purposeId)) && required) {
                this.erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.SICUREZZA_TOKEN_NON_VALIDO, prefixAuthorization + this.getErroreClaimNonPresente(purposeIdClaim)));
            }
        }
        catch (Exception e) {
            this.logError("Lettura purpose id token fallita: " + e.getMessage(), e);
            this.erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.SICUREZZA_TOKEN_NON_VALIDO, prefixAuthorization + this.getErroreClaimNonValido(purposeIdClaim)));
        }
        return purposeId;
    }

    private void validateAudit02(String securityMessageProfileSorgenteTokenIdAuth, boolean rest, String prefixAudit) throws ProtocolException {
        SecurityToken securityToken;
        boolean expectedAccessToken = false;
        if ("pdnd".equals(securityMessageProfileSorgenteTokenIdAuth) || "oauth".equals(securityMessageProfileSorgenteTokenIdAuth)) {
            expectedAccessToken = true;
        }
        if ((securityToken = ModIUtilities.readSecurityToken(this.context)) == null) {
            this.erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.SICUREZZA_NON_PRESENTE, "Token di sicurezza non presenti"));
            return;
        }
        RestMessageSecurityToken restSecurityToken = null;
        if (expectedAccessToken) {
            restSecurityToken = securityToken.getAccessToken();
        } else if (rest) {
            restSecurityToken = securityToken.getAuthorization();
        } else {
            this.erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.SICUREZZA_TOKEN_NON_VALIDO, "Token di sicurezza IDAuth Locale su API Soap non \u00e8 utilizzabile con pattern AUDIT_REST_02"));
            return;
        }
        String prefixAuthorization = this.getPrefixHeader("Authorization");
        String suffixAudit02 = " (richiesto con pattern 'AUDIT_REST_02')";
        if (restSecurityToken == null) {
            this.erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.SICUREZZA_NON_PRESENTE, prefixAuthorization + MSG_ERRORE_NON_PRESENTE + suffixAudit02));
            return;
        }
        String digestClaimPrefix = "digest.";
        String digestAlgo = this.readDigestAlgorithm(digestClaimPrefix, restSecurityToken, prefixAuthorization);
        String digestValue = this.readDigestValue(digestClaimPrefix, restSecurityToken, prefixAuthorization);
        if (digestAlgo == null || digestValue == null) {
            return;
        }
        RestMessageSecurityToken auditSecurityToken = securityToken.getAudit();
        if (auditSecurityToken == null || auditSecurityToken.getToken() == null || StringUtils.isEmpty((CharSequence)((CharSequence)((Object)auditSecurityToken.getToken())))) {
            this.erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.SICUREZZA_TOKEN_NON_PRESENTE, prefixAudit + MSG_ERRORE_NON_PRESENTE));
            return;
        }
        String digestAuditRicalcolato = null;
        try {
            digestAuditRicalcolato = DigestUtils.getDigestValue((byte[])((String)((Object)auditSecurityToken.getToken())).getBytes(), (String)digestAlgo, (DigestEncoding)DigestEncoding.HEX, (boolean)false);
        }
        catch (Exception e) {
            this.logError("Calcolo digest del token di audit fallito: " + e.getMessage(), e);
            this.erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.SICUREZZA, prefixAudit + "check digest failed"));
            return;
        }
        if (!digestValue.equalsIgnoreCase(digestAuditRicalcolato)) {
            String digestValueClaim = digestClaimPrefix + "value";
            this.erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.SICUREZZA_TOKEN_NON_VALIDO, prefixAuthorization + "possiede un valore nel campo '" + digestValueClaim + "' non corrispondente al token di audit previsto dal pattern 'AUDIT_REST_02'"));
        }
    }

    private String readDigestAlgorithm(String digestClaimPrefix, RestMessageSecurityToken restSecurityToken, String prefixAuthorization) throws ProtocolException {
        String digestAlgo = null;
        String digestAlgClaim = digestClaimPrefix + "alg";
        try {
            digestAlgo = restSecurityToken.getPayloadClaim(digestAlgClaim);
            if (digestAlgo == null || StringUtils.isEmpty((CharSequence)digestAlgo)) {
                this.erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.SICUREZZA_TOKEN_NON_VALIDO, prefixAuthorization + this.getErroreClaimNonPresente(digestAlgClaim)));
            }
        }
        catch (Exception e) {
            this.logError("Lettura algoritmo di digest in authorization token fallita: " + e.getMessage(), e);
            this.erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.SICUREZZA_TOKEN_NON_VALIDO, prefixAuthorization + this.getErroreClaimNonValido(digestAlgClaim)));
        }
        return digestAlgo;
    }

    private String readDigestValue(String digestClaimPrefix, RestMessageSecurityToken restSecurityToken, String prefixAuthorization) throws ProtocolException {
        String digestValue = null;
        String digestValueClaim = digestClaimPrefix + "value";
        try {
            digestValue = restSecurityToken.getPayloadClaim(digestValueClaim);
            if (digestValue == null || StringUtils.isEmpty((CharSequence)digestValue)) {
                this.erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.SICUREZZA_TOKEN_NON_VALIDO, prefixAuthorization + this.getErroreClaimNonPresente(digestValueClaim)));
            }
        }
        catch (Exception e) {
            this.logError("Lettura valore del digest audit in authorization token fallita: " + e.getMessage(), e);
            this.erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.SICUREZZA_TOKEN_NON_VALIDO, prefixAuthorization + this.getErroreClaimNonValido(digestValueClaim)));
        }
        return digestValue;
    }

    private void validateTokenAuthorizationId(OpenSPCoop2Message msg, String prefixAuthorization, ModIValidazioneSemanticaProfiloSicurezza modIValidazioneSemanticaProfiloSicurezza) throws ProtocolException {
        boolean useJtiAuthorization = ModIUtils.useJtiAuthorizationObject((OpenSPCoop2Message)msg);
        if (useJtiAuthorization) {
            String jtiClaimReceived = TokenUtilities.readJtiFromInformazioniToken((Context)this.context);
            if (jtiClaimReceived == null || StringUtils.isEmpty((CharSequence)jtiClaimReceived)) {
                this.erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.IDENTIFICATIVO_MESSAGGIO_NON_PRESENTE, prefixAuthorization + this.getErroreClaimNonPresente("jti")));
            } else if (modIValidazioneSemanticaProfiloSicurezza != null) {
                // empty if block
            }
        }
    }

    private PortaApplicativa validateTokenAuthorizationAudience(OpenSPCoop2Message msg, IProtocolFactory<?> factory, IState state, RequestInfo requestInfo, boolean isRichiesta, String prefixAuthorization, boolean checkAudienceByModIConfig) throws ProtocolException {
        PortaApplicativa pa = this.readPortaApplicativa(msg, factory, state, requestInfo);
        boolean audienceCheckDefinedInAuthorizationTokenClaims = this.isAudienceCheckDefinedInAuthorizationTokenClaims(pa);
        if (!audienceCheckDefinedInAuthorizationTokenClaims) {
            this.validateTokenAuthorizationAudienceByModIConfig(msg, factory, state, requestInfo, isRichiesta, prefixAuthorization, checkAudienceByModIConfig);
        }
        return pa;
    }

    private void validateTokenAuthorizationAudienceByModIConfig(OpenSPCoop2Message msg, IProtocolFactory<?> factory, IState state, RequestInfo requestInfo, boolean isRichiesta, String prefixAuthorization, boolean checkAudienceByModIConfig) throws ProtocolException {
        List<String> audienceClaimReceived = this.readAudienceFromTokenOAuth();
        if (audienceClaimReceived == null || audienceClaimReceived.isEmpty()) {
            this.erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(isRichiesta ? CodiceErroreCooperazione.SERVIZIO_APPLICATIVO_EROGATORE_NON_PRESENTE : CodiceErroreCooperazione.SERVIZIO_APPLICATIVO_FRUITORE_NON_PRESENTE, prefixAuthorization + this.getErroreClaimNonPresente("aud")));
        } else if (checkAudienceByModIConfig) {
            this.checkAudienceModIConfig(msg, factory, state, requestInfo, isRichiesta, prefixAuthorization, audienceClaimReceived);
        } else {
            this.erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(isRichiesta ? CodiceErroreCooperazione.SERVIZIO_APPLICATIVO_EROGATORE_NON_VALIDO : CodiceErroreCooperazione.SERVIZIO_APPLICATIVO_FRUITORE_NON_VALIDO, prefixAuthorization + "Token contenente un claim 'aud' non verificabile; autorizzazione per token claim non definita"));
        }
    }

    private boolean validateTokenAuthorizationClaims(RemoteStoreConfig rsc, IDSoggetto idSoggetto, boolean isRichiesta, String prefixAuthorization) throws ProtocolException {
        List<String> claimsAttesi = null;
        claimsAttesi = rsc != null ? this.modiProperties.getValidazioneTokenPDNDClaimsRequired(idSoggetto.getNome()) : this.modiProperties.getValidazioneTokenOAuthClaimsRequired(idSoggetto.getNome());
        if (claimsAttesi != null && !claimsAttesi.isEmpty()) {
            for (String claim : claimsAttesi) {
                String claimValue = this.readClaimFromTokenOAuth(claim);
                if (claimValue != null && !StringUtils.isEmpty((CharSequence)claimValue)) continue;
                this.erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(isRichiesta ? CodiceErroreCooperazione.SERVIZIO_APPLICATIVO_EROGATORE_NON_PRESENTE : CodiceErroreCooperazione.SERVIZIO_APPLICATIVO_FRUITORE_NON_PRESENTE, prefixAuthorization + this.getErroreClaimNonPresente(claim)));
                return false;
            }
        }
        return true;
    }

    private boolean validateTokenAuthorizationProducerIdByModIConfig(IRegistryReader registryReader, IDSoggetto idSoggetto, boolean isRichiesta, String prefixAuthorization) throws ProtocolException {
        boolean checkEnabled;
        boolean bl = checkEnabled = idSoggetto != null && idSoggetto.getNome() != null && this.modiProperties.isValidazioneTokenPDNDProducerIdCheck(idSoggetto.getNome());
        if (!checkEnabled) {
            return true;
        }
        String producerIdClaimReceived = this.readProducerIdFromTokenOAuth();
        if (producerIdClaimReceived != null && StringUtils.isNotEmpty((CharSequence)producerIdClaimReceived)) {
            Soggetto s = null;
            try {
                s = registryReader.getSoggetto(idSoggetto);
            }
            catch (Exception e) {
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
            String idEnte = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry((List)s.getProtocolPropertyList(), (String)"modipaSoggettoIDEnte");
            if (idEnte != null && StringUtils.isNotEmpty((CharSequence)idEnte) && !idEnte.equals(producerIdClaimReceived)) {
                this.erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(isRichiesta ? CodiceErroreCooperazione.SERVIZIO_APPLICATIVO_EROGATORE_NON_VALIDO : CodiceErroreCooperazione.SERVIZIO_APPLICATIVO_FRUITORE_NON_VALIDO, prefixAuthorization + this.getErroreClaimNonValido("producerId")));
                return false;
            }
        }
        return true;
    }

    private boolean validateTokenAuthorizationServiceDescriptorIdByModIConfig(IRegistryReader registryReader, Busta busta, boolean isRichiesta, String prefixAuthorization) throws ProtocolException {
        IDServizio idServizio = null;
        if (busta != null && busta.getTipoServizio() != null && busta.getServizio() != null && busta.getVersioneServizio() != null && busta.getTipoDestinatario() != null && busta.getDestinatario() != null) {
            try {
                idServizio = IDServizioFactory.getInstance().getIDServizioFromValues(busta.getTipoServizio(), busta.getServizio(), busta.getTipoDestinatario(), busta.getDestinatario(), busta.getVersioneServizio().intValue());
            }
            catch (Exception e) {
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
            AccordoServizioParteSpecifica asps = null;
            try {
                asps = registryReader.getAccordoServizioParteSpecifica(idServizio, false);
            }
            catch (Exception e) {
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
            if (!this.validateTokenAuthorizationServiceIdByModIConfig(asps, isRichiesta, prefixAuthorization)) {
                return false;
            }
            if (!this.validateTokenAuthorizationDescriptorIdByModIConfig(asps, isRichiesta, prefixAuthorization)) {
                return false;
            }
        }
        return true;
    }

    private boolean validateTokenAuthorizationServiceIdByModIConfig(AccordoServizioParteSpecifica asps, boolean isRichiesta, String prefixAuthorization) throws ProtocolException {
        boolean checkEnabled;
        boolean bl = checkEnabled = asps != null && asps.getNomeSoggettoErogatore() != null && this.modiProperties.isValidazioneTokenPDNDEServiceIdCheck(asps.getNomeSoggettoErogatore());
        if (!checkEnabled) {
            return true;
        }
        String eServiceId = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry((List)asps.getProtocolPropertyList(), (String)"modipaInfoGenEserviceId");
        if (eServiceId != null && StringUtils.isNotEmpty((CharSequence)eServiceId)) {
            String serviceIdClaimReceived = this.readServiceIdFromTokenOAuth();
            if (serviceIdClaimReceived == null || StringUtils.isEmpty((CharSequence)serviceIdClaimReceived)) {
                this.erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(isRichiesta ? CodiceErroreCooperazione.SERVIZIO_APPLICATIVO_EROGATORE_NON_VALIDO : CodiceErroreCooperazione.SERVIZIO_APPLICATIVO_FRUITORE_NON_VALIDO, prefixAuthorization + this.getErroreClaimNonPresente("eserviceId")));
                return false;
            }
            if (!serviceIdClaimReceived.equals(eServiceId)) {
                this.erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(isRichiesta ? CodiceErroreCooperazione.SERVIZIO_APPLICATIVO_EROGATORE_NON_VALIDO : CodiceErroreCooperazione.SERVIZIO_APPLICATIVO_FRUITORE_NON_VALIDO, prefixAuthorization + this.getErroreClaimNonValido("eserviceId")));
                return false;
            }
        }
        return true;
    }

    private boolean validateTokenAuthorizationDescriptorIdByModIConfig(AccordoServizioParteSpecifica asps, boolean isRichiesta, String prefixAuthorization) throws ProtocolException {
        boolean checkEnabled;
        boolean bl = checkEnabled = asps != null && asps.getNomeSoggettoErogatore() != null && this.modiProperties.isValidazioneTokenPDNDDescriptorIdCheck(asps.getNomeSoggettoErogatore());
        if (!checkEnabled) {
            return true;
        }
        String tmpDescriptorId = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry((List)asps.getProtocolPropertyList(), (String)"modipaInfoGenDescriptorId");
        List<String> descriptorIdList = null;
        if (tmpDescriptorId != null && StringUtils.isNotEmpty((CharSequence)tmpDescriptorId)) {
            descriptorIdList = ModISecurityConfig.convertToList(tmpDescriptorId);
        }
        if (descriptorIdList != null && !descriptorIdList.isEmpty()) {
            return this.validateTokenAuthorizationDescriptorIdByModIConfig(descriptorIdList, isRichiesta, prefixAuthorization);
        }
        return true;
    }

    private boolean validateTokenAuthorizationDescriptorIdByModIConfig(List<String> descriptorIdList, boolean isRichiesta, String prefixAuthorization) throws ProtocolException {
        String descriptorIdClaimReceived = this.readDescriptorIdFromTokenOAuth();
        if (descriptorIdClaimReceived == null || StringUtils.isEmpty((CharSequence)descriptorIdClaimReceived)) {
            this.erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(isRichiesta ? CodiceErroreCooperazione.SERVIZIO_APPLICATIVO_EROGATORE_NON_VALIDO : CodiceErroreCooperazione.SERVIZIO_APPLICATIVO_FRUITORE_NON_VALIDO, prefixAuthorization + this.getErroreClaimNonPresente("descriptorId")));
            return false;
        }
        if (!descriptorIdList.contains(descriptorIdClaimReceived)) {
            this.erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(isRichiesta ? CodiceErroreCooperazione.SERVIZIO_APPLICATIVO_EROGATORE_NON_VALIDO : CodiceErroreCooperazione.SERVIZIO_APPLICATIVO_FRUITORE_NON_VALIDO, prefixAuthorization + this.getErroreClaimNonValido("descriptorId")));
            return false;
        }
        return true;
    }

    private PortaApplicativa readPortaApplicativa(OpenSPCoop2Message msg, IProtocolFactory<?> factory, IState state, RequestInfo requestInfo) throws ProtocolException {
        PortaApplicativa pa = null;
        String interfaceName = null;
        if (msg != null && msg.getTransportRequestContext() != null && msg.getTransportRequestContext().getInterfaceName() != null) {
            interfaceName = msg.getTransportRequestContext().getInterfaceName();
        } else if (requestInfo != null && requestInfo.getProtocolContext() != null && requestInfo.getProtocolContext().getInterfaceName() != null) {
            interfaceName = requestInfo.getProtocolContext().getInterfaceName();
        }
        if (interfaceName == null) {
            throw new ProtocolException("ID Porta non presente");
        }
        IDPortaApplicativa idPA = new IDPortaApplicativa();
        idPA.setNome(interfaceName);
        try {
            pa = factory.getCachedConfigIntegrationReader(state, requestInfo).getPortaApplicativa(idPA);
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
        return pa;
    }

    private PortaApplicativa readPortaApplicativaDefault(OpenSPCoop2Message msg, IProtocolFactory<?> factory, IState state, RequestInfo requestInfo) throws ProtocolException {
        PortaApplicativa paDefault = null;
        if (msg != null) {
            Object nomePortaInvocataObject = msg.getContextProperty(CostantiPdD.NOME_PORTA_INVOCATA);
            String nomePorta = null;
            if (nomePortaInvocataObject instanceof String) {
                nomePorta = (String)nomePortaInvocataObject;
            }
            if (nomePorta == null && this.context != null && this.context.containsKey(CostantiPdD.NOME_PORTA_INVOCATA)) {
                nomePorta = (String)this.context.getObject(CostantiPdD.NOME_PORTA_INVOCATA);
            }
            if (nomePorta == null && requestInfo != null && requestInfo.getProtocolContext() != null && requestInfo.getProtocolContext().getInterfaceName() != null) {
                nomePorta = requestInfo.getProtocolContext().getInterfaceName();
            }
            if (nomePorta != null) {
                IDPortaApplicativa idPA = new IDPortaApplicativa();
                idPA.setNome(nomePorta);
                try {
                    paDefault = factory.getCachedConfigIntegrationReader(state, requestInfo).getPortaApplicativa(idPA);
                }
                catch (Exception e) {
                    throw new ProtocolException(e.getMessage(), (Throwable)e);
                }
            } else {
                throw new ProtocolException("ID Porta 'default' non presente");
            }
        }
        return paDefault;
    }

    private boolean isAudienceCheckDefinedInAuthorizationTokenClaims(PortaApplicativa pa) throws ProtocolException {
        boolean audienceCheckDefinedInAuthorizationTokenClaims = false;
        if (pa.getGestioneToken() != null && pa.getGestioneToken().getOptions() != null) {
            SortedMap properties = null;
            try {
                properties = PropertiesUtilities.convertTextToSortedListMap((String)pa.getGestioneToken().getOptions());
            }
            catch (Exception e) {
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
            if (properties != null && properties.size() > 0 && properties.containsKey("aud")) {
                audienceCheckDefinedInAuthorizationTokenClaims = true;
            }
        }
        return audienceCheckDefinedInAuthorizationTokenClaims;
    }

    private List<String> readAudienceFromTokenOAuth() {
        Object oInformazioniTokenNormalizzate = null;
        if (this.context != null) {
            oInformazioniTokenNormalizzate = this.context.getObject(Costanti.PDD_CONTEXT_TOKEN_INFORMAZIONI_NORMALIZZATE);
        }
        InformazioniToken informazioniTokenNormalizzate = null;
        List audienceClaimReceived = null;
        if (oInformazioniTokenNormalizzate != null) {
            informazioniTokenNormalizzate = (InformazioniToken)oInformazioniTokenNormalizzate;
            audienceClaimReceived = informazioniTokenNormalizzate.getAud();
        }
        return audienceClaimReceived;
    }

    private void checkAudienceModIConfig(OpenSPCoop2Message msg, IProtocolFactory<?> factory, IState state, RequestInfo requestInfo, boolean isRichiesta, String prefixAuthorization, List<String> audienceClaimReceived) throws ProtocolException {
        PortaApplicativa paDefault = this.readPortaApplicativaDefault(msg, factory, state, requestInfo);
        this.checkAudienceModIConfig(msg, state, requestInfo, isRichiesta, prefixAuthorization, paDefault, audienceClaimReceived);
    }

    private void checkAudienceModIConfig(OpenSPCoop2Message msg, IState state, RequestInfo requestInfo, boolean isRichiesta, String prefixAuthorization, PortaApplicativa paDefault, List<String> audienceClaimReceived) throws ProtocolException {
        ModISecurityConfig modISecurityConfig = new ModISecurityConfig(msg, this.protocolFactory, state, requestInfo, !isRichiesta, isRichiesta, paDefault);
        boolean find = false;
        for (String claim : audienceClaimReceived) {
            if (!claim.equalsIgnoreCase(modISecurityConfig.getAudience())) continue;
            find = true;
            break;
        }
        if (!find) {
            this.erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(isRichiesta ? CodiceErroreCooperazione.SERVIZIO_APPLICATIVO_EROGATORE_NON_VALIDO : CodiceErroreCooperazione.SERVIZIO_APPLICATIVO_FRUITORE_NON_VALIDO, prefixAuthorization + this.getErroreClaimNonValido("aud")));
        }
    }

    private String readProducerIdFromTokenOAuth() {
        return this.readClaimFromTokenOAuth("producerId");
    }

    private String readServiceIdFromTokenOAuth() {
        return this.readClaimFromTokenOAuth("eserviceId");
    }

    private String readDescriptorIdFromTokenOAuth() {
        return this.readClaimFromTokenOAuth("descriptorId");
    }

    private String readClaimFromTokenOAuth(String name) {
        Serializable s;
        Object oInformazioniTokenNormalizzate = null;
        if (this.context != null) {
            oInformazioniTokenNormalizzate = this.context.getObject(Costanti.PDD_CONTEXT_TOKEN_INFORMAZIONI_NORMALIZZATE);
        }
        InformazioniToken informazioniTokenNormalizzate = null;
        if (oInformazioniTokenNormalizzate != null && (informazioniTokenNormalizzate = (InformazioniToken)oInformazioniTokenNormalizzate).getClaims() != null && (s = (Serializable)informazioniTokenNormalizzate.getClaims().get(name)) instanceof String) {
            return (String)((Object)s);
        }
        return null;
    }
}

