/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.spcoop.archive;

import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.AccordoCooperazione;
import org.openspcoop2.core.registry.AccordoCooperazionePartecipanti;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.driver.IDAccordoFactory;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.protocol.sdk.registry.IRegistryReader;
import org.openspcoop2.protocol.spcoop.sica.SICAtoOpenSPCoopContext;

public class SPCoopArchiveExportUtils {
    public static void setCodiceIPA(AccordoServizioParteComune aspc, SICAtoOpenSPCoopContext contextSICA, IRegistryReader registryReader) throws Exception {
        if (aspc.getSoggettoReferente() != null) {
            IDSoggetto soggettoReferente = new IDSoggetto(aspc.getSoggettoReferente().getTipo(), aspc.getSoggettoReferente().getNome());
            String codiceIPAReferente = registryReader.getCodiceIPA(soggettoReferente);
            contextSICA.addMappingSoggettoSPCoopToCodiceIPA(soggettoReferente, codiceIPAReferente);
        }
        if (aspc.getServizioComposto() != null) {
            for (int i = 0; i < aspc.getServizioComposto().sizeServizioComponenteList(); ++i) {
                IDSoggetto soggettoErogatoreServizioComponente = new IDSoggetto(aspc.getServizioComposto().getServizioComponente(i).getTipoSoggetto(), aspc.getServizioComposto().getServizioComponente(i).getNomeSoggetto());
                String codiceIPASoggettoErogatoreServizioComponente = registryReader.getCodiceIPA(soggettoErogatoreServizioComponente);
                contextSICA.addMappingSoggettoSPCoopToCodiceIPA(soggettoErogatoreServizioComponente, codiceIPASoggettoErogatoreServizioComponente);
            }
        }
    }

    public static void setCodiceIPA(AccordoCooperazione ac, SICAtoOpenSPCoopContext contextSICA, IRegistryReader registryReader) throws Exception {
        if (ac.getSoggettoReferente() != null) {
            IDSoggetto soggettoCoordinatore = new IDSoggetto(ac.getSoggettoReferente().getTipo(), ac.getSoggettoReferente().getNome());
            String codiceIPACoordinatore = registryReader.getCodiceIPA(soggettoCoordinatore);
            contextSICA.addMappingSoggettoSPCoopToCodiceIPA(soggettoCoordinatore, codiceIPACoordinatore);
        }
        if (ac.getElencoPartecipanti() != null) {
            AccordoCooperazionePartecipanti partecipanti = ac.getElencoPartecipanti();
            for (int i = 0; i < partecipanti.sizeSoggettoPartecipanteList(); ++i) {
                IDSoggetto soggettoPartecipante = new IDSoggetto(partecipanti.getSoggettoPartecipante(i).getTipo(), partecipanti.getSoggettoPartecipante(i).getNome());
                String codiceIPAPartecipante = registryReader.getCodiceIPA(soggettoPartecipante);
                contextSICA.addMappingSoggettoSPCoopToCodiceIPA(soggettoPartecipante, codiceIPAPartecipante);
            }
        }
        for (int i = 0; i < ac.sizeUriServiziCompostiList(); ++i) {
            String uriServizioComposto = ac.getUriServiziComposti(i);
            IDAccordo idAccordoServizioComposto = IDAccordoFactory.getInstance().getIDAccordoFromUri(uriServizioComposto);
            if (idAccordoServizioComposto.getSoggettoReferente() == null) continue;
            String codiceIPASoggettoErogatoreServizioComposto = registryReader.getCodiceIPA(idAccordoServizioComposto.getSoggettoReferente());
            contextSICA.addMappingSoggettoSPCoopToCodiceIPA(idAccordoServizioComposto.getSoggettoReferente(), codiceIPASoggettoErogatoreServizioComposto);
        }
    }

    public static void setCodiceIPA(IDServizio idS, IDAccordo idAccordoServizioParteComune, SICAtoOpenSPCoopContext contextSICA, IRegistryReader registryReader) throws Exception {
        String codiceIPASoggettoErogatore = registryReader.getCodiceIPA(idS.getSoggettoErogatore());
        contextSICA.addMappingSoggettoSPCoopToCodiceIPA(idS.getSoggettoErogatore(), codiceIPASoggettoErogatore);
        if (idAccordoServizioParteComune.getSoggettoReferente() != null) {
            IDSoggetto referenteParteComune = new IDSoggetto(idAccordoServizioParteComune.getSoggettoReferente().getTipo(), idAccordoServizioParteComune.getSoggettoReferente().getNome());
            String codiceIPAReferenteParteComune = registryReader.getCodiceIPA(referenteParteComune);
            contextSICA.addMappingSoggettoSPCoopToCodiceIPA(referenteParteComune, codiceIPAReferenteParteComune);
        }
    }

    public static void setURI_APS(AccordoServizioParteComune as, SICAtoOpenSPCoopContext contextSICA, IRegistryReader registryReader) throws Exception {
        if (as.getServizioComposto() != null) {
            for (int i = 0; i < as.getServizioComposto().sizeServizioComponenteList(); ++i) {
                IDSoggetto soggettoErogatoreServizioComponente = new IDSoggetto(as.getServizioComposto().getServizioComponente(i).getTipoSoggetto(), as.getServizioComposto().getServizioComponente(i).getNomeSoggetto());
                IDServizio idServizioComponente = IDServizioFactory.getInstance().getIDServizioFromValues(as.getServizioComposto().getServizioComponente(i).getTipo(), as.getServizioComposto().getServizioComponente(i).getNome(), soggettoErogatoreServizioComponente, as.getServizioComposto().getServizioComponente(i).getVersione().intValue());
                contextSICA.addMappingServizioToUriAPS(registryReader, idServizioComponente);
            }
        }
    }
}

