/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.spcoop.validator;

import jakarta.xml.soap.SOAPBody;
import jakarta.xml.soap.SOAPElement;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.xml.MessageXMLUtils;
import org.openspcoop2.message.xml.ValidatoreXSD;
import org.openspcoop2.protocol.basic.BasicStateComponentFactory;
import org.openspcoop2.protocol.sdk.Eccezione;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.constants.CodiceErroreCooperazione;
import org.openspcoop2.protocol.sdk.constants.ContestoCodificaEccezione;
import org.openspcoop2.protocol.sdk.constants.LivelloRilevanza;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.protocol.sdk.validator.IValidazioneConSchema;
import org.openspcoop2.protocol.spcoop.SPCoopBustaRawContent;
import org.openspcoop2.protocol.spcoop.config.SPCoopProperties;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.xml.XSDResourceResolver;
import org.slf4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.SAXException;

public class SPCoopValidazioneConSchema
extends BasicStateComponentFactory
implements IValidazioneConSchema {
    private static HashMap<String, ValidatoreXSD> validatoreBustaSPCoop_map = new HashMap();
    private List<Eccezione> erroriValidazione;
    private List<Eccezione> erroriProcessamento;

    public SPCoopValidazioneConSchema(IProtocolFactory<?> protocolFactory, IState state) throws ProtocolException {
        super(protocolFactory, state);
    }

    public List<Eccezione> getEccezioniValidazione() {
        return this.erroriValidazione;
    }

    public List<Eccezione> getEccezioniProcessamento() {
        return this.erroriProcessamento;
    }

    public static synchronized boolean initializeSchema(OpenSPCoop2MessageFactory messageFactory, Logger log) {
        String key = messageFactory.getClass().getName();
        if (!validatoreBustaSPCoop_map.containsKey(key)) {
            if (log == null) {
                log = LoggerWrapperFactory.getLogger((String)"ValidazioneConSchemaSPCoop");
            }
            try {
                SPCoopProperties spcoopProperties = SPCoopProperties.getInstance(log);
                log.info("Inizializzazione dello schema per il protocollo spcoop (possono essere necessari alcuni minuti...)");
                String[] schemiXSDDaImportare = spcoopProperties.getSchemiXSDImportatiValidazioneXSDBusta();
                String schemaXSD = spcoopProperties.getSchemaXSDValidazioneXSDBusta();
                ValidatoreXSD val = SPCoopValidazioneConSchema.createSchemaValidator(messageFactory, log, schemiXSDDaImportare, schemaXSD);
                validatoreBustaSPCoop_map.put(key, val);
                log.info("Inizializzazione dello schema per il protocollo spcoop terminata.");
                return true;
            }
            catch (Exception e) {
                log.error("Riscontrato errore durante l'inizializzazione dello schema per il protocollo spcoop: " + e.getMessage(), (Throwable)e);
                return false;
            }
        }
        return true;
    }

    private static ValidatoreXSD getValidatoreXSD(OpenSPCoop2MessageFactory messageFactory, Logger log) {
        String key = messageFactory.getClass().getName();
        if (!validatoreBustaSPCoop_map.containsKey(key)) {
            SPCoopValidazioneConSchema.initializeSchema(messageFactory, log);
        }
        return validatoreBustaSPCoop_map.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ValidatoreXSD createSchemaValidator(OpenSPCoop2MessageFactory messageFactory, Logger log, String[] schemiXSDDaImportare, String schemaXSD) throws Exception {
        XSDResourceResolver xsdResourceResolver = new XSDResourceResolver();
        if (schemiXSDDaImportare != null) {
            for (int i = 0; i < schemiXSDDaImportare.length; ++i) {
                File fXsd = new File(schemiXSDDaImportare[i]);
                InputStream is = null;
                try {
                    is = fXsd.exists() ? new FileInputStream(fXsd) : SPCoopValidazioneConSchema.class.getResourceAsStream("/" + schemiXSDDaImportare[i]);
                    xsdResourceResolver.addResource(fXsd.getName(), is);
                    continue;
                }
                finally {
                    try {
                        if (is != null) {
                            is.close();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
        }
        File fXsd = new File(schemaXSD);
        InputStream is = null;
        try {
            is = fXsd.exists() ? new FileInputStream(fXsd) : SPCoopValidazioneConSchema.class.getResourceAsStream("/" + schemaXSD);
            ValidatoreXSD validatoreXSD = new ValidatoreXSD(messageFactory, log, (LSResourceResolver)xsdResourceResolver, is);
            return validatoreXSD;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void valida(OpenSPCoop2Message message, boolean isSPCoopErroreProcessamento, boolean isSPCoopErroreIntestazione, boolean isMessaggioConAttachments, boolean validazioneManifestAttachments) throws ProtocolException {
        Eccezione ecc;
        this.erroriValidazione = new ArrayList<Eccezione>();
        this.erroriProcessamento = new ArrayList<Eccezione>();
        MessageXMLUtils xmlUtils = MessageXMLUtils.getInstance((OpenSPCoop2MessageFactory)message.getFactory());
        ValidatoreXSD validatoreBustaSPCoop = SPCoopValidazioneConSchema.getValidatoreXSD(message.getFactory(), this.log);
        if (validatoreBustaSPCoop == null) {
            throw new ProtocolException("Validatore con schema XSD non inizializzato");
        }
        try {
            SPCoopBustaRawContent bustaElement = (SPCoopBustaRawContent)this.protocolFactory.createValidazioneSintattica(this.state).getBustaRawContent_senzaControlli(message);
            SOAPElement header = (SOAPElement)bustaElement.getElement();
            if (!isSPCoopErroreProcessamento && !isSPCoopErroreIntestazione) {
                validatoreBustaSPCoop.valida((Node)xmlUtils.newDocument(OpenSPCoop2MessageFactory.getAsByte((OpenSPCoop2MessageFactory)message.getFactory(), (Node)header, (boolean)false)));
            } else {
                Iterator itChilds = header.getChildElements();
                SOAPElement listaEccezioni = null;
                while (itChilds.hasNext()) {
                    SOAPElement elemInterno;
                    Object element = itChilds.next();
                    if (!(element instanceof SOAPElement) || !"ListaEccezioni".equals((elemInterno = (SOAPElement)element).getLocalName())) continue;
                    listaEccezioni = elemInterno;
                    break;
                }
                if (listaEccezioni == null && isSPCoopErroreIntestazione) {
                    throw new SAXException("ListaEccezioni non presente in un messaggio SPCoopErrore");
                }
                if (listaEccezioni != null) {
                    validatoreBustaSPCoop.valida((Node)xmlUtils.newDocument(OpenSPCoop2MessageFactory.getAsByte((OpenSPCoop2MessageFactory)message.getFactory(), listaEccezioni, (boolean)false)));
                }
            }
        }
        catch (SAXException e) {
            ecc = new Eccezione();
            ecc.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
            ecc.setCodiceEccezione(CodiceErroreCooperazione.FORMATO_INTESTAZIONE_NON_CORRETTO);
            ecc.setRilevanza(LivelloRilevanza.ERROR);
            ecc.setDescrizione(e.getMessage());
            this.erroriValidazione.add(ecc);
        }
        catch (Exception e) {
            ecc = new Eccezione();
            ecc.setContestoCodifica(ContestoCodificaEccezione.PROCESSAMENTO);
            ecc.setCodiceEccezione(CodiceErroreCooperazione.ERRORE_GENERICO_PROCESSAMENTO_MESSAGGIO);
            ecc.setRilevanza(LivelloRilevanza.ERROR);
            ecc.setDescrizione("Validazione con schema xsd dell'header egov non riuscita: errore di processamento");
            this.log.error("Validazione con schema xsd dell'header egov non riuscita non riuscita", (Throwable)e);
            this.erroriProcessamento.add(ecc);
        }
        SOAPBody soapBody = null;
        if (validazioneManifestAttachments && isMessaggioConAttachments) {
            try {
                soapBody = message.castAsSoap().getSOAPBody();
            }
            catch (Exception e) {
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
        }
        if (soapBody != null) {
            Eccezione ecc2;
            try {
                Element firstElement = OpenSPCoop2MessageFactory.getFirstChildElement((OpenSPCoop2MessageFactory)message.getFactory(), (MessageType)MessageType.SOAP_11, (SOAPElement)soapBody);
                validatoreBustaSPCoop.valida((Node)firstElement);
            }
            catch (SAXException e) {
                ecc2 = new Eccezione();
                ecc2.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                ecc2.setCodiceEccezione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO);
                ecc2.setRilevanza(LivelloRilevanza.ERROR);
                ecc2.setDescrizione("ManifestAttachments: " + e.getMessage());
                this.log.error("Validazione con schema xsd del manifest degli attachments fallita", (Throwable)e);
                this.erroriValidazione.add(ecc2);
            }
            catch (Exception e) {
                ecc2 = new Eccezione();
                ecc2.setContestoCodifica(ContestoCodificaEccezione.PROCESSAMENTO);
                ecc2.setCodiceEccezione(CodiceErroreCooperazione.ERRORE_GENERICO_PROCESSAMENTO_MESSAGGIO);
                ecc2.setRilevanza(LivelloRilevanza.ERROR);
                ecc2.setDescrizione("Validazione con schema xsd del manifest degli attachments non riuscita: errore di processamento");
                this.log.error("Validazione con schema xsd del manifest degli attachments non riuscita", (Throwable)e);
                this.erroriProcessamento.add(ecc2);
            }
        }
    }

    public boolean initialize(OpenSPCoop2MessageFactory messageFactory) {
        return SPCoopValidazioneConSchema.initializeSchema(messageFactory, this.log);
    }
}

