/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.template_scan.cli;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class TemplateScanProperties {
    private final String dbUsername;
    private final String dbPassword;
    private final String dbType;
    private final String dbUrl;
    private final String dbDriver;
    private final Boolean enableTransformationRequest;
    private final Boolean enableTransformationResponse;
    private final Boolean enableConnectors;
    private final Boolean enableAtttributeAuthority;
    private final Boolean enableTokenPolicy;
    public static final String PROPERTIES_FILE = "/template_scan.cli.properties";
    public static final String LOG_PROPERTIES_FILE = "/template_scan.cli.log4j2.properties";
    public static final String REGISTRY_SEGMENT = "Registro";
    public static final String CONFIG_SEGMENT = "Configurazione";
    public static final String CONFIGURATION_SEGMENT = "Configurazione";
    public static final String TRANSFORMATION_SEGMENT = "Transformazioni";
    public static final String TRANSFORMATION_REQUEST_SEGMENT = "Richiesta";
    public static final String TRANSFORMATION_RESPONSE_SEGMENT = "Risposte";
    public static final String TRANSFORMATION_REQUEST_CONTENT_SEGMENT = "Contenuto";
    public static final String TRANSFORMATION_RESPONSE_CONTENT_SEGMENT = "Contenuto";
    public static final String MISC_SEGMENT = "misc";
    public static final String EROGATION_SEGMENT = "Erogazioni";
    public static final String FRUITION_SEGMENT = "Fruizioni";
    public static final String TOKEN_POLICY_SEGMENT = "Token Policy";
    public static final String TOKEN_POLICY_TOKEN_ENDPOINT_SEGMENT = "Token Endpoint";
    public static final String ATTRIBUTE_AUTHORITY_SEGMENT = "Attribute Authority";
    public static final String ATTRIBUTE_AUTHORITY_REQUEST_SEGMENT = "Richiesta";

    public static TemplateScanProperties getInstance() {
        return InstanceHolder.INSTANCE;
    }

    private String readProperty(Properties p, String key, boolean required) {
        if (required && !p.containsKey(key)) {
            throw new IllegalStateException("property " + key + " necessaria");
        }
        return p.getProperty(key);
    }

    private Boolean readPropertyBoolean(Properties p, String key, boolean required) {
        if (required && !p.containsKey(key)) {
            throw new IllegalStateException("property " + key + " necessaria");
        }
        return Boolean.valueOf(p.getProperty(key));
    }

    private TemplateScanProperties(InputStream is) throws IOException {
        Properties p = new Properties();
        p.load(is);
        this.dbUsername = this.readProperty(p, "db.user", true);
        this.dbPassword = this.readProperty(p, "db.password", true);
        this.dbType = this.readProperty(p, "db.type", true);
        this.dbUrl = this.readProperty(p, "db.url", true);
        this.dbDriver = this.readProperty(p, "db.driver", true);
        this.enableAtttributeAuthority = this.readPropertyBoolean(p, "scan.attribute_authority.enable", true);
        this.enableConnectors = this.readPropertyBoolean(p, "scan.connettori.enable", true);
        this.enableTokenPolicy = this.readPropertyBoolean(p, "scan.token_policy.enable", true);
        this.enableTransformationRequest = this.readPropertyBoolean(p, "scan.trasformazioni.richiesta.enable", true);
        this.enableTransformationResponse = this.readPropertyBoolean(p, "scan.trasformazioni.risposta.enable", true);
    }

    public String getDbUsername() {
        return this.dbUsername;
    }

    public String getDbPassword() {
        return this.dbPassword;
    }

    public String getDbType() {
        return this.dbType;
    }

    public String getDbUrl() {
        return this.dbUrl;
    }

    public String getDbDriver() {
        return this.dbDriver;
    }

    public boolean isEnableTransformationRequest() {
        return this.enableTransformationRequest;
    }

    public boolean isEnableTransformationResponse() {
        return this.enableTransformationResponse;
    }

    public boolean isEnableConnectors() {
        return this.enableConnectors;
    }

    public boolean isEnableAtttributeAuthority() {
        return this.enableAtttributeAuthority;
    }

    public boolean isEnableTokenPolicy() {
        return this.enableTokenPolicy;
    }

    private static class InstanceHolder {
        private static final TemplateScanProperties INSTANCE = InstanceHolder.createInstance();

        private InstanceHolder() {
        }

        private static TemplateScanProperties createInstance() {
            TemplateScanProperties templateScanProperties;
            block8: {
                InputStream is = TemplateScanProperties.class.getResourceAsStream(TemplateScanProperties.PROPERTIES_FILE);
                try {
                    templateScanProperties = new TemplateScanProperties(is);
                    if (is == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new IllegalStateException(e);
                    }
                }
                is.close();
            }
            return templateScanProperties;
        }
    }
}

